/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.transform.Scale;
import javafx.stage.WindowEvent;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.CellGraphicFactory;
import org.controlsfx.control.spreadsheet.ClipboardCell;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridBase;
import org.controlsfx.control.spreadsheet.Picker;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetViewSelectionModel;
import org.controlsfx.tools.Utils;

public class SpreadsheetView
extends Control {
    private static final double DEFAULT_ROW_HEADER_WIDTH = 30.0;
    private final SpreadsheetGridView cellsView;
    private SimpleObjectProperty<Grid> gridProperty = new SimpleObjectProperty();
    private DataFormat fmt;
    private final ObservableList<Integer> fixedRows = FXCollections.observableArrayList();
    private final ObservableList<SpreadsheetColumn> fixedColumns = FXCollections.observableArrayList();
    private final BooleanProperty fixingRowsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty fixingColumnsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty showColumnHeader = new SimpleBooleanProperty(true, "showColumnHeader", true);
    private final BooleanProperty showRowHeader = new SimpleBooleanProperty(true, "showRowHeader", true);
    private BitSet rowFix;
    private final ObservableMap<Integer, Picker> rowPickers = FXCollections.observableHashMap();
    private final ObservableMap<Integer, Picker> columnPickers = FXCollections.observableHashMap();
    private ObservableList<SpreadsheetColumn> columns = FXCollections.observableArrayList();
    private Map<SpreadsheetCellType<?>, SpreadsheetCellEditor> editors = new IdentityHashMap();
    private final SpreadsheetViewSelectionModel selectionModel;
    private final KeyCombination zoomOutChar = new KeyCharacterCombination("-", KeyCombination.SHORTCUT_DOWN);
    private final KeyCombination zoomOutKeypad = new KeyCodeCombination(KeyCode.SUBTRACT, KeyCombination.SHORTCUT_DOWN);
    private final KeyCombination zoomInChar = new KeyCharacterCombination("+", KeyCombination.SHORTCUT_DOWN);
    private final KeyCombination zoomInCharShift = new KeyCharacterCombination("+", KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN);
    private final KeyCombination zoomInKeypadAdd = new KeyCodeCombination(KeyCode.ADD, KeyCombination.SHORTCUT_DOWN);
    private final KeyCombination zoomNormalKeypad = new KeyCodeCombination(KeyCode.NUMPAD0, KeyCombination.SHORTCUT_DOWN);
    private final KeyCombination zoomNormal = new KeyCodeCombination(KeyCode.DIGIT0, KeyCombination.SHORTCUT_DOWN);
    private final KeyCombination zoomNormalShift = new KeyCodeCombination(KeyCode.DIGIT0, KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN);
    private final DoubleProperty rowHeaderWidth = new SimpleDoubleProperty(30.0);
    private DoubleProperty zoomFactor = new SimpleDoubleProperty(1.0);
    private static final double MIN_ZOOM = 0.2;
    private static final double MAX_ZOOM = 2.0;
    private static final double STEP_ZOOM = 0.1;
    private final ObjectProperty<BitSet> hiddenRowsProperty = new SimpleObjectProperty<BitSet>();
    private IdentityHashMap<ObservableList<SpreadsheetCell>, Integer> identityMap;
    private final ObjectProperty<BitSet> hiddenColumnsProperty = new SimpleObjectProperty<BitSet>();
    private HashMap<Integer, Integer> rowMap;
    private HashMap<Integer, Integer> columnMap = new HashMap();
    private Integer filteredRow;
    private FilteredList<ObservableList<SpreadsheetCell>> filteredList;
    private SortedList<ObservableList<SpreadsheetCell>> sortedList;
    private CellGraphicFactory cellGraphicFactory;
    private String stylesheet;
    private final BitSet columnWidthSet = new BitSet();
    final SpreadsheetHandle handle = new SpreadsheetHandle(){

        @Override
        protected SpreadsheetView getView() {
            return SpreadsheetView.this;
        }

        @Override
        protected GridViewSkin getCellsViewSkin() {
            return SpreadsheetView.this.getCellsViewSkin();
        }

        @Override
        protected SpreadsheetGridView getGridView() {
            return SpreadsheetView.this.getCellsView();
        }

        @Override
        protected boolean isColumnWidthSet(int indexColumn) {
            return SpreadsheetView.this.columnWidthSet.get(indexColumn);
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends Integer> c) {
            while (c.next()) {
                if (c.wasAdded()) {
                    List<? extends Integer> newRows = c.getAddedSubList();
                    if (!SpreadsheetView.this.areRowsFixable(newRows)) {
                        throw new IllegalArgumentException(SpreadsheetView.this.computeReason(newRows));
                    }
                    FXCollections.sort(SpreadsheetView.this.fixedRows);
                }
                if (!c.wasRemoved()) continue;
            }
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> c) {
            while (c.next()) {
                List<? extends SpreadsheetColumn> newColumns;
                if (!c.wasAdded() || SpreadsheetView.this.areSpreadsheetColumnsFixable(newColumns = c.getAddedSubList())) continue;
                ArrayList<Integer> newList = new ArrayList<Integer>();
                for (SpreadsheetColumn spreadsheetColumn : newColumns) {
                    if (spreadsheetColumn == null) continue;
                    newList.add(SpreadsheetView.this.columns.indexOf(spreadsheetColumn));
                }
                throw new IllegalArgumentException(this.computeReason(newList));
            }
        }

        /*
         * WARNING - void declaration
         */
        private String computeReason(List<Integer> list) {
            Object reason = "\n This column cannot be frozen.";
            ObservableList<ObservableList<SpreadsheetCell>> rows = SpreadsheetView.this.getGrid().getRows();
            for (Integer columnIndex : list) {
                void var9_10;
                if (SpreadsheetView.this.isColumnFixable(columnIndex)) continue;
                int maxSpan = 1;
                for (List list2 : rows) {
                    SpreadsheetCell cell = (SpreadsheetCell)list2.get(columnIndex);
                    if (!list.contains(cell.getColumn())) {
                        reason = (String)reason + "The column " + columnIndex + " is inside a column span and the starting column " + cell.getColumn() + " is not frozen.\n";
                    }
                    if (cell.getColumnSpan() <= maxSpan || cell.getColumn() != columnIndex.intValue()) continue;
                    maxSpan = cell.getColumnSpan();
                }
                int count = columnIndex + maxSpan - 1;
                int n = columnIndex + 1;
                while (var9_10 < count) {
                    if (!list.contains((int)var9_10)) {
                        reason = (String)reason + "One cell on the column " + columnIndex + " has a column span of " + maxSpan + ". But the column " + (int)var9_10 + " contained within that span is not frozen.\n";
                    }
                    ++var9_10;
                }
            }
            return reason;
        }
    };
    private final ChangeListener<ContextMenu> contextMenuChangeListener = new ChangeListener<ContextMenu>(){

        @Override
        public void changed(ObservableValue<? extends ContextMenu> arg0, ContextMenu oldContextMenu, ContextMenu newContextMenu) {
            if (oldContextMenu != null) {
                oldContextMenu.setOnShowing(null);
            }
            if (newContextMenu != null) {
                newContextMenu.setOnShowing(new WeakEventHandler<WindowEvent>(SpreadsheetView.this.hideContextMenuEventHandler));
            }
        }
    };
    private final EventHandler<WindowEvent> hideContextMenuEventHandler = new EventHandler<WindowEvent>(){

        @Override
        public void handle(WindowEvent arg0) {
            if (SpreadsheetView.this.getEditingCell() != null) {
                Platform.runLater(() -> SpreadsheetView.this.getContextMenu().hide());
            }
        }
    };
    private final EventHandler<KeyEvent> keyPressedHandler = keyEvent -> {
        TablePosition position = this.getSelectionModel().getFocusedCell();
        if (this.getEditingCell() == null && KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
            if (position != null) {
                if (keyEvent.isShiftDown()) {
                    this.getCellsViewSkin().getBehavior().selectCell(-1, 0);
                } else {
                    this.getCellsViewSkin().getBehavior().selectCell(1, 0);
                }
                keyEvent.consume();
            }
            this.getCellsViewSkin().scrollHorizontally();
        } else if (this.getEditingCell() == null && KeyCode.TAB.equals((Object)keyEvent.getCode()) && !keyEvent.isShortcutDown()) {
            if (position != null) {
                if (keyEvent.isShiftDown()) {
                    this.getSelectionModel().clearAndSelectLeftCell();
                } else {
                    this.getSelectionModel().clearAndSelectRightCell();
                }
            }
            keyEvent.consume();
            this.getCellsViewSkin().scrollHorizontally();
        } else if (KeyCode.DELETE.equals((Object)keyEvent.getCode())) {
            this.deleteSelectedCells();
        } else if (this.isEditionKey((KeyEvent)keyEvent)) {
            this.getCellsView().edit(position.getRow(), position.getTableColumn());
        } else if (this.zoomNormalKeypad.match((KeyEvent)keyEvent) || this.zoomNormal.match((KeyEvent)keyEvent) || this.zoomNormalShift.match((KeyEvent)keyEvent)) {
            this.setZoomFactor(1.0);
        } else if (this.zoomInChar.match((KeyEvent)keyEvent) || this.zoomInKeypadAdd.match((KeyEvent)keyEvent) || this.zoomInCharShift.match((KeyEvent)keyEvent)) {
            this.incrementZoom();
        } else if (this.zoomOutChar.match((KeyEvent)keyEvent) || this.zoomOutKeypad.match((KeyEvent)keyEvent)) {
            this.decrementZoom();
        }
    };

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    final SpreadsheetGridView getCellsView() {
        return this.cellsView;
    }

    @Override
    public String getUserAgentStylesheet() {
        if (this.stylesheet == null) {
            this.stylesheet = SpreadsheetView.class.getResource("spreadsheet.css").toExternalForm();
        }
        return this.stylesheet;
    }

    void columnWidthSet(int indexColumn) {
        this.columnWidthSet.set(indexColumn);
    }

    public SpreadsheetView() {
        this(SpreadsheetView.getSampleGrid());
        for (SpreadsheetColumn column : this.getColumns()) {
            column.setPrefWidth(100.0);
        }
    }

    public void setCellGraphicFactory(CellGraphicFactory cellGraphicFactory) {
        this.cellGraphicFactory = cellGraphicFactory;
    }

    public CellGraphicFactory getCellGraphicFactory() {
        return this.cellGraphicFactory;
    }

    public SpreadsheetView(Grid grid) {
        this.addEventHandler(RowHeightEvent.ROW_HEIGHT_CHANGE, (? super T event) -> {
            if (this.getFixedRows().contains(this.getModelRow(event.getRow())) && this.getCellsViewSkin() != null) {
                this.getCellsViewSkin().computeFixedRowHeight();
            }
        });
        this.hiddenRowsProperty.addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                SpreadsheetView.this.computeRowMap();
                SpreadsheetView.this.initRowFix(SpreadsheetView.this.getGrid());
            }
        });
        this.hiddenColumnsProperty.addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                SpreadsheetView.this.computeColumnMap();
                SpreadsheetView.this.initRowFix(SpreadsheetView.this.getGrid());
            }
        });
        this.getStyleClass().add("SpreadsheetView");
        this.setSkin(new Skin<SpreadsheetView>(){

            @Override
            public Node getNode() {
                return SpreadsheetView.this.getCellsView();
            }

            @Override
            public SpreadsheetView getSkinnable() {
                return SpreadsheetView.this;
            }

            @Override
            public void dispose() {
            }
        });
        this.cellsView = new SpreadsheetGridView(this.handle);
        this.getChildren().add(this.cellsView);
        TableViewSpanSelectionModel tableViewSpanSelectionModel = new TableViewSpanSelectionModel(this, this.cellsView);
        this.cellsView.setSelectionModel(tableViewSpanSelectionModel);
        tableViewSpanSelectionModel.setCellSelectionEnabled(true);
        tableViewSpanSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.selectionModel = new SpreadsheetViewSelectionModel(this, tableViewSpanSelectionModel);
        this.cellsView.getFocusModel().focusedCellProperty().addListener(new FocusModelListener(this, this.cellsView));
        this.cellsView.addEventFilter(KeyEvent.KEY_PRESSED, this.keyPressedHandler);
        this.contextMenuProperty().addListener(new WeakChangeListener<ContextMenu>(this.contextMenuChangeListener));
        CellView.getValue(() -> this.setContextMenu(this.getSpreadsheetViewContextMenu()));
        this.setGrid(grid);
        this.setEditable(true);
        this.fixedRows.addListener(this.fixedRowsListener);
        this.fixedColumns.addListener(this.fixedColumnsListener);
        final Scale scale = new Scale(1.0, 1.0);
        this.getTransforms().add(scale);
        this.zoomFactor.addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                scale.setX(newValue.doubleValue());
                scale.setY(newValue.doubleValue());
                SpreadsheetView.this.requestLayout();
            }
        });
        this.addEventFilter(ScrollEvent.ANY, (? super T event) -> {
            if (event.isShortcutDown()) {
                if (event.getTextDeltaY() > 0.0) {
                    this.incrementZoom();
                } else {
                    this.decrementZoom();
                }
                event.consume();
            }
        });
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        Pos pos = Pos.TOP_LEFT;
        double width = this.getWidth();
        double height = this.getHeight();
        double top = this.getInsets().getTop();
        double right = this.getInsets().getRight();
        double left = this.getInsets().getLeft();
        double bottom = this.getInsets().getBottom();
        double contentWidth = (width - left - right) / this.zoomFactor.get();
        double contentHeight = (height - top - bottom) / this.zoomFactor.get();
        this.layoutInArea((Node)this.getChildren().get(0), left, top, contentWidth, contentHeight, 0.0, null, pos.getHpos(), pos.getVpos());
    }

    public boolean isRowHidden(int row) {
        return ((BitSet)this.hiddenRowsProperty.get()).get(row);
    }

    public BitSet getHiddenRows() {
        return (BitSet)this.hiddenRowsProperty.get();
    }

    public final ObjectProperty<BitSet> hiddenRowsProperty() {
        return this.hiddenRowsProperty;
    }

    public void setHiddenRows(BitSet hiddenRows) {
        BitSet bitSet = new BitSet(hiddenRows.size());
        bitSet.or(hiddenRows);
        this.hiddenRowsProperty.setValue(bitSet);
        this.requestLayout();
    }

    public void setHiddenColumns(BitSet hiddenColumns) {
        BitSet bitSet = new BitSet(hiddenColumns.size());
        bitSet.or(hiddenColumns);
        this.hiddenColumnsProperty.setValue(bitSet);
        this.requestLayout();
    }

    public boolean isColumnHidden(int column) {
        return ((BitSet)this.hiddenColumnsProperty.get()).get(column);
    }

    public BitSet getHiddenColumns() {
        return (BitSet)this.hiddenColumnsProperty.get();
    }

    public final ObjectProperty<BitSet> hiddenColumnsProperty() {
        return this.hiddenColumnsProperty;
    }

    public int getFilteredRow() {
        return this.filteredRow == null ? -1 : this.filteredRow;
    }

    public void setFilteredRow(Integer row) {
        this.filteredRow = row == null || row > this.getGrid().getRowCount() ? null : row;
    }

    public void hideRow(int row) {
        if (this.getHiddenRows().get(row)) {
            return;
        }
        this.getHiddenRows().set(row, true);
        BitSet bitSet = new BitSet(this.getHiddenRows().size());
        bitSet.or(this.getHiddenRows());
        this.setHiddenRows(bitSet);
    }

    public void hideColumn(SpreadsheetColumn column) {
        int indexColumn = this.getColumns().indexOf(column);
        if (this.getHiddenColumns().get(indexColumn)) {
            return;
        }
        this.getHiddenColumns().set(indexColumn, true);
        BitSet bitSet = new BitSet(this.getHiddenColumns().size());
        bitSet.or(this.getHiddenColumns());
        this.setHiddenColumns(bitSet);
    }

    private void computeRowMap() {
        if (this.getHiddenRows().isEmpty()) {
            this.filteredList.setPredicate(null);
        } else {
            this.filteredList.setPredicate(new Predicate<ObservableList<SpreadsheetCell>>(){

                @Override
                public boolean test(ObservableList<SpreadsheetCell> t) {
                    int index = SpreadsheetView.this.identityMap.get(t);
                    return !SpreadsheetView.this.getHiddenRows().get(index) || index == SpreadsheetView.this.getFilteredRow();
                }
            });
        }
        int rowCount = this.getGrid().getRowCount();
        this.rowMap = new HashMap(rowCount);
        int visibleRow = 0;
        for (int i = 0; i < rowCount; ++i) {
            if (!this.getHiddenRows().get(i)) {
                this.rowMap.put(i, visibleRow++);
                continue;
            }
            this.rowMap.put(i, visibleRow);
        }
    }

    private void computeColumnMap() {
        int columnCount = this.getGrid().getColumnCount();
        this.columnMap = new HashMap(columnCount);
        CellView.getValue(() -> {
            int columnSize = this.getColumns().size();
            int totalColumn = this.getGrid().getColumnCount();
            int visibleColumn = 0;
            for (int i = 0; i < totalColumn; ++i) {
                if (!this.getHiddenColumns().get(i)) {
                    if (i < columnSize) {
                        ((SpreadsheetColumn)this.getColumns().get((int)i)).column.setVisible(true);
                    }
                    this.columnMap.put(i, visibleColumn++);
                    continue;
                }
                if (i < columnSize) {
                    ((SpreadsheetColumn)this.getColumns().get((int)i)).column.setVisible(false);
                }
                this.columnMap.put(i, visibleColumn);
            }
        });
    }

    public void showRow(int row) {
        if (!this.getHiddenRows().get(row)) {
            return;
        }
        this.getHiddenRows().set(row, false);
        BitSet bitSet = new BitSet(this.getHiddenRows().size());
        bitSet.or(this.getHiddenRows());
        this.setHiddenRows(bitSet);
    }

    public void showColumn(SpreadsheetColumn column) {
        int indexColumn = this.getColumns().indexOf(column);
        if (!this.getHiddenColumns().get(indexColumn)) {
            return;
        }
        this.getHiddenColumns().set(indexColumn, false);
        BitSet bitSet = new BitSet(this.getHiddenColumns().size());
        bitSet.or(this.getHiddenColumns());
        this.setHiddenColumns(bitSet);
    }

    public int getFilteredRow(int modelRow) {
        try {
            return this.rowMap.get(modelRow);
        }
        catch (NullPointerException ex) {
            return modelRow;
        }
    }

    public int getViewColumn(int modelColumn) {
        try {
            return this.columnMap.get(modelColumn);
        }
        catch (NullPointerException ex) {
            return modelColumn;
        }
    }

    public int getModelColumn(int viewColumn) {
        try {
            return this.cellsView.getColumns().indexOf(this.cellsView.getVisibleLeafColumn(viewColumn));
        }
        catch (NullPointerException ex) {
            return viewColumn;
        }
    }

    public int getViewRow(int modelRow) {
        modelRow = this.getFilteredRow(modelRow);
        if (this.getComparator() != null) {
            modelRow = this.getViewIndex(modelRow);
        }
        return modelRow;
    }

    private int getViewIndex(int sourceIndex) {
        return this.sortedList.getViewIndex(sourceIndex);
    }

    public int getModelRow(int viewRow) {
        if (viewRow < 0 || viewRow >= this.sortedList.size()) {
            return viewRow;
        }
        try {
            return this.getFilteredSourceIndex(this.sortedList.getSourceIndex(viewRow));
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            return viewRow;
        }
    }

    public int getFilteredSourceIndex(int viewRow) {
        if (viewRow < 0 || viewRow >= this.filteredList.size()) {
            return viewRow;
        }
        try {
            return this.filteredList.getSourceIndex(viewRow);
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            return viewRow;
        }
    }

    public int getRowSpan(SpreadsheetCell cell, int index) {
        int rowSpan = 0;
        do {
            ++rowSpan;
        } while (++index < this.sortedList.size() && cell.getColumn() < this.getGrid().getColumnCount() && this.sortedList.get(index).get(cell.getColumn()) == cell);
        return rowSpan;
    }

    public int getReverseRowSpan(SpreadsheetCell cell, int index) {
        int rowSpan = 0;
        do {
            ++rowSpan;
        } while (--index >= 0 && cell.getColumn() < this.getGrid().getColumnCount() && this.sortedList.get(index).get(cell.getColumn()) == cell);
        return rowSpan;
    }

    public int getRowSpanFilter(SpreadsheetCell cell) {
        int rowSpan = cell.getRowSpan();
        for (int i = cell.getRow(); i < cell.getRow() + cell.getRowSpan(); ++i) {
            rowSpan -= this.getHiddenRows().get(i) ? 1 : 0;
        }
        return rowSpan;
    }

    public ObservableList<ObservableList<SpreadsheetCell>> getItems() {
        return this.cellsView.getItems();
    }

    public int getColumnSpan(SpreadsheetCell cell) {
        int colSpan = cell.getColumnSpan();
        for (int i = cell.getColumn(); i < cell.getColumn() + cell.getColumnSpan(); ++i) {
            colSpan -= this.getHiddenColumns().get(i) ? 1 : 0;
        }
        return colSpan;
    }

    public final Double getZoomFactor() {
        return this.zoomFactor.get();
    }

    public final void setZoomFactor(Double zoomFactor) {
        this.zoomFactor.set(zoomFactor);
    }

    public final DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }

    public void incrementZoom() {
        double newZoom = this.zoomFactor.getValue() + 0.1;
        newZoom *= 10.0;
        newZoom = Math.floor((float)newZoom);
        this.zoomFactor.setValue((newZoom /= 10.0) > 2.0 ? 2.0 : newZoom);
    }

    public void decrementZoom() {
        double newZoom = this.zoomFactor.getValue() - 0.1;
        newZoom *= 10.0;
        newZoom = Math.ceil((float)newZoom);
        this.zoomFactor.setValue((newZoom /= 10.0) < 0.2 ? 0.2 : newZoom);
    }

    public void edit(int row, SpreadsheetColumn column) {
        this.cellsView.edit(row, column == null ? null : column.column);
    }

    public Comparator getComparator() {
        return this.sortedList == null ? null : this.sortedList.getComparator();
    }

    public ObjectProperty<Comparator<? super ObservableList<SpreadsheetCell>>> comparatorProperty() {
        return this.sortedList.comparatorProperty();
    }

    public void setComparator(Comparator<ObservableList<SpreadsheetCell>> comparator) {
        this.sortedList.setComparator(comparator);
        this.computeRowMap();
        this.requestLayout();
    }

    /*
     * WARNING - void declaration
     */
    public final void setGrid(Grid grid) {
        void var5_11;
        if (grid == null) {
            return;
        }
        this.filteredList = new FilteredList<ObservableList<SpreadsheetCell>>(grid.getRows());
        this.sortedList = new SortedList<ObservableList<SpreadsheetCell>>((ObservableList<ObservableList<SpreadsheetCell>>)this.filteredList);
        this.gridProperty.set(grid);
        this.setHiddenRows(new BitSet(this.filteredList.getSource().size()));
        this.setHiddenColumns(new BitSet(grid.getColumnCount()));
        this.initRowFix(grid);
        ArrayList<Integer> newFixedRows = new ArrayList<Integer>();
        for (Integer n : this.getFixedRows()) {
            if (!this.isRowFixable(n)) continue;
            newFixedRows.add(n);
        }
        this.getFixedRows().setAll((Collection<Integer>)newFixedRows);
        ArrayList<Integer> columnsFixed = new ArrayList<Integer>();
        for (SpreadsheetColumn spreadsheetColumn : this.getFixedColumns()) {
            columnsFixed.add(this.getColumns().indexOf(spreadsheetColumn));
        }
        this.getFixedColumns().clear();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (SpreadsheetColumn column : this.columns) {
            arrayList.add(column.getWidth());
        }
        Object var5_9 = null;
        TablePosition focusedCell = this.cellsView.getFocusModel().getFocusedCell();
        if (focusedCell != null && focusedCell.getRow() != -1 && focusedCell.getColumn() != -1) {
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(focusedCell.getRow(), focusedCell.getColumn());
        }
        void finalPair = var5_11;
        if (grid.getRows() != null) {
            this.cellsView.setItems(this.sortedList);
            this.computeRowMap();
            int columnCount = grid.getColumnCount();
            this.columns.clear();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                SpreadsheetColumn spreadsheetColumn = new SpreadsheetColumn(this.getTableColumn(grid, columnIndex), this, columnIndex, grid);
                if (arrayList.size() > columnIndex) {
                    spreadsheetColumn.setPrefWidth((Double)arrayList.get(columnIndex));
                }
                this.columns.add(spreadsheetColumn);
                if (!columnsFixed.contains(columnIndex) || !spreadsheetColumn.isColumnFixable()) continue;
                spreadsheetColumn.setFixed(true);
            }
        }
        ArrayList<Pair<Integer, Integer>> selectedCells = new ArrayList<Pair<Integer, Integer>>();
        for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
            selectedCells.add(new Pair<Integer, Integer>(position.getRow(), position.getColumn()));
        }
        Runnable runnable = () -> this.lambda$setGrid$4(grid, selectedCells, (Pair)finalPair);
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            try {
                FutureTask<Object> future = new FutureTask<Object>(runnable, null);
                Platform.runLater(future);
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(SpreadsheetView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> getEditingCell() {
        return this.cellsView.getEditingCell();
    }

    public ReadOnlyObjectProperty<TablePosition<ObservableList<SpreadsheetCell>, ?>> editingCellProperty() {
        return this.cellsView.editingCellProperty();
    }

    public final ObservableList<SpreadsheetColumn> getColumns() {
        return this.columns;
    }

    public final Grid getGrid() {
        return (Grid)this.gridProperty.get();
    }

    public final ReadOnlyObjectProperty<Grid> gridProperty() {
        return this.gridProperty;
    }

    public ObservableList<Integer> getFixedRows() {
        return this.fixedRows;
    }

    public boolean isRowFixable(int row) {
        return row >= 0 && row < this.rowFix.size() && this.isFixingRowsAllowed() ? this.rowFix.get(row) : false;
    }

    public boolean areRowsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isFixingRowsAllowed()) {
            return false;
        }
        Grid grid = this.getGrid();
        int rowCount = grid.getRowCount();
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        for (Integer n : list) {
            if (n == null || n < 0 || n >= rowCount) {
                return false;
            }
            if (this.isRowFixable(n)) continue;
            int maxSpan = 1;
            List gridRow = (List)rows.get(n);
            for (SpreadsheetCell cell : gridRow) {
                if (!list.contains(cell.getRow())) {
                    return false;
                }
                if (this.getRowSpan(cell, n) <= maxSpan || cell.getRow() != n.intValue()) continue;
                maxSpan = cell.getRowSpan();
            }
            int count = n + maxSpan - 1;
            for (int index = n + 1; index <= count; ++index) {
                if (list.contains(index)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFixingRowsAllowed() {
        return this.fixingRowsAllowedProperty.get();
    }

    public void setFixingRowsAllowed(boolean b) {
        this.fixingRowsAllowedProperty.set(b);
    }

    public ReadOnlyBooleanProperty fixingRowsAllowedProperty() {
        return this.fixingRowsAllowedProperty;
    }

    public ObservableList<SpreadsheetColumn> getFixedColumns() {
        return this.fixedColumns;
    }

    public boolean isColumnFixable(int columnIndex) {
        return columnIndex >= 0 && columnIndex < this.getColumns().size() && this.isFixingColumnsAllowed() ? ((SpreadsheetColumn)this.getColumns().get(columnIndex)).isColumnFixable() : false;
    }

    public boolean areSpreadsheetColumnsFixable(List<? extends SpreadsheetColumn> list) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (SpreadsheetColumn spreadsheetColumn : list) {
            if (spreadsheetColumn == null) continue;
            newList.add(this.columns.indexOf(spreadsheetColumn));
        }
        return this.areColumnsFixable(newList);
    }

    /*
     * WARNING - void declaration
     */
    public boolean areColumnsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isFixingRowsAllowed()) {
            return false;
        }
        Grid grid = this.getGrid();
        int columnCount = grid.getColumnCount();
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        for (Integer n : list) {
            void var10_11;
            if (n == null || n < 0 || n >= columnCount) {
                return false;
            }
            if (this.isColumnFixable(n)) continue;
            int maxSpan = 1;
            for (List list2 : rows) {
                SpreadsheetCell cell = (SpreadsheetCell)list2.get(n);
                if (!list.contains(cell.getColumn())) {
                    return false;
                }
                if (cell.getColumnSpan() <= maxSpan || cell.getColumn() != n.intValue()) continue;
                maxSpan = cell.getColumnSpan();
            }
            int count = n + maxSpan - 1;
            int n2 = n + 1;
            while (var10_11 <= count) {
                if (!list.contains((int)var10_11)) {
                    return false;
                }
                ++var10_11;
            }
        }
        return true;
    }

    public boolean isFixingColumnsAllowed() {
        return this.fixingColumnsAllowedProperty.get();
    }

    public void setFixingColumnsAllowed(boolean b) {
        this.fixingColumnsAllowedProperty.set(b);
    }

    public ReadOnlyBooleanProperty fixingColumnsAllowedProperty() {
        return this.fixingColumnsAllowedProperty;
    }

    public final void setShowColumnHeader(boolean b) {
        this.showColumnHeader.setValue(b);
    }

    public final boolean isShowColumnHeader() {
        return this.showColumnHeader.get();
    }

    public final BooleanProperty showColumnHeaderProperty() {
        return this.showColumnHeader;
    }

    public final void setShowRowHeader(boolean b) {
        this.showRowHeader.setValue(b);
    }

    public final boolean isShowRowHeader() {
        return this.showRowHeader.get();
    }

    public final BooleanProperty showRowHeaderProperty() {
        return this.showRowHeader;
    }

    public final DoubleProperty rowHeaderWidthProperty() {
        return this.rowHeaderWidth;
    }

    public final void setRowHeaderWidth(double value) {
        this.rowHeaderWidth.setValue(value);
    }

    public final double getRowHeaderWidth() {
        return this.rowHeaderWidth.get();
    }

    public ObservableMap<Integer, Picker> getRowPickers() {
        return this.rowPickers;
    }

    public ObservableMap<Integer, Picker> getColumnPickers() {
        return this.columnPickers;
    }

    public void resizeRowsToFitContent() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToFitContent();
        }
    }

    public void resizeRowsToMaximum() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToMaximum();
        }
    }

    public void resizeRowsToDefault() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToDefault();
        }
    }

    public double getRowHeight(int row) {
        if (this.getCellsViewSkin() == null) {
            return this.getGrid().getRowHeight(row);
        }
        return this.getCellsViewSkin().getRowHeight(row);
    }

    public SpreadsheetViewSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void scrollToRow(int row) {
        this.cellsView.scrollTo(row);
    }

    public void setVBarValue(double value) {
        if (this.getCellsViewSkin() == null) {
            Platform.runLater(() -> this.setVBarValue(value));
            return;
        }
        this.getCellsViewSkin().getVBar().setValue(value);
    }

    public void setHBarValue(double value) {
        this.setHBarValue(value, 0);
    }

    private void setHBarValue(double value, int attempt) {
        if (attempt > 10) {
            return;
        }
        if (this.getCellsViewSkin() == null) {
            int newAttempt = ++attempt;
            Platform.runLater(() -> this.setHBarValue(value, newAttempt));
            return;
        }
        this.getCellsViewSkin().setHbarValue(value);
    }

    public double getVBarValue() {
        if (this.getCellsViewSkin() != null && this.getCellsViewSkin().getVBar() != null) {
            return this.getCellsViewSkin().getVBar().getValue();
        }
        return 0.0;
    }

    public double getHBarValue() {
        if (this.getCellsViewSkin() != null && this.getCellsViewSkin().getHBar() != null) {
            return this.getCellsViewSkin().getHBar().getValue();
        }
        return 0.0;
    }

    public void scrollToColumn(SpreadsheetColumn column) {
        this.cellsView.scrollToColumn(column.column);
    }

    public void scrollToColumnIndex(int modelColumn) {
        this.cellsView.scrollToColumnIndex(modelColumn);
    }

    public final Optional<SpreadsheetCellEditor> getEditor(SpreadsheetCellType<?> cellType) {
        if (cellType == null) {
            return Optional.empty();
        }
        SpreadsheetCellEditor cellEditor = this.editors.get(cellType);
        if (cellEditor == null) {
            cellEditor = cellType.createEditor(this);
            if (cellEditor == null) {
                return Optional.empty();
            }
            this.editors.put(cellType, cellEditor);
        }
        return Optional.of(cellEditor);
    }

    public final void setEditable(boolean b) {
        this.cellsView.setEditable(b);
    }

    public final boolean isEditable() {
        return this.cellsView.isEditable();
    }

    public final BooleanProperty editableProperty() {
        return this.cellsView.editableProperty();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        return this.cellsView.placeholderProperty();
    }

    public final void setPlaceholder(Node placeholder) {
        this.cellsView.setPlaceholder(placeholder);
    }

    public final Node getPlaceholder() {
        return this.cellsView.getPlaceholder();
    }

    public void copyClipboard() {
        this.checkFormat();
        ArrayList<ClipboardCell> list = new ArrayList<ClipboardCell>();
        ObservableList<TablePosition> posList = this.getSelectionModel().getSelectedCells();
        HashSet<SpreadsheetCell> treatedCells = new HashSet<SpreadsheetCell>();
        for (TablePosition p : posList) {
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(this.getModelRow(p.getRow()))).get(this.getModelColumn(p.getColumn()));
            if (treatedCells.contains(cell)) continue;
            treatedCells.add(cell);
            for (int row = 0; row < this.getRowSpan(cell, p.getRow()); ++row) {
                for (int col = 0; col < this.getColumnSpan(cell); ++col) {
                    list.add(new ClipboardCell(p.getRow() + row, p.getColumn() + col, cell));
                }
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.put(this.fmt, list);
        Clipboard.getSystemClipboard().setContent(content);
    }

    private void pasteOneValue(ClipboardCell change) {
        for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
            this.tryPasteCell(this.getModelRow(position.getRow()), this.getModelColumn(position.getColumn()), change);
        }
    }

    private void tryPasteCell(int row, int column, ClipboardCell change) {
        SpanType type = this.getSpanType(row, column);
        if (type == SpanType.NORMAL_CELL || type == SpanType.ROW_VISIBLE) {
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(row)).get(column);
            Object value = change.getHtmlVersion() == null ? change.getValue() : change.getHtmlVersion();
            value = cell.isCellGraphic() ? value : change.getValue();
            boolean succeed = cell.getCellType().match(value, cell.getOptionsForEditor());
            if (succeed) {
                this.getGrid().setCellValue(cell.getRow(), cell.getColumn(), cell.getCellType().convertValue(value));
            }
        }
    }

    private void pasteMixedValues(ArrayList<ClipboardCell> list) {
        block8: {
            RectangleSelection.SelectionRange sourceSelectionRange = new RectangleSelection.SelectionRange();
            sourceSelectionRange.fillClipboardRange(list);
            if (sourceSelectionRange.getRange() == null) break block8;
            RectangleSelection.SelectionRange targetSelectionRange = new RectangleSelection.SelectionRange();
            targetSelectionRange.fill(this.cellsView.getSelectionModel().getSelectedCells());
            if (targetSelectionRange.getRange() != null) {
                RectangleSelection.GridRange sourceRange = sourceSelectionRange.getRange();
                RectangleSelection.GridRange targetRange = targetSelectionRange.getRange();
                int sourceRowGap = sourceRange.getBottom() - sourceRange.getTop() + 1;
                int targetRowGap = targetRange.getBottom() - targetRange.getTop() + 1;
                int sourceColumnGap = sourceRange.getRight() - sourceRange.getLeft() + 1;
                int targetColumnGap = targetRange.getRight() - targetRange.getLeft() + 1;
                int offsetRow = targetRange.getTop() - sourceRange.getTop();
                int offsetCol = targetRange.getLeft() - sourceRange.getLeft();
                if ((sourceRowGap == targetRowGap || targetRowGap == 1) && targetColumnGap % sourceColumnGap == 0) {
                    for (ClipboardCell change : list) {
                        int row = this.getModelRow(change.getRow() + offsetRow);
                        int column = change.getColumn() + offsetCol;
                        do {
                            int modelColumn = this.getModelColumn(column);
                            if (row >= this.getGrid().getRowCount() || modelColumn >= this.getGrid().getColumnCount() || row < 0 || column < 0) continue;
                            this.tryPasteCell(row, modelColumn, change);
                        } while ((column += sourceColumnGap) <= targetRange.getRight());
                    }
                } else if ((sourceColumnGap == targetColumnGap || targetColumnGap == 1) && targetRowGap % sourceRowGap == 0) {
                    for (ClipboardCell change : list) {
                        int row = change.getRow() + offsetRow;
                        int column = this.getModelColumn(change.getColumn() + offsetCol);
                        do {
                            int modelRow;
                            if ((modelRow = this.getModelRow(row)) >= this.getGrid().getRowCount() || column >= this.getGrid().getColumnCount() || row < 0 || column < 0) continue;
                            this.tryPasteCell(modelRow, column, change);
                        } while ((row += sourceRowGap) <= targetRange.getBottom());
                    }
                }
            }
        }
    }

    private void pasteSeveralValues(ArrayList<ClipboardCell> list) {
        int minRow = this.getGrid().getRowCount();
        int minCol = this.getGrid().getColumnCount();
        int maxRow = 0;
        int maxCol = 0;
        for (ClipboardCell p : list) {
            int tempcol = p.getColumn();
            int temprow = p.getRow();
            if (tempcol < minCol) {
                minCol = tempcol;
            }
            if (tempcol > maxCol) {
                maxCol = tempcol;
            }
            if (temprow < minRow) {
                minRow = temprow;
            }
            if (temprow <= maxRow) continue;
            maxRow = temprow;
        }
        TablePosition p = this.cellsView.getFocusModel().getFocusedCell();
        int offsetRow = p.getRow() - minRow;
        int offsetCol = p.getColumn() - minCol;
        int rowCount = this.getGrid().getRowCount();
        int columnCount = this.getGrid().getColumnCount();
        for (ClipboardCell change : list) {
            int row = this.getModelRow(change.getRow() + offsetRow);
            int column = this.getModelColumn(change.getColumn() + offsetCol);
            if (row >= rowCount || column >= columnCount || row < 0 || column < 0) continue;
            this.tryPasteCell(row, column, change);
        }
    }

    public void pasteClipboard() {
        ObservableList<TablePosition> selectedCells = this.cellsView.getSelectionModel().getSelectedCells();
        if (!this.isEditable() || selectedCells.isEmpty()) {
            return;
        }
        this.checkFormat();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.getContent(this.fmt) != null) {
            ArrayList list = (ArrayList)clipboard.getContent(this.fmt);
            if (list.size() == 1) {
                this.pasteOneValue((ClipboardCell)list.get(0));
            } else if (selectedCells.size() > 1) {
                this.pasteMixedValues(list);
            } else {
                this.pasteSeveralValues(list);
            }
        } else if (clipboard.hasString()) {
            // empty if block
        }
    }

    public ContextMenu getSpreadsheetViewContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem copyItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.copy")));
        copyItem.setGraphic(new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("copySpreadsheetView.png"))));
        copyItem.setAccelerator(new KeyCodeCombination(KeyCode.C, KeyCombination.SHORTCUT_DOWN));
        copyItem.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                SpreadsheetView.this.copyClipboard();
            }
        });
        MenuItem pasteItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.paste")));
        pasteItem.setGraphic(new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("pasteSpreadsheetView.png"))));
        pasteItem.setAccelerator(new KeyCodeCombination(KeyCode.V, KeyCombination.SHORTCUT_DOWN));
        pasteItem.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                SpreadsheetView.this.pasteClipboard();
            }
        });
        Menu cornerMenu = new Menu(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment")));
        cornerMenu.setGraphic(new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("comment.png"))));
        MenuItem topLeftItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-left")));
        topLeftItem.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(pos.getRow()))).get(SpreadsheetView.this.getModelColumn(pos.getColumn()));
                cell.activateCorner(SpreadsheetCell.CornerPosition.TOP_LEFT);
            }
        });
        MenuItem topRightItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-right")));
        topRightItem.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(pos.getRow()))).get(SpreadsheetView.this.getModelColumn(pos.getColumn()));
                cell.activateCorner(SpreadsheetCell.CornerPosition.TOP_RIGHT);
            }
        });
        MenuItem bottomRightItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-right")));
        bottomRightItem.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(pos.getRow()))).get(SpreadsheetView.this.getModelColumn(pos.getColumn()));
                cell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_RIGHT);
            }
        });
        MenuItem bottomLeftItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-left")));
        bottomLeftItem.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(pos.getRow()))).get(SpreadsheetView.this.getModelColumn(pos.getColumn()));
                cell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_LEFT);
            }
        });
        cornerMenu.getItems().addAll((MenuItem[])new MenuItem[]{topLeftItem, topRightItem, bottomRightItem, bottomLeftItem});
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{copyItem, pasteItem, cornerMenu});
        return contextMenu;
    }

    public void deleteSelectedCells() {
        for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
            this.getGrid().setCellValue(this.getModelRow(position.getRow()), this.getModelColumn(position.getColumn()), null);
        }
    }

    public SpanType getSpanType(int rowIndex, int modelColumn) {
        boolean containsSameCellMinusOne;
        boolean containsRowMinusOne;
        if (this.getGrid() == null) {
            return SpanType.NORMAL_CELL;
        }
        if (rowIndex < 0 || modelColumn < 0 || rowIndex >= this.getItems().size() || modelColumn >= this.getGrid().getColumnCount()) {
            return SpanType.NORMAL_CELL;
        }
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getCellsView().getItems().get(rowIndex)).get(modelColumn);
        int cellColumn = this.getHiddenColumns().nextClearBit(cell.getColumn());
        int cellRowSpan = this.getRowSpanFilter(cell);
        if (cellColumn == modelColumn && cellRowSpan == 1) {
            return SpanType.NORMAL_CELL;
        }
        int cellColumnSpan = this.getColumnSpan(cell);
        GridViewSkin skin = this.getCellsViewSkin();
        boolean bl = containsRowMinusOne = skin == null ? true : skin.containsRow(rowIndex - 1);
        boolean bl2 = rowIndex > 0 ? ((ObservableList)this.getCellsView().getItems().get(rowIndex - 1)).get(modelColumn) == cell : (containsSameCellMinusOne = false);
        if (containsRowMinusOne && cellColumnSpan > 1 && cellColumn != modelColumn && cellRowSpan > 1 && containsSameCellMinusOne) {
            return SpanType.BOTH_INVISIBLE;
        }
        if (cellRowSpan > 1 && cellColumn == modelColumn) {
            if (!containsSameCellMinusOne || !containsRowMinusOne) {
                return SpanType.ROW_VISIBLE;
            }
            return SpanType.ROW_SPAN_INVISIBLE;
        }
        if (!(cellColumnSpan <= 1 || containsSameCellMinusOne && containsRowMinusOne)) {
            if (cellColumn == modelColumn) {
                return SpanType.NORMAL_CELL;
            }
            return SpanType.COLUMN_SPAN_INVISIBLE;
        }
        return SpanType.NORMAL_CELL;
    }

    private TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> getTableColumn(Grid grid, int columnIndex) {
        TableColumn column;
        String columnHeader;
        String string = columnHeader = grid.getColumnHeaders().size() > columnIndex ? (String)grid.getColumnHeaders().get(columnIndex) : Utils.getExcelLetterFromNumber(columnIndex);
        if (columnIndex < this.cellsView.getColumns().size()) {
            column = (TableColumn)this.cellsView.getColumns().get(columnIndex);
            column.setText(columnHeader);
        } else {
            column = new TableColumn(columnHeader);
            column.setEditable(true);
            column.setSortable(false);
            column.setReorderable(false);
            column.setCellValueFactory(p -> {
                if (columnIndex >= ((ObservableList)p.getValue()).size()) {
                    return null;
                }
                return new ReadOnlyObjectWrapper<SpreadsheetCell>((SpreadsheetCell)((ObservableList)p.getValue()).get(columnIndex));
            });
            column.setCellFactory(p -> new CellView(this.handle));
        }
        return column;
    }

    private static Grid getSampleGrid() {
        GridBase gridBase = new GridBase(100, 15);
        ObservableList<ObservableList<SpreadsheetCell>> rows = FXCollections.observableArrayList();
        for (int row = 0; row < gridBase.getRowCount(); ++row) {
            ObservableList<SpreadsheetCell> currentRow = FXCollections.observableArrayList();
            for (int column = 0; column < gridBase.getColumnCount(); ++column) {
                currentRow.add(SpreadsheetCellType.STRING.createCell(row, column, 1, 1, "toto"));
            }
            rows.add(currentRow);
        }
        gridBase.setRows(rows);
        return gridBase;
    }

    private void initRowFix(Grid grid) {
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        int rowSize = rows.size();
        this.rowFix = new BitSet(rowSize);
        this.identityMap = new IdentityHashMap(rowSize);
        block0: for (int r = 0; r < rowSize; ++r) {
            ObservableList row = (ObservableList)rows.get(r);
            this.identityMap.put(row, r);
            for (SpreadsheetCell cell : row) {
                if (this.getRowSpanFilter(cell) <= 1) continue;
                continue block0;
            }
            this.rowFix.set(r);
        }
    }

    private void verifyGrid(Grid grid) {
        this.verifyColumnSpan(grid);
    }

    private void verifyColumnSpan(Grid grid) {
        for (int i = 0; i < grid.getRows().size(); ++i) {
            ObservableList row = (ObservableList)grid.getRows().get(i);
            int count = 0;
            for (int j = 0; j < row.size(); ++j) {
                if (((SpreadsheetCell)row.get(j)).getColumnSpan() == 1) {
                    ++count;
                    continue;
                }
                if (((SpreadsheetCell)row.get(j)).getColumnSpan() > 1) {
                    ++count;
                    SpreadsheetCell currentCell = (SpreadsheetCell)row.get(j);
                    for (int k = j + 1; k < currentCell.getColumn() + currentCell.getColumnSpan(); ++k) {
                        if (!((SpreadsheetCell)row.get(k)).equals(currentCell)) {
                            throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell is in the range of a columnSpan but is different. \nEvery cell in a range of a ColumnSpan must be of the same instance.");
                        }
                        ++count;
                        ++j;
                    }
                    continue;
                }
                throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell has a negative columnSpan");
            }
            if (count == grid.getColumnCount()) continue;
            throw new IllegalStateException("The row" + i + " has a number of cells different of the columnCount declared in the grid.");
        }
    }

    private void checkFormat() {
        this.fmt = DataFormat.lookupMimeType("SpreadsheetView");
        if (this.fmt == null) {
            this.fmt = new DataFormat("SpreadsheetView");
        }
    }

    private String computeReason(List<? extends Integer> list) {
        Object reason = "\n A row cannot be frozen. \n";
        for (Integer n : list) {
            if (this.isRowFixable(n)) continue;
            int maxSpan = 1;
            List gridRow = (List)this.getGrid().getRows().get(n);
            for (SpreadsheetCell cell : gridRow) {
                if (!list.contains(cell.getRow())) {
                    reason = (String)reason + "The row " + n + " is inside a row span and the starting row " + cell.getRow() + " is not frozen.\n";
                }
                if (cell.getRowSpan() <= maxSpan || cell.getRow() != n.intValue()) continue;
                maxSpan = cell.getRowSpan();
            }
            int count = n + maxSpan - 1;
            for (int index = n + 1; index < count; ++index) {
                if (list.contains(index)) continue;
                reason = (String)reason + "One cell on the row " + n + " has a row span of " + maxSpan + ". But the row " + index + " contained within that span is not frozen.\n";
            }
        }
        return reason;
    }

    private boolean isEditionKey(KeyEvent keyEvent) {
        return !keyEvent.isShortcutDown() && !keyEvent.getCode().isNavigationKey() && !keyEvent.getCode().isFunctionKey() && !keyEvent.getCode().isModifierKey() && !keyEvent.getCode().isMediaKey() && keyEvent.getCode() != KeyCode.ESCAPE;
    }

    public static class RowHeightEvent
    extends Event {
        public static final EventType<RowHeightEvent> ROW_HEIGHT_CHANGE = new EventType<Event>(Event.ANY, "RowHeightChange" + UUID.randomUUID().toString());
        private final int modelRow;
        private final double height;

        public RowHeightEvent(int row, double height) {
            super(ROW_HEIGHT_CHANGE);
            this.modelRow = row;
            this.height = height;
        }

        public int getRow() {
            return this.modelRow;
        }

        public double getHeight() {
            return this.height;
        }
    }

    public static enum SpanType {
        NORMAL_CELL,
        COLUMN_SPAN_INVISIBLE,
        ROW_SPAN_INVISIBLE,
        ROW_VISIBLE,
        BOTH_INVISIBLE;

    }

    public static class ColumnWidthEvent
    extends Event {
        public static final EventType<ColumnWidthEvent> COLUMN_WIDTH_CHANGE = new EventType<Event>(Event.ANY, "ColumnWidthChange" + UUID.randomUUID().toString());
        private final int column;
        private final double width;

        public ColumnWidthEvent(int column, double width) {
            super(COLUMN_WIDTH_CHANGE);
            this.column = column;
            this.width = width;
        }

        public int getColumn() {
            return this.column;
        }

        public double getWidth() {
            return this.width;
        }
    }
}

