/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.service;

import com.jiuqi.accds.feign.constant.ReceiverFileType;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.exception.BusinessException;
import com.jiuqi.gov.dzpz.validategui.exception.VerifyFileNameIllegalException;
import com.jiuqi.gov.dzpz.validategui.handle.AtrHandle;
import com.jiuqi.gov.dzpz.validategui.handle.BkerHandle;
import com.jiuqi.gov.dzpz.validategui.handle.BkrsHandle;
import com.jiuqi.gov.dzpz.validategui.handle.CtpHandle;
import com.jiuqi.gov.dzpz.validategui.handle.EfiHandle;
import com.jiuqi.gov.dzpz.validategui.handle.EinvOrdHandle;
import com.jiuqi.gov.dzpz.validategui.handle.EinvSpclHandle;
import com.jiuqi.gov.dzpz.validategui.handle.InvOrdHandle;
import com.jiuqi.gov.dzpz.validategui.handle.InvSpclHandle;
import com.jiuqi.gov.dzpz.validategui.handle.NtrevHandle;
import com.jiuqi.gov.dzpz.validategui.handle.RaiHandle;
import com.jiuqi.gov.dzpz.validategui.util.AccdsReceiverFileUtil;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverFileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReceiverFileService.class);
    InvOrdHandle invOrdHandle = new InvOrdHandle();
    InvSpclHandle invSpclHandle = new InvSpclHandle();
    NtrevHandle ntrevHandle = new NtrevHandle();
    AtrHandle atrHandle = new AtrHandle();
    RaiHandle raiHandle = new RaiHandle();
    EfiHandle efiHandle = new EfiHandle();
    CtpHandle ctpHandle = new CtpHandle();
    BkerHandle bkerHandle = new BkerHandle();
    BkrsHandle bkrsHandle = new BkrsHandle();
    EinvOrdHandle einvOrdHandle = new EinvOrdHandle();
    EinvSpclHandle einvSpclHandle = new EinvSpclHandle();

    public void handle(Path zipFile, ReceiverFileType fileType) throws Exception {
        UserLoginDTO user = this.getAnonymousUser();
        String fileName = String.valueOf(zipFile.getFileName());
        if (fileName != null && fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        ReceiverFileService.validateFileName(fileName);
        ReceiverFileParamsDTO receiverFileParamsDTO = new ReceiverFileParamsDTO();
        receiverFileParamsDTO.setGuest(true);
        receiverFileParamsDTO.setUser(user);
        receiverFileParamsDTO.setUnitcode(user.getLoginUnit());
        Optional<String> unionCode = AccdsReceiverFileUtil.getUnionCodeFromFileName(fileName);
        if (!unionCode.isPresent()) {
            throw new VerifyFileNameIllegalException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5\uff0c\u672a\u627e\u5230\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
        }
        receiverFileParamsDTO.setUnioncode(unionCode.get());
        receiverFileParamsDTO.setCheckOrgFlag(CommonConstant.FALSE);
        receiverFileParamsDTO.setCheckNull(this.getOpenCheckNull());
        receiverFileParamsDTO.setFileType(fileType);
        this.uploadByMemory(zipFile, receiverFileParamsDTO);
    }

    public void uploadByMemory(Path zipFile, ReceiverFileParamsDTO receiverFileParamsDTO) throws Exception {
        ReceiverFileType fileType = receiverFileParamsDTO.getFileType();
        VerifyPair<UploadFileDO, UploadFileDO> filePair = this.initZip(zipFile);
        this.validateXmlName(filePair, fileType);
        this.fileHandleByType(receiverFileParamsDTO, filePair);
    }

    private VerifyPair<UploadFileDO, UploadFileDO> initZip(Path zipFile) throws Exception {
        try (ZipArchiveInputStream zipStream = new ZipArchiveInputStream(new BufferedInputStream(Files.newInputStream(zipFile, new OpenOption[0])), StandardCharsets.UTF_8.name(), false, true);){
            List<UploadFileDO> fileList = this.readZipEntries(zipStream);
            if (fileList.isEmpty()) {
                throw new BusinessException("\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\uff01");
            }
            VerifyPair<UploadFileDO, UploadFileDO> verifyPair = this.createVerifyPair(fileList);
            return verifyPair;
        }
    }

    private List<UploadFileDO> readZipEntries(ZipArchiveInputStream zipStream) throws Exception {
        ZipArchiveEntry entry;
        ArrayList<UploadFileDO> fileList = new ArrayList<UploadFileDO>(2);
        while ((entry = zipStream.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                throw new BusinessException("\u538b\u7f29\u6587\u4ef6\u4e2d\u5305\u542b\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\uff01");
            }
            String xmlName = entry.getName();
            if (!xmlName.toLowerCase().endsWith(".xml")) {
                throw new BusinessException("\u538b\u7f29\u6587\u4ef6\u4e2d\u5305\u542b\u975eXML\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\uff01");
            }
            byte[] xmlBytes = IOUtils.toByteArray(zipStream);
            UploadFileDO uploadFile = new UploadFileDO();
            uploadFile.setFileName(xmlName);
            uploadFile.setContent(new String(xmlBytes, StandardCharsets.UTF_8));
            uploadFile.setType(xmlName.contains(CommonConstant.ISSUER) ? CommonConstant.UP_ISSUER : CommonConstant.UP_RECEIVER);
            fileList.add(uploadFile);
        }
        return fileList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VerifyPair<UploadFileDO, UploadFileDO> createVerifyPair(List<UploadFileDO> fileList) {
        VerifyPair<UploadFileDO, UploadFileDO> result = new VerifyPair<UploadFileDO, UploadFileDO>();
        if (fileList.size() == 1) {
            UploadFileDO file = fileList.get(0);
            if (!file.getFileName().contains("bkrs")) throw new BusinessException("zip\u6587\u4ef6\u4e2d\u7f3a\u5c11XML\uff0c\u8bf7\u68c0\u67e5\u538b\u7f29\u5305\u5185\u5bb9");
            result.setIssuer(file);
            return result;
        } else {
            if (fileList.size() < 2) throw new BusinessException("zip\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\uff01");
            UploadFileDO issuerFile = null;
            ArrayList<UploadFileDO> receiverFiles = new ArrayList<UploadFileDO>();
            for (UploadFileDO file : fileList) {
                String fileName = file.getFileName().toLowerCase();
                if (this.isIssuerFile(fileName)) {
                    if (issuerFile != null) {
                        throw new BusinessException("zip\u6587\u4ef6\u4e2d\u5305\u542b\u591a\u4e2a\u5f00\u5177\u65b9\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\uff01");
                    }
                    issuerFile = file;
                    file.setType(CommonConstant.UP_ISSUER);
                    continue;
                }
                if (!this.isReceiverFile(fileName)) throw new BusinessException("\u65e0\u6cd5\u8bc6\u522b\u6587\u4ef6\u7c7b\u578b\uff1a" + file.getFileName());
                receiverFiles.add(file);
                file.setType(CommonConstant.UP_RECEIVER);
            }
            if (issuerFile == null) {
                throw new BusinessException("zip\u6587\u4ef6\u7f3a\u5c11\u5f00\u5177\u65b9(issuer)\u6587\u4ef6");
            }
            if (receiverFiles.isEmpty() && !issuerFile.getFileName().contains("bkrs")) {
                throw new BusinessException("zip\u6587\u4ef6\u7f3a\u5c11\u63a5\u6536\u65b9(receiver)\u6587\u4ef6");
            }
            result.setIssuer(issuerFile);
            for (UploadFileDO receiverFile : receiverFiles) {
                result.addReceiver(receiverFile);
            }
            this.validateReceiverSequence(receiverFiles);
        }
        return result;
    }

    private boolean isIssuerFile(String fileName) {
        String pattern = "^(einv_ord|einv_spcl|rai|atr|efi|ntrev_gpm|bker|bkrs|inv_ord|inv_spcl|ctp)_issuer\\.xml$";
        return fileName.matches(pattern);
    }

    private boolean isReceiverFile(String fileName) {
        String standardPattern = "^(einv_ord|einv_spcl|rai|atr|efi|ntrev_gpm|bker|bkrs|inv_ord|inv_spcl|ctp)_receiver_\\d{2}\\.xml$";
        String compatPattern = "^(einv_ord|einv_spcl|rai|atr|efi|ntrev_gpm|bker|bkrs|inv_ord|inv_spcl|ctp)_receiver\\.xml$";
        return fileName.matches(standardPattern) || fileName.matches(compatPattern);
    }

    private void validateReceiverSequence(List<UploadFileDO> receiverFiles) {
        if (receiverFiles.size() == 0) {
            return;
        }
        if (receiverFiles.size() == 1) {
            int sequence;
            String compatPattern;
            String fileName = receiverFiles.get(0).getFileName();
            if (fileName.matches(compatPattern = "^([a-z_]+)_receiver\\.xml$")) {
                return;
            }
            String sequencedPattern = "^([a-z_]+)_receiver_(\\d{2})\\.xml$";
            Pattern pattern = Pattern.compile(sequencedPattern);
            Matcher matcher = pattern.matcher(fileName);
            if (matcher.matches() && (sequence = Integer.parseInt(matcher.group(2))) != 1) {
                throw new BusinessException("\u5355\u4e2a\u63a5\u6536\u65b9\u6587\u4ef6\u5982\u679c\u5e26\u5e8f\u53f7\uff0c\u5e8f\u53f7\u5fc5\u987b\u662f01\uff0c\u5f53\u524d\u5e8f\u53f7\u4e3a\uff1a" + String.format("%02d", sequence));
            }
            return;
        }
        ArrayList<Integer> sequences = new ArrayList<Integer>();
        String ticketTypePrefix = null;
        boolean hasSequencedFile = false;
        boolean hasNonSequencedFile = false;
        for (UploadFileDO file : receiverFiles) {
            String currentPrefix;
            String fileName = file.getFileName();
            Pattern sequencedPattern = Pattern.compile("^([a-z_]+)_receiver_(\\d{2})\\.xml$");
            Matcher sequencedMatcher = sequencedPattern.matcher(fileName);
            Pattern nonSequencedPattern = Pattern.compile("^([a-z_]+)_receiver\\.xml$");
            Matcher nonSequencedMatcher = nonSequencedPattern.matcher(fileName);
            if (sequencedMatcher.matches()) {
                hasSequencedFile = true;
                currentPrefix = sequencedMatcher.group(1);
                int sequence = Integer.parseInt(sequencedMatcher.group(2));
                if (ticketTypePrefix == null) {
                    ticketTypePrefix = currentPrefix;
                } else if (!ticketTypePrefix.equals(currentPrefix)) {
                    throw new BusinessException("\u63a5\u6536\u65b9\u6587\u4ef6\u4e2d\u5305\u542b\u4e0d\u540c\u7684\u7968\u636e\u7c7b\u578b\uff1a" + fileName);
                }
                sequences.add(sequence);
                continue;
            }
            if (!nonSequencedMatcher.matches()) continue;
            hasNonSequencedFile = true;
            currentPrefix = nonSequencedMatcher.group(1);
            if (ticketTypePrefix == null) {
                ticketTypePrefix = currentPrefix;
                continue;
            }
            if (ticketTypePrefix.equals(currentPrefix)) continue;
            throw new BusinessException("\u63a5\u6536\u65b9\u6587\u4ef6\u4e2d\u5305\u542b\u4e0d\u540c\u7684\u7968\u636e\u7c7b\u578b\uff1a" + fileName);
        }
        if (hasSequencedFile && hasNonSequencedFile) {
            throw new BusinessException("\u63a5\u6536\u65b9\u6587\u4ef6\u4e0d\u80fd\u540c\u65f6\u5305\u542b\u5e26\u5e8f\u53f7\u548c\u4e0d\u5e26\u5e8f\u53f7\u7684\u6587\u4ef6");
        }
        if (hasNonSequencedFile && receiverFiles.size() > 1) {
            throw new BusinessException("\u4e0d\u5e26\u5e8f\u53f7\u7684\u63a5\u6536\u65b9\u6587\u4ef6\u53ea\u80fd\u6709\u4e00\u4e2a");
        }
        if (hasSequencedFile) {
            sequences.sort(Integer::compareTo);
            if (!sequences.isEmpty() && (Integer)sequences.get(0) != 1) {
                throw new BusinessException("\u63a5\u6536\u65b9\u6587\u4ef6\u5e8f\u53f7\u5fc5\u987b\u4ece01\u5f00\u59cb\uff0c\u5f53\u524d\u7b2c\u4e00\u4e2a\u5e8f\u53f7\u4e3a\uff1a" + String.format("%02d", sequences.get(0)));
            }
            for (int i = 0; i < sequences.size(); ++i) {
                int expectedSequence = i + 1;
                if ((Integer)sequences.get(i) == expectedSequence) continue;
                throw new BusinessException("\u63a5\u6536\u65b9\u6587\u4ef6\u5e8f\u53f7\u4e0d\u8fde\u7eed\uff0c\u671f\u671b\uff1a" + String.format("%02d", expectedSequence) + "\uff0c\u5b9e\u9645\uff1a" + String.format("%02d", sequences.get(i)));
            }
        }
    }

    private static void validateFileName(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            throw new VerifyFileNameIllegalException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String regex = "^receiver_[0-9A-Za-z]{18}$";
        if (!fileName.matches(regex)) {
            throw new VerifyFileNameIllegalException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5");
        }
    }

    private UserLoginDTO getAnonymousUser() {
        UserLoginDTO user = new UserLoginDTO();
        user.setUsername("guest");
        user.setLoginUnit("10000");
        return user;
    }

    public boolean getOpenCheckNull() {
        try {
            File configFile = new File("config.ini");
            if (!configFile.exists()) {
                log.debug("\u914d\u7f6e\u6587\u4ef6 config.ini \u4e0d\u5b58\u5728\uff0c\u9ed8\u8ba4\u5f00\u542f\u975e\u7a7a\u6821\u9a8c");
                return true;
            }
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(configFile);){
                properties.load(fis);
            }
            String checkNullValue = properties.getProperty("check_null");
            if ("false".equalsIgnoreCase(checkNullValue)) {
                log.info("\u914d\u7f6e\u6587\u4ef6\u4e2d check_null=false\uff0c\u5173\u95ed\u975e\u7a7a\u6821\u9a8c");
                return false;
            }
            log.info("\u914d\u7f6e\u6587\u4ef6\u4e2d check_null={}, \u5f00\u542f\u975e\u7a7a\u6821\u9a8c", (Object)checkNullValue);
            return true;
        }
        catch (IOException e) {
            log.warn("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 config.ini \u5931\u8d25\uff0c\u9ed8\u8ba4\u5f00\u542f\u975e\u7a7a\u6821\u9a8c: {}", (Object)e.getMessage());
            return true;
        }
    }

    private void validateXmlName(VerifyPair<UploadFileDO, UploadFileDO> pair, ReceiverFileType fileType) {
        if (fileType == ReceiverFileType.BKRS) {
            return;
        }
        String issuerFileName = pair.getIssuer().getFileName();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        String issuerPattern = "^(einv_ord|einv_spcl|rai|atr|efi|ntrev_gpm|bker|bkrs|inv_ord|inv_spcl|ctp)_issuer\\.xml$";
        Pattern issuerPat = Pattern.compile(issuerPattern);
        Matcher issuerMatcher = issuerPat.matcher(issuerFileName);
        if (!issuerMatcher.matches()) {
            throw new BusinessException("\u65e0\u6cd5\u89e3\u6790\u5f00\u5177\u65b9\u6587\u4ef6\u7684\u7968\u636e\u7c7b\u578b: " + issuerFileName);
        }
        String issuerTicketType = issuerMatcher.group(1);
        String receiverPatternWithSequence = "^(einv_ord|einv_spcl|rai|atr|efi|ntrev_gpm|bker|bkrs|inv_ord|inv_spcl|ctp)_receiver_(\\d{2})\\.xml$";
        String receiverPatternWithoutSequence = "^(einv_ord|einv_spcl|rai|atr|efi|ntrev_gpm|bker|bkrs|inv_ord|inv_spcl|ctp)_receiver\\.xml$";
        for (UploadFileDO receiverFile : receiverFiles) {
            String receiverFileName = receiverFile.getFileName();
            String receiverTicketType = null;
            Pattern receiverPatWithSeq = Pattern.compile(receiverPatternWithSequence);
            Matcher receiverMatcherWithSeq = receiverPatWithSeq.matcher(receiverFileName);
            if (receiverMatcherWithSeq.matches()) {
                receiverTicketType = receiverMatcherWithSeq.group(1);
            } else {
                Pattern receiverPatWithoutSeq = Pattern.compile(receiverPatternWithoutSequence);
                Matcher receiverMatcherWithoutSeq = receiverPatWithoutSeq.matcher(receiverFileName);
                if (receiverMatcherWithoutSeq.matches()) {
                    receiverTicketType = receiverMatcherWithoutSeq.group(1);
                }
            }
            if (receiverTicketType != null) {
                if (receiverTicketType.equals(issuerTicketType)) continue;
                throw new BusinessException("\u5f00\u5177\u65b9\u548c\u63a5\u6536\u65b9\u6587\u4ef6\u7684\u7968\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5f00\u5177\u65b9: " + issuerTicketType + "\uff0c\u63a5\u6536\u65b9: " + receiverTicketType);
            }
            throw new BusinessException("\u65e0\u6cd5\u89e3\u6790\u63a5\u6536\u65b9\u6587\u4ef6\u7684\u7968\u636e\u7c7b\u578b: " + receiverFileName);
        }
        ReceiverFileType expectedType = ReceiverFileType.getFromCode(issuerTicketType).orElseThrow(() -> new BusinessException("\u672a\u77e5\u7684\u7968\u636e\u7c7b\u578b: " + issuerTicketType));
        if (expectedType != fileType) {
            throw new BusinessException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d: \u9884\u671f " + String.valueOf((Object)fileType) + ", \u5b9e\u9645 " + String.valueOf((Object)expectedType));
        }
    }

    private void fileHandleByType(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        switch (receiverFileParamsDTO.getFileType()) {
            case INV_ORD: {
                this.invOrdHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case INV_SPCL: {
                this.invSpclHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case NTREV_GPM: {
                this.ntrevHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case RAI: {
                this.raiHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case ATR: {
                this.atrHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case BKER: {
                this.bkerHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case BKRS: {
                this.bkrsHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case EINV_ORD: {
                this.einvOrdHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case EINV_SPCL: {
                this.einvSpclHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case EFI: {
                this.efiHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            case CTP: {
                this.ctpHandle.handleFile(receiverFileParamsDTO, pair);
                break;
            }
            default: {
                throw new BusinessException(String.format("\u672a\u77e5\u7684\u6587\u4ef6\u7c7b\u578b:%s", receiverFileParamsDTO.getFileType().getCode()));
            }
        }
    }
}

