/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.einv.ord.issDetail.EinvOrdReceiverIssuerDetailDO;
import com.jiuqi.accds.feign.domain.vo.EinvOrdReceiverVO;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.EinvOrdReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.Assert;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.gov.dzpz.validategui.util.XmlToJsonUtil;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EinvOrdHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EinvOrdHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        if (pair.isEmpty()) {
            throw new ValidateException("\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        UploadFileDO issuerFile = pair.getIssuer();
        String issXml = issuerFile.getContent();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, issXml, receiverFile.getContent());
            }
            catch (Exception e) {
                log.error("\u5904\u7406 EinvOrd \u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25", e);
                throw new ValidateException(e.getMessage(), e);
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, String issXml, String receiverXml) throws Exception {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        JSONObject einvOrdIssuer = XmlToJsonUtil.xml2Json(issXml);
        EinvOrdReceiver einvOrdReceiver = CommonUtils.xbrlToObject("einv_ord_receiver", receiverXml, new TypeReference<EinvOrdReceiver>(this){});
        if (ObjectUtils.isEmpty(einvOrdIssuer) || ObjectUtils.isEmpty(einvOrdReceiver)) {
            throw new ValidateException("\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        JSONObject eInvoiceData = einvOrdIssuer.getJSONObject("EInvoiceData");
        Assert.notNull(eInvoiceData, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7968\u9762\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject header = einvOrdIssuer.getJSONObject("Header");
        Assert.notNull(header, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5934\u90e8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String eIid = header.getString("EIid");
        JSONObject buyerInformation = eInvoiceData.getJSONObject("BuyerInformation");
        Assert.notNull(buyerInformation, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7968\u9762\u4fe1\u606f==>\u8d2d\u4e70\u65b9\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String buyerIdNum = buyerInformation.getString("BuyerIdNum");
        String invoiceNumber = einvOrdReceiver.getInvoiceNumber();
        if (ObjectUtils.isEmpty(eIid) || ObjectUtils.isEmpty(invoiceNumber) || !eIid.equals(invoiceNumber)) {
            throw new ValidateException("\u3010\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6InvoiceNumber\uff08\u53d1\u7968\u552f\u4e00\u6807\u8bc6\uff09\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        if (!unioncode.equals(buyerIdNum) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u7968\u636e\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u7968\u636e\u6587\u4ef6\uff1a" + buyerIdNum + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        if (!unioncode.equals(einvOrdReceiver.getUnifiedSocialCreditCodeOfAccountingEntity()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968) \u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011 \u51ed\u8bc1\u6587\u4ef6\uff1a" + einvOrdReceiver.getUnifiedSocialCreditCodeOfAccountingEntity() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        EinvOrdReceiverVO einvOrdReceiverVO = new EinvOrdReceiverVO();
        this.addMainData(einvOrdIssuer, einvOrdReceiverVO);
        this.addDetailData(eInvoiceData, einvOrdReceiverVO);
        ArrayList<UploadFileDO> tempList = new ArrayList<UploadFileDO>();
        UploadFileDO issuerUpload = new UploadFileDO();
        issuerUpload.setContent(issXml);
        issuerUpload.setType(CommonConstant.UP_ISSUER);
        UploadFileDO receiverUpload = new UploadFileDO();
        receiverUpload.setContent(receiverXml);
        receiverUpload.setType(CommonConstant.UP_RECEIVER);
        tempList.add(issuerUpload);
        tempList.add(receiverUpload);
        boolean account = this.account(tempList, user, isCheckNull, einvOrdReceiver, einvOrdReceiverVO, invoiceNumber, fileId);
        if (!account) {
            return;
        }
        einvOrdReceiverVO.setAccountHandle(true);
        einvOrdReceiverVO.setEnterprise(false);
        einvOrdReceiverVO.setExistvoucher(1);
        einvOrdReceiverVO.setUnitcode(unitcode);
        einvOrdReceiverVO.setUserLoginDTO(user);
        if (isCheckNull && !(checkStatus = this.checkUniformity(einvOrdReceiverVO))) {
            throw new ValidateException("\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
    }

    private boolean account(List<UploadFileDO> list, UserLoginDTO user, boolean isCheckNull, EinvOrdReceiver einvOrdReceiver, EinvOrdReceiverVO einvOrdReceiverVO, String invoiceNumber, String fileId) {
        ArrayList<String> resultList = new ArrayList<String>();
        String whetherEinvoiceIsRedEinvoice = einvOrdReceiver.getWhetherEinvoiceIsRedEinvoice();
        String whetherEinvoiceHasBeenChecked = einvOrdReceiver.getWhetherEinvoiceHasBeenChecked();
        String whetherEinvoiceHasBeenBooked = einvOrdReceiver.getWhetherEinvoiceHasBeenBooked();
        String unifiedSocialCreditCodeOfAccountingEntity = einvOrdReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = einvOrdReceiver.getNameOfAccountingEntity();
        List<InformationOfAccountingDocumentsTuple> accountList = einvOrdReceiver.getInformationOfAccountingDocumentsTuple();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(invoiceNumber)) {
                flag = 2;
                resultList.add("\u3010InvoiceNumber\uff08\u53d1\u7968\u552f\u4e00\u6807\u8bc6\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherEinvoiceIsRedEinvoice) || whetherEinvoiceIsRedEinvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherEinvoiceIsRedEinvoice\uff08\u662f\u5426\u7ea2\u5b57\u53d1\u7968\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherEinvoiceHasBeenChecked) || whetherEinvoiceHasBeenChecked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherEinvoiceHasBeenChecked\uff08\u662f\u5426\u5df2\u9a8c\u771f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherEinvoiceHasBeenBooked) || whetherEinvoiceHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherEinvoiceHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(list) && (stringBuilder = AccountDataManageUtil.checkAccountData(accountList)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u6570\u7535\u7968-\u666e\u901a\u7968\u5fc5\u586b\u9879\u68c0\u67e5\u4e0d\u901a\u8fc7:" + JSON.toJSONString(resultList));
            }
        }
        einvOrdReceiverVO.setRecsellername(einvOrdReceiver.getSellerName());
        einvOrdReceiverVO.setRecselleridnum(einvOrdReceiver.getSellerIdNum());
        einvOrdReceiverVO.setRectotalamwithouttax(CommonUtils.stringToBigDecimal(einvOrdReceiver.getTotalAmWithoutTax()));
        einvOrdReceiverVO.setRectotaltaxam(CommonUtils.stringToBigDecimal(einvOrdReceiver.getTotalTaxAm()));
        einvOrdReceiverVO.setRectotaltaxincludedamount(CommonUtils.stringToBigDecimal(einvOrdReceiver.getTotalTaxIncludedAmount()));
        einvOrdReceiverVO.setRecrequesttime(einvOrdReceiver.getRequestTime());
        einvOrdReceiverVO.setReccontractnumber(einvOrdReceiver.getContractNumber());
        einvOrdReceiverVO.setRecmatchingstate(einvOrdReceiver.getMatchingStateBetweenBusinessDocumentsAndVatEinvoice());
        einvOrdReceiverVO.setRecdepreciationmethods(einvOrdReceiver.getDepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets());
        einvOrdReceiverVO.setRechasbeenfactored(einvOrdReceiver.getWhetherEinvoiceHasBeenFactoredSoldOrSecuritized());
        einvOrdReceiverVO.setRechasbeenpaid(einvOrdReceiver.getWhetherEinvoiceHasBeenPaid());
        einvOrdReceiverVO.setRecnumberofbank(einvOrdReceiver.getNumberOfBankElectronicReceipt());
        einvOrdReceiverVO.setRechasbeencompleted(einvOrdReceiver.getWhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted());
        einvOrdReceiverVO.setRecbeginningofpretax(einvOrdReceiver.getBeginningOfPreTaxDeductionYearOfIncomeTax());
        einvOrdReceiverVO.setRecbeginofexpend(einvOrdReceiver.getEndOfPreTaxDeductionYearOfIncomeTax());
        einvOrdReceiverVO.setRecbeginofexpend(einvOrdReceiver.getBeginningOfExpenditurePeriodUnderAccrualBasis());
        einvOrdReceiverVO.setRecendofexpend(einvOrdReceiver.getEndOfExpenditurePeriodUnderAccrualBasis());
        einvOrdReceiverVO.setInvoicenumber(invoiceNumber);
        einvOrdReceiverVO.setRecisredeinvoice(whetherEinvoiceIsRedEinvoice);
        einvOrdReceiverVO.setRechasbeenchecked(whetherEinvoiceHasBeenChecked);
        einvOrdReceiverVO.setRechasbeenbooked(whetherEinvoiceHasBeenBooked);
        einvOrdReceiverVO.setRecunifiedsocial(unifiedSocialCreditCodeOfAccountingEntity);
        einvOrdReceiverVO.setRecnameofaccount(nameOfAccountingEntity);
        if (!CollectionUtils.isEmpty(accountList)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(accountList);
            einvOrdReceiverVO.setAccountList(detailList);
        }
        return true;
    }

    private boolean checkUniformity(EinvOrdReceiverVO einvOrdReceiverVO) {
        if (!Objects.equals(einvOrdReceiverVO.getIsssellername(), einvOrdReceiverVO.getRecsellername())) {
            return false;
        }
        if (!Objects.equals(einvOrdReceiverVO.getIssselleridnum(), einvOrdReceiverVO.getRecselleridnum())) {
            return false;
        }
        if (!Objects.equals(einvOrdReceiverVO.getIsstotalamwithouttax(), einvOrdReceiverVO.getRectotalamwithouttax())) {
            return false;
        }
        if (!Objects.equals(einvOrdReceiverVO.getIsstotaltaxam(), einvOrdReceiverVO.getRectotaltaxam())) {
            return false;
        }
        if (!Objects.equals(einvOrdReceiverVO.getIssrequesttime(), einvOrdReceiverVO.getRecrequesttime())) {
            return false;
        }
        return Objects.equals(einvOrdReceiverVO.getIssincludedamount(), einvOrdReceiverVO.getRectotaltaxincludedamount());
    }

    public void addDetailData(JSONObject eInvoiceData, EinvOrdReceiverVO einvOrdReceiverVO) {
        Object issuItemInformationObj = eInvoiceData.get("IssuItemInformation");
        ArrayList<EinvOrdReceiverIssuerDetailDO> detailDOArraylist = new ArrayList<EinvOrdReceiverIssuerDetailDO>();
        if (issuItemInformationObj instanceof JSONObject) {
            this.handleDetailList((JSONObject)issuItemInformationObj, detailDOArraylist);
        }
        if (issuItemInformationObj instanceof JSONArray) {
            for (Object item : (JSONArray)issuItemInformationObj) {
                this.handleDetailList((JSONObject)item, detailDOArraylist);
            }
        }
        einvOrdReceiverVO.setIssuerDetailList(detailDOArraylist);
    }

    public void handleDetailList(JSONObject issuItemInformationObj, List<EinvOrdReceiverIssuerDetailDO> detailDOArraylist) {
        String itemName = issuItemInformationObj.getString("ItemName");
        String specMod = issuItemInformationObj.getString("SpecMod");
        String meaUnits = issuItemInformationObj.getString("MeaUnits");
        String quantity = issuItemInformationObj.getString("Quantity");
        String unPrice = issuItemInformationObj.getString("UnPrice");
        String amount = issuItemInformationObj.getString("Amount");
        String taxRate = issuItemInformationObj.getString("TaxRate");
        String comTaxAm = issuItemInformationObj.getString("ComTaxAm");
        String totaltaxIncludedAmount = issuItemInformationObj.getString("TotaltaxIncludedAmount");
        String taxClassificationCode = issuItemInformationObj.getString("TaxClassificationCode");
        EinvOrdReceiverIssuerDetailDO einvOrdReceiverIssuerDetailDO = new EinvOrdReceiverIssuerDetailDO();
        einvOrdReceiverIssuerDetailDO.setItemname(itemName);
        einvOrdReceiverIssuerDetailDO.setSpecmod(specMod);
        einvOrdReceiverIssuerDetailDO.setMeaunits(meaUnits);
        einvOrdReceiverIssuerDetailDO.setQuantity(CommonUtils.stringToBigDecimal(quantity));
        einvOrdReceiverIssuerDetailDO.setUnprice(unPrice);
        einvOrdReceiverIssuerDetailDO.setAmount(CommonUtils.stringToBigDecimal(amount));
        einvOrdReceiverIssuerDetailDO.setTaxrate(taxRate);
        einvOrdReceiverIssuerDetailDO.setComtaxam(CommonUtils.stringToBigDecimal(comTaxAm));
        einvOrdReceiverIssuerDetailDO.setTotaltaxincludedamount(CommonUtils.stringToBigDecimal(totaltaxIncludedAmount));
        einvOrdReceiverIssuerDetailDO.setTaxclassificationcode(taxClassificationCode);
        detailDOArraylist.add(einvOrdReceiverIssuerDetailDO);
    }

    public void addMainData(JSONObject sreObject, EinvOrdReceiverVO einvOrdReceiverVO) throws Exception {
        JSONObject additionalInformation;
        JSONObject redEInvoice;
        JSONObject eInvoiceData = sreObject.getJSONObject("EInvoiceData");
        Assert.notNull(eInvoiceData, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7968\u9762\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject sellerAuthentication = sreObject.getJSONObject("SellerAuthentication");
        Assert.notNull(sellerAuthentication, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5f00\u7968\u65b9\u8ba4\u8bc1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject taxBureauSignature = sreObject.getJSONObject("TaxBureauSignature");
        Assert.notNull(taxBureauSignature, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7a0e\u52a1\u5c40\u6570\u5b57\u7b7e\u540d\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject header = sreObject.getJSONObject("Header");
        Assert.notNull(header, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5934\u90e8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject taxSupervisionInfo = sreObject.getJSONObject("TaxSupervisionInfo");
        Assert.notNull(taxSupervisionInfo, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7a0e\u52a1\u76d1\u5236\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String eInvoiceTag = header.getString("EInvoiceTag");
        String version = header.getString("Version");
        JSONObject inherentLabel = header.getJSONObject("InherentLabel");
        Assert.notNull(inherentLabel, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5934\u90e8\u4fe1\u606f==>\u56fa\u5b9a\u6807\u7b7e\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject inIssuType = inherentLabel.getJSONObject("InIssuType");
        Assert.notNull(inIssuType, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5934\u90e8\u4fe1\u606f>>>\u56fa\u5b9a\u6807\u7b7e==>\u5f00\u7968\u7c7b\u578b\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject eInvoiceType = inherentLabel.getJSONObject("EInvoiceType");
        Assert.notNull(eInvoiceType, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5934\u90e8\u4fe1\u606f>>>\u56fa\u5b9a\u6807\u7b7e==>\u53d1\u7968\u7968\u79cd\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject generalOrSpecialVAT = inherentLabel.getJSONObject("GeneralOrSpecialVAT");
        Assert.notNull(generalOrSpecialVAT, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5934\u90e8\u4fe1\u606f>>>\u56fa\u5b9a\u6807\u7b7e==>\u7968\u79cd\u7c7b\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject taxpayerType = inherentLabel.getJSONObject("TaxpayerType");
        Assert.notNull(taxpayerType, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u5934\u90e8\u4fe1\u606f>>>\u56fa\u5b9a\u6807\u7b7e==>\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String inIssuType_labelCode = inIssuType.getString("LabelCode");
        String inIssuType_labelName = inIssuType.getString("LabelName");
        String eInvoiceType_labelCode = eInvoiceType.getString("LabelCode");
        String eInvoiceType_labelName = eInvoiceType.getString("LabelName");
        String generalOrSpecialVAT_labelCode = generalOrSpecialVAT.getString("LabelCode");
        String generalOrSpecialVAT_labelName = generalOrSpecialVAT.getString("LabelName");
        String taxpayerType_labelCode = taxpayerType.getString("LabelCode");
        String taxpayerType_labelName = taxpayerType.getString("LabelName");
        JSONObject sellerInformation = eInvoiceData.getJSONObject("SellerInformation");
        Assert.notNull(sellerInformation, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7968\u9762\u4fe1\u606f==>\u9500\u552e\u65b9\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String sellerIdNum = sellerInformation.getString("SellerIdNum");
        String sellerName = sellerInformation.getString("SellerName");
        String sellerAddr = sellerInformation.getString("SellerAddr");
        String sellerTelNum = sellerInformation.getString("SellerTelNum");
        String sellerBankName = sellerInformation.getString("SellerBankName");
        String sellerBankAccNum = sellerInformation.getString("SellerBankAccNum");
        JSONObject buyerInformation = eInvoiceData.getJSONObject("BuyerInformation");
        Assert.notNull(buyerInformation, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7968\u9762\u4fe1\u606f==>\u8d2d\u4e70\u65b9\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String buyerIdNum = buyerInformation.getString("BuyerIdNum");
        String buyerName = buyerInformation.getString("BuyerName");
        String buyerAddr = buyerInformation.getString("BuyerAddr");
        String buyerTelNum = buyerInformation.getString("BuyerTelNum");
        String buyerBankName = buyerInformation.getString("BuyerBankName");
        String buyerBankAccNum = buyerInformation.getString("BuyerBankAccNum");
        String buyerHandlingName = buyerInformation.getString("BuyerHandlingName");
        JSONObject basicInformation = eInvoiceData.getJSONObject("BasicInformation");
        Assert.notNull(basicInformation, "\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)>>>\u7968\u9762\u4fe1\u606f==>\u7968\u9762\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String totalAmWithoutTax = basicInformation.getString("TotalAmWithoutTax");
        String totalTaxAm = basicInformation.getString("TotalTaxAm");
        String includedAmount = basicInformation.getString("TotalTax-includedAmount");
        String includedAmountInChinese = basicInformation.getString("TotalTax-includedAmountInChinese");
        String drawer = basicInformation.getString("Drawer");
        String requestTime = basicInformation.getString("RequestTime");
        String invoiceNumber = taxSupervisionInfo.getString("InvoiceNumber");
        String issueTime = taxSupervisionInfo.getString("IssueTime");
        String taxBureauCode = taxSupervisionInfo.getString("TaxBureauCode");
        String taxBureauName = taxSupervisionInfo.getString("TaxBureauName");
        einvOrdReceiverVO.setIsseinvoicetag(eInvoiceTag);
        einvOrdReceiverVO.setIsseinvversion(version);
        einvOrdReceiverVO.setIssinissutypecode(inIssuType_labelCode);
        einvOrdReceiverVO.setIssinissutypename(inIssuType_labelName);
        einvOrdReceiverVO.setIsseinvoicetypecode(eInvoiceType_labelCode);
        einvOrdReceiverVO.setIsseinvoicetypename(eInvoiceType_labelName);
        einvOrdReceiverVO.setIssgeneralorcode(generalOrSpecialVAT_labelCode);
        einvOrdReceiverVO.setIssgeneralorname(generalOrSpecialVAT_labelName);
        einvOrdReceiverVO.setIsstaxpayertypecode(taxpayerType_labelCode);
        einvOrdReceiverVO.setIsstaxpayertypename(taxpayerType_labelName);
        einvOrdReceiverVO.setIssselleridnum(sellerIdNum);
        einvOrdReceiverVO.setIsssellername(sellerName);
        einvOrdReceiverVO.setIssselleraddr(sellerAddr);
        einvOrdReceiverVO.setIsssellertelnum(sellerTelNum);
        einvOrdReceiverVO.setIsssellerbankname(sellerBankName);
        einvOrdReceiverVO.setIsssellerbankaccnum(sellerBankAccNum);
        einvOrdReceiverVO.setIssbuyeridnum(buyerIdNum);
        einvOrdReceiverVO.setIssbuyername(buyerName);
        einvOrdReceiverVO.setIssbuyeraddr(buyerAddr);
        einvOrdReceiverVO.setIssbuyertelnum(buyerTelNum);
        einvOrdReceiverVO.setIssbuyerbankname(buyerBankName);
        einvOrdReceiverVO.setIssbuyerbankaccnum(buyerBankAccNum);
        einvOrdReceiverVO.setIssbuyerhandlingname(buyerHandlingName);
        einvOrdReceiverVO.setIsstotalamwithouttax(CommonUtils.stringToBigDecimal(totalAmWithoutTax));
        einvOrdReceiverVO.setIsstotaltaxam(CommonUtils.stringToBigDecimal(totalTaxAm));
        einvOrdReceiverVO.setIssincludedamount(CommonUtils.stringToBigDecimal(includedAmount));
        einvOrdReceiverVO.setIssincludedamountinchinese(includedAmountInChinese);
        einvOrdReceiverVO.setIssdrawer(drawer);
        einvOrdReceiverVO.setIssrequesttime(CommonUtils.covertDate(requestTime));
        JSONObject specificInformation = eInvoiceData.getJSONObject("SpecificInformation");
        if (specificInformation != null && (redEInvoice = specificInformation.getJSONObject("RedEInvoice")) != null) {
            String originalInvoiceCode = redEInvoice.getString("OriginalInvoiceCode");
            einvOrdReceiverVO.setIssoriginalinvoicecode(originalInvoiceCode);
        }
        if ((additionalInformation = eInvoiceData.getJSONObject("AdditionalInformation")) != null) {
            String remark = additionalInformation.getString("Remark");
            einvOrdReceiverVO.setIssremark(remark);
        }
        einvOrdReceiverVO.setIssinvoicenumber(invoiceNumber);
        einvOrdReceiverVO.setIssuetime(CommonUtils.covertDate(issueTime));
        einvOrdReceiverVO.setIsstaxbureaucode(taxBureauCode);
        einvOrdReceiverVO.setIsstaxbureauname(taxBureauName);
    }
}

