/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.efi.issDetail.EfiReceiverIssuerDetailDO;
import com.jiuqi.accds.feign.domain.vo.EfiReceiverVO;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.EfiReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.Assert;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.gov.dzpz.validategui.util.XmlToJsonUtil;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EfiHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EfiHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        UploadFileDO issuerFile = pair.getIssuer();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        if (issuerFile == null || CollectionUtils.isEmpty(receiverFiles)) {
            throw new ValidateException("\u8d22\u653f\u7968\u636e\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issXml = issuerFile.getContent();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, issXml, receiverFile.getContent());
            }
            catch (Exception e) {
                log.error("\u8d22\u653f\u7968\u636e\u5904\u7406\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                throw new ValidateException(e.getMessage(), e);
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, String issXml, String receiverXml) throws Exception {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        JSONObject efiIssuer = XmlToJsonUtil.xml2Json(issXml);
        EfiReceiver efiReceiver = CommonUtils.xbrlToObject("efi", receiverXml, new TypeReference<EfiReceiver>(this){});
        if (ObjectUtils.isEmpty(efiIssuer) || ObjectUtils.isEmpty(efiReceiver)) {
            throw new ValidateException("\u8d22\u653f\u7968\u636e\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        JSONObject eInvoiceData = efiIssuer.getJSONObject("EInvoiceData");
        Assert.notNull(eInvoiceData, "\u8d22\u653f\u7968\u636e>>>\u7968\u9762\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject header = efiIssuer.getJSONObject("Header");
        Assert.notNull(header, "\u8d22\u653f\u7968\u636e>>>\u5934\u90e8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String iss_eInvoiceID = header.getString("EInvoiceID");
        String rec_eInvoiceID = efiReceiver.geteInvoiceID();
        if (ObjectUtils.isEmpty(iss_eInvoiceID) || ObjectUtils.isEmpty(rec_eInvoiceID)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u8d22\u653f\u7968\u636e\u7968\u636e\u4fe1\u606f\u6216\u8005\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7f3a\u5931\u7535\u5b50\u7968\u636e\u6807\u8bc6\u3011");
        }
        if (!iss_eInvoiceID.equals(rec_eInvoiceID)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u8d22\u653f\u7968\u636e\u7968\u636e\u4fe1\u606f\u4e0e\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6 EInvoiceID\uff08\u7535\u5b50\u7968\u636e\u6807\u8bc6\uff09\u4e0d\u4e00\u81f4\u3011");
        }
        if (!unioncode.equals(efiReceiver.getUnifiedSocialCreditCodeOfAccountingEntity()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u8d22\u653f\u7968\u636e \u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011 \u51ed\u8bc1\u6587\u4ef6\uff1a" + efiReceiver.getUnifiedSocialCreditCodeOfAccountingEntity() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        EfiReceiverVO efiReceiverVO = new EfiReceiverVO();
        this.addMainData(efiIssuer, efiReceiverVO);
        this.addDetailData(eInvoiceData, efiReceiverVO);
        ArrayList<UploadFileDO> tempList = new ArrayList<UploadFileDO>();
        UploadFileDO issuerUpload = new UploadFileDO();
        issuerUpload.setContent(issXml);
        issuerUpload.setType(CommonConstant.UP_ISSUER);
        UploadFileDO receiverUpload = new UploadFileDO();
        receiverUpload.setContent(receiverXml);
        receiverUpload.setType(CommonConstant.UP_RECEIVER);
        tempList.add(issuerUpload);
        tempList.add(receiverUpload);
        boolean account = this.account(tempList, user, isCheckNull, efiReceiver, rec_eInvoiceID, efiReceiverVO, fileId);
        if (!account) {
            return;
        }
        efiReceiverVO.setAccountHandle(true);
        efiReceiverVO.setEnterprise(false);
        efiReceiverVO.setUnitcode(unitcode);
        efiReceiverVO.setUserLoginDTO(user);
        efiReceiverVO.setExistvoucher(1);
        if (isCheckNull && !(checkStatus = this.checkUniformity(efiReceiverVO))) {
            throw new ValidateException("\u8d22\u653f\u7968\u636e\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
    }

    private boolean account(List<UploadFileDO> list, UserLoginDTO user, boolean isCheckNull, EfiReceiver efiReceiver, String eInvoiceID, EfiReceiverVO efiReceiverVO, String fileId) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        String whetherEinvoiceIsRedEinvoice = efiReceiver.getWhetherInvoiceIsRedInvoice();
        String whetherEinvoiceHasBeenChecked = efiReceiver.getWhetherInvoiceHasBeenChecked();
        String whetherEinvoiceHasBeenBooked = efiReceiver.getWhetherInvoiceHasBeenBooked();
        String unifiedSocialCreditCodeOfAccountingEntity = efiReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = efiReceiver.getNameOfAccountingEntity();
        List<InformationOfAccountingDocumentsTuple> accountList = efiReceiver.getInformationOfAccountingDocumentsTuple();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(eInvoiceID)) {
                flag = 2;
                resultList.add("\u3010EInvoiceID\uff08\u7535\u5b50\u7968\u636e\u6807\u8bc6\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherEinvoiceIsRedEinvoice) || whetherEinvoiceIsRedEinvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceIsRedInvoice\uff08\u662f\u5426\u7ea2\u5b57\u7968\u636e\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherEinvoiceHasBeenChecked) || whetherEinvoiceHasBeenChecked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenChecked\uff08\u662f\u5426\u5df2\u9a8c\u771f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherEinvoiceHasBeenBooked) || whetherEinvoiceHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(list) && (stringBuilder = AccountDataManageUtil.checkAccountData(accountList)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u8d22\u653f\u7968\u636e\u5fc5\u586b\u9879\u68c0\u67e5\u4e0d\u901a\u8fc7:" + JSON.toJSONString(resultList));
            }
        }
        efiReceiverVO.setRecinvoicingpartyname(efiReceiver.getInvoicingPartyName());
        efiReceiverVO.setRecinvoicingpartycode(efiReceiver.getInvoicingPartyCode());
        efiReceiverVO.setRecissuedate(CommonUtils.covertDate(efiReceiver.getIssueDate()));
        efiReceiverVO.setRectotalamount(CommonUtils.stringToBigDecimal(efiReceiver.getTotalAmount()));
        efiReceiverVO.setEinvoiceid(eInvoiceID);
        efiReceiverVO.setRecisredinvoice(whetherEinvoiceIsRedEinvoice);
        efiReceiverVO.setRechasbeenchecked(whetherEinvoiceHasBeenChecked);
        efiReceiverVO.setRechasbeenbooked(whetherEinvoiceHasBeenBooked);
        efiReceiverVO.setRecunifiedsocial(unifiedSocialCreditCodeOfAccountingEntity);
        efiReceiverVO.setRecnameofaccount(nameOfAccountingEntity);
        if (!CollectionUtils.isEmpty(accountList)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(accountList);
            efiReceiverVO.setAccountList(detailList);
        }
        return true;
    }

    private boolean checkUniformity(EfiReceiverVO efiReceiverVO) {
        if (!Objects.equals(efiReceiverVO.getIssinvoicingpartycode(), efiReceiverVO.getRecinvoicingpartycode())) {
            return false;
        }
        if (!Objects.equals(efiReceiverVO.getIssinvoicingpartyname(), efiReceiverVO.getRecinvoicingpartyname())) {
            return false;
        }
        if (!Objects.equals(efiReceiverVO.getIssuedate(), efiReceiverVO.getRecissuedate())) {
            return false;
        }
        return Objects.equals(efiReceiverVO.getIsstotalamount(), efiReceiverVO.getRectotalamount());
    }

    public void addDetailData(JSONObject eInvoiceData, EfiReceiverVO efiReceiverVO) {
        JSONObject details = eInvoiceData.getJSONObject("Details");
        Object item = details.get("Item");
        ArrayList<EfiReceiverIssuerDetailDO> detailDOArraylist = new ArrayList<EfiReceiverIssuerDetailDO>();
        if (item instanceof JSONObject) {
            this.handleDetailList((JSONObject)item, detailDOArraylist);
        }
        if (item instanceof JSONArray) {
            for (Object obj : (JSONArray)item) {
                this.handleDetailList((JSONObject)obj, detailDOArraylist);
            }
        }
        efiReceiverVO.setIssuerDetailList(detailDOArraylist);
    }

    public void handleDetailList(JSONObject item, List<EfiReceiverIssuerDetailDO> detailDOArraylist) {
        String itemCode = item.getString("ItemCode");
        String itemName = item.getString("ItemName");
        String itemQuantity = item.getString("ItemQuantity");
        String itemUnit = item.getString("ItemUnit");
        String itemStd = item.getString("ItemStd");
        String itemAmount = item.getString("ItemAmount");
        String itemRemark = item.getString("ItemRemark");
        EfiReceiverIssuerDetailDO efiReceiverIssuerDetailDO = new EfiReceiverIssuerDetailDO();
        efiReceiverIssuerDetailDO.setItemcode(itemCode);
        efiReceiverIssuerDetailDO.setItemname(itemName);
        efiReceiverIssuerDetailDO.setItemquantity(CommonUtils.stringToBigDecimal(itemQuantity));
        efiReceiverIssuerDetailDO.setItemunit(itemUnit);
        efiReceiverIssuerDetailDO.setItemstd(itemStd);
        efiReceiverIssuerDetailDO.setItemamount(CommonUtils.stringToBigDecimal(itemAmount));
        efiReceiverIssuerDetailDO.setItemremark(itemRemark);
        detailDOArraylist.add(efiReceiverIssuerDetailDO);
    }

    public void addMainData(JSONObject sreObject, EfiReceiverVO efiReceiverVO) throws Exception {
        JSONObject eInvoiceData = sreObject.getJSONObject("EInvoiceData");
        Assert.notNull(eInvoiceData, "\u8d22\u653f\u7968\u636e>>>\u7968\u9762\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject header = sreObject.getJSONObject("Header");
        Assert.notNull(header, "\u8d22\u653f\u7968\u636e>>>\u5934\u90e8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        JSONObject main = eInvoiceData.getJSONObject("Main");
        Assert.notNull(main, "\u8d22\u653f\u7968\u636e>>>\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        String eInvoiceCode = main.getString("EInvoiceCode");
        String eInvoiceNumber = main.getString("EInvoiceNumber");
        JSONObject payerParty = main.getJSONObject("PayerParty");
        if (!ObjectUtils.isEmpty(payerParty)) {
            String payerPartyCode = payerParty.getString("PayerPartyCode");
            efiReceiverVO.setIsspayerpartycode(payerPartyCode);
            String payerPartyName = payerParty.getString("PayerPartyName");
            efiReceiverVO.setIsspayerpartyname(payerPartyName);
        }
        String randomNumber = main.getString("RandomNumber");
        String issueDate = main.getString("IssueDate");
        String totalAmount = main.getString("TotalAmount");
        String remark = main.getString("Remark");
        JSONObject invoicingParty = main.getJSONObject("InvoicingParty");
        if (!ObjectUtils.isEmpty(invoicingParty)) {
            String invoicingPartyName = invoicingParty.getString("InvoicingPartyName");
            efiReceiverVO.setIssinvoicingpartyname(invoicingPartyName);
            String invoicingPartyCode = invoicingParty.getString("InvoicingPartyCode");
            efiReceiverVO.setIssinvoicingpartycode(invoicingPartyCode);
        }
        String checker = main.getString("Checker");
        String handlingPerson = main.getString("HandlingPerson");
        efiReceiverVO.setIsseinvoicecode(eInvoiceCode);
        efiReceiverVO.setIsseinvoicenumber(eInvoiceNumber);
        efiReceiverVO.setIssrandomnumber(randomNumber);
        efiReceiverVO.setIssuedate(CommonUtils.covertDate(issueDate));
        efiReceiverVO.setIsstotalamount(CommonUtils.stringToBigDecimal(totalAmount));
        efiReceiverVO.setIssremark(remark);
        efiReceiverVO.setIsschecker(checker);
        efiReceiverVO.setIsshandlingperson(handlingPerson);
    }
}

