/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.ctp.CtpReceiverDO;
import com.jiuqi.accds.feign.issuerentity.ctp.CtpIssuer;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.CtpReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtpHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CtpHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        String fileId = receiverFileParamsDTO.getFileId();
        if (pair.isEmpty()) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        UploadFileDO issuerFile = pair.getIssuer();
        String issXml = issuerFile.getContent();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, issXml, receiverFile.getContent());
            }
            catch (Exception e) {
                log.error("\u5904\u7406 CTP \u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25", e);
                throw new ValidateException(e.getMessage(), e);
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, String issXml, String receiverXml) throws Exception {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        String fileId = receiverFileParamsDTO.getFileId();
        CtpIssuer ctpIssuer = CommonUtils.xbrlToObject("ctp", issXml, new TypeReference<CtpIssuer>(this){});
        CtpReceiver ctpReceiver = CommonUtils.xbrlToObject("ctp", receiverXml, new TypeReference<CtpReceiver>(this){});
        if (ObjectUtils.isEmpty(ctpIssuer) || ObjectUtils.isEmpty(ctpReceiver)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String iss_identifyingCode = ctpIssuer.getUniqueCodeOfInvoice();
        String rec_identifyingCode = ctpReceiver.getUniqueCodeOfInvoice();
        if (ObjectUtils.isEmpty(iss_identifyingCode) || ObjectUtils.isEmpty(rec_identifyingCode) || !iss_identifyingCode.equals(rec_identifyingCode)) {
            throw new ValidateException("\u3010\u56fd\u5e93\u96c6\u4e2d\u652f\u4ed8\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u7801(UniqueCodeOfInvoice)\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        if (!unioncode.equals(ctpReceiver.getUnifiedSocialCreditCodeOfAccountingEntity()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u56fd\u5e93\u96c6\u4e2d\u652f\u4ed8\u7535\u5b50\u51ed\u8bc1\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u51ed\u8bc1\u6587\u4ef6\uff1a" + ctpReceiver.getUnifiedSocialCreditCodeOfAccountingEntity() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        if (isCheckNull && !(checkStatus = this.checkUniformity(ctpIssuer, ctpReceiver))) {
            throw new ValidateException("\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
        this.commonHandle(receiverFileParamsDTO, ctpIssuer, ctpReceiver, fileId);
    }

    private void commonHandle(ReceiverFileParamsDTO receiverFileParamsDTO, CtpIssuer ctpIssuer, CtpReceiver ctpReceiver, String fileId) {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String rec_identifyingCode = ctpReceiver.getUniqueCodeOfInvoice();
        CtpReceiverDO ctpReceiverDO = new CtpReceiverDO();
        ctpReceiverDO.setId(UUID.randomUUID());
        ctpReceiverDO.setUniqueCodeOfInvoice(rec_identifyingCode);
        ctpReceiverDO.setUnifiedSocialCreditCode(unioncode);
        ctpReceiverDO.setUnitcode(receiverFileParamsDTO.getUnitcode());
        Date now = new Date();
        ctpReceiverDO.setCreatetime(now);
        ctpReceiverDO.setUpdatetime(now);
        ctpReceiverDO.setVer(System.currentTimeMillis());
        ctpReceiverDO.setCreatetime(now);
        ctpReceiverDO.setOptusername(ObjectUtils.isEmpty(user) ? "\u63a5\u53e3\u8c03\u7528" : user.getUsername());
        ctpReceiverDO.setOptusertitle(ObjectUtils.isEmpty(user) ? "\u63a5\u53e3\u8c03\u7528" : user.getUsername());
        this.account(ctpReceiver, user, isCheckNull, rec_identifyingCode, ctpReceiverDO, fileId);
    }

    private boolean checkUniformity(CtpIssuer ctpBill, CtpReceiver ctpReceiver) {
        return Objects.equals(ctpBill.getUniqueCodeOfInvoice(), ctpReceiver.getUniqueCodeOfInvoice());
    }

    private boolean account(CtpReceiver ctpReceiver, UserLoginDTO user, boolean isCheckNull, String uniqueCodeOfInvoice, CtpReceiverDO ctpReceiverDO, String fileId) {
        ArrayList<String> resultList = new ArrayList<String>();
        String unifiedSocialCreditCodeOfAccountingEntity = ctpReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String VoucherNo = ctpReceiver.getVoucherNo();
        List<InformationOfAccountingDocumentsTuple> list = ctpReceiver.getInformationOfAccountingDocumentsTuple();
        if (isCheckNull) {
            int flag = 0;
            if (!StringUtils.hasText(uniqueCodeOfInvoice) || uniqueCodeOfInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010UniqueCodeOfInvoice\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(VoucherNo) || VoucherNo.equals("null")) {
                flag = 2;
                resultList.add("\u3010VoucherNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(list)) {
                StringBuilder stringBuilder = new StringBuilder();
                list.forEach(item -> {
                    if (item.getPostingDate() == null) {
                        stringBuilder.append("postingDate\uff08\u8bb0\u8d26\u65e5\u671f\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.hasText(item.getAccountingPeriod()) || item.getAccountingPeriod().equals("null")) {
                        stringBuilder.append("accountingPeriod\uff08\u4f1a\u8ba1\u671f\u95f4\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
                if (stringBuilder.length() > 0) {
                    resultList.add(stringBuilder.toString());
                    flag = 2;
                }
            }
            if (flag == 2) {
                throw new ValidateException("\u56fd\u5e93\u96c6\u4e2d\u652f\u4ed8\u7535\u5b50\u51ed\u8bc1\u5fc5\u586b\u9879\u68c0\u67e5\uff1a" + JSON.toJSONString(resultList));
            }
        }
        ctpReceiverDO.setUnifiedSocialCreditCode(unifiedSocialCreditCodeOfAccountingEntity);
        ctpReceiverDO.setVoucherNo(VoucherNo);
        if (!CollectionUtils.isEmpty(list)) {
            ctpReceiverDO.setAccountingPeriod(list.get(0).getAccountingPeriod());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                ctpReceiverDO.setPostingDate(simpleDateFormat.format(list.get(0).getPostingDate()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

