/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.bkrs.detail.BkrsReceiverDetailDO;
import com.jiuqi.accds.feign.domain.vo.BkrsReceiverVO;
import com.jiuqi.accds.feign.issuerentity.bkrs.BkrsIssuer;
import com.jiuqi.accds.feign.issuerentity.bkrs.InformationOfReconcileDetailsTuple;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class BkrsHandle {
    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String fileId = receiverFileParamsDTO.getFileId();
        UploadFileDO issuerFile = pair.getIssuer();
        if (issuerFile == null) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u5bf9\u8d26\u5355\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        this.processFile(receiverFileParamsDTO, issuerFile.getContent());
    }

    private void processFile(ReceiverFileParamsDTO receiverFileParamsDTO, String xml) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String fileId = receiverFileParamsDTO.getFileId();
        BkrsIssuer bkrsIssuer = CommonUtils.xbrlToObject("bkrs", xml, new TypeReference<BkrsIssuer>(this){});
        if (bkrsIssuer == null) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u5bf9\u8d26\u5355\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        BkrsReceiverVO bkrsIssuerVO = new BkrsReceiverVO();
        bkrsIssuerVO.setIdentificatcode(bkrsIssuer.getIdentificationCodeOfIssuer());
        bkrsIssuerVO.setBankbranchnum(bkrsIssuer.getNumberOfBankBranch());
        bkrsIssuerVO.setCurrency(bkrsIssuer.getCurrency());
        bkrsIssuerVO.setCustomeraccbank(bkrsIssuer.getCustomerSettlementBankAccount());
        bkrsIssuerVO.setCustomeraccname(bkrsIssuer.getNameOfCustomerAccount());
        bkrsIssuerVO.setCustomerbankcode(bkrsIssuer.getCodeOfBankCustomer());
        String year = bkrsIssuer.getYearOfBankReconciliationStatement();
        bkrsIssuerVO.setBankyear(StringUtils.hasText(year) ? year.substring(0, 4) : null);
        String month = bkrsIssuer.getMonthOfBankReconciliationStatement();
        bkrsIssuerVO.setBankmonth(StringUtils.hasText(month) ? month.substring(0, 2) : null);
        bkrsIssuerVO.setPrinttimes(bkrsIssuer.getPrintTimes());
        bkrsIssuerVO.setPrintdate(bkrsIssuer.getPrintDate());
        bkrsIssuerVO.setAccountamount(CommonUtils.stringToBigDecimal(bkrsIssuer.getAccountBalanceAtTheEndOfReconciliationCycleAmount()));
        bkrsIssuerVO.setAvailableamount(CommonUtils.stringToBigDecimal(bkrsIssuer.getAvailableBalanceAtTheEndOfReconciliationCycleAmount()));
        bkrsIssuerVO.setReservebalance(CommonUtils.stringToBigDecimal(bkrsIssuer.getReserveBalanceAtTheEndOfReconciliationCycle()));
        bkrsIssuerVO.setFrozenbalance(CommonUtils.stringToBigDecimal(bkrsIssuer.getFrozenBalanceAtTheEndOfReconciliationCycle()));
        bkrsIssuerVO.setOverdraftbalance(CommonUtils.stringToBigDecimal(bkrsIssuer.getOverdraftBalanceAtEndOfReconciliationCycle()));
        bkrsIssuerVO.setSocialcreditcode(unioncode);
        bkrsIssuerVO.setBusinessserialnumber(bkrsIssuer.getBusinessSerialNumber());
        List<InformationOfReconcileDetailsTuple> list = bkrsIssuer.getInformationOfReconcileDetailsTuple();
        if (!CollectionUtils.isEmpty(list)) {
            List<BkrsReceiverDetailDO> bkreDetailList = list.stream().map(item -> {
                BkrsReceiverDetailDO bkrsIssuerDetailDO = new BkrsReceiverDetailDO();
                bkrsIssuerDetailDO.setBookdate(item.getDateOfBookkeeping());
                bkrsIssuerDetailDO.setProductstypes(item.getTypesOfBusinessProducts());
                bkrsIssuerDetailDO.setDocumenttype(item.getTypeOfSourceDocument());
                bkrsIssuerDetailDO.setDocumentnumber(item.getNumberOfSourceDocument());
                bkrsIssuerDetailDO.setNotes(item.getNotesOfBankElectronicReceipt());
                bkrsIssuerDetailDO.setCreditordebit(item.getIdentificationOfCreditOrDebit());
                bkrsIssuerDetailDO.setTransactionamount(CommonUtils.stringToBigDecimal(item.getTransactionAmount()));
                bkrsIssuerDetailDO.setDebitorcreditbalance(CommonUtils.stringToBigDecimal(item.getDebitOrCreditOfBalance()));
                bkrsIssuerDetailDO.setAccountbalance(CommonUtils.stringToBigDecimal(item.getAccountBalance()));
                bkrsIssuerDetailDO.setTransactioncode(item.getTransactionCode());
                bkrsIssuerDetailDO.setCounterpartyaccount(item.getAccountOfCounterparty());
                bkrsIssuerDetailDO.setCounterpartyname(item.getNameOfCounterparty());
                bkrsIssuerDetailDO.setCounterpartybank(item.getDepositoryBankOfCounterparty());
                bkrsIssuerDetailDO.setBookkeeper(item.getBookkeeper());
                bkrsIssuerDetailDO.setBooktime(item.getTimeOfBookkeeping());
                bkrsIssuerDetailDO.setAccountjournal(item.getJournalAccountOfBookkeeping());
                bkrsIssuerDetailDO.setOtheraccount(item.getOtherAccountingInformation());
                bkrsIssuerDetailDO.setReceiptnumber(item.getNumberOfBankElectronicReceipt());
                return bkrsIssuerDetailDO;
            }).collect(Collectors.toList());
            bkrsIssuerVO.setIssuerDetailList(bkreDetailList);
        }
    }
}

