/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.vo.BkerReceiverVO;
import com.jiuqi.accds.feign.issuerentity.bker.BkerIssuer;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.BkerReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BkerHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BkerHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        UploadFileDO issuerFile = pair.getIssuer();
        if (ObjectUtils.isEmpty(issuerFile)) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u56de\u5355\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        if (CollectionUtils.isEmpty(receiverFiles)) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u56de\u5355\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issXml = issuerFile.getContent();
        BkerIssuer bkerBill = CommonUtils.xbrlToObject("bker_issuer", issXml, new TypeReference<BkerIssuer>(this){});
        if (ObjectUtils.isEmpty(bkerBill)) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u56de\u5355\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issIdentifyingCode = bkerBill.getIdentifyingCode();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, bkerBill, issXml, receiverFile, issIdentifyingCode);
            }
            catch (Exception e) {
                log.error("\u5904\u7406BKER\u63a5\u6536\u65b9\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u552f\u4e00\u7f16\u53f7: {}", (Object)issIdentifyingCode, (Object)e);
                throw new ValidateException("\u5904\u7406\u63a5\u6536\u65b9\u6587\u4ef6\u5f02\u5e38: " + e.getMessage());
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, BkerIssuer bkerBill, String issXml, UploadFileDO receiverFile, String uniqueCode) throws Exception {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        String receiverXml = receiverFile.getContent();
        BkerReceiver bkerAccount = CommonUtils.xbrlToObject("bker_receiver", receiverXml, new TypeReference<BkerReceiver>(this){});
        if (ObjectUtils.isEmpty(bkerAccount)) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u56de\u5355\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String recIdentifyingCode = bkerAccount.getIdentifyingCode();
        if (ObjectUtils.isEmpty(uniqueCode) || ObjectUtils.isEmpty(recIdentifyingCode) || !uniqueCode.equals(recIdentifyingCode)) {
            throw new ValidateException("\u3010\u94f6\u884c\u7535\u5b50\u56de\u5355\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u7801(Identifying code)\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        if (isCheckNull && !(checkStatus = this.checkUniformity(bkerBill, bkerAccount))) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u56de\u5355\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
        this.commonHandle(receiverFileParamsDTO, bkerBill, bkerAccount, issXml, receiverXml, fileId);
    }

    private boolean checkUniformity(BkerIssuer bkerBill, BkerReceiver bkerAccount) {
        if (!Objects.equals(bkerBill.getCurrency(), bkerAccount.getCurrency())) {
            return false;
        }
        return Objects.equals(bkerBill.getTransactionAmountInFigures(), bkerAccount.getTransactionAmountInFigures());
    }

    public void commonHandle(ReceiverFileParamsDTO receiverFileParamsDTO, BkerIssuer bkerIssuer, BkerReceiver bkerReceiver, String issuerXml, String receiverXml, String fileId) {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String recIdentifyingCode = bkerReceiver.getIdentifyingCode();
        if (!unioncode.equals(bkerReceiver.getUnifiedSocialCreditCodeOfAccountingEntity()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u94f6\u884c\u7535\u5b50\u56de\u5355\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u51ed\u8bc1\u6587\u4ef6\uff1a" + bkerReceiver.getUnifiedSocialCreditCodeOfAccountingEntity() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        BkerReceiverVO bkerReceiverVO = new BkerReceiverVO();
        this.bill(bkerIssuer, bkerReceiverVO);
        if (!this.account(bkerReceiver, user, isCheckNull, recIdentifyingCode, bkerReceiverVO, fileId)) {
            throw new ValidateException("\u94f6\u884c\u7535\u5b50\u56de\u5355\u5fc5\u586b\u9879\u68c0\u67e5\u5931\u8d25");
        }
    }

    private boolean account(BkerReceiver bkerReceiver, UserLoginDTO user, boolean isCheckNull, String identifyingCode, BkerReceiverVO bkerReceiverVO, String fileId) {
        ArrayList<String> resultList = new ArrayList<String>();
        String whetherReceiptHasBeenBooked = bkerReceiver.getWhetherReceiptHasBeenBooked();
        String unifiedSocialCreditCodeOfAccountingEntity = bkerReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = bkerReceiver.getNameOfAccountingEntity();
        String currency = bkerReceiver.getCurrency();
        String transactionAmountInFigures = bkerReceiver.getTransactionAmountInFigures();
        List<InformationOfAccountingDocumentsTuple> list = bkerReceiver.getInformationOfAccountingDocumentsTuple();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(identifyingCode) || identifyingCode.equals("null")) {
                flag = 2;
                resultList.add("\u3010identifyingCode\uff08\u6821\u9a8c\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(currency) || currency.equals("null")) {
                flag = 2;
                resultList.add("\u3010currency\uff08\u5e01\u79cd\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(transactionAmountInFigures) || transactionAmountInFigures.equals("null")) {
                flag = 2;
                resultList.add("\u3010transactionAmountInFigures\uff08\u5c0f\u5199\u91d1\u989d\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherReceiptHasBeenBooked) || whetherReceiptHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherReceiptHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(list) && (stringBuilder = AccountDataManageUtil.checkAccountData(list)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u94f6\u884c\u7535\u5b50\u56de\u5355\u5fc5\u586b\u9879\u68c0\u67e5\uff1a" + JSON.toJSONString(resultList));
            }
        }
        bkerReceiverVO.setIdentifyingcode(bkerReceiver.getIdentifyingCode());
        bkerReceiverVO.setContractnumber(bkerReceiver.getContractNumber());
        bkerReceiverVO.setInvoicetype(bkerReceiver.getTypeOfInvoice());
        bkerReceiverVO.setIssuedate(bkerReceiver.getDateOfIssue());
        bkerReceiverVO.setInvoiceuniquecode(bkerReceiver.getUniqueCodeOfInvoice());
        bkerReceiverVO.setParamount(CommonUtils.stringToBigDecimal(bkerReceiver.getAmountPayableAndReceivable()));
        bkerReceiverVO.setBeenclaimed(bkerReceiver.getWhetherInvoiceHasBeenClaimed());
        bkerReceiverVO.setBeenbooked(whetherReceiptHasBeenBooked);
        bkerReceiverVO.setBeenreconciled(bkerReceiver.getWhetherReceiptHasBeenReconciled());
        bkerReceiverVO.setBeentransferredtobank(bkerReceiver.getWhetherReceiptHasBeenTransferredToBank());
        bkerReceiverVO.setSocialcreditcode(unifiedSocialCreditCodeOfAccountingEntity);
        bkerReceiverVO.setAccountname(nameOfAccountingEntity);
        bkerReceiverVO.setReccurrency(currency);
        bkerReceiverVO.setRectransactionamountinfigures(CommonUtils.stringToBigDecimal(transactionAmountInFigures));
        if (!CollectionUtils.isEmpty(list)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(list);
            bkerReceiverVO.setAccountList(detailList);
        }
        return true;
    }

    private void bill(BkerIssuer bkerIssuer, BkerReceiverVO bkerReceiverVO) {
        bkerReceiverVO.setIdentifyingcode(bkerIssuer.getIdentifyingCode());
        bkerReceiverVO.setReceiptnumber(bkerIssuer.getNumberOfBankElectronicReceipt());
        bkerReceiverVO.setReceipttype(bkerIssuer.getTypeOfBankElectronicReceipt());
        bkerReceiverVO.setIssueridenticode(bkerIssuer.getIdentificationCodeOfIssuer());
        bkerReceiverVO.setIssuedate(ObjectUtils.isEmpty(bkerIssuer.getIssueDate()) ? null : bkerIssuer.getIssueDate());
        bkerReceiverVO.setIdentcreditordebit(bkerIssuer.getIdentificationOfCreditOrDebit());
        bkerReceiverVO.setIdentcashortransfer(bkerIssuer.getIdentificationOfCashOrTransfer());
        bkerReceiverVO.setBookdate(bkerIssuer.getDateOfBookkeeping());
        bkerReceiverVO.setTimeofbookkeeping(bkerIssuer.getTimeOfBookkeeping());
        bkerReceiverVO.setBookkeeper(bkerIssuer.getBookkeeper());
        bkerReceiverVO.setBookjournal(bkerIssuer.getJournalAccountOfBookkeeping());
        bkerReceiverVO.setCurrency(bkerIssuer.getCurrency());
        bkerReceiverVO.setAmount(CommonUtils.stringToBigDecimal(bkerIssuer.getTransactionAmountInFigures()));
        bkerReceiverVO.setTypeofsourcedocument(bkerIssuer.getTypeOfSourceDocument());
        bkerReceiverVO.setNumberofsourcedocument(bkerIssuer.getNumberOfSourceDocument());
        bkerReceiverVO.setBusinessproducttype(bkerIssuer.getBusinessProductType());
        bkerReceiverVO.setTransactioncode(bkerIssuer.getTransactionCode());
        bkerReceiverVO.setChanneltype(bkerIssuer.getChannelType());
        bkerReceiverVO.setUsages(bkerIssuer.getUsage());
        bkerReceiverVO.setNotes(bkerIssuer.getNotes());
        bkerReceiverVO.setPayername(bkerIssuer.getAccountNameOfPayer());
        bkerReceiverVO.setPayernumber(bkerIssuer.getAccountNumberOfPayer());
        bkerReceiverVO.setPayeropeningbank(bkerIssuer.getOpeningBankOfPayer());
        bkerReceiverVO.setPayeeaccountname(bkerIssuer.getAccountNameOfPayee());
        bkerReceiverVO.setPayeeaccountnumber(bkerIssuer.getAccountNumberOfPayee());
        bkerReceiverVO.setPayeeopeningbank(bkerIssuer.getOpeningBankOfPayee());
        bkerReceiverVO.setRecipientaccountnumber(bkerIssuer.getAccountNumberOfRecipient());
        bkerReceiverVO.setRecipientidentificationnumber(bkerIssuer.getIdentificationNumberOfRecipient());
        bkerReceiverVO.setIssbusinessserialnumber(bkerIssuer.getBusinessSerialNumber());
    }
}

