/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.atr.issuerDetail.AtrReceiverIssuerDetailDO;
import com.jiuqi.accds.feign.domain.vo.AtrReceiverVO;
import com.jiuqi.accds.feign.issuerentity.atr.AtrIssuer;
import com.jiuqi.accds.feign.issuerentity.atr.DetailInformationOfAirTicketTuple;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.AtrReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.handle.EinvOrdHandle;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtrHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtrHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        UploadFileDO issuerFile = pair.getIssuer();
        if (ObjectUtils.isEmpty(issuerFile)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        if (CollectionUtils.isEmpty(receiverFiles)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issXml = issuerFile.getContent();
        if (this.isNewAirTicketFormat(issXml)) {
            this.handleNewFormatAirTicket(receiverFileParamsDTO, pair);
        } else {
            this.handleTraditionalAirTicket(receiverFileParamsDTO, pair, issXml);
        }
    }

    private boolean isNewAirTicketFormat(String xmlContent) {
        int endOfDeclaration;
        if (!StringUtils.hasText(xmlContent)) {
            return false;
        }
        String trimmedContent = xmlContent.trim();
        if (trimmedContent.startsWith("<?xml") && (endOfDeclaration = trimmedContent.indexOf("?>")) != -1) {
            trimmedContent = trimmedContent.substring(endOfDeclaration + 2).trim();
        }
        return trimmedContent.startsWith("<EInvoice");
    }

    private void handleNewFormatAirTicket(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        log.info("\u68c0\u6d4b\u5230\u65b0\u683c\u5f0f\u7684\u822a\u7a7a\u5ba2\u7968\uff0c\u4f7f\u7528\u6570\u7535\u7968\u5904\u7406\u903b\u8f91");
        EinvOrdHandle einvOrdHandle = new EinvOrdHandle();
        einvOrdHandle.handleFile(receiverFileParamsDTO, pair);
    }

    private void handleTraditionalAirTicket(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair, String issXml) {
        log.info("\u68c0\u6d4b\u5230\u4f20\u7edf\u683c\u5f0f\u7684\u822a\u7a7a\u5ba2\u7968\uff0c\u4f7f\u7528\u539f\u6709XBRL\u5904\u7406\u903b\u8f91");
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String fileId = receiverFileParamsDTO.getFileId();
        AtrIssuer atrBill = CommonUtils.xbrlToObject("atr_issuer", issXml, new TypeReference<AtrIssuer>(this){});
        if (ObjectUtils.isEmpty(atrBill)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issuerElectronicInvoiceAirTransportReceiptNumber = atrBill.getElectronicInvoiceAirTransportReceiptNumber();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, atrBill, receiverFile, issuerElectronicInvoiceAirTransportReceiptNumber);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                throw new ValidateException("\u5904\u7406\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, AtrIssuer atrBill, UploadFileDO receiverFile, String uniqueCode) {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        String receiverXml = receiverFile.getContent();
        AtrReceiver atrAccount = CommonUtils.xbrlToObject("atr_receiver", receiverXml, new TypeReference<AtrReceiver>(this){});
        if (ObjectUtils.isEmpty(atrAccount)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String accountElectronicInvoiceAirTransportReceiptNumber = atrAccount.getElectronicInvoiceAirTransportReceiptNumber();
        if (ObjectUtils.isEmpty(uniqueCode) || ObjectUtils.isEmpty(accountElectronicInvoiceAirTransportReceiptNumber) || !uniqueCode.equals(accountElectronicInvoiceAirTransportReceiptNumber)) {
            throw new ValidateException("\u3010\u6570\u7535\u7968(\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355)\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6electronicInvoiceAirTransportReceiptNumber\uff08\u7535\u5b50\u53d1\u7968\uff08\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355\uff09\u53f7\u7801\uff09\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        if (isCheckNull && !(checkStatus = this.checkUniformity(atrBill, atrAccount))) {
            throw new ValidateException("\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
        this.commonHandle(receiverFileParamsDTO, atrBill, atrAccount);
    }

    private void commonHandle(ReceiverFileParamsDTO receiverFileParamsDTO, AtrIssuer atrIssuer, AtrReceiver atrReceiver) {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        if (!unioncode.equals(atrIssuer.getUnifiedSocialCreditCodeOfPurchaser()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u7968\u636e\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355)\u8d2d\u4e70\u65b9\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u7968\u636e\u6587\u4ef6\uff1a" + atrIssuer.getUnifiedSocialCreditCodeOfPurchaser() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        String receiptNumber = atrReceiver.getElectronicInvoiceAirTransportReceiptNumber();
        if (!unioncode.equals(atrReceiver.getUnifiedSocialCreditCodeOfAccountingEntity()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355)\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u51ed\u8bc1\u6587\u4ef6\uff1a" + atrReceiver.getUnifiedSocialCreditCodeOfAccountingEntity() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        AtrReceiverVO atrReceiverVO = new AtrReceiverVO();
        this.bill(atrIssuer, unitcode, atrReceiverVO);
        this.account(atrReceiver, user, unitcode, isCheckNull, receiptNumber, atrReceiverVO, fileId);
    }

    private boolean account(AtrReceiver atrReceiver, UserLoginDTO user, String unitcode, boolean isCheckNull, String receiptNumber, AtrReceiverVO atrReceiverVO, String fileId) {
        ArrayList<String> resultList = new ArrayList<String>();
        String whetherInvoiceIsRedInvoice = atrReceiver.getWhetherInvoiceIsRedInvoice();
        String whetherInvoiceHasBeenChecked = atrReceiver.getWhetherInvoiceHasBeenChecked();
        String whetherInvoiceHasBeenBooked = atrReceiver.getWhetherInvoiceHasBeenBooked();
        String whetherInvoiceHasBeenDeducted = atrReceiver.getWhetherInvoiceHasBeenDeducted();
        String period = atrReceiver.getTaxPeriodOfInvoiceDeduction();
        String unifiedSocialCreditCodeOfAccountingEntity = atrReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = atrReceiver.getNameOfAccountingEntity();
        String fare = atrReceiver.getFare();
        String issueParty = atrReceiver.getIssueParty();
        Date issueDate = atrReceiver.getIssueDate();
        List<InformationOfAccountingDocumentsTuple> accountList = atrReceiver.getInformationOfAccountingDocumentsTuple();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(receiptNumber) || receiptNumber.equals("null")) {
                flag = 2;
                resultList.add("\u3010electronicInvoiceAirTransportReceiptNumber\uff08\u7535\u5b50\u53d1\u7968\uff08\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355\uff09\u53f7\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(fare) || fare.equals("null")) {
                flag = 2;
                resultList.add("\u3010fare\uff08\u7ea2\u5b57\u884c\u7a0b\u5355\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(issueParty) || issueParty.equals("null")) {
                flag = 2;
                resultList.add("\u3010issueParty\uff08\u586b\u5f00\u5355\u4f4d\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty(issueDate)) {
                flag = 2;
                resultList.add("\u3010issueDate\uff08\u586b\u5f00\u65e5\u671f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceIsRedInvoice) || whetherInvoiceIsRedInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceIsRedInvoice\uff08\u7ea2\u5b57\u884c\u7a0b\u5355\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenChecked) || whetherInvoiceHasBeenChecked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenChecked\uff08\u662f\u5426\u5df2\u9a8c\u771f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenBooked) || whetherInvoiceHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenDeducted) || whetherInvoiceHasBeenDeducted.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenDeducted\uff08\u662f\u5426\u5df2\u62b5\u6263\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(period) || period.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxPeriodOfInvoiceDeduction\uff08\u7a0e\u6536\u62b5\u6263\u671f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(accountList) && (stringBuilder = AccountDataManageUtil.checkAccountData(accountList)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u6570\u7535\u7968(\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355)\u5fc5\u586b\u9879\u68c0\u67e5\u672a\u901a\u8fc7: " + JSON.toJSONString(resultList));
            }
        }
        atrReceiverVO.setReceiptnumber(receiptNumber);
        atrReceiverVO.setRedreceipt(whetherInvoiceIsRedInvoice);
        atrReceiverVO.setBeenchecked(whetherInvoiceHasBeenChecked);
        atrReceiverVO.setBeenbooked(whetherInvoiceHasBeenBooked);
        atrReceiverVO.setBeendeducted(whetherInvoiceHasBeenDeducted);
        if (StringUtils.hasText(period)) {
            atrReceiverVO.setTaxperiod(Integer.valueOf(period.replace("-", "")));
        }
        atrReceiverVO.setSocialcreditcode(unifiedSocialCreditCodeOfAccountingEntity);
        atrReceiverVO.setAccountname(nameOfAccountingEntity);
        atrReceiverVO.setUnitcode(unitcode);
        atrReceiverVO.setRecfare(CommonUtils.stringToBigDecimal(fare));
        atrReceiverVO.setRecissueparty(issueParty);
        atrReceiverVO.setRecissuedate(issueDate);
        if (!CollectionUtils.isEmpty(accountList)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(accountList);
            atrReceiverVO.setAccountList(detailList);
        }
        return true;
    }

    private void bill(AtrIssuer atrIssuer, String unitcode, AtrReceiverVO atrReceiverVO) {
        atrReceiverVO.setName(atrIssuer.getPassengerName());
        atrReceiverVO.setIdnum(atrIssuer.getValidIdNumber());
        atrReceiverVO.setEndorsement(atrIssuer.getEndorsement());
        atrReceiverVO.setOrdernumber(atrIssuer.getNumberOfGpOrder());
        atrReceiverVO.setFare(CommonUtils.stringToBigDecimal(atrIssuer.getFare()));
        atrReceiverVO.setFuel(CommonUtils.stringToBigDecimal(atrIssuer.getFuelSurcharge()));
        atrReceiverVO.setVatrate(atrIssuer.getVatRate());
        atrReceiverVO.setVattaxamount(CommonUtils.stringToBigDecimal(atrIssuer.getVatTaxAmount()));
        atrReceiverVO.setCivilaviation(CommonUtils.stringToBigDecimal(atrIssuer.getCivilAviationDevelopmentFund()));
        atrReceiverVO.setOthertaxes(CommonUtils.stringToBigDecimal(atrIssuer.getOtherTaxes()));
        atrReceiverVO.setTotalamount(CommonUtils.stringToBigDecimal(atrIssuer.getTotalAmount()));
        atrReceiverVO.setEticketnumber(atrIssuer.geteTicketNumber());
        atrReceiverVO.setVerificationcode(atrIssuer.getVerificationCode());
        atrReceiverVO.setQrcode(atrIssuer.getQrCode());
        atrReceiverVO.setPromptinfor(atrIssuer.getPromptInformation());
        atrReceiverVO.setInsurance(atrIssuer.getInsurance());
        atrReceiverVO.setAgentcode(atrIssuer.getAgentCode());
        atrReceiverVO.setIssueparty(atrIssuer.getIssueParty());
        atrReceiverVO.setIssuedate(ObjectUtils.isEmpty(atrIssuer.getIssueDate()) ? null : atrIssuer.getIssueDate());
        atrReceiverVO.setIssuingstatus(atrIssuer.getIssuingStatus());
        atrReceiverVO.setMarking(atrIssuer.getMarkingOfDomesticOrInternational());
        atrReceiverVO.setPurname(atrIssuer.getPassengerName());
        atrReceiverVO.setRushredreason(atrIssuer.getReasonOfRushRed());
        atrReceiverVO.setReceiptnumber(atrIssuer.getElectronicInvoiceAirTransportReceiptNumber());
        atrReceiverVO.setNameofseller(atrIssuer.getNameOfSeller());
        atrReceiverVO.setUnifiedsocialcreditcode(atrIssuer.getUnifiedSocialCreditCodeOfPurchaser());
        atrReceiverVO.setOriginalreceiptnumber(atrIssuer.getOriginalElectronicInvoiceAirTransportReceiptNumber());
        atrReceiverVO.setUnitcode(unitcode);
        List<DetailInformationOfAirTicketTuple> list = atrIssuer.getDetailInformationOfAirTicketTuple();
        if (!CollectionUtils.isEmpty(list)) {
            List<AtrReceiverIssuerDetailDO> atrIssuerDetailList = list.stream().map(item -> {
                AtrReceiverIssuerDetailDO atrReceiverIssuerDetailDO = new AtrReceiverIssuerDetailDO();
                atrReceiverIssuerDetailDO.setDeparturestation(item.getDepartureStation());
                atrReceiverIssuerDetailDO.setDestinationstation(item.getDestinationStation());
                atrReceiverIssuerDetailDO.setFlightsegment(item.getFlightSegment());
                atrReceiverIssuerDetailDO.setCarrier(item.getCarrier());
                atrReceiverIssuerDetailDO.setFlight(item.getFlight());
                atrReceiverIssuerDetailDO.setAsclass(item.getAsClass());
                atrReceiverIssuerDetailDO.setCarrierdate(item.getCarrierDate());
                atrReceiverIssuerDetailDO.setDeparturetime(item.getDepartureTime());
                atrReceiverIssuerDetailDO.setFarebasis(item.getFareBasis());
                atrReceiverIssuerDetailDO.setEffectivedate(item.getEffectiveDate());
                atrReceiverIssuerDetailDO.setExpirationdate(item.getExpirationDate());
                atrReceiverIssuerDetailDO.setFreebag(item.getFreeBaggageAllowance());
                return atrReceiverIssuerDetailDO;
            }).collect(Collectors.toList());
            atrReceiverVO.setIssuerDetailList(atrIssuerDetailList);
        }
    }

    private boolean checkUniformity(AtrIssuer atrBill, AtrReceiver atrAccount) {
        if (!Objects.equals(atrBill.getFare(), atrAccount.getFare())) {
            return false;
        }
        if (!Objects.equals(atrBill.getIssueParty(), atrAccount.getIssueParty())) {
            return false;
        }
        return Objects.equals(atrBill.getIssueDate(), atrAccount.getIssueDate());
    }
}

