/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui;

import com.jiuqi.accds.feign.constant.ReceiverFileType;
import com.jiuqi.gov.dzpz.validategui.service.ReceiverFileService;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Duration;
import javafx.util.StringConverter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateController.class);
    @FXML
    private ComboBox<ReceiverFileType> typeComboBox;
    @FXML
    private TextField filePathField;
    @FXML
    private TextFlow statusTextFlow;
    @FXML
    private ScrollPane statusScrollPane;
    @FXML
    private Button browseButton;
    @FXML
    private Button validateButton;
    @FXML
    private Label versionLabel;
    private File selectedFile;
    private ExecutorService executorService;
    private Timeline statusAnimation;
    private boolean isValidating = false;
    private final ReceiverFileService receiverFileService = new ReceiverFileService();

    @FXML
    public void initialize() {
        this.versionLabel.setText("V1.0");
        this.typeComboBox.getItems().addAll((ReceiverFileType[])ReceiverFileType.values());
        this.typeComboBox.setConverter(new StringConverter<ReceiverFileType>(this){

            @Override
            public String toString(ReceiverFileType type) {
                return type != null ? type.getName() : "";
            }

            @Override
            public ReceiverFileType fromString(String string) {
                return null;
            }
        });
        if (!this.typeComboBox.getItems().isEmpty()) {
            this.typeComboBox.getSelectionModel().selectFirst();
        }
        this.typeComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !newValue.equals(oldValue)) {
                this.selectedFile = null;
                this.filePathField.setText("");
                this.statusTextFlow.getChildren().clear();
                if (this.statusAnimation != null && this.statusAnimation.getStatus() == Animation.Status.RUNNING) {
                    this.statusAnimation.stop();
                }
                if (this.isValidating) {
                    this.setValidatingState(false);
                }
            }
        });
        this.executorService = Executors.newSingleThreadExecutor();
        this.statusAnimation = new Timeline(new KeyFrame(Duration.seconds(0.3), e -> {
            if (!this.statusTextFlow.getChildren().isEmpty()) {
                Text lastText = (Text)this.statusTextFlow.getChildren().get(this.statusTextFlow.getChildren().size() - 1);
                String currentText = lastText.getText();
                Object newText = currentText.endsWith("...") ? currentText.substring(0, currentText.length() - 3) : (currentText.endsWith("..") ? currentText + "." : (currentText.endsWith(".") ? currentText + "." : currentText + "."));
                lastText.setText((String)newText);
            }
        }, new KeyValue[0]));
        this.statusAnimation.setCycleCount(-1);
    }

    @FXML
    protected void onBrowseButtonClick() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("\u9009\u62e9ZIP\u6587\u4ef6");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("ZIP\u6587\u4ef6", "*.zip"));
        Stage stage = (Stage)this.filePathField.getScene().getWindow();
        this.selectedFile = fileChooser.showOpenDialog(stage);
        if (this.selectedFile != null) {
            this.filePathField.setText(this.selectedFile.getAbsolutePath());
            this.statusTextFlow.getChildren().clear();
            if (this.statusAnimation != null && this.statusAnimation.getStatus() == Animation.Status.RUNNING) {
                this.statusAnimation.stop();
            }
        }
    }

    @FXML
    protected void onValidateButtonClick() {
        if (this.isValidating) {
            return;
        }
        ReceiverFileType selectedType = (ReceiverFileType)((Object)this.typeComboBox.getValue());
        if (selectedType == null) {
            this.showErrorStatus("\u8bf7\u9009\u62e9\u6587\u4ef6\u7c7b\u578b");
            return;
        }
        if (this.selectedFile == null || !this.selectedFile.exists()) {
            this.showErrorStatus("\u8bf7\u9009\u62e9\u6709\u6548\u7684ZIP\u6587\u4ef6");
            return;
        }
        this.statusTextFlow.getChildren().clear();
        if (this.statusAnimation != null && this.statusAnimation.getStatus() == Animation.Status.RUNNING) {
            this.statusAnimation.stop();
        }
        this.setValidatingState(true);
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String baseMessage = String.format("[%s] \u6b63\u5728\u9a8c\u8bc1 [%s] \u7c7b\u578b\u7684\u6587\u4ef6: %s", timestamp, selectedType.getName(), this.selectedFile.getName());
        this.appendToTextFlow(baseMessage, Color.web("#0096C9"));
        this.statusAnimation.play();
        this.executorService.submit(() -> {
            try {
                Thread.sleep(500L);
                this.receiverFileService.handle(this.selectedFile.toPath(), selectedType);
                Platform.runLater(() -> {
                    this.statusAnimation.stop();
                    this.setValidatingState(false);
                    this.showSuccessStatus("\u6587\u4ef6\u9a8c\u8bc1\u6210\u529f\uff01\n");
                });
            }
            catch (InterruptedException e) {
                Platform.runLater(() -> {
                    this.statusAnimation.stop();
                    this.setValidatingState(false);
                    this.showErrorStatus("\u9a8c\u8bc1\u88ab\u4e2d\u65ad");
                });
            }
            catch (Exception e) {
                log.error("\u9a8c\u8bc1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
                Platform.runLater(() -> {
                    this.statusAnimation.stop();
                    this.setValidatingState(false);
                    this.showErrorStatus("\u9a8c\u8bc1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                });
            }
        });
    }

    private void showErrorStatus(String message) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String prefix = this.statusTextFlow.getChildren().isEmpty() ? "" : "\n";
        this.appendToTextFlow(String.format("%s[%s] %s", prefix, timestamp, message), Color.web("#f44336"));
    }

    private void showSuccessStatus(String message) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.appendToTextFlow(String.format("\n[%s] %s", timestamp, message), Color.web("#4caf50"));
    }

    private void appendToTextFlow(String text, Color color) {
        if (Platform.isFxApplicationThread()) {
            Text textNode = new Text(text);
            textNode.setFill(color);
            this.statusTextFlow.getChildren().add(textNode);
            Platform.runLater(() -> this.statusScrollPane.setVvalue(1.0));
        } else {
            Platform.runLater(() -> {
                Text textNode = new Text(text);
                textNode.setFill(color);
                this.statusTextFlow.getChildren().add(textNode);
                Platform.runLater(() -> this.statusScrollPane.setVvalue(1.0));
            });
        }
    }

    private void setValidatingState(boolean validating) {
        this.isValidating = validating;
        if (this.validateButton != null) {
            this.validateButton.setDisable(validating);
            if (validating) {
                this.validateButton.setText("\u9a8c\u8bc1\u4e2d...");
            } else {
                this.validateButton.setText("\u5f00\u59cb\u9a8c\u8bc1");
            }
        }
        if (this.browseButton != null) {
            this.browseButton.setDisable(validating);
        }
        if (this.typeComboBox != null) {
            this.typeComboBox.setDisable(validating);
        }
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.statusAnimation != null && this.statusAnimation.getStatus() == Animation.Status.RUNNING) {
            this.statusAnimation.stop();
        }
    }
}

