/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.tools;

import cn.com.szhtkj.tools.FileTool;
import cn.com.szhtkj.tools.QRCodeTool;
import cn.com.szhtkj.tools.UUIDTool;
import cn.com.szhtkj.tools.ZipTool;
import cn.com.szhtkj.verify.OFDValidator;
import cn.com.szhtkj.verify.SignedDataValidateContainer;
import cn.com.szhtkj.verify.container.GBT35275ValidateContainer;
import cn.com.szhtkj.verify.container.SESV4ValidateContainer;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.ofdrw.reader.OFDReader;

public class OfdTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String verificationSignature(File file) throws DocumentException, IOException, GeneralSecurityException {
        JSONObject jsonObject = new JSONObject();
        String tempPath = System.getProperty("java.io.tmpdir") + File.separator + "temp" + File.separator + UUIDTool.uuid() + "_temp";
        File tempDir = new File(tempPath);
        tempDir.mkdirs();
        try {
            Attribute signatureAttribute;
            String signatureTypeAttributeValue;
            boolean unZipOfd = ZipTool.unZip(file, tempPath);
            if (!unZipOfd) {
                jsonObject.put("Errcode", (Object)"001");
                jsonObject.put("Errmsg", (Object)"\u4e0d\u662f\u6b63\u89c4\u7684OFD\u6587\u4ef6");
                String string = jsonObject.toJSONString();
                return string;
            }
            SignedDataValidateContainer validator = null;
            SAXReader reader = new SAXReader();
            Document ofdDocument = reader.read(new File(tempDir + File.separator + "OFD.xml"));
            List signaturesNodes = ofdDocument.selectNodes("/ofd:OFD/ofd:DocBody/ofd:Signatures");
            if (CollectionUtil.isEmpty((Collection)signaturesNodes)) {
                jsonObject.put("Errcode", (Object)"002");
                jsonObject.put("Errmsg", (Object)"\u6ca1\u6709\u7b7e\u540d\u6587\u4ef6");
                String string = jsonObject.toJSONString();
                return string;
            }
            Node signaturesNode = (Node)signaturesNodes.get(0);
            String signaturesNodeValue = signaturesNode.getStringValue();
            File signaturesFile = new File(tempDir + File.separator + signaturesNodeValue);
            Document signaturesDocument = reader.read(signaturesFile);
            List signatureTypeNodes = signaturesDocument.selectNodes("/ofd:Signatures/ofd:Signature/@Type");
            validator = CollectionUtil.isEmpty((Collection)signatureTypeNodes) ? new SESV4ValidateContainer() : ("Sign".equals(signatureTypeAttributeValue = (signatureAttribute = (Attribute)signatureTypeNodes.get(0)).getValue()) ? new GBT35275ValidateContainer() : new SESV4ValidateContainer());
            Path src = Paths.get(file.getPath(), new String[0]);
            try (OFDReader ofdReader = new OFDReader(src);
                 OFDValidator ofdValidator = new OFDValidator(ofdReader);){
                ofdValidator.setValidator(validator);
                ofdValidator.exeValidate();
                jsonObject.put("Errcode", (Object)"0");
            }
            catch (Exception e) {
                jsonObject.put("Errcode", (Object)"003");
                jsonObject.put("Errmsg", (Object)e.getMessage());
            }
        }
        finally {
            FileTool.deleteDir(tempDir);
        }
        return jsonObject.toJSONString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractXBRL(String ofdFilePath, String outputFilePath) throws Exception {
        File xbrlFile;
        block5: {
            xbrlFile = null;
            File ofdFile = new File(ofdFilePath);
            if (Objects.nonNull(ofdFile) && ofdFile.exists()) {
                String tempPath = System.getProperty("java.io.tmpdir") + File.separator + "temp" + File.separator + UUIDTool.uuid() + "_temp";
                File tempDir = new File(tempPath);
                tempDir.mkdirs();
                try {
                    File[] listFiles;
                    File file;
                    boolean unZipOfd = ZipTool.unZip(ofdFile, tempPath);
                    if (!unZipOfd || !(file = new File(tempPath + File.separator + "Doc_0" + File.separator + "Attachs")).exists()) break block5;
                    for (File fileItem : listFiles = file.listFiles()) {
                        String readFileString = FileTool.readFileString(fileItem.getPath());
                        if (!readFileString.contains("<xbrl")) continue;
                        outputFilePath = StrUtil.isBlank((CharSequence)outputFilePath) ? System.getProperty("java.io.tmpdir") + File.separator + "xbrl" + File.separator + "xbrl_" + UUIDTool.uuid() + File.separator + fileItem.getName() : outputFilePath + File.separator + fileItem.getName();
                        xbrlFile = new File(outputFilePath);
                        FileUtils.copyFile((File)fileItem, (File)xbrlFile);
                        break;
                    }
                }
                finally {
                    FileTool.deleteDir(tempDir);
                }
            }
        }
        return xbrlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String identificationQRCode(File file) throws Exception {
        String qrInfo;
        block9: {
            qrInfo = null;
            String tempPath = System.getProperty("java.io.tmpdir") + File.separator + "temp" + File.separator + UUIDTool.uuid() + "_temp";
            File tempDir = new File(tempPath);
            tempDir.mkdirs();
            try {
                boolean unZipOfd = ZipTool.unZip(file, tempPath);
                if (unZipOfd) {
                    File xmlFile = new File(tempDir + File.separator + "Doc_0" + File.separator + "Attachs" + File.separator + "original_invoice.xml");
                    File customTagXml = new File(tempDir + File.separator + "Doc_0" + File.separator + "Tags" + File.separator + "CustomTag.xml");
                    if (xmlFile.exists()) {
                        String xmlFileStr = FileTool.readFileString(xmlFile.getPath());
                        List<String> itemStr = OfdTool.getItemStr(xmlFileStr, "<fp:GraphCode>", "</fp:GraphCode>");
                        if (CollUtil.isNotEmpty(itemStr)) {
                            String string = itemStr.get(0).replace("<fp:GraphCode>", "").replace("</fp:GraphCode>", "").trim();
                            return string;
                        }
                        break block9;
                    }
                    File resFileDir = new File(tempDir + File.separator + "Doc_0" + File.separator + "Res");
                    if (!resFileDir.exists()) {
                        resFileDir = new File(tempDir + File.separator + "Doc_0" + File.separator + "Res_0");
                    }
                    if (!resFileDir.exists()) break block9;
                    File[] files = resFileDir.listFiles();
                    BufferedImage image = null;
                    for (File fileItem : files) {
                        image = ImageIO.read(fileItem);
                        if (image == null || image.getHeight() != image.getWidth() || !StrUtil.isNotBlank((CharSequence)(qrInfo = QRCodeTool.extractImages(image = QRCodeTool.zoomInImage(image, 5))))) continue;
                        break block9;
                    }
                    break block9;
                }
                throw new Exception("\u89e3\u538b\u6587\u4ef6\u8bc6\u522b\u4e8c\u7ef4\u7801\u4fe1\u606f\u5931\u8d25");
            }
            finally {
                FileTool.deleteDir(tempDir);
            }
        }
        return qrInfo;
    }

    private static List<String> getItemStr(String allText, String beggin, String end) {
        ArrayList<String> results = new ArrayList<String>();
        int begginIndex = allText.indexOf(beggin);
        int endIndex = allText.indexOf(end);
        if (begginIndex > -1 && endIndex > 0 && begginIndex < endIndex) {
            String substring = allText.substring(begginIndex, endIndex + end.length());
            while (StrUtil.isNotBlank((CharSequence)substring)) {
                results.add(substring);
                allText = allText.substring(endIndex + end.length());
                begginIndex = allText.indexOf(beggin);
                endIndex = allText.indexOf(end);
                if (begginIndex <= -1 || endIndex <= 0 || begginIndex >= endIndex) break;
                substring = allText.substring(begginIndex, endIndex + end.length());
            }
        }
        return results;
    }
}

