/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.sm2soft;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import xjyb.com.sansec.device.local.Card;
import xjyb.org.bjca.crypto.digests.sm3.util.SM3Digest;
import xjyb.org.bjca.crypto.signers.SM2Signer;
import xjyb.org.bjca.math.ec.ECPoint;
import xjyb.org.bjca.sm2soft.SM2Algorithm;
import xjyb.org.bjca.sm4soft.crypto.SM4Crypto;
import xjyb.org.bjca.util.ByteArrayUtil;
import xjyb.org.bjca.util.MathUtil;

public class SM2JavaAlgorithm
extends Card {
    private static SM2JavaAlgorithm sm2Alg = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SM2JavaAlgorithm getInstance() {
        if (sm2Alg != null) return sm2Alg;
        Class<SM2Algorithm> clazz = SM2Algorithm.class;
        synchronized (SM2Algorithm.class) {
            if (sm2Alg != null) return sm2Alg;
            sm2Alg = new SM2JavaAlgorithm();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm2Alg;
        }
    }

    @Override
    public int closeDevice() {
        return 0;
    }

    @Override
    public int openDevice() {
        return 0;
    }

    @Override
    public byte[] sm2ExternalEncrypt(byte[] bPubKey, byte[] bMessage) {
        SM2Signer sm2 = new SM2Signer();
        byte[] encryptedData = sm2.encryptReDer(bPubKey, bMessage);
        byte[] returnData = new byte[encryptedData.length + 4];
        if (encryptedData != null) {
            byte[] rightByte = MathUtil.intToByteArray(0);
            System.arraycopy(rightByte, 0, returnData, 0, 4);
            System.arraycopy(encryptedData, 0, returnData, 4, encryptedData.length);
        } else {
            byte[] errorByte = MathUtil.intToByteArray(1);
            System.arraycopy(errorByte, 0, returnData, 0, 4);
            System.arraycopy(encryptedData, 0, returnData, 4, encryptedData.length);
        }
        return returnData;
    }

    @Override
    public byte[] sm2ExternalDecrypt(byte[] privateKey, byte[] encryptedData) {
        SM2Signer sm2 = new SM2Signer();
        byte[] originalData = null;
        try {
            originalData = sm2.decryptUseDerData(privateKey, encryptedData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] returnData = new byte[originalData.length + 4];
        if (originalData != null) {
            byte[] rightByte = MathUtil.intToByteArray(0);
            System.arraycopy(rightByte, 0, returnData, 0, 4);
            System.arraycopy(originalData, 0, returnData, 4, originalData.length);
        } else {
            byte[] errorByte = MathUtil.intToByteArray(1);
            System.arraycopy(errorByte, 0, returnData, 0, 4);
            System.arraycopy(originalData, 0, returnData, 4, originalData.length);
        }
        return returnData;
    }

    @Override
    public byte[] sm2ExternalSign(int algId, byte[] hash, byte[] privateKey) {
        byte[] allsignedResult = new byte[68];
        byte[] stateData = ByteArrayUtil.intToByte(0);
        SM2Signer sm2 = new SM2Signer();
        byte[] signedResult = sm2.sign(privateKey, hash);
        System.arraycopy(stateData, 0, allsignedResult, 0, 4);
        System.arraycopy(signedResult, 0, allsignedResult, 4, 64);
        return allsignedResult;
    }

    @Override
    public byte[] sm2ExternalVerify(int algId, byte[] hash, byte[] signature, byte[] publicKey) {
        byte[] stateData = ByteArrayUtil.intToByte(0);
        SM2Signer sm2 = new SM2Signer();
        boolean isSuccess = sm2.verify(publicKey, hash, signature);
        if (isSuccess) {
            return stateData;
        }
        return MathUtil.intToByteArray(1);
    }

    @Override
    public byte[] sm2GenKeyPair() {
        byte[] allKeyPairData = new byte[100];
        byte[] stateData = ByteArrayUtil.intToByte(0);
        SM2Signer sm2 = new SM2Signer();
        byte[] keypair = sm2.genKeyPair();
        System.arraycopy(stateData, 0, allKeyPairData, 0, 4);
        System.arraycopy(keypair, 0, allKeyPairData, 4, 96);
        return allKeyPairData;
    }

    @Override
    public byte[] sm3Hash(byte[] dataInput, byte[] publicKey, byte[] id) {
        byte[] bHash = new byte[32];
        SM2Signer sm2 = new SM2Signer();
        SM3Digest sm3 = new SM3Digest();
        if (publicKey == null) {
            sm3.update(dataInput, 0, dataInput.length);
            sm3.doFinal(bHash, 0);
        } else {
            ECPoint pubkey = sm2.decodePoint(publicKey);
            BigInteger affineX = pubkey.getX().toBigInteger();
            BigInteger affineY = pubkey.getY().toBigInteger();
            sm3.addId(affineX, affineY, id);
            sm3.update(dataInput, 0, dataInput.length);
            sm3.doFinal(bHash, 0);
        }
        byte[] returnData = new byte[bHash.length + 4];
        if (bHash != null) {
            byte[] rightByte = MathUtil.intToByteArray(0);
            System.arraycopy(rightByte, 0, returnData, 0, 4);
            System.arraycopy(bHash, 0, returnData, 4, bHash.length);
        } else {
            byte[] errorByte = MathUtil.intToByteArray(1);
            System.arraycopy(errorByte, 0, returnData, 0, 4);
            System.arraycopy(bHash, 0, returnData, 4, bHash.length);
        }
        return returnData;
    }

    @Override
    public byte[] encrypt(int algId, boolean forPKCS5Padding, byte[] key, byte[] iv, byte[] dataInput) {
        SecretKeyFactory keyfactory;
        String algStr;
        byte[] out = null;
        if (algId == 8193) {
            algStr = "DESede/ECB/Nopadding";
            if (forPKCS5Padding) {
                algStr = "DESede/ECB/PKCS5Padding";
            }
            try {
                keyfactory = SecretKeyFactory.getInstance("DESede");
                DESedeKeySpec keyspec = new DESedeKeySpec(key);
                SecretKey deskey = keyfactory.generateSecret(keyspec);
                Cipher cpher = Cipher.getInstance(algStr);
                cpher.init(1, deskey);
                out = cpher.doFinal(dataInput);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (algId == 8194) {
            algStr = "DESede/CBC/Nopadding";
            if (forPKCS5Padding) {
                algStr = "DESede/CBC/PKCS5Padding";
            }
            try {
                keyfactory = SecretKeyFactory.getInstance("DESede");
                DESedeKeySpec keyspec = new DESedeKeySpec(key);
                SecretKey deskey = keyfactory.generateSecret(keyspec);
                Cipher cpher = Cipher.getInstance(algStr);
                IvParameterSpec ivpara = new IvParameterSpec(iv);
                cpher.init(1, (Key)deskey, ivpara);
                out = cpher.doFinal(dataInput);
            }
            catch (Exception e) {
                return null;
            }
        }
        SM4Crypto sm4C = new SM4Crypto();
        try {
            out = null != iv ? sm4C.encrypt_pkcs5(2, key, iv, dataInput) : sm4C.encrypt_pkcs5(1, key, iv, dataInput);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        byte[] returnData = new byte[out.length + 4];
        if (out != null) {
            byte[] rightByte = MathUtil.intToByteArray(0);
            System.arraycopy(rightByte, 0, returnData, 0, 4);
            System.arraycopy(out, 0, returnData, 4, out.length);
        }
        return returnData;
    }

    @Override
    public byte[] decrypt(int algId, boolean forPKCS5Padding, byte[] key, byte[] iv, byte[] dataInput) {
        SecretKeyFactory keyfactory;
        String algStr;
        byte[] out = null;
        if (algId == 8193) {
            algStr = "DESede/ECB/Nopadding";
            if (forPKCS5Padding) {
                algStr = "DESede/ECB/PKCS5Padding";
            }
            try {
                keyfactory = SecretKeyFactory.getInstance("DESede");
                DESedeKeySpec keyspec = new DESedeKeySpec(key);
                SecretKey deskey = keyfactory.generateSecret(keyspec);
                Cipher cpher = Cipher.getInstance(algStr);
                cpher.init(2, deskey);
                out = cpher.doFinal(dataInput);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (algId == 8194) {
            algStr = "DESede/CBC/Nopadding";
            if (forPKCS5Padding) {
                algStr = "DESede/CBC/PKCS5Padding";
            }
            try {
                keyfactory = SecretKeyFactory.getInstance("DESede");
                DESedeKeySpec keyspec = new DESedeKeySpec(key);
                SecretKey deskey = keyfactory.generateSecret(keyspec);
                Cipher cpher = Cipher.getInstance(algStr);
                IvParameterSpec ivpara = new IvParameterSpec(iv);
                cpher.init(2, (Key)deskey, ivpara);
                out = cpher.doFinal(dataInput);
            }
            catch (Exception e) {
                return null;
            }
        }
        SM4Crypto sm4C = new SM4Crypto();
        try {
            out = null != iv ? sm4C.decrypt_pkcs5(2, key, iv, dataInput) : sm4C.decrypt_pkcs5(1, key, iv, dataInput);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        byte[] returnData = new byte[out.length + 4];
        if (out != null) {
            byte[] rightByte = MathUtil.intToByteArray(0);
            System.arraycopy(rightByte, 0, returnData, 0, 4);
            System.arraycopy(out, 0, returnData, 4, out.length);
        }
        return returnData;
    }
}

