/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.symmetric;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.misc.IDEACBCPar;
import xjyb.org.bjca.crypto.CipherKeyGenerator;
import xjyb.org.bjca.crypto.engines.IDEAEngine;
import xjyb.org.bjca.crypto.macs.CBCBlockCipherMac;
import xjyb.org.bjca.crypto.macs.CFBBlockCipherMac;
import xjyb.org.bjca.crypto.modes.CBCBlockCipher;
import xjyb.org.bjca.jce.provider.JCEBlockCipher;
import xjyb.org.bjca.jce.provider.JCEKeyGenerator;
import xjyb.org.bjca.jce.provider.JCEMac;
import xjyb.org.bjca.jce.provider.JCESecretKeyFactory;
import xjyb.org.bjca.jce.provider.JDKAlgorithmParameterGenerator;
import xjyb.org.bjca.jce.provider.JDKAlgorithmParameters;

public final class IDEA {
    private IDEA() {
    }

    public static class CFB8Mac
    extends JCEMac {
        public CFB8Mac() {
            super(new CFBBlockCipherMac(new IDEAEngine()));
        }
    }

    public static class Mac
    extends JCEMac {
        public Mac() {
            super(new CBCBlockCipherMac(new IDEAEngine()));
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters {
        private byte[] iv;

        @Override
        protected byte[] engineGetEncoded() throws IOException {
            return this.engineGetEncoded("ASN.1");
        }

        @Override
        protected byte[] engineGetEncoded(String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                return new IDEACBCPar(this.engineGetEncoded("RAW")).getEncoded();
            }
            if (format.equals("RAW")) {
                byte[] tmp = new byte[this.iv.length];
                System.arraycopy(this.iv, 0, tmp, 0, this.iv.length);
                return tmp;
            }
            return null;
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == IvParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)paramSpec).getIV();
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            this.iv = new byte[params.length];
            System.arraycopy(params, 0, this.iv, 0, this.iv.length);
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (format.equals("RAW")) {
                this.engineInit(params);
                return;
            }
            if (format.equals("ASN.1")) {
                ASN1InputStream aIn = new ASN1InputStream(params);
                IDEACBCPar oct = new IDEACBCPar((ASN1Sequence)aIn.readObject());
                this.engineInit(oct.getIV());
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        @Override
        protected String engineToString() {
            return "IDEA Parameters";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("IDEA", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class PBEWithSHAAndIDEA
    extends JCEBlockCipher {
        public PBEWithSHAAndIDEA() {
            super(new CBCBlockCipher(new IDEAEngine()));
        }
    }

    public static class PBEWithSHAAndIDEAKeyGen
    extends JCESecretKeyFactory.PBEKeyFactory {
        public PBEWithSHAAndIDEAKeyGen() {
            super("PBEwithSHAandIDEA-CBC", null, true, 2, 1, 128, 64);
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("IDEA", 128, new CipherKeyGenerator());
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new IDEAEngine()), 64);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new IDEAEngine());
        }
    }
}

