/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import xjyb.org.bjca.crypto.CipherKeyGenerator;
import xjyb.org.bjca.crypto.engines.AESEngine;
import xjyb.org.bjca.crypto.engines.AESFastEngine;
import xjyb.org.bjca.crypto.engines.AESWrapEngine;
import xjyb.org.bjca.crypto.engines.RFC3211WrapEngine;
import xjyb.org.bjca.crypto.modes.CBCBlockCipher;
import xjyb.org.bjca.crypto.modes.CFBBlockCipher;
import xjyb.org.bjca.crypto.modes.OFBBlockCipher;
import xjyb.org.bjca.jce.provider.JCEBlockCipher;
import xjyb.org.bjca.jce.provider.JCEKeyGenerator;
import xjyb.org.bjca.jce.provider.JDKAlgorithmParameterGenerator;
import xjyb.org.bjca.jce.provider.JDKAlgorithmParameters;
import xjyb.org.bjca.jce.provider.WrapCipherSpi;

public final class AES {
    private AES() {
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "AES IV";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("AES", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen256
    extends KeyGen {
        public KeyGen256() {
            super(256);
        }
    }

    public static class KeyGen192
    extends KeyGen {
        public KeyGen192() {
            super(192);
        }
    }

    public static class KeyGen128
    extends KeyGen {
        public KeyGen128() {
            super(128);
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            this(192);
        }

        public KeyGen(int keySize) {
            super("AES", keySize, new CipherKeyGenerator());
        }
    }

    public static class RFC3211Wrap
    extends WrapCipherSpi {
        public RFC3211Wrap() {
            super(new RFC3211WrapEngine(new AESEngine()), 16);
        }
    }

    public static class Wrap
    extends WrapCipherSpi {
        public Wrap() {
            super(new AESWrapEngine());
        }
    }

    public static class OFB
    extends JCEBlockCipher {
        public OFB() {
            super(new OFBBlockCipher(new AESFastEngine(), 128), 128);
        }
    }

    public static class CFB
    extends JCEBlockCipher {
        public CFB() {
            super(new CFBBlockCipher(new AESFastEngine(), 128), 128);
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new AESFastEngine()), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new AESFastEngine());
        }
    }
}

