/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser;

import java.util.ArrayList;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.Item;

public class RecipientInfo {
    private Item version = new Item();
    private Item issuerAndSerialNumber = new Item();
    private Item keyEncryptionAlgorithm = new Item();
    private Item encryptedKey = new Item();
    private byte[] bIssuerAndSerialNumber = null;
    private byte[] encKey = null;
    private String encryptedAlgorithmIdenfitier = null;
    private byte[] iv = null;

    public void parse(byte[] input, int offset, int length) {
        if (length < 2) {
            return;
        }
        int position = 0;
        Item tmpitem = new Item();
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.version = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.issuerAndSerialNumber = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.keyEncryptionAlgorithm = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        tmpitem.offset += offset;
        this.encryptedKey = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("Version is (" + this.version.offset + "," + this.version.length + ")\nissuerAndSerialNumber is (" + this.issuerAndSerialNumber.offset + "," + this.issuerAndSerialNumber.length + ")\nkeyEncryptionAlgorithm is (" + this.keyEncryptionAlgorithm.offset + "," + this.keyEncryptionAlgorithm.length + ")\nencryptedKey is (" + this.encryptedKey.offset + "," + this.encryptedKey.length + ")");
            DerUtil.printItem(input, this.encryptedKey);
        }
        if (this.encryptedKey.length > 0) {
            this.encKey = new byte[this.encryptedKey.length];
            System.arraycopy(input, this.encryptedKey.offset, this.encKey, 0, this.encryptedKey.length);
        }
        if (this.issuerAndSerialNumber.length > 0) {
            this.bIssuerAndSerialNumber = new byte[this.issuerAndSerialNumber.length];
            System.arraycopy(input, this.issuerAndSerialNumber.offset, this.bIssuerAndSerialNumber, 0, this.issuerAndSerialNumber.length);
        }
        if (this.keyEncryptionAlgorithm.length > 0) {
            DerUtil.printItem(input, this.keyEncryptionAlgorithm);
            ArrayList aiv = new ArrayList(1);
            DerUtil.parseSequence(input, this.keyEncryptionAlgorithm, aiv);
            if (aiv.size() > 0) {
                tmpitem = (Item)aiv.get(0);
                if (tmpitem.length > 0) {
                    this.encryptedAlgorithmIdenfitier = DerUtil.toDERObjectIdentifier(input, tmpitem.offset, tmpitem.length);
                }
                if (DerUtil.debug) {
                    DerUtil.printItem(input, tmpitem);
                }
            }
            if (aiv.size() > 1) {
                tmpitem = (Item)aiv.get(1);
                if ((input[tmpitem.offset] & 0xFF) == 5) {
                    this.iv = null;
                } else {
                    this.iv = new byte[tmpitem.length];
                    System.arraycopy(input, tmpitem.offset, this.iv, 0, tmpitem.length);
                }
                if (DerUtil.debug) {
                    DerUtil.printItem(input, tmpitem);
                }
            }
        }
    }

    public final Item getVersion() {
        return this.version;
    }

    public final Item getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public final Item getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public final Item getEncryptedKey() {
        return this.encryptedKey;
    }

    public final byte[] getEncKey() {
        return this.encKey;
    }

    public final String getEncryptedAlgorithmIdenfitier() {
        return this.encryptedAlgorithmIdenfitier;
    }

    public final byte[] getIvParameter() {
        return this.iv;
    }

    public final byte[] getIssuerAndSerialNumberBytes() {
        return this.bIssuerAndSerialNumber;
    }
}

