/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERBoolean;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DERGeneralizedTime;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.DERUTCTime;
import xjyb.org.bjca.asn1.cmp.PKIStatusInfo;
import xjyb.org.bjca.asn1.cms.ContentInfo;
import xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.tsp.Accuracy;
import xjyb.org.bjca.asn1.tsp.TimeStampResp;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.CertificateList;
import xjyb.org.bjca.asn1.x509.TBSCertificateStructure;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.FX509Certificate;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.timestamp.FastTimeStamp;
import xjyb.org.bjca.jce.interfaces.TimeStampInterface;
import xjyb.org.bjca.jce.provider.X509CRLObject;
import xjyb.org.bjca.jce.provider.X509CertificateObjectFP;
import xjyb.org.bjca.util.TimeFormatUtil;

public class CNTimeStamp
implements PKCSObjectIdentifiers,
TimeStampInterface {
    int version;
    int signerversion;
    Set originalDataDigestAlgs;
    Collection certs;
    Collection crls;
    X509CertificateStructure signCert;
    byte[] signCertByte;
    byte[] encryptedDigest;
    byte[] timeStampOriginalData;
    String digestAlgorithm;
    String digestEncryptionAlgorithm;
    byte[] contentData;
    private byte[] finalOriginalData = null;
    Date signDate;
    private byte[] originalHashByte = null;
    private byte[] timeByte = null;
    private byte[] accuracy = null;
    private String serialNumber = null;
    TBSCertificateStructure signCertTBS;
    DERObject[] certsEncoded;
    Hashtable isAndsns;
    private boolean isAttachServerCert = true;
    static final String ID_TimeStamping = "1.3.6.1.5.5.7.3.8";
    static final String ID_ct_TSTInfo = "1.2.840.113549.1.9.16.1.4";
    static final String ID_ts_contentType = "1.2.840.113549.1.9.3";
    static final String ID_ts_messageDigest = "1.2.840.113549.1.9.4";
    static final String ID_ts_signingTime = "1.2.840.113549.1.9.5";
    byte[] bsPKCS7 = null;
    FastTimeStamp fxPKCS7 = null;
    String provider = "";

    public CNTimeStamp() {
    }

    public byte[] createRequest(byte[] originalHashData, boolean isAttachCert) throws IOException {
        DERConstructedSequence requestSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERConstructedSequence requestContent = new DERConstructedSequence();
        DERConstructedSequence contentTypeSeq = new DERConstructedSequence();
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.1.401.1");
        contentTypeSeq.addObject(contentType);
        DEROctetString originalHash = null;
        if (originalHashData != null) {
            originalHash = new DEROctetString(originalHashData);
        }
        requestContent.addObject(contentType);
        requestContent.addObject(originalHash);
        DERBoolean isContainCert = new DERBoolean(isAttachCert);
        requestSequence.addObject(version);
        requestSequence.addObject(requestContent);
        requestSequence.addObject(isContainCert);
        return requestSequence.getEncoded();
    }

    public CNTimeStamp(byte[] in) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, IOException, CRLException {
        this.fxPKCS7 = new FastTimeStamp();
        this.fxPKCS7.pkcs7Data(in);
        this.provider = this.provider;
        this.bsPKCS7 = in;
        ArrayList alCerts = this.fxPKCS7.getCerts();
        this.certs = new ArrayList();
        this.certsEncoded = new DERObject[alCerts.size()];
        for (int i = 0; i < alCerts.size(); ++i) {
            Item itCert = (Item)alCerts.get(i);
            byte[] bsCert = new byte[itCert.length + itCert.tagsize];
            System.arraycopy(this.bsPKCS7, itCert.offset - itCert.tagsize, bsCert, 0, bsCert.length);
            this.certs.add(new X509CertificateObjectFP(bsCert));
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsCert));
            try {
                ASN1Sequence derCert = (ASN1Sequence)ains.readObject();
                this.certsEncoded[i] = derCert;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        ArrayList alCrls = this.fxPKCS7.getCrls();
        this.crls = new ArrayList();
        for (int i = 0; i < alCrls.size(); ++i) {
            Item itCrl = (Item)alCrls.get(i);
            byte[] bsCrl = new byte[itCrl.length + itCrl.tagsize];
            System.arraycopy(this.bsPKCS7, itCrl.offset - itCrl.tagsize, bsCrl, 0, bsCrl.length);
            ByteArrayInputStream bIn = new ByteArrayInputStream(bsCrl);
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            CertificateList certList = new CertificateList(seq);
            this.crls.add(new X509CRLObject(certList));
        }
        Item signCertItem = this.fxPKCS7.getSignCert();
        this.signCertByte = DerUtil.getItemDataAndTag(this.bsPKCS7, signCertItem);
        if (this.signCertByte.length != 0) {
            this.signCert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(this.signCertByte));
            this.signCertTBS = this.signCert.getTBSCertificate();
            Item item = this.fxPKCS7.getSignCert();
            byte[] bs = new byte[item.length];
            System.arraycopy(in, item.offset, bs, 0, item.length);
            FX509Certificate fx = new FX509Certificate();
            fx.parse(bs, 0, bs.length);
        }
        ArrayList daAl = this.fxPKCS7.getDigestAlgorithms();
        this.originalDataDigestAlgs = new HashSet();
        for (int i = 0; i < daAl.size(); ++i) {
            Item daItem = (Item)daAl.get(i);
            byte[] ds = DerUtil.getItemDataAndTag(this.bsPKCS7, daItem);
            ASN1InputStream a = new ASN1InputStream(ds);
            ASN1Sequence asn = null;
            try {
                DERObject obj = a.readObject();
                asn = (ASN1Sequence)obj;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DERObjectIdentifier o = (DERObjectIdentifier)asn.getObjectAt(0);
            this.originalDataDigestAlgs.add(o.getId());
        }
        this.version = this.fxPKCS7.getVersion();
        this.signerversion = this.fxPKCS7.getSignInfoVersion();
        Item rawDataItem = this.fxPKCS7.getRawData();
        this.contentData = DerUtil.getItemData(this.bsPKCS7, rawDataItem);
        this.originalHashByte = this.fxPKCS7.getOriginalHashByte();
        this.timeByte = this.fxPKCS7.getTimeByte();
        Item accuracyItem = this.fxPKCS7.getAccuracy();
        this.accuracy = DerUtil.getItemDataAndTag(this.bsPKCS7, accuracyItem);
        this.serialNumber = this.fxPKCS7.getIssuerAndSerialNum().getSerialNumber().getSerialNumber().toString(16);
        Item digestItem = this.fxPKCS7.getDigest();
        this.encryptedDigest = DerUtil.getItemData(this.bsPKCS7, digestItem);
        this.digestAlgorithm = this.fxPKCS7.getDigestAlgorithm();
        this.digestEncryptionAlgorithm = this.fxPKCS7.getDigestEncryptionAlgorithm();
        Item authenticateAttrItem = this.fxPKCS7.getAuthenticatedAttributes();
        byte[] authenticateAttriByte = DerUtil.getItemData(this.bsPKCS7, authenticateAttrItem);
        int len = authenticateAttriByte.length;
        ArrayList lenList = DerUtil.getLengthDer(len);
        int addLen = lenList.size();
        this.finalOriginalData = new byte[len + 1 + addLen];
        this.finalOriginalData[0] = 49;
        for (int i = 0; i < addLen; ++i) {
            this.finalOriginalData[i + 1] = (byte)Integer.parseInt((String)lenList.get(i));
        }
        System.arraycopy(authenticateAttriByte, 0, this.finalOriginalData, addLen + 1, len);
    }

    public CNTimeStamp(X509CertificateStructure[] certChain) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.originalDataDigestAlgs = new HashSet();
        this.originalDataDigestAlgs.add("1.2.156.10197.1.401.1");
        this.digestAlgorithm = "1.2.156.10197.1.401";
        this.signCert = certChain[0];
        for (int i = 0; i < certChain.length; ++i) {
            this.certs.add(certChain[i]);
        }
        this.digestEncryptionAlgorithm = "1.2.156.10197.1.301.1";
    }

    public X509CertificateStructure[] getCertificates() {
        return this.certs.toArray(new X509CertificateStructure[0]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509CertificateStructure getSigningCertificate() {
        return this.signCert;
    }

    @Override
    public byte[] getSignCertByte() {
        return this.signCertByte;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public byte[] getSignValue() {
        return this.encryptedDigest;
    }

    public TBSCertificateStructure getSignCertTBS() {
        return this.signCertTBS;
    }

    public DERObject[] getCertEncoded() {
        return this.certsEncoded;
    }

    public void updateRequest(byte[] request) throws IOException {
        ASN1InputStream requestStream = new ASN1InputStream(request);
        DERObject requestObj = requestStream.readObject();
        ASN1Sequence requestSeq = (ASN1Sequence)requestObj;
        ASN1Sequence originalHashDataContent = (ASN1Sequence)requestSeq.getObjectAt(1);
        DERBoolean isAttachCert = (DERBoolean)requestSeq.getObjectAt(2);
        this.isAttachServerCert = isAttachCert.isTrue();
        BigInteger serialNum = new BigInteger("100000001");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        TimeZone tz = TimeZone.getTimeZone("Zulu");
        dateformat.setTimeZone(tz);
        this.signDate = new Date();
        String nowTime = dateformat.format(this.signDate);
        DERConstructedSequence timeStampOriginalDataSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERObjectIdentifier contentType = new DERObjectIdentifier(ID_TimeStamping);
        Object originalHash = null;
        DERInteger serialNumInt = new DERInteger(serialNum);
        DERGeneralizedTime generalizedTime = new DERGeneralizedTime(nowTime);
        timeStampOriginalDataSequence.addObject(version);
        timeStampOriginalDataSequence.addObject(contentType);
        timeStampOriginalDataSequence.addObject(originalHashDataContent);
        timeStampOriginalDataSequence.addObject(serialNumInt);
        timeStampOriginalDataSequence.addObject(generalizedTime);
        this.timeStampOriginalData = timeStampOriginalDataSequence.getEncoded();
    }

    public void updateRequest0033(byte[] request) throws IOException {
        ASN1InputStream requestStream = new ASN1InputStream(request);
        DERObject requestObj = requestStream.readObject();
        ASN1Sequence requestSeq = (ASN1Sequence)requestObj;
        ASN1Sequence originalHashDataContent = (ASN1Sequence)requestSeq.getObjectAt(1);
        DERBoolean isAttachCert = (DERBoolean)requestSeq.getObjectAt(2);
        this.isAttachServerCert = isAttachCert.isTrue();
        BigInteger serialNum = new BigInteger("100000001");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        TimeZone tz = TimeZone.getTimeZone("Zulu");
        dateformat.setTimeZone(tz);
        this.signDate = new Date();
        String nowTime = dateformat.format(this.signDate);
        DERConstructedSequence timeStampOriginalDataSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERObjectIdentifier contentType = new DERObjectIdentifier(ID_TimeStamping);
        Object originalHash = null;
        DERInteger serialNumInt = new DERInteger(serialNum);
        DERGeneralizedTime generalizedTime = new DERGeneralizedTime(nowTime);
        Accuracy accuracy = new Accuracy(new DERInteger(1), new DERInteger(1), new DERInteger(1));
        timeStampOriginalDataSequence.addObject(version);
        timeStampOriginalDataSequence.addObject(contentType);
        timeStampOriginalDataSequence.addObject(originalHashDataContent);
        timeStampOriginalDataSequence.addObject(serialNumInt);
        timeStampOriginalDataSequence.addObject(generalizedTime);
        timeStampOriginalDataSequence.addObject(accuracy.toASN1Object());
        this.timeStampOriginalData = timeStampOriginalDataSequence.getEncoded();
    }

    public void update(byte[] digest) throws IOException {
        BigInteger serialNum = new BigInteger("100000001");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        TimeZone tz = TimeZone.getTimeZone("Zulu");
        dateformat.setTimeZone(tz);
        this.signDate = new Date();
        String nowTime = dateformat.format(this.signDate);
        DERConstructedSequence timeStampOriginalDataSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERObjectIdentifier contentType = new DERObjectIdentifier(ID_TimeStamping);
        DERConstructedSequence originalHashDataContent = new DERConstructedSequence();
        DERConstructedSequence hashTypeSeq = new DERConstructedSequence();
        DERObjectIdentifier hashType = new DERObjectIdentifier("1.2.156.10197.1.401");
        hashTypeSeq.addObject(hashType);
        DEROctetString originalHash = null;
        if (digest != null) {
            originalHash = new DEROctetString(digest);
        }
        originalHashDataContent.addObject(hashTypeSeq);
        originalHashDataContent.addObject(originalHash);
        DERInteger serialNumInt = new DERInteger(serialNum);
        DERGeneralizedTime generalizedTime = new DERGeneralizedTime(nowTime);
        timeStampOriginalDataSequence.addObject(version);
        timeStampOriginalDataSequence.addObject(contentType);
        timeStampOriginalDataSequence.addObject(originalHashDataContent);
        timeStampOriginalDataSequence.addObject(serialNumInt);
        timeStampOriginalDataSequence.addObject(generalizedTime);
        this.timeStampOriginalData = timeStampOriginalDataSequence.getEncoded();
    }

    public boolean verify(byte[] cert) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        boolean isSuccess = false;
        WrapCard wCard = new WrapCard();
        X509CertificateStructure x509Cert = null;
        if (cert == null) {
            x509Cert = this.signCert;
            isSuccess = wCard.vefiySM3WithSM2Sign(this.finalOriginalData, this.signCert, this.encryptedDigest);
        } else {
            x509Cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(cert));
            isSuccess = wCard.vefiySM3WithSM2Sign(this.finalOriginalData, x509Cert, this.encryptedDigest);
        }
        if (!isSuccess) {
            return false;
        }
        try {
            Date endDate = x509Cert.getEndDate().getDate();
            String formatString = "yyyyMMddHHmmss";
            SimpleDateFormat newDateformat = new SimpleDateFormat(formatString);
            String tsTime = TimeFormatUtil.convertTimeFormat(this.getTimeByte(), formatString);
            int comRes = endDate.compareTo(newDateformat.parse(tsTime));
            if (comRes < 0) {
                return false;
            }
        }
        catch (Exception e) {
            throw new IOException("convert timeFormat Exception" + e);
        }
        return isSuccess;
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream(new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded(byte[] privateKey, boolean isAttachCert) {
        try {
            WrapCard wCard = new WrapCard();
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.originalDataDigestAlgs.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier(ID_ct_TSTInfo));
            DEROctetString octets = new DEROctetString(this.timeStampOriginalData);
            DERTaggedObject tagged = new DERTaggedObject(0, octets);
            contentinfo.addObject(tagged);
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509CertificateStructure)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuer().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), this.signCert.getSerialNumber());
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            DERConstructedSequence contentinfo1 = new DERConstructedSequence();
            DERObjectIdentifier contentTypeIden = new DERObjectIdentifier(ID_ts_contentType);
            DERObjectIdentifier tstInfoIden = new DERObjectIdentifier(ID_ct_TSTInfo);
            DERConstructedSet tstInfoSet = new DERConstructedSet();
            tstInfoSet.addObject(tstInfoIden);
            contentinfo1.addObject(contentTypeIden);
            contentinfo1.addObject(tstInfoSet);
            DERConstructedSequence contentinfo2 = new DERConstructedSequence();
            DERObjectIdentifier signingTimeIden = new DERObjectIdentifier(ID_ts_signingTime);
            DERConstructedSet utcTimeSet = new DERConstructedSet();
            DERUTCTime utcTime = new DERUTCTime(this.signDate);
            utcTimeSet.addObject(utcTime);
            contentinfo2.addObject(signingTimeIden);
            contentinfo2.addObject(utcTimeSet);
            DERConstructedSequence contentinfo3 = new DERConstructedSequence();
            DERObjectIdentifier tsDigestIden = new DERObjectIdentifier(ID_ts_messageDigest);
            DERConstructedSet digestSet = new DERConstructedSet();
            byte[] tsInfoDigest = wCard.sm3(this.timeStampOriginalData, null, null);
            DEROctetString tsInfoDigestStr = new DEROctetString(tsInfoDigest);
            digestSet.addObject(tsInfoDigestStr);
            contentinfo3.addObject(tsDigestIden);
            contentinfo3.addObject(digestSet);
            DERConstructedSet tobeSignedOriginalSet = new DERConstructedSet();
            tobeSignedOriginalSet.addObject(contentinfo1);
            tobeSignedOriginalSet.addObject(contentinfo2);
            tobeSignedOriginalSet.addObject(contentinfo3);
            byte[] tobeSignedOriginalDataByte = tobeSignedOriginalSet.getEncoded();
            byte[] tobeWriteOrigianlDataByte = (byte[])tobeSignedOriginalDataByte.clone();
            tobeWriteOrigianlDataByte[0] = -96;
            ByteArrayInputStream tobeWriteArrayIn = new ByteArrayInputStream(tobeWriteOrigianlDataByte);
            ASN1InputStream tobeWriteIn = new ASN1InputStream(tobeWriteArrayIn);
            DERObject tobeWriteDer = tobeWriteIn.readObject();
            signerinfo.addObject(tobeWriteDer);
            if (null == this.encryptedDigest) {
                this.encryptedDigest = wCard.sm3WithSM2Sign(tobeSignedOriginalDataByte, this.signCert, privateKey);
            }
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.encryptedDigest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            if (this.isAttachServerCert && isAttachCert) {
                body.addObject(new DERTaggedObject(false, 0, dercertificates));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier("1.2.156.10197.6.1.4.2.2"));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public byte[] getEncoded0033(byte[] privateKey, boolean isAttachCert) {
        try {
            WrapCard wCard = new WrapCard();
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.originalDataDigestAlgs.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier(ID_ct_TSTInfo));
            DEROctetString octets = new DEROctetString(this.timeStampOriginalData);
            DERTaggedObject tagged = new DERTaggedObject(0, octets);
            contentinfo.addObject(tagged);
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509CertificateStructure)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuer().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), this.signCert.getSerialNumber());
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            DERConstructedSequence contentinfo1 = new DERConstructedSequence();
            DERObjectIdentifier contentTypeIden = new DERObjectIdentifier(ID_ts_contentType);
            DERObjectIdentifier tstInfoIden = new DERObjectIdentifier(ID_ct_TSTInfo);
            DERConstructedSet tstInfoSet = new DERConstructedSet();
            tstInfoSet.addObject(tstInfoIden);
            contentinfo1.addObject(contentTypeIden);
            contentinfo1.addObject(tstInfoSet);
            DERConstructedSequence contentinfo2 = new DERConstructedSequence();
            DERObjectIdentifier signingTimeIden = new DERObjectIdentifier(ID_ts_signingTime);
            DERConstructedSet utcTimeSet = new DERConstructedSet();
            DERUTCTime utcTime = new DERUTCTime(this.signDate);
            utcTimeSet.addObject(utcTime);
            contentinfo2.addObject(signingTimeIden);
            contentinfo2.addObject(utcTimeSet);
            DERConstructedSequence contentinfo3 = new DERConstructedSequence();
            DERObjectIdentifier tsDigestIden = new DERObjectIdentifier(ID_ts_messageDigest);
            DERConstructedSet digestSet = new DERConstructedSet();
            byte[] tsInfoDigest = wCard.sm3(this.timeStampOriginalData, null, null);
            DEROctetString tsInfoDigestStr = new DEROctetString(tsInfoDigest);
            digestSet.addObject(tsInfoDigestStr);
            contentinfo3.addObject(tsDigestIden);
            contentinfo3.addObject(digestSet);
            DERConstructedSet tobeSignedOriginalSet = new DERConstructedSet();
            tobeSignedOriginalSet.addObject(contentinfo1);
            tobeSignedOriginalSet.addObject(contentinfo2);
            tobeSignedOriginalSet.addObject(contentinfo3);
            byte[] tobeSignedOriginalDataByte = tobeSignedOriginalSet.getEncoded();
            byte[] tobeWriteOrigianlDataByte = (byte[])tobeSignedOriginalDataByte.clone();
            tobeWriteOrigianlDataByte[0] = -96;
            ByteArrayInputStream tobeWriteArrayIn = new ByteArrayInputStream(tobeWriteOrigianlDataByte);
            ASN1InputStream tobeWriteIn = new ASN1InputStream(tobeWriteArrayIn);
            DERObject tobeWriteDer = tobeWriteIn.readObject();
            signerinfo.addObject(tobeWriteDer);
            if (null == this.encryptedDigest) {
                this.encryptedDigest = wCard.sm3WithSM2Sign(tobeSignedOriginalDataByte, this.signCert, privateKey);
            }
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.encryptedDigest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            if (this.isAttachServerCert && isAttachCert) {
                body.addObject(new DERTaggedObject(false, 0, dercertificates));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DERObjectIdentifier("1.2.156.10197.6.1.4.2.2"));
            v.add(new DERTaggedObject(0, body));
            DERSequence whole = new DERSequence(v);
            ContentInfo contentInfo = new ContentInfo(whole);
            PKIStatusInfo pkiStatusInfo = new PKIStatusInfo(0);
            TimeStampResp TimeStampResp2 = new TimeStampResp(pkiStatusInfo, contentInfo);
            return TimeStampResp2.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public byte[] getOriginalHashByte() {
        return this.originalHashByte;
    }

    @Override
    public byte[] getTimeByte() {
        return this.timeByte;
    }

    @Override
    public byte[] getAccuracy() {
        return this.accuracy;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    public String getHashDigestAlg() {
        return this.digestAlgorithm;
    }
}

