/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.signers;

import java.util.Hashtable;
import xjyb.org.bjca.asn1.DERNull;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.nist.NISTObjectIdentifiers;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.teletrust.TeleTrusTObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.DigestInfo;
import xjyb.org.bjca.asn1.x509.X509ObjectIdentifiers;
import xjyb.org.bjca.crypto.AsymmetricBlockCipher;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.CryptoException;
import xjyb.org.bjca.crypto.DataLengthException;
import xjyb.org.bjca.crypto.Digest;
import xjyb.org.bjca.crypto.Signer;
import xjyb.org.bjca.crypto.encodings.PKCS1Encoding;
import xjyb.org.bjca.crypto.engines.RSABlindedEngine;
import xjyb.org.bjca.crypto.params.AsymmetricKeyParameter;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;

public class BJCASigner
implements Signer {
    private final AsymmetricBlockCipher rsaEngine = new PKCS1Encoding(new RSABlindedEngine());
    private final AlgorithmIdentifier algId;
    private boolean forSigning;
    private byte[] hashedData;
    private static final Hashtable oidMap = new Hashtable();
    private Digest digest;

    public BJCASigner(Digest digest) {
        this.digest = digest;
        this.algId = new AlgorithmIdentifier((DERObjectIdentifier)oidMap.get(digest.getAlgorithmName()), DERNull.INSTANCE);
    }

    public BJCASigner() {
        this.algId = new AlgorithmIdentifier((DERObjectIdentifier)oidMap.get("SHA-1"), DERNull.INSTANCE);
    }

    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "withRSA";
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        AsymmetricKeyParameter k = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !k.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!forSigning && k.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.rsaEngine.init(forSigning, parameters);
    }

    @Override
    public void update(byte input) {
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.hashedData = new byte[length];
        System.arraycopy(input, inOff, this.hashedData, 0, length);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.forSigning) {
            throw new IllegalStateException("RSADigestSigner not initialised for signature generation.");
        }
        byte[] data = this.derEncode(this.hashedData);
        return this.rsaEngine.processBlock(data, 0, data.length);
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        byte[] expected;
        byte[] sig;
        if (this.forSigning) {
            throw new IllegalStateException("RSADigestSigner not initialised for verification");
        }
        try {
            sig = this.rsaEngine.processBlock(signature, 0, signature.length);
            expected = this.derEncode(this.hashedData);
        }
        catch (Exception e) {
            return false;
        }
        if (sig.length == expected.length) {
            for (int i = 0; i < sig.length; ++i) {
                if (sig[i] == expected[i]) continue;
                return false;
            }
        } else if (sig.length == expected.length - 2) {
            int i;
            int sigOffset = sig.length - this.hashedData.length - 2;
            int expectedOffset = expected.length - this.hashedData.length - 2;
            expected[1] = (byte)(expected[1] - 2);
            expected[3] = (byte)(expected[3] - 2);
            for (i = 0; i < this.hashedData.length; ++i) {
                if (sig[sigOffset + i] == expected[expectedOffset + i]) continue;
                return false;
            }
            for (i = 0; i < sigOffset; ++i) {
                if (sig[i] == expected[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
    }

    private byte[] derEncode(byte[] hash) {
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        return dInfo.getDEREncoded();
    }

    static {
        oidMap.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        oidMap.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        oidMap.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        oidMap.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        oidMap.put("SHA-224", NISTObjectIdentifiers.id_sha224);
        oidMap.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        oidMap.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        oidMap.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        oidMap.put("MD2", PKCSObjectIdentifiers.md2);
        oidMap.put("MD4", PKCSObjectIdentifiers.md4);
        oidMap.put("MD5", PKCSObjectIdentifiers.md5);
    }
}

