/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPair;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPairGenerator;
import xjyb.org.bjca.crypto.KeyGenerationParameters;
import xjyb.org.bjca.crypto.params.ECDomainParameters;
import xjyb.org.bjca.crypto.params.ECKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.ECPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ECPublicKeyParameters;
import xjyb.org.bjca.math.ec.ECConstants;
import xjyb.org.bjca.math.ec.ECPoint;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        while ((d = new BigInteger(nBitLength, this.random)).equals(ZERO) || d.compareTo(n) >= 0) {
        }
        ECPoint Q = this.params.getG().multiply(d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }
}

