/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.security.SuperEngine;
import xjyb.cn.org.bjca.utils.FileUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.x509.CertificateList;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.provider.X509CRLObject;

public class CRLThread
extends Thread {
    private static long beforeTime;

    @Override
    public void run() {
        LoggerUtil.systemlog("all", "CRL Thread start!");
        FileUtil fileU = new FileUtil("all");
        String path = GetPathUtil.getConfigPath();
        while (true) {
            long time = 0L;
            try {
                int i;
                File allFile = new File(path + "/Trust/crl");
                String[] strList = allFile.list();
                int len = 0;
                if (strList != null) {
                    len = strList.length;
                }
                for (i = 0; i < len; ++i) {
                    String file = strList[i];
                    if (file.indexOf(".crl") == -1) continue;
                    File singleFile = new File(path + "/Trust/crl/" + file);
                    time += singleFile.lastModified();
                }
                if (time != beforeTime) {
                    for (i = 0; i < len; ++i) {
                        String fileName = strList[i];
                        LoggerUtil.systemlog("all", "all file name == " + fileName);
                        int caPos = fileName.indexOf(".crl");
                        if (caPos == -1) continue;
                        try {
                            int crlAuthorityKeyIdentifierLen;
                            X509Name crlX509Name = null;
                            LoggerUtil.systemlog("all", "CRL name == " + fileName);
                            String singleFilePath = path + "/Trust/crl/" + fileName;
                            byte[] crlByte = fileU.readFile(singleFilePath);
                            ByteArrayInputStream bIn = new ByteArrayInputStream(crlByte);
                            ASN1InputStream aIn = new ASN1InputStream(bIn);
                            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                            CertificateList certList = new CertificateList(seq);
                            crlX509Name = certList.getIssuer();
                            Object crlMapKey = crlX509Name;
                            String crlAuthorityKeyIdentifier = certList.getTBSCertList().getExtensions().getExtension(X509Extensions.AuthorityKeyIdentifier).getValue().toString();
                            int n = crlAuthorityKeyIdentifierLen = crlAuthorityKeyIdentifier == null ? 0 : crlAuthorityKeyIdentifier.length();
                            if (crlAuthorityKeyIdentifierLen > 9) {
                                crlMapKey = crlX509Name + crlAuthorityKeyIdentifier.substring(9);
                            }
                            X509CRLObject crlObj = new X509CRLObject(certList);
                            Set crlSet = crlObj.getRevokedCertificates();
                            TreeSet<String> crlTreeSet = new TreeSet<String>();
                            if (crlSet != null && crlSet.size() != 0) {
                                for (X509CRLEntry tEntry : crlSet) {
                                    String revokeCertSn = tEntry.getSerialNumber().toString(16);
                                    crlTreeSet.add(revokeCertSn);
                                }
                            }
                            Hashtable crlTable = SuperEngine.listCrl;
                            crlTable.put(crlMapKey, certList);
                            Hashtable crlSnTable = SuperEngine.listCrlSn;
                            crlSnTable.put(crlMapKey, crlTreeSet);
                            continue;
                        }
                        catch (Exception e) {
                            LoggerUtil.errorlog("all", fileName + "  error !", e);
                            LoggerUtil.systemlog("all", fileName + "  error !");
                        }
                    }
                    beforeTime = time;
                    LoggerUtil.systemlog("all", "CRL files need update !");
                    Hashtable secTable = SuperEngine.listApp;
                    Collection sedCol = secTable.values();
                    for (SuperEngine sedObject : sedCol) {
                        sedObject.verifyCRL();
                    }
                }
                Thread.sleep(1800000L);
                continue;
            }
            catch (Exception e) {
                beforeTime = time;
                LoggerUtil.errorlog("all", "CRL thread error !", e);
                LoggerUtil.systemlog("all", "CRL thread error !");
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    LoggerUtil.errorlog("all", "CRL thread sleep error !", e);
                    LoggerUtil.systemlog("all", "CRL thread sleep error !");
                    continue;
                }
            }
            break;
        }
    }

    public void initCRL(String[] fileList) {
    }
}

