/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.math.BigInteger;
import java.util.Random;
import sun.misc.BASE64Encoder;
import xjyb.cn.org.bjca.constants.SecretConst;
import xjyb.cn.org.bjca.exception.SecretSegmentException;

public class SecretShare {
    private int m = 0;
    private int n = 0;
    private BigInteger big = null;

    private void init(int m, int n) throws SecretSegmentException {
        if (m > n || n > 7) {
            throw new SecretSegmentException(SecretSegmentException.PARAMETER_ERROR);
        }
        byte[] bbig = new byte[]{-34, -68, 85, 31, 81, -20, -111, -84, -91, 106, 55, -57, -81, 96, 120, 53};
        this.big = new BigInteger(1, bbig);
        this.m = m;
        this.n = n;
    }

    public byte[][] split(int m, int n) throws SecretSegmentException {
        this.init(m, n);
        byte[][] rs = new byte[n][];
        BigInteger a1 = null;
        BigInteger a2 = null;
        BigInteger a3 = null;
        BigInteger a4 = null;
        BigInteger a5 = null;
        BigInteger a6 = null;
        BigInteger a7 = null;
        BigInteger pt = null;
        byte[] ba1 = new byte[16];
        byte[] ba2 = new byte[16];
        byte[] ba3 = new byte[16];
        byte[] ba4 = new byte[16];
        byte[] ba5 = new byte[16];
        byte[] ba6 = new byte[16];
        byte[] ba7 = new byte[16];
        Random rand = new Random();
        while (true) {
            rand.nextBytes(ba1);
            a1 = new BigInteger(1, ba1);
            if (this.big.compareTo(a1) > 0) break;
            a1 = null;
        }
        while (true) {
            rand.nextBytes(ba2);
            a2 = new BigInteger(1, ba2);
            if (this.big.compareTo(a2) > 0) break;
            a2 = null;
        }
        while (true) {
            rand.nextBytes(ba3);
            a3 = new BigInteger(1, ba3);
            if (this.big.compareTo(a3) > 0) break;
            a3 = null;
        }
        while (true) {
            rand.nextBytes(ba4);
            a4 = new BigInteger(1, ba4);
            if (this.big.compareTo(a4) > 0) break;
            a4 = null;
        }
        while (true) {
            rand.nextBytes(ba5);
            a5 = new BigInteger(1, ba5);
            if (this.big.compareTo(a5) > 0) break;
            a5 = null;
        }
        while (true) {
            rand.nextBytes(ba6);
            a6 = new BigInteger(1, ba6);
            if (this.big.compareTo(a6) > 0) break;
            a6 = null;
        }
        while (true) {
            rand.nextBytes(ba7);
            a7 = new BigInteger(1, ba7);
            System.out.println("a7 = " + a7);
            if (this.big.compareTo(a7) > 0 && ba7[0] != 0) break;
            a7 = null;
        }
        block16: for (int i = 0; i < n; ++i) {
            switch (m) {
                case 1: {
                    BigInteger temp = new BigInteger(1, ba7);
                    temp = temp.mod(this.big);
                    rs[i] = temp.toByteArray();
                    continue block16;
                }
                case 2: {
                    pt = BigInteger.valueOf(SecretConst.seven_two[i][1]);
                    BigInteger p = a1.multiply(pt);
                    BigInteger temp = a7.add(p);
                    temp = temp.mod(this.big);
                    rs[i] = temp.toByteArray();
                    continue block16;
                }
                case 3: {
                    pt = BigInteger.valueOf(SecretConst.seven_three[i][1]);
                    BigInteger p = a1.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_three[i][2]);
                    BigInteger q = a2.multiply(pt);
                    p = q.add(p);
                    BigInteger temp = a7.add(p);
                    temp = temp.mod(this.big);
                    rs[i] = temp.toByteArray();
                    continue block16;
                }
                case 4: {
                    pt = BigInteger.valueOf(SecretConst.seven_four[i][1]);
                    BigInteger p = a1.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_four[i][2]);
                    BigInteger q = a2.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_four[i][3]);
                    BigInteger r = a3.multiply(pt);
                    p = q.add(p);
                    p = r.add(p);
                    BigInteger temp = a7.add(p);
                    temp = temp.mod(this.big);
                    rs[i] = temp.toByteArray();
                    continue block16;
                }
                case 5: {
                    pt = BigInteger.valueOf(SecretConst.seven_five[i][1]);
                    BigInteger p = a1.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_five[i][2]);
                    BigInteger q = a2.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_five[i][3]);
                    BigInteger r = a3.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_five[i][4]);
                    BigInteger s = a4.multiply(pt);
                    p = q.add(p);
                    p = r.add(p);
                    p = s.add(p);
                    BigInteger temp = a7.add(p);
                    temp = temp.mod(this.big);
                    rs[i] = temp.toByteArray();
                    continue block16;
                }
                case 6: {
                    pt = BigInteger.valueOf(SecretConst.seven_six[i][1]);
                    BigInteger p = a1.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_six[i][2]);
                    BigInteger q = a2.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_six[i][3]);
                    BigInteger r = a3.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_six[i][4]);
                    BigInteger s = a4.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_six[i][5]);
                    BigInteger t = a5.multiply(pt);
                    p = q.add(p);
                    p = r.add(p);
                    p = s.add(p);
                    p = t.add(p);
                    BigInteger temp = a7.add(p);
                    temp = temp.mod(this.big);
                    rs[i] = temp.toByteArray();
                    continue block16;
                }
                case 7: {
                    pt = BigInteger.valueOf(SecretConst.seven_seven[i][1]);
                    BigInteger p = a1.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_seven[i][2]);
                    BigInteger q = a2.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_seven[i][3]);
                    BigInteger r = a3.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_seven[i][4]);
                    BigInteger s = a4.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_seven[i][5]);
                    BigInteger t = a5.multiply(pt);
                    pt = BigInteger.valueOf(SecretConst.seven_seven[i][6]);
                    BigInteger u = a6.multiply(pt);
                    p = q.add(p);
                    p = r.add(p);
                    p = s.add(p);
                    p = t.add(p);
                    p = u.add(p);
                    BigInteger temp = a7.add(p);
                    temp = temp.mod(this.big);
                    rs[i] = temp.toByteArray();
                    continue block16;
                }
            }
        }
        return rs;
    }

    public byte[] pasteKey(int m, int n, byte[][] pPart) throws SecretSegmentException {
        this.init(m, n);
        int k = 0;
        for (int i = 0; i < this.n && (pPart[i] == null || ++k != this.m); ++i) {
        }
        if (k != m) {
            throw new SecretSegmentException(SecretSegmentException.YINZI_NOTENOUGH);
        }
        switch (m) {
            case 1: {
                return this.pasteKey_1(pPart);
            }
            case 2: {
                return this.pasteKey_2(pPart);
            }
            case 3: {
                return this.pasteKey_3(pPart);
            }
            case 4: {
                return this.pasteKey_4(pPart);
            }
            case 5: {
                return this.pasteKey_5(pPart);
            }
            case 6: {
                return this.pasteKey_6(pPart);
            }
            case 7: {
                return this.pasteKey_7(pPart);
            }
        }
        throw new SecretSegmentException(SecretSegmentException.PARAMETER_ERROR);
    }

    private byte[] pasteKey_1(byte[][] pPart) {
        BigInteger k_1 = new BigInteger(1, pPart[0]);
        return k_1.toByteArray();
    }

    private byte[] pasteKey_2(byte[][] pPart) {
        int[] man = new int[this.m];
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            if (pPart[i] == null) continue;
            man[k] = i;
            if (++k == this.m) break;
        }
        BigInteger k_1 = new BigInteger(1, pPart[man[0]]);
        BigInteger k_2 = new BigInteger(1, pPart[man[1]]);
        long[][] two = new long[2][2];
        two[0][0] = SecretConst.seven_two[man[0]][0];
        two[0][1] = SecretConst.seven_two[man[0]][1];
        two[1][0] = SecretConst.seven_two[man[1]][0];
        two[1][1] = SecretConst.seven_two[man[1]][1];
        long result = 0L;
        result = this.r_2(two);
        BigInteger pt = BigInteger.valueOf(SecretConst.seven_two[man[1]][1]);
        BigInteger p = k_1.multiply(pt);
        pt = null;
        pt = BigInteger.valueOf(SecretConst.seven_two[man[0]][1]);
        BigInteger q = k_2.multiply(pt);
        pt = null;
        q = result < 0L ? q.subtract(p) : p.subtract(q);
        if (q.signum() == -1) {
            while ((q = q.add(this.big)).signum() == -1) {
            }
        }
        if (q.compareTo(this.big) > 0) {
            while ((q = q.subtract(this.big)).compareTo(this.big) >= 0) {
            }
        }
        BigInteger r = null;
        if (result > 0L) {
            int i = 0;
            while ((long)i < result) {
                pt = BigInteger.valueOf(result);
                BigInteger[] re = q.divideAndRemainder(pt);
                p = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.valueOf(0L)) != 0) {
                    q = q.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            q = this.big.subtract(q);
            int i = 0;
            while ((long)i < -result) {
                pt = BigInteger.valueOf(-result);
                BigInteger[] re = q.divideAndRemainder(pt);
                p = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.ZERO) != 0) {
                    q = q.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return p.toByteArray();
    }

    private long r_2(long[][] two) {
        return two[0][0] * two[1][1] - two[1][0] * two[0][1];
    }

    private long r_3(long[][] a) {
        return a[0][0] * a[1][1] * a[2][2] + a[1][0] * a[2][1] * a[0][2] + a[0][1] * a[1][2] * a[2][0] - a[2][0] * a[1][1] * a[0][2] - a[2][1] * a[1][2] * a[0][0] - a[0][1] * a[1][0] * a[2][2];
    }

    private long r_4(long[][] a) {
        long result = 0L;
        long[][] p = new long[3][3];
        long[][] q = new long[3][3];
        long[][] r = new long[3][3];
        long[][] s = new long[3][3];
        p[0][0] = a[1][1];
        p[0][1] = a[1][2];
        p[0][2] = a[1][3];
        p[1][0] = a[2][1];
        p[1][1] = a[2][2];
        p[1][2] = a[2][3];
        p[2][0] = a[3][1];
        p[2][1] = a[3][2];
        p[2][2] = a[3][3];
        q[0][0] = a[0][1];
        q[0][1] = a[0][2];
        q[0][2] = a[0][3];
        q[1][0] = a[2][1];
        q[1][1] = a[2][2];
        q[1][2] = a[2][3];
        q[2][0] = a[3][1];
        q[2][1] = a[3][2];
        q[2][2] = a[3][3];
        r[0][0] = a[0][1];
        r[0][1] = a[0][2];
        r[0][2] = a[0][3];
        r[1][0] = a[1][1];
        r[1][1] = a[1][2];
        r[1][2] = a[1][3];
        r[2][0] = a[3][1];
        r[2][1] = a[3][2];
        r[2][2] = a[3][3];
        s[0][0] = a[0][1];
        s[0][1] = a[0][2];
        s[0][2] = a[0][3];
        s[1][0] = a[1][1];
        s[1][1] = a[1][2];
        s[1][2] = a[1][3];
        s[2][0] = a[2][1];
        s[2][1] = a[2][2];
        s[2][2] = a[2][3];
        result = a[0][0] * this.r_3(p) - a[1][0] * this.r_3(q) + a[2][0] * this.r_3(r) - a[3][0] * this.r_3(s);
        return result;
    }

    private long r_5(long[][] a) {
        long result = 0L;
        long[][] t = new long[4][4];
        long[][] p = new long[4][4];
        long[][] q = new long[4][4];
        long[][] r = new long[4][4];
        long[][] s = new long[4][4];
        p[0][0] = a[1][1];
        p[0][1] = a[1][2];
        p[0][2] = a[1][3];
        p[0][3] = a[1][4];
        p[1][0] = a[2][1];
        p[1][1] = a[2][2];
        p[1][2] = a[2][3];
        p[1][3] = a[2][4];
        p[2][0] = a[3][1];
        p[2][1] = a[3][2];
        p[2][2] = a[3][3];
        p[2][3] = a[3][4];
        p[3][0] = a[4][1];
        p[3][1] = a[4][2];
        p[3][2] = a[4][3];
        p[3][3] = a[4][4];
        q[0][0] = a[0][1];
        q[0][1] = a[0][2];
        q[0][2] = a[0][3];
        q[0][3] = a[0][4];
        q[1][0] = a[2][1];
        q[1][1] = a[2][2];
        q[1][2] = a[2][3];
        q[1][3] = a[2][4];
        q[2][0] = a[3][1];
        q[2][1] = a[3][2];
        q[2][2] = a[3][3];
        q[2][3] = a[3][4];
        q[3][0] = a[4][1];
        q[3][1] = a[4][2];
        q[3][2] = a[4][3];
        q[3][3] = a[4][4];
        r[0][0] = a[0][1];
        r[0][1] = a[0][2];
        r[0][2] = a[0][3];
        r[0][3] = a[0][4];
        r[1][0] = a[1][1];
        r[1][1] = a[1][2];
        r[1][2] = a[1][3];
        r[1][3] = a[1][4];
        r[2][0] = a[3][1];
        r[2][1] = a[3][2];
        r[2][2] = a[3][3];
        r[2][3] = a[3][4];
        r[3][0] = a[4][1];
        r[3][1] = a[4][2];
        r[3][2] = a[4][3];
        r[3][3] = a[4][4];
        s[0][0] = a[0][1];
        s[0][1] = a[0][2];
        s[0][2] = a[0][3];
        s[0][3] = a[0][4];
        s[1][0] = a[1][1];
        s[1][1] = a[1][2];
        s[1][2] = a[1][3];
        s[1][3] = a[1][4];
        s[2][0] = a[2][1];
        s[2][1] = a[2][2];
        s[2][2] = a[2][3];
        s[2][3] = a[2][4];
        s[3][0] = a[4][1];
        s[3][1] = a[4][2];
        s[3][2] = a[4][3];
        s[3][3] = a[4][4];
        t[0][0] = a[0][1];
        t[0][1] = a[0][2];
        t[0][2] = a[0][3];
        t[0][3] = a[0][4];
        t[1][0] = a[1][1];
        t[1][1] = a[1][2];
        t[1][2] = a[1][3];
        t[1][3] = a[1][4];
        t[2][0] = a[2][1];
        t[2][1] = a[2][2];
        t[2][2] = a[2][3];
        t[2][3] = a[2][4];
        t[3][0] = a[3][1];
        t[3][1] = a[3][2];
        t[3][2] = a[3][3];
        t[3][3] = a[3][4];
        result = a[0][0] * this.r_4(p) - a[1][0] * this.r_4(q) + a[2][0] * this.r_4(r) - a[3][0] * this.r_4(s) + a[4][0] * this.r_4(t);
        return result;
    }

    private long r_6(long[][] a) {
        long result = 0L;
        long[][] u = new long[5][5];
        long[][] t = new long[5][5];
        long[][] p = new long[5][5];
        long[][] q = new long[5][5];
        long[][] r = new long[5][5];
        long[][] s = new long[5][5];
        p[0][0] = a[1][1];
        p[0][1] = a[1][2];
        p[0][2] = a[1][3];
        p[0][3] = a[1][4];
        p[0][4] = a[1][5];
        p[1][0] = a[2][1];
        p[1][1] = a[2][2];
        p[1][2] = a[2][3];
        p[1][3] = a[2][4];
        p[1][4] = a[2][5];
        p[2][0] = a[3][1];
        p[2][1] = a[3][2];
        p[2][2] = a[3][3];
        p[2][3] = a[3][4];
        p[2][4] = a[3][5];
        p[3][0] = a[4][1];
        p[3][1] = a[4][2];
        p[3][2] = a[4][3];
        p[3][3] = a[4][4];
        p[3][4] = a[4][5];
        p[4][0] = a[5][1];
        p[4][1] = a[5][2];
        p[4][2] = a[5][3];
        p[4][3] = a[5][4];
        p[4][4] = a[5][5];
        q[0][0] = a[0][1];
        q[0][1] = a[0][2];
        q[0][2] = a[0][3];
        q[0][3] = a[0][4];
        q[0][4] = a[0][5];
        q[1][0] = a[2][1];
        q[1][1] = a[2][2];
        q[1][2] = a[2][3];
        q[1][3] = a[2][4];
        q[1][4] = a[2][5];
        q[2][0] = a[3][1];
        q[2][1] = a[3][2];
        q[2][2] = a[3][3];
        q[2][3] = a[3][4];
        q[2][4] = a[3][5];
        q[3][0] = a[4][1];
        q[3][1] = a[4][2];
        q[3][2] = a[4][3];
        q[3][3] = a[4][4];
        q[3][4] = a[4][5];
        q[4][0] = a[5][1];
        q[4][1] = a[5][2];
        q[4][2] = a[5][3];
        q[4][3] = a[5][4];
        q[4][4] = a[5][5];
        r[0][0] = a[0][1];
        r[0][1] = a[0][2];
        r[0][2] = a[0][3];
        r[0][3] = a[0][4];
        r[0][4] = a[0][5];
        r[1][0] = a[1][1];
        r[1][1] = a[1][2];
        r[1][2] = a[1][3];
        r[1][3] = a[1][4];
        r[1][4] = a[1][5];
        r[2][0] = a[3][1];
        r[2][1] = a[3][2];
        r[2][2] = a[3][3];
        r[2][3] = a[3][4];
        r[2][4] = a[3][5];
        r[3][0] = a[4][1];
        r[3][1] = a[4][2];
        r[3][2] = a[4][3];
        r[3][3] = a[4][4];
        r[3][4] = a[4][5];
        r[4][0] = a[5][1];
        r[4][1] = a[5][2];
        r[4][2] = a[5][3];
        r[4][3] = a[5][4];
        r[4][4] = a[5][5];
        s[0][0] = a[0][1];
        s[0][1] = a[0][2];
        s[0][2] = a[0][3];
        s[0][3] = a[0][4];
        s[0][4] = a[0][5];
        s[1][0] = a[1][1];
        s[1][1] = a[1][2];
        s[1][2] = a[1][3];
        s[1][3] = a[1][4];
        s[1][4] = a[1][5];
        s[2][0] = a[2][1];
        s[2][1] = a[2][2];
        s[2][2] = a[2][3];
        s[2][3] = a[2][4];
        s[2][4] = a[2][5];
        s[3][0] = a[4][1];
        s[3][1] = a[4][2];
        s[3][2] = a[4][3];
        s[3][3] = a[4][4];
        s[3][4] = a[4][5];
        s[4][0] = a[5][1];
        s[4][1] = a[5][2];
        s[4][2] = a[5][3];
        s[4][3] = a[5][4];
        s[4][4] = a[5][5];
        t[0][0] = a[0][1];
        t[0][1] = a[0][2];
        t[0][2] = a[0][3];
        t[0][3] = a[0][4];
        t[0][4] = a[0][5];
        t[1][0] = a[1][1];
        t[1][1] = a[1][2];
        t[1][2] = a[1][3];
        t[1][3] = a[1][4];
        t[1][4] = a[1][5];
        t[2][0] = a[2][1];
        t[2][1] = a[2][2];
        t[2][2] = a[2][3];
        t[2][3] = a[2][4];
        t[2][4] = a[2][5];
        t[3][0] = a[3][1];
        t[3][1] = a[3][2];
        t[3][2] = a[3][3];
        t[3][3] = a[3][4];
        t[3][4] = a[3][5];
        t[4][0] = a[5][1];
        t[4][1] = a[5][2];
        t[4][2] = a[5][3];
        t[4][3] = a[5][4];
        t[4][4] = a[5][5];
        u[0][0] = a[0][1];
        u[0][1] = a[0][2];
        u[0][2] = a[0][3];
        u[0][3] = a[0][4];
        u[0][4] = a[0][5];
        u[1][0] = a[1][1];
        u[1][1] = a[1][2];
        u[1][2] = a[1][3];
        u[1][3] = a[1][4];
        u[1][4] = a[1][5];
        u[2][0] = a[2][1];
        u[2][1] = a[2][2];
        u[2][2] = a[2][3];
        u[2][3] = a[2][4];
        u[2][4] = a[2][5];
        u[3][0] = a[3][1];
        u[3][1] = a[3][2];
        u[3][2] = a[3][3];
        u[3][3] = a[3][4];
        u[3][4] = a[3][5];
        u[4][0] = a[4][1];
        u[4][1] = a[4][2];
        u[4][2] = a[4][3];
        u[4][3] = a[4][4];
        u[4][4] = a[4][5];
        result = a[0][0] * this.r_5(p) - a[1][0] * this.r_5(q) + a[2][0] * this.r_5(r) - a[3][0] * this.r_5(s) + a[4][0] * this.r_5(t) - a[5][0] * this.r_5(u);
        return result;
    }

    private long r_7(long[][] a) {
        int i = 0;
        long[][] six_7 = new long[6][6];
        long[][] six_1 = new long[6][6];
        long[][] six_2 = new long[6][6];
        long[][] six_3 = new long[6][6];
        long[][] six_4 = new long[6][6];
        long[][] six_5 = new long[6][6];
        long[][] six_6 = new long[6][6];
        for (i = 0; i < 6; ++i) {
            six_1[0][i] = SecretConst.seven_seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[1][i] = SecretConst.seven_seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[2][i] = SecretConst.seven_seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[3][i] = SecretConst.seven_seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[4][i] = SecretConst.seven_seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[5][i] = SecretConst.seven_seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[0][i] = SecretConst.seven_seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[1][i] = SecretConst.seven_seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[2][i] = SecretConst.seven_seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[3][i] = SecretConst.seven_seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[4][i] = SecretConst.seven_seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[5][i] = SecretConst.seven_seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[0][i] = SecretConst.seven_seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[1][i] = SecretConst.seven_seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[2][i] = SecretConst.seven_seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[3][i] = SecretConst.seven_seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[4][i] = SecretConst.seven_seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[5][i] = SecretConst.seven_seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[0][i] = SecretConst.seven_seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[1][i] = SecretConst.seven_seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[2][i] = SecretConst.seven_seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[3][i] = SecretConst.seven_seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[4][i] = SecretConst.seven_seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[5][i] = SecretConst.seven_seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[0][i] = SecretConst.seven_seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[1][i] = SecretConst.seven_seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[2][i] = SecretConst.seven_seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[3][i] = SecretConst.seven_seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[4][i] = SecretConst.seven_seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[5][i] = SecretConst.seven_seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[0][i] = SecretConst.seven_seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[1][i] = SecretConst.seven_seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[2][i] = SecretConst.seven_seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[3][i] = SecretConst.seven_seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[4][i] = SecretConst.seven_seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[5][i] = SecretConst.seven_seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[0][i] = SecretConst.seven_seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[1][i] = SecretConst.seven_seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[2][i] = SecretConst.seven_seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[3][i] = SecretConst.seven_seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[4][i] = SecretConst.seven_seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[5][i] = SecretConst.seven_seven[5][i + 1];
        }
        long result = SecretConst.seven_seven[0][0] * this.r_6(six_1) - SecretConst.seven_seven[1][0] * this.r_6(six_2) + SecretConst.seven_seven[2][0] * this.r_6(six_3) - SecretConst.seven_seven[3][0] * this.r_6(six_4) + SecretConst.seven_seven[4][0] * this.r_6(six_5) - SecretConst.seven_seven[5][0] * this.r_6(six_6) + SecretConst.seven_seven[6][0] * this.r_6(six_7);
        return result;
    }

    private byte[] pasteKey_3(byte[][] pPart) {
        int[] man = new int[this.m];
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            if (pPart[i] == null) continue;
            man[k] = i;
            if (++k == this.m) break;
        }
        BigInteger k_1 = new BigInteger(1, pPart[man[0]]);
        BigInteger k_2 = new BigInteger(1, pPart[man[1]]);
        BigInteger k_3 = new BigInteger(1, pPart[man[2]]);
        long[][] three = new long[3][3];
        long[][] two_1 = new long[2][2];
        long[][] two_2 = new long[2][2];
        long[][] two_3 = new long[2][2];
        int i = 0;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                three[i][j] = SecretConst.seven_three[man[i]][j];
            }
        }
        for (i = 0; i < 2; ++i) {
            two_1[0][i] = three[1][i + 1];
        }
        for (i = 0; i < 2; ++i) {
            two_1[1][i] = three[2][i + 1];
        }
        for (i = 0; i < 2; ++i) {
            two_2[0][i] = three[0][i + 1];
        }
        for (i = 0; i < 2; ++i) {
            two_2[1][i] = three[2][i + 1];
        }
        for (i = 0; i < 2; ++i) {
            two_3[0][i] = three[0][i + 1];
        }
        for (i = 0; i < 2; ++i) {
            two_3[1][i] = three[1][i + 1];
        }
        long result = 0L;
        result = this.r_3(three);
        BigInteger p = null;
        BigInteger q = null;
        BigInteger r = null;
        BigInteger pt = null;
        if (this.r_2(two_1) < 0L) {
            pt = BigInteger.valueOf(-this.r_2(two_1));
            p = k_1.multiply(pt);
            pt = BigInteger.valueOf(0L);
            p = pt.subtract(p);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_2(two_1));
            p = k_1.multiply(pt);
            pt = null;
        }
        if (this.r_2(two_2) < 0L) {
            pt = BigInteger.valueOf(-this.r_2(two_2));
            q = k_2.multiply(pt);
            pt = BigInteger.valueOf(0L);
            q = pt.subtract(q);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_2(two_2));
            q = k_2.multiply(pt);
            pt = null;
        }
        if (this.r_2(two_3) < 0L) {
            pt = BigInteger.valueOf(-this.r_2(two_3));
            r = k_3.multiply(pt);
            pt = BigInteger.valueOf(0L);
            r = pt.subtract(r);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_2(two_3));
            r = k_3.multiply(pt);
            pt = null;
        }
        p = p.subtract(q);
        p = p.add(r);
        if (p.signum() == -1) {
            while ((p = p.add(this.big)).signum() == -1) {
            }
        }
        if (p.compareTo(this.big) > 0) {
            while ((p = p.subtract(this.big)).compareTo(this.big) >= 0) {
            }
        }
        if (result > 0L) {
            i = 0;
            while ((long)i < result) {
                pt = BigInteger.valueOf(result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.valueOf(0L)) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            p = this.big.subtract(p);
            i = 0;
            while ((long)i < -result) {
                pt = BigInteger.valueOf(-result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.ZERO) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return q.toByteArray();
    }

    private byte[] pasteKey_4(byte[][] pPart) {
        int[] man = new int[this.m];
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            if (pPart[i] == null) continue;
            man[k] = i;
            if (++k == this.m) break;
        }
        BigInteger k_1 = new BigInteger(1, pPart[man[0]]);
        BigInteger k_2 = new BigInteger(1, pPart[man[1]]);
        BigInteger k_3 = new BigInteger(1, pPart[man[2]]);
        BigInteger k_4 = new BigInteger(1, pPart[man[3]]);
        long[][] four = new long[4][4];
        long[][] three_1 = new long[3][3];
        long[][] three_2 = new long[3][3];
        long[][] three_3 = new long[3][3];
        long[][] three_4 = new long[3][3];
        int i = 0;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                four[i][j] = SecretConst.seven_four[man[i]][j];
            }
        }
        for (i = 0; i < 3; ++i) {
            three_1[0][i] = four[1][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_1[1][i] = four[2][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_1[2][i] = four[3][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_2[0][i] = four[0][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_2[1][i] = four[2][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_2[2][i] = four[3][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_3[0][i] = four[0][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_3[1][i] = four[1][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_3[2][i] = four[3][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_4[0][i] = four[0][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_4[1][i] = four[1][i + 1];
        }
        for (i = 0; i < 3; ++i) {
            three_4[2][i] = four[2][i + 1];
        }
        long result = 0L;
        result = this.r_4(four);
        BigInteger p = null;
        BigInteger q = null;
        BigInteger r = null;
        BigInteger s = null;
        BigInteger pt = null;
        if (this.r_3(three_1) < 0L) {
            pt = BigInteger.valueOf(-this.r_3(three_1));
            p = k_1.multiply(pt);
            pt = BigInteger.valueOf(0L);
            p = pt.subtract(p);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_3(three_1));
            p = k_1.multiply(pt);
            pt = null;
        }
        if (this.r_3(three_2) < 0L) {
            pt = BigInteger.valueOf(-this.r_3(three_2));
            q = k_2.multiply(pt);
            pt = BigInteger.valueOf(0L);
            q = pt.subtract(q);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_3(three_2));
            q = k_2.multiply(pt);
            pt = null;
        }
        if (this.r_3(three_3) < 0L) {
            pt = BigInteger.valueOf(-this.r_3(three_3));
            r = k_3.multiply(pt);
            pt = BigInteger.valueOf(0L);
            r = pt.subtract(r);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_3(three_3));
            r = k_3.multiply(pt);
            pt = null;
        }
        if (this.r_3(three_4) < 0L) {
            pt = BigInteger.valueOf(-this.r_3(three_4));
            s = k_4.multiply(pt);
            pt = BigInteger.valueOf(0L);
            s = pt.subtract(s);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_3(three_4));
            s = k_4.multiply(pt);
            pt = null;
        }
        p = p.subtract(q);
        p = p.add(r);
        p = p.subtract(s);
        if (p.signum() == -1) {
            while ((p = p.add(this.big)).signum() == -1) {
            }
        }
        if (p.compareTo(this.big) > 0) {
            while ((p = p.subtract(this.big)).compareTo(this.big) >= 0) {
            }
        }
        if (result > 0L) {
            i = 0;
            while ((long)i < result) {
                pt = BigInteger.valueOf(result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.valueOf(0L)) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            p = this.big.subtract(p);
            i = 0;
            while ((long)i < -result) {
                pt = BigInteger.valueOf(-result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.ZERO) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return q.toByteArray();
    }

    private byte[] pasteKey_5(byte[][] pPart) {
        int[] man = new int[this.m];
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            if (pPart[i] == null) continue;
            man[k] = i;
            if (++k == this.m) break;
        }
        BigInteger k_1 = new BigInteger(1, pPart[man[0]]);
        BigInteger k_2 = new BigInteger(1, pPart[man[1]]);
        BigInteger k_3 = new BigInteger(1, pPart[man[2]]);
        BigInteger k_4 = new BigInteger(1, pPart[man[3]]);
        BigInteger k_5 = new BigInteger(1, pPart[man[4]]);
        long[][] five = new long[5][5];
        long[][] four_1 = new long[4][4];
        long[][] four_2 = new long[4][4];
        long[][] four_3 = new long[4][4];
        long[][] four_4 = new long[4][4];
        long[][] four_5 = new long[4][4];
        int i = 0;
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                five[i][j] = SecretConst.seven_five[man[i]][j];
            }
        }
        for (i = 0; i < 4; ++i) {
            four_1[0][i] = five[1][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_1[1][i] = five[2][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_1[2][i] = five[3][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_1[3][i] = five[4][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_2[0][i] = five[0][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_2[1][i] = five[2][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_2[2][i] = five[3][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_2[3][i] = five[4][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_3[0][i] = five[0][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_3[1][i] = five[1][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_3[2][i] = five[3][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_3[3][i] = five[4][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_4[0][i] = five[0][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_4[1][i] = five[1][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_4[2][i] = five[2][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_4[3][i] = five[4][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_5[0][i] = five[0][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_5[1][i] = five[1][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_5[2][i] = five[2][i + 1];
        }
        for (i = 0; i < 4; ++i) {
            four_5[3][i] = five[3][i + 1];
        }
        long result = 0L;
        result = this.r_5(five);
        BigInteger p = null;
        BigInteger q = null;
        BigInteger r = null;
        BigInteger s = null;
        BigInteger t = null;
        BigInteger pt = null;
        if (this.r_4(four_1) < 0L) {
            pt = BigInteger.valueOf(-this.r_4(four_1));
            p = k_1.multiply(pt);
            pt = BigInteger.valueOf(0L);
            p = pt.subtract(p);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_4(four_1));
            p = k_1.multiply(pt);
            pt = null;
        }
        if (this.r_4(four_2) < 0L) {
            pt = BigInteger.valueOf(-this.r_4(four_2));
            q = k_2.multiply(pt);
            pt = BigInteger.valueOf(0L);
            q = pt.subtract(q);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_4(four_2));
            q = k_2.multiply(pt);
            pt = null;
        }
        if (this.r_4(four_3) < 0L) {
            pt = BigInteger.valueOf(-this.r_4(four_3));
            r = k_3.multiply(pt);
            pt = BigInteger.valueOf(0L);
            r = pt.subtract(r);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_4(four_3));
            r = k_3.multiply(pt);
            pt = null;
        }
        if (this.r_4(four_4) < 0L) {
            pt = BigInteger.valueOf(-this.r_4(four_4));
            s = k_4.multiply(pt);
            pt = BigInteger.valueOf(0L);
            s = pt.subtract(s);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_4(four_4));
            s = k_4.multiply(pt);
            pt = null;
        }
        if (this.r_4(four_5) < 0L) {
            pt = BigInteger.valueOf(-this.r_4(four_5));
            t = k_5.multiply(pt);
            pt = BigInteger.valueOf(0L);
            t = pt.subtract(t);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_4(four_5));
            t = k_5.multiply(pt);
            pt = null;
        }
        p = p.subtract(q);
        p = p.add(r);
        p = p.subtract(s);
        p = p.add(t);
        if (p.signum() == -1) {
            while ((p = p.add(this.big)).signum() == -1) {
            }
        }
        if (p.compareTo(this.big) > 0) {
            while ((p = p.subtract(this.big)).compareTo(this.big) >= 0) {
            }
        }
        if (result > 0L) {
            i = 0;
            while ((long)i < result) {
                pt = BigInteger.valueOf(result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.valueOf(0L)) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            p = this.big.subtract(p);
            i = 0;
            while ((long)i < -result) {
                pt = BigInteger.valueOf(-result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.ZERO) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return q.toByteArray();
    }

    private byte[] pasteKey_6(byte[][] pPart) {
        int[] man = new int[this.m];
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            if (pPart[i] == null) continue;
            man[k] = i;
            if (++k == this.m) break;
        }
        BigInteger k_1 = new BigInteger(1, pPart[man[0]]);
        BigInteger k_2 = new BigInteger(1, pPart[man[1]]);
        BigInteger k_3 = new BigInteger(1, pPart[man[2]]);
        BigInteger k_4 = new BigInteger(1, pPart[man[3]]);
        BigInteger k_5 = new BigInteger(1, pPart[man[4]]);
        BigInteger k_6 = new BigInteger(1, pPart[man[5]]);
        long[][] six = new long[6][6];
        long[][] five_1 = new long[5][5];
        long[][] five_2 = new long[5][5];
        long[][] five_3 = new long[5][5];
        long[][] five_4 = new long[5][5];
        long[][] five_5 = new long[5][5];
        long[][] five_6 = new long[5][5];
        int i = 0;
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                six[i][j] = SecretConst.seven_six[man[i]][j];
            }
        }
        for (i = 0; i < 5; ++i) {
            five_1[0][i] = six[1][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_1[1][i] = six[2][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_1[2][i] = six[3][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_1[3][i] = six[4][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_1[4][i] = six[5][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_2[0][i] = six[0][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_2[1][i] = six[2][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_2[2][i] = six[3][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_2[3][i] = six[4][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_2[4][i] = six[5][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_3[0][i] = six[0][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_3[1][i] = six[1][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_3[2][i] = six[3][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_3[3][i] = six[4][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_3[4][i] = six[5][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_4[0][i] = six[0][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_4[1][i] = six[1][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_4[2][i] = six[2][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_4[3][i] = six[4][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_4[4][i] = six[5][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_5[0][i] = six[0][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_5[1][i] = six[1][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_5[2][i] = six[2][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_5[3][i] = six[3][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_5[4][i] = six[5][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_6[0][i] = six[0][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_6[1][i] = six[1][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_6[2][i] = six[2][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_6[3][i] = six[3][i + 1];
        }
        for (i = 0; i < 5; ++i) {
            five_6[4][i] = six[4][i + 1];
        }
        long result = 0L;
        result = this.r_6(six);
        BigInteger p = null;
        BigInteger q = null;
        BigInteger r = null;
        BigInteger s = null;
        BigInteger t = null;
        BigInteger u = null;
        BigInteger pt = null;
        if (this.r_5(five_1) < 0L) {
            pt = BigInteger.valueOf(-this.r_5(five_1));
            p = k_1.multiply(pt);
            pt = BigInteger.valueOf(0L);
            p = pt.subtract(p);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_5(five_1));
            p = k_1.multiply(pt);
            pt = null;
        }
        if (this.r_5(five_2) < 0L) {
            pt = BigInteger.valueOf(-this.r_5(five_2));
            q = k_2.multiply(pt);
            pt = BigInteger.valueOf(0L);
            q = pt.subtract(q);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_5(five_2));
            q = k_2.multiply(pt);
            pt = null;
        }
        if (this.r_5(five_3) < 0L) {
            pt = BigInteger.valueOf(-this.r_5(five_3));
            r = k_3.multiply(pt);
            pt = BigInteger.valueOf(0L);
            r = pt.subtract(r);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_5(five_3));
            r = k_3.multiply(pt);
            pt = null;
        }
        if (this.r_5(five_4) < 0L) {
            pt = BigInteger.valueOf(-this.r_5(five_4));
            s = k_4.multiply(pt);
            pt = BigInteger.valueOf(0L);
            s = pt.subtract(s);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_5(five_4));
            s = k_4.multiply(pt);
            pt = null;
        }
        if (this.r_5(five_5) < 0L) {
            pt = BigInteger.valueOf(-this.r_5(five_5));
            t = k_5.multiply(pt);
            pt = BigInteger.valueOf(0L);
            t = pt.subtract(t);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_5(five_5));
            t = k_5.multiply(pt);
            pt = null;
        }
        if (this.r_5(five_6) < 0L) {
            pt = BigInteger.valueOf(-this.r_5(five_6));
            u = k_6.multiply(pt);
            pt = BigInteger.valueOf(0L);
            u = pt.subtract(u);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_5(five_6));
            u = k_6.multiply(pt);
            pt = null;
        }
        p = p.subtract(q);
        p = p.add(r);
        p = p.subtract(s);
        p = p.add(t);
        p = p.subtract(u);
        if (p.signum() == -1) {
            while ((p = p.add(this.big)).signum() == -1) {
            }
        }
        if (p.compareTo(this.big) > 0) {
            while ((p = p.subtract(this.big)).compareTo(this.big) >= 0) {
            }
        }
        if (result > 0L) {
            i = 0;
            while ((long)i < result) {
                pt = BigInteger.valueOf(result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.valueOf(0L)) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            p = this.big.subtract(p);
            i = 0;
            while ((long)i < -result) {
                pt = BigInteger.valueOf(-result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.ZERO) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return q.toByteArray();
    }

    private byte[] pasteKey_7(byte[][] pPart) {
        int[] man = new int[this.m];
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            if (pPart[i] == null) continue;
            man[k] = i;
            if (++k == this.m) break;
        }
        BigInteger k_1 = new BigInteger(1, pPart[man[0]]);
        BigInteger k_2 = new BigInteger(1, pPart[man[1]]);
        BigInteger k_3 = new BigInteger(1, pPart[man[2]]);
        BigInteger k_4 = new BigInteger(1, pPart[man[3]]);
        BigInteger k_5 = new BigInteger(1, pPart[man[4]]);
        BigInteger k_6 = new BigInteger(1, pPart[man[5]]);
        BigInteger k_7 = new BigInteger(1, pPart[man[6]]);
        long[][] seven = new long[7][7];
        long[][] six_1 = new long[6][6];
        long[][] six_2 = new long[6][6];
        long[][] six_3 = new long[6][6];
        long[][] six_4 = new long[6][6];
        long[][] six_5 = new long[6][6];
        long[][] six_6 = new long[6][6];
        long[][] six_7 = new long[6][6];
        int i = 0;
        for (i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                seven[i][j] = SecretConst.seven_seven[man[i]][j];
            }
        }
        for (i = 0; i < 6; ++i) {
            six_1[0][i] = seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[1][i] = seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[2][i] = seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[3][i] = seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[4][i] = seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_1[5][i] = seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[0][i] = seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[1][i] = seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[2][i] = seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[3][i] = seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[4][i] = seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_2[5][i] = seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[0][i] = seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[1][i] = seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[2][i] = seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[3][i] = seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[4][i] = seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_3[5][i] = seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[0][i] = seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[1][i] = seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[2][i] = seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[3][i] = seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[4][i] = seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_4[5][i] = seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[0][i] = seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[1][i] = seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[2][i] = seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[3][i] = seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[4][i] = seven[5][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_5[5][i] = seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[0][i] = seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[1][i] = seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[2][i] = seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[3][i] = seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[4][i] = seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_6[5][i] = seven[6][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[0][i] = seven[0][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[1][i] = seven[1][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[2][i] = seven[2][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[3][i] = seven[3][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[4][i] = seven[4][i + 1];
        }
        for (i = 0; i < 6; ++i) {
            six_7[5][i] = seven[5][i + 1];
        }
        long result = 0L;
        result = this.r_7(seven);
        BigInteger p = null;
        BigInteger q = null;
        BigInteger r = null;
        BigInteger s = null;
        BigInteger t = null;
        BigInteger u = null;
        BigInteger v = null;
        BigInteger pt = null;
        if (this.r_6(six_1) < 0L) {
            pt = BigInteger.valueOf(-this.r_6(six_1));
            p = k_1.multiply(pt);
            pt = BigInteger.valueOf(0L);
            p = pt.subtract(p);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_6(six_1));
            p = k_1.multiply(pt);
            pt = null;
        }
        if (this.r_6(six_2) < 0L) {
            pt = BigInteger.valueOf(-this.r_6(six_2));
            q = k_2.multiply(pt);
            pt = BigInteger.valueOf(0L);
            q = pt.subtract(q);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_6(six_2));
            q = k_2.multiply(pt);
            pt = null;
        }
        if (this.r_6(six_3) < 0L) {
            pt = BigInteger.valueOf(-this.r_6(six_3));
            r = k_3.multiply(pt);
            pt = BigInteger.valueOf(0L);
            r = pt.subtract(r);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_6(six_3));
            r = k_3.multiply(pt);
            pt = null;
        }
        if (this.r_6(six_4) < 0L) {
            pt = BigInteger.valueOf(-this.r_6(six_4));
            s = k_4.multiply(pt);
            pt = BigInteger.valueOf(0L);
            s = pt.subtract(s);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_6(six_4));
            s = k_4.multiply(pt);
            pt = null;
        }
        if (this.r_6(six_5) < 0L) {
            pt = BigInteger.valueOf(-this.r_6(six_5));
            t = k_5.multiply(pt);
            pt = BigInteger.valueOf(0L);
            t = pt.subtract(t);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_6(six_5));
            t = k_5.multiply(pt);
            pt = null;
        }
        if (this.r_6(six_6) < 0L) {
            pt = BigInteger.valueOf(-this.r_6(six_6));
            u = k_6.multiply(pt);
            pt = BigInteger.valueOf(0L);
            u = pt.subtract(u);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_6(six_6));
            u = k_6.multiply(pt);
            pt = null;
        }
        if (this.r_6(six_7) < 0L) {
            pt = BigInteger.valueOf(-this.r_6(six_7));
            v = k_7.multiply(pt);
            pt = BigInteger.valueOf(0L);
            v = pt.subtract(v);
            pt = null;
        } else {
            pt = BigInteger.valueOf(this.r_6(six_7));
            v = k_7.multiply(pt);
            pt = null;
        }
        p = p.subtract(q);
        p = p.add(r);
        p = p.subtract(s);
        p = p.add(t);
        p = p.subtract(u);
        p = p.add(v);
        if (p.signum() == -1) {
            while ((p = p.add(this.big)).signum() == -1) {
            }
        }
        if (p.compareTo(this.big) > 0) {
            while ((p = p.subtract(this.big)).compareTo(this.big) >= 0) {
            }
        }
        if (result > 0L) {
            i = 0;
            while ((long)i < result) {
                pt = BigInteger.valueOf(result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.valueOf(0L)) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            p = this.big.subtract(p);
            i = 0;
            while ((long)i < -result) {
                pt = BigInteger.valueOf(-result);
                BigInteger[] re = p.divideAndRemainder(pt);
                q = re[0];
                r = re[1];
                pt = null;
                if (r.compareTo(BigInteger.ZERO) != 0) {
                    p = p.add(this.big);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return q.toByteArray();
    }

    public static void main(String[] args) {
        SecretShare cfcasecretshare = new SecretShare();
        int m = 4;
        int n = 7;
        try {
            byte[][] result = cfcasecretshare.split(m, n);
            byte[][] val1 = new byte[5][];
            byte[][] val2 = new byte[7][];
            val1[1] = result[1];
            val1[2] = result[2];
            val1[3] = result[3];
            val1[4] = result[4];
            val2[1] = result[1];
            val2[2] = result[2];
            val2[3] = result[3];
            val2[4] = result[4];
            val2[6] = result[6];
            byte[] key = cfcasecretshare.pasteKey(m, n, val1);
            byte[] key1 = cfcasecretshare.pasteKey(m, n, val2);
            BASE64Encoder base64encoder = new BASE64Encoder();
            System.out.println(new String(base64encoder.encode(key)));
            System.out.println(new String(base64encoder.encode(key1)));
        }
        catch (Exception ex) {
            System.out.println("ex" + ex);
            ex.printStackTrace();
        }
    }
}

