/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.math.BigInteger;
import java.util.Random;
import xjyb.cn.org.bjca.java.utils.AlgUtil;

public class Alg {
    public static final byte[] iv;
    public static int[] Tj;

    Alg() {
    }

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = Alg.convert(V);
        int[] b = Alg.convert(B);
        return Alg.convert(Alg.CF(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < arr.length; i += 4) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = Alg.bigEndianByteToInt(tmp);
        }
        return out;
    }

    private static byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        for (int i = 0; i < arr.length; ++i) {
            tmp = Alg.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
        }
        return out;
    }

    public static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = Alg.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        for (int j = 0; j < 64; ++j) {
            int ss1 = Alg.rotateLeft(a, 12) + e + Alg.rotateLeft(Tj[j], j);
            ss1 = Alg.rotateLeft(ss1, 7);
            int ss2 = ss1 ^ Alg.rotateLeft(a, 12);
            int tt1 = Alg.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = Alg.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = Alg.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Alg.rotateLeft(f, 19);
            f = e;
            e = Alg.P0(tt2);
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(int[] B) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        for (i = 0; i < B.length; ++i) {
            W[i] = B[i];
        }
        for (i = 16; i < 68; ++i) {
            W[i] = Alg.P1(W[i - 16] ^ W[i - 9] ^ Alg.rotateLeft(W[i - 3], 15)) ^ Alg.rotateLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static byte[] bigEndianIntToByte(int num) {
        return Alg.back(AlgUtil.IntToByte(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return AlgUtil.ByteToInt(Alg.back(bytes));
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return Alg.FF1j(X, Y, Z);
        }
        return Alg.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return Alg.GG1j(X, Y, Z);
        }
        return Alg.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private static int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private static int P0(int X) {
        int y = Alg.rotateLeft(X, 9);
        y = Alg.rotateLeft(X, 9);
        int z = Alg.rotateLeft(X, 17);
        z = Alg.rotateLeft(X, 17);
        int t = X ^ y ^ z;
        return t;
    }

    private static int P1(int X) {
        int t = X ^ Alg.rotateLeft(X, 15) ^ Alg.rotateLeft(X, 23);
        return t;
    }

    public static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = Alg.back(AlgUtil.LongToByte(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[out.length - i - 1];
        }
        return out;
    }

    public static int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    public static void main(String[] args) {
        Random r = new Random();
        int x = r.nextInt();
        int n = r.nextInt();
        while (n < 1) {
            n = r.nextInt();
        }
        x = -529020450;
        n = 294715530;
        System.out.println("x = " + x + " , n = " + n + " , n%32 = " + n % 32);
        System.out.println("x = " + Integer.toBinaryString(x));
        int y = Alg.rotateLeft(x, n);
        System.out.println(y);
        y = Alg.rotateLeft(x, n);
        System.out.println("x = " + Integer.toBinaryString(y));
        System.out.println(y);
    }

    public static void print(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            System.out.print(String.valueOf(Integer.toHexString(arr[i])) + " ");
            if ((i + 1) % 16 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    static {
        int i;
        iv = new BigInteger("7380166f4914b2b9172442d7da8a0600a96f30bc163138aae38dee4db0fb0e4e", 16).toByteArray();
        Tj = new int[64];
        for (i = 0; i < 16; ++i) {
            Alg.Tj[i] = 2043430169;
        }
        for (i = 16; i < 64; ++i) {
            Alg.Tj[i] = 2055708042;
        }
    }
}

