/*
 * Decompiled with CFR 0.152.
 */
package test.junit;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Properties;
import junit.framework.TestCase;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.org.bjca.jce.exception.EncryptAlgException;
import xjyb.org.bjca.jce.exception.EncryptDataException;
import xjyb.org.bjca.jce.exception.EncryptKeyException;
import xjyb.org.bjca.jce.exception.WriteEnvDataException;

public class TestSecurityEngineDeal_jni
extends TestCase {
    SecurityEngineDeal secEngineDeal = null;
    Properties properties = new Properties();

    protected void setUp() throws Exception {
        this.properties.load(new FileInputStream("src/test/junit/test_jni.properties"));
        this.secEngineDeal = SecurityEngineDeal.getInstance(this.properties.getProperty("applicationName").trim());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetInstance() {
        System.out.println(this.secEngineDeal.getClass().getName());
        TestSecurityEngineDeal_jni.assertNotNull((Object)this.secEngineDeal);
    }

    public void testGetApplicationName() {
        String applicationName = this.properties.getProperty("applicationName").trim();
        TestSecurityEngineDeal_jni.assertEquals((String)"\u83b7\u5f97\u5e94\u7528\u540d\u51fa\u9519", (String)applicationName, (String)this.secEngineDeal.getApplicationName());
    }

    public void testSetApplicationName() {
        String applicationName = this.properties.getProperty("applicationName");
        this.secEngineDeal.setApplicationName(applicationName);
        TestSecurityEngineDeal_jni.assertEquals((String)"\u8bbe\u7f6e\u5e94\u7528\u540d\u51fa\u9519", (String)applicationName, (String)this.secEngineDeal.getApplicationName());
    }

    public void testSetDebug() {
    }

    public void testSetSignMethod() throws AlgorithmNotFoundException {
        String signMethod = this.properties.getProperty("signMethod");
        this.secEngineDeal.setSignMethod(signMethod);
        TestSecurityEngineDeal_jni.assertEquals((String)"\u8bbe\u7f6e\u7b7e\u540d\u7b97\u6cd5\u51fa\u9519", (String)signMethod, (String)this.secEngineDeal.getSignMethod());
    }

    public void testGetSignMethod() {
        String signMethod = this.properties.getProperty("signMethod");
        TestSecurityEngineDeal_jni.assertEquals((String)"\u83b7\u5f97\u7b7e\u540d\u7b97\u6cd5\u51fa\u9519", (String)signMethod, (String)this.secEngineDeal.getSignMethod());
    }

    public void testGetEncryptMethod() {
        String encryptMethod = this.properties.getProperty("encryptMethod");
        TestSecurityEngineDeal_jni.assertEquals((String)"\u83b7\u5f97\u52a0\u89e3\u5bc6\u7b97\u6cd5\u51fa\u9519", (String)encryptMethod, (String)this.secEngineDeal.getEncryptMethod());
    }

    public void testGetServerCertificate() throws Base64Exception {
        String cert = this.secEngineDeal.getServerCertificate();
        System.out.println("\u5f53\u524d\u5e94\u7528\u7684\u670d\u52a1\u5668\u7684\u7b7e\u540d\u8bc1\u4e66\u4e3a: " + cert);
    }

    public void testGetServerCertificateInt() throws Base64Exception {
        String cert = this.secEngineDeal.getServerCertificate(1);
        System.out.println("\u5f53\u524d\u5e94\u7528\u7684\u670d\u52a1\u5668\u7684\u7b7e\u540d\u8bc1\u4e66\u4e3a: " + cert);
    }

    public void testGenRandom() throws RandomNumberException, Base64Exception {
        String random = this.secEngineDeal.genRandom();
        System.out.println("\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a\uff1a" + random);
    }

    public void testGenRandomInt() throws RandomNumberException, Base64Exception {
        System.out.println("\u4f20\u51650\uff0c\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a: " + this.secEngineDeal.genRandom(0));
        System.out.println("\u4f20\u51651\uff0c\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a: " + this.secEngineDeal.genRandom(1));
        System.out.println("\u4f20\u516513\uff0c\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a: " + this.secEngineDeal.genRandom(13));
    }

    public void testGetCertInfo() throws Base64Exception, GetCertInfoException {
        String[] title = new String[]{"\u8bc1\u4e66\u7248\u672c", "\u8bc1\u4e66\u5e8f\u5217\u53f7", "\u6458\u8981\u7b7e\u540d\u7b97\u6cd5\u540d\u79f0", "\u8bc1\u4e66\u53d1\u653e\u8005\u56fd\u5bb6\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u7ec4\u7ec7\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u90e8\u95e8\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u7701\u5dde\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u901a\u7528\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u57ce\u5e02\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005EMAIL\u5730\u5740", "\u8bc1\u4e66\u6709\u6548\u671f\u8d77\u59cb", "\u8bc1\u4e66\u6709\u6548\u671f\u622a\u6b62", "\u7528\u6237\u56fd\u5bb6\u540d", "\u7528\u6237\u7ec4\u7ec7\u540d", "\u7528\u6237\u90e8\u95e8\u540d", "\u7528\u6237\u7701\u5dde\u540d", "\u7528\u6237\u901a\u7528\u540d", "\u7528\u6237\u57ce\u5e02\u540d", "\u7528\u6237EMAIL\u5730\u5740"};
        String cert = this.secEngineDeal.getServerCertificate();
        for (int i = 1; i < 20; ++i) {
            System.out.println(title[i - 1] + ": " + this.secEngineDeal.getCertInfo(cert, i));
        }
        System.out.println("\u6d4b\u8bd5\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\uff0c\u4f20\u5165-1\uff1a" + this.secEngineDeal.getCertInfo(cert, -1));
        System.out.println("\u6d4b\u8bd5\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\uff0c\u4f20\u516550\uff1a" + this.secEngineDeal.getCertInfo(cert, 50));
    }

    public void testGetCertInfoByOid() throws Base64Exception, GetCertInfoException {
        String cert = this.secEngineDeal.getServerCertificate();
        String oid = this.properties.getProperty("oid");
        System.out.println("\u6d4b\u8bd5\u901a\u8fc7OID\u83b7\u53d6\u8bc1\u4e66\u6269\u5c55\u4fe1\u606f\uff1a" + this.secEngineDeal.getCertInfoByOid(cert, oid));
    }

    public void testValidateCert() throws CertificateException, Base64Exception, ValidateCertException, GetCertInfoException {
        String cert = this.secEngineDeal.getServerCertificate();
        System.out.println(this.secEngineDeal.validateCert(cert));
    }

    public void testSignData() throws Base64Exception, HashException, RsaSignException {
        String signData = this.properties.getProperty("signData");
        System.out.println("\u7b7e\u540d\u539f\u6587\u4e3a\uff1a" + signData);
        System.out.println("\u7b7e\u540d\u503c\u4e3a\uff1a" + this.secEngineDeal.signData(signData));
    }

    public void testVerifySignedData() throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException, RsaSignException {
        String cert = this.secEngineDeal.getServerCertificate();
        String signData = this.properties.getProperty("signData");
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.verifySignedData(cert, signData, this.secEngineDeal.signData(signData)));
    }

    public void testSignFile() throws HashException, RsaSignException, Base64Exception {
        String path = this.properties.getProperty("sign_path");
        System.out.println("\u5f85\u7b7e\u540d\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + path);
        System.out.println("\u6587\u4ef6\u7b7e\u540d\u503c\u4e3a\uff1a" + this.secEngineDeal.signFile(path));
    }

    public void testVerifySignedFile() throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException, RsaSignException {
        String cert = this.secEngineDeal.getServerCertificate();
        String path = this.properties.getProperty("sign_path");
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.verifySignedFile(cert, path, this.secEngineDeal.signFile(path)));
    }

    public void testSecretSegment() throws SecretSegmentException, RandomNumberException, Base64Exception {
        String secret = this.secEngineDeal.genRandom(8);
        int all_seq = Integer.parseInt(this.properties.getProperty("all_seg"));
        int min_seq = Integer.parseInt(this.properties.getProperty("min_seg"));
        int req_n = Integer.parseInt(this.properties.getProperty("req_n"));
        System.out.println("\u95e8\u9650\u7b97\u6cd5\uff0c\u62c6\u5206\u540e\u7684\u5bc6\u7801\u4e3a\uff1a" + this.secEngineDeal.secretSegment(secret, all_seq, min_seq, req_n));
    }

    public void testSecertRecovery() throws SecretRecoveryException, SecretSegmentException, RandomNumberException, Base64Exception {
        String secret = this.secEngineDeal.genRandom(8);
        System.out.println("\u95e8\u9650\u7b97\u6cd5\uff0c\u62c6\u5206\u524d\u7684\u79d8\u5bc6\u4e3a\uff1a" + secret);
        int all_seq = Integer.parseInt(this.properties.getProperty("all_seg"));
        int min_seq = Integer.parseInt(this.properties.getProperty("min_seg"));
        int req_n = Integer.parseInt(this.properties.getProperty("req_n"));
        System.out.println("\u95e8\u9650\u7b97\u6cd5\uff0c\u6062\u590d\u540e\u7684\u79d8\u5bc6\u4e3a\uff1a" + this.secEngineDeal.secretRecovery(this.secEngineDeal.secretSegment(secret, all_seq, min_seq, req_n)));
    }

    public void testEncryptData() throws xjyb.cn.org.bjca.exception.EncryptDataException, IOException, Base64Exception {
        String key = this.properties.getProperty("data_symencry_key");
        String data = this.properties.getProperty("data_symencry_data");
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5bc6\u94a5\u4e3a: " + key);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5f85\u52a0\u5bc6\u660e\u6587\u4e3a\uff1a" + data);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5bc6\u6587\u4e3a\uff1a" + this.secEngineDeal.encryptData(key, data));
    }

    public void testDecryptData() throws DecryptDataException, Base64Exception, IOException, xjyb.cn.org.bjca.exception.EncryptDataException {
        String key = this.properties.getProperty("data_symencry_key");
        String data = this.properties.getProperty("data_symencry_data");
        TestSecurityEngineDeal_jni.assertEquals((String)"\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u51fa\u9519", (String)this.secEngineDeal.decryptData(key, this.secEngineDeal.encryptData(key, data)), (String)data);
    }

    public void testPubKeyEncrypt() throws Base64Exception, GetCertInfoException, RsaEncryptException {
        String cert = this.secEngineDeal.getServerCertificate();
        String data = this.properties.getProperty("cert_encry_data");
        System.out.println("\u4f7f\u7528\u8bc1\u4e66\u5bf9\u6570\u636e\u52a0\u5bc6\uff0c\u8bc1\u4e66\u4e3a\uff1a" + cert);
        System.out.println("\u4f7f\u7528\u8bc1\u4e66\u5bf9\u6570\u636e\u52a0\u5bc6\uff0c\u539f\u6570\u636e\u4e3a\uff1a" + data);
        System.out.println("\u4f7f\u7528\u8bc1\u4e66\u5bf9\u6570\u636e\u52a0\u5bc6\uff0c\u52a0\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.pubKeyEncrypt(cert, data));
    }

    public void testPriKeyDecrypt() throws Base64Exception, GetCertInfoException, RsaEncryptException, RsaDecryptException {
        String cert = this.secEngineDeal.getServerCertificate(1);
        String data = this.properties.getProperty("cert_encry_data");
        String secret = this.secEngineDeal.pubKeyEncrypt(cert, data);
        System.out.println("\u79c1\u94a5\u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a" + secret);
        System.out.println("\u79c1\u94a5\u89e3\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.priKeyDecrypt(secret));
    }

    public void testAddFile() {
        String file1 = this.properties.getProperty("addFile_1");
        String file2 = this.properties.getProperty("addFile_2");
        String file3 = this.properties.getProperty("addFile_3");
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.addSignFile(file1));
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.addSignFile(file2));
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.addSignFile(file3));
    }

    public void testAddString() {
        String str1 = this.properties.getProperty("addString_1");
        String str2 = this.properties.getProperty("addString_2");
        String str3 = this.properties.getProperty("addString_3");
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.addSignString(str1));
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.addSignString(str2));
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.addSignString(str3));
    }

    public void testClear() {
    }

    public void testSignDataPkcs7() throws InvalidKeyException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, SecurityException, NoSuchProviderException, SignatureException, Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        String data = this.properties.getProperty("pkcs7_data");
        System.out.println("\u5bf9\u5b57\u7b26\u4e32\u8fdb\u884cpkcs7\u683c\u5f0f\u7684\u6570\u5b57\u7b7e\u540d\uff0c\u539f\u6570\u636e\u4e3a\uff1a" + data);
        System.out.println("\u5bf9\u5b57\u7b26\u4e32\u8fdb\u884cpkcs7\u683c\u5f0f\u7684\u6570\u5b57\u7b7e\u540d\uff0c\u7b7e\u540d\u540e\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.signDataPkcs7(data));
    }

    public void testVerifySignedDataPkcs7() throws InvalidKeyException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, SecurityException, NoSuchProviderException, SignatureException, Pkcs7SignException, Pkcs7EncodeException, Base64Exception, CRLException, Pkcs7VerifySignException {
        String data = this.properties.getProperty("pkcs7_data");
        String secret = this.secEngineDeal.signDataPkcs7(data);
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.verifySignedDataPkcs7(secret));
    }

    public void testGetP7SignDataInfo() throws Exception {
        String data = this.properties.getProperty("pkcs7_data");
        String secret = this.secEngineDeal.signDataPkcs7(data);
        int type = 1;
        System.out.println("\u89e3\u6790p7\u7b7e\u540d\u5305\u4fe1\u606f\uff0c\u60f3\u83b7\u53d6\u7684\u4fe1\u606f\u7c7b\u578b\u4e3a(1.\u539f\u6587\uff0c2.\u7b7e\u540d\u8005\u8bc1\u4e66): " + type);
        System.out.println("\u89e3\u6790p7\u7b7e\u540d\u5305\u4fe1\u606f\uff0c\u83b7\u53d6\u7684\u4fe1\u606f\u4e3a\uff1a" + this.secEngineDeal.getP7SignDataInfo(secret, type));
    }

    public void testEncodeP7EnvelopedData() throws CertificateException, Base64Exception, Pkcs7EncodeException, Pkcs7EncodeEnvelopeException, EncryptAlgException, xjyb.cn.org.bjca.exception.EncryptDataException, EncryptKeyException, WriteEnvDataException, EncryptDataException {
        String cert = this.secEngineDeal.getServerCertificate(1);
        String data = this.properties.getProperty("pkcs7_env_data");
        System.out.println("\u5bf9\u6570\u636e\u8fdb\u884cp7\u6570\u5b57\u4fe1\u5c01\u52a0\u5bc6\uff0c\u539f\u6570\u636e\u4e3a\uff1a" + data);
        System.out.println("\u5bf9\u6570\u636e\u8fdb\u884cp7\u6570\u5b57\u4fe1\u5c01\u52a0\u5bc6\uff0c\u52a0\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.encodeP7EnvelopedData(cert, data));
    }

    public void testDecodeP7EnvelopedData() throws Exception {
        String cert = this.secEngineDeal.getServerCertificate(1);
        String data = this.properties.getProperty("pkcs7_env_data");
        String secret = this.secEngineDeal.encodeP7EnvelopedData(cert, data);
        TestSecurityEngineDeal_jni.assertEquals((String)data, (String)this.secEngineDeal.decodeP7EnvelopedData(secret));
    }

    public void testEncodeP7SignAndEnvelopData() throws Exception {
        String cert = this.secEngineDeal.getServerCertificate(2);
        String data = this.properties.getProperty("pkcs7_env_sign_data");
        System.out.println("pkcs7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u63a5\u53d7\u8005\u8bc1\u4e66\u4e3a\uff1a" + cert);
        System.out.println("pkcs7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u539f\u6587\u4e3a\uff1a" + data);
        System.out.println("pkcs7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u52a0\u5bc6\u540e\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.encodeP7SignAndEnvelopData(cert, data));
    }

    public void testDecodeP7SignAndEnvelopData() throws Exception {
        String cert = this.secEngineDeal.getServerCertificate(1);
        String data = this.properties.getProperty("pkcs7_env_sign_data");
        String secret = this.secEngineDeal.encodeP7SignAndEnvelopData(cert, data);
        TestSecurityEngineDeal_jni.assertEquals((String)data, (String)this.secEngineDeal.decodeP7SignAndEnvelopData(secret));
    }

    public void testSignDataXML() throws XmlSignException {
        String data = this.properties.getProperty("sign_xml_data");
        System.out.println("\u5bf9xml\u8fdb\u884c\u6570\u5b57\u7b7e\u540d\uff0c\u539f\u6570\u636e\u4e3a\uff1a" + data);
        System.out.println("\u5bf9xml\u8fdb\u884c\u6570\u5b57\u7b7e\u540d\uff0c\u7b7e\u540d\u540e\u7684\u7ed3\u679c\u4e3a\uff1a" + this.secEngineDeal.signDataXML(data));
    }

    public void testVerifySignedDataXML() throws XmlVerifySignException, XmlSignException {
        String data = this.properties.getProperty("sign_xml_data");
        String secret = this.secEngineDeal.signDataXML(data);
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.verifySignedDataXML(secret));
    }

    public void testGetXMLSignatureInfo() throws GetXMLSignInfoException, JDOMException, XmlSignException {
        String secret = this.properties.getProperty("xml_sign_secret");
        int type = Integer.parseInt(this.properties.getProperty("xml_sign_type"));
        System.out.println("\u89e3\u6790xml\u7b7e\u540d\u6570\u636e\uff0c\u7b7e\u540d\u6570\u636e\u4e3a\uff1a" + secret);
        System.out.println("\u89e3\u6790xml\u7b7e\u540d\u6570\u636e\uff0c\u7c7b\u578b\u4e3a(1\uff1axml\u539f\u6587 2\uff1a\u6458\u8981 3\uff1a\u7b7e\u540d\u503c 4\uff1a\u7b7e\u540d\u8bc1\u4e66 5\uff1a\u6458\u8981\u7b97\u6cd5 6\uff1a\u7b7e\u540d\u7b97\u6cd5): " + type);
        System.out.println("\u89e3\u6790xml\u7b7e\u540d\u6570\u636e\uff0c\u89e3\u6790\u540e\u7684\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.getXMLSignatureInfo(secret, type));
    }

    public void testGetTotalTsReq() throws NoSuchAlgorithmException, TsException, Base64Exception {
        System.out.println("\u6d4b\u8bd5\u83b7\u5f97\u591a\u6587\u4ef6\u6216\u591a\u5b57\u7b26\u4e32\u7684\u603b\u65f6\u95f4\u6233\u8bf7\u6c42: " + this.secEngineDeal.getTotalTsReq());
    }

    public void testCreateTimeStampRequest() throws HashException, TsException, Base64Exception {
        Base64Util util = new Base64Util("");
        String data = this.properties.getProperty("time_stamp_req_data");
        String base64data = util.BJS_EncodeBase64(data.getBytes());
        System.out.println("\u6d4b\u8bd5\u521b\u5efa\u65f6\u95f4\u6233\u8bf7\u6c42\uff0c\u539f\u6587\u4e3a\uff1a" + base64data);
        System.out.println("\u6d4b\u8bd5\u521b\u5efa\u65f6\u95f4\u6233\u8bf7\u6c42\uff0c\u65f6\u95f4\u6233\u8bf7\u6c42\u4e3a\uff1a" + this.secEngineDeal.createTimeStampRequest(base64data));
    }

    public void testCreateTimeStampresponse() throws Base64Exception, HashException, TsException {
        Base64Util util = new Base64Util("");
        String data = this.properties.getProperty("time_stamp_resp_data");
        String base64data = util.BJS_EncodeBase64(data.getBytes());
        String timeStampReq = this.secEngineDeal.createTimeStampRequest(base64data);
        System.out.println("\u6d4b\u8bd5\u521b\u5efa\u65f6\u95f4\u6233\u54cd\u5e94\uff0c\u539f\u6587\u4e3a\uff1a" + timeStampReq);
        System.out.println("\u6d4b\u8bd5\u521b\u5efa\u65f6\u95f4\u6233\u54cd\u5e94\uff0c\u65f6\u95f4\u6233\u54cd\u5e94\u4e3a\uff1a" + this.secEngineDeal.createTimeStamp(timeStampReq));
    }

    public void testVerifyTimeStamp() throws Base64Exception, HashException, TsException {
        Base64Util util = new Base64Util("");
        String data = this.properties.getProperty("time_stamp_resp_data");
        String base64data = util.BJS_EncodeBase64(data.getBytes());
        String reqData = this.secEngineDeal.createTimeStampRequest(base64data);
        String respData = this.secEngineDeal.createTimeStamp(reqData);
        TestSecurityEngineDeal_jni.assertTrue((boolean)this.secEngineDeal.verifyTimeStamp(base64data, respData));
    }

    public void testGetTimeStampInfo() throws Base64Exception, HashException, TsException, ParseException, Pkcs7DecodeException {
        int type = Integer.parseInt(this.properties.getProperty("get_time_stamp_info_type"));
        Base64Util util = new Base64Util("");
        String data = this.properties.getProperty("get_time_stamp_info_data");
        String base64data = util.BJS_EncodeBase64(data.getBytes());
        String reqData = this.secEngineDeal.createTimeStampRequest(base64data);
        String respData = this.secEngineDeal.createTimeStamp(reqData);
        System.out.println("\u6d4b\u8bd5\u89e3\u6790\u65f6\u95f4\u6233\uff0c\u7c7b\u578b\u4e3a(1,\u65f6\u95f4 2,\u7b7e\u540d\u503c 3,\u7b7e\u540d\u8bc1\u4e66): " + type);
        System.out.println("\u6d4b\u8bd5\u89e3\u6790\u65f6\u95f4\u6233\uff0c\u8fd4\u56de\u503c\u4e3a\uff1a" + this.secEngineDeal.getTimeStampInfo("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", type));
    }
}

