/*
 * Decompiled with CFR 0.152.
 */
package test.junit;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Properties;
import junit.framework.TestCase;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.CertHasExpiredException;
import xjyb.cn.org.bjca.exception.CertInvalidException;
import xjyb.cn.org.bjca.exception.CertRevokedException;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;
import xjyb.cn.org.bjca.utils.FileUtil;
import xjyb.org.bjca.jce.exception.EncryptAlgException;
import xjyb.org.bjca.jce.exception.EncryptDataException;
import xjyb.org.bjca.jce.exception.EncryptKeyException;
import xjyb.org.bjca.jce.exception.WriteEnvDataException;

public class TestSecurityEngineDeal_java
extends TestCase {
    SecurityEngineDeal secEngineDeal = null;
    Properties properties = new Properties();

    protected void setUp() throws Exception {
        this.properties.load(new FileInputStream("src/test/junit/test_java.properties"));
        this.secEngineDeal = SecurityEngineDeal.getInstance(this.properties.getProperty("applicationName").trim());
    }

    protected void tearDown() throws Exception {
    }

    public void testGetInstance() throws FileNotFoundException, KeyStoreException, NoSuchAlgorithmException, CertificateException, JDOMException, IOException, InitException {
        System.out.println(this.secEngineDeal.getClass().getName());
        TestSecurityEngineDeal_java.assertNotNull((Object)this.secEngineDeal);
    }

    public void testGetApplicationName() {
        String applicationName = this.properties.getProperty("applicationName").trim();
        TestSecurityEngineDeal_java.assertEquals((String)"\u83b7\u5f97\u5e94\u7528\u540d\u51fa\u9519", (String)applicationName, (String)this.secEngineDeal.getApplicationName());
    }

    public void testSetApplicationName() {
        String applicationName = this.properties.getProperty("applicationName");
        this.secEngineDeal.setApplicationName(applicationName);
        TestSecurityEngineDeal_java.assertEquals((String)"\u8bbe\u7f6e\u5e94\u7528\u540d\u51fa\u9519", (String)applicationName, (String)this.secEngineDeal.getApplicationName());
    }

    public void testSetDebug() {
    }

    public void testSetSignMethod() throws AlgorithmNotFoundException {
        String signMethod = this.properties.getProperty("signMethod");
        this.secEngineDeal.setSignMethod(signMethod);
        TestSecurityEngineDeal_java.assertEquals((String)"\u8bbe\u7f6e\u7b7e\u540d\u7b97\u6cd5\u51fa\u9519", (String)signMethod, (String)this.secEngineDeal.getSignMethod());
    }

    public void testGetSignMethod() throws AlgorithmNotFoundException {
        String signMethod = this.properties.getProperty("signMethod");
        this.secEngineDeal.setSignMethod(signMethod);
        TestSecurityEngineDeal_java.assertEquals((String)"\u83b7\u5f97\u7b7e\u540d\u7b97\u6cd5\u51fa\u9519", (String)signMethod, (String)this.secEngineDeal.getSignMethod());
    }

    public void testGetEncryptMethod() {
        String encryptMethod = this.properties.getProperty("encryptMethod");
        TestSecurityEngineDeal_java.assertEquals((String)"\u83b7\u5f97\u52a0\u89e3\u5bc6\u7b97\u6cd5\u51fa\u9519", (String)encryptMethod, (String)this.secEngineDeal.getEncryptMethod());
    }

    public void testGetServerCertificate() throws Base64Exception {
        String cert = this.secEngineDeal.getServerCertificate();
        System.out.println("\u5f53\u524d\u5e94\u7528\u7684\u670d\u52a1\u5668\u7684\u7b7e\u540d\u8bc1\u4e66\u4e3a: " + cert);
    }

    public void testGetServerCertificateInt() throws Base64Exception {
        String cert = this.secEngineDeal.getServerCertificate(1);
        System.out.println("\u5f53\u524d\u5e94\u7528\u7684\u670d\u52a1\u5668\u7684\u7b7e\u540d\u8bc1\u4e66\u4e3a: " + cert);
    }

    public void testGenRandom() throws RandomNumberException, Base64Exception {
        String random = this.secEngineDeal.genRandom();
        System.out.println("\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a\uff1a" + random);
    }

    public void testGenRandomInt() throws RandomNumberException, Base64Exception {
        System.out.println("\u4f20\u51651\uff0c\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a: " + this.secEngineDeal.genRandom(1));
        System.out.println("\u4f20\u516513\uff0c\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a: " + this.secEngineDeal.genRandom(13));
    }

    public void testGetCertInfo() throws Base64Exception, GetCertInfoException {
        String[] title = new String[]{"\u8bc1\u4e66\u7248\u672c", "\u8bc1\u4e66\u5e8f\u5217\u53f7", "\u6458\u8981\u7b7e\u540d\u7b97\u6cd5\u540d\u79f0", "\u8bc1\u4e66\u53d1\u653e\u8005\u56fd\u5bb6\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u7ec4\u7ec7\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u90e8\u95e8\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u7701\u5dde\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u901a\u7528\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u57ce\u5e02\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005EMAIL\u5730\u5740", "\u8bc1\u4e66\u6709\u6548\u671f\u8d77\u59cb", "\u8bc1\u4e66\u6709\u6548\u671f\u622a\u6b62", "\u7528\u6237\u56fd\u5bb6\u540d", "\u7528\u6237\u7ec4\u7ec7\u540d", "\u7528\u6237\u90e8\u95e8\u540d", "\u7528\u6237\u7701\u5dde\u540d", "\u7528\u6237\u901a\u7528\u540d", "\u7528\u6237\u57ce\u5e02\u540d", "\u7528\u6237EMAIL\u5730\u5740"};
        String cert = this.secEngineDeal.getServerCertificate();
        for (int i = 1; i < 20; ++i) {
            System.out.println(title[i - 1] + ": " + this.secEngineDeal.getCertInfo(cert, i));
        }
        System.out.println("\u6d4b\u8bd5\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\uff0c\u4f20\u5165-1\uff1a" + this.secEngineDeal.getCertInfo(cert, -1));
        System.out.println("\u6d4b\u8bd5\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\uff0c\u4f20\u516550\uff1a" + this.secEngineDeal.getCertInfo(cert, 50));
    }

    public void testGetCertInfoByOid() throws Base64Exception, GetCertInfoException {
        String cert = this.secEngineDeal.getServerCertificate();
        String oid = this.properties.getProperty("oid");
        System.out.println("\u6d4b\u8bd5\u901a\u8fc7OID\u83b7\u53d6\u8bc1\u4e66\u6269\u5c55\u4fe1\u606f\uff1a" + this.secEngineDeal.getCertInfoByOid(cert, oid));
    }

    public void testValidateCert() throws CertInvalidException, CertHasExpiredException, CertRevokedException, Base64Exception, GetCertInfoException, ParseException, CertificateException, ValidateCertException {
        String cert = this.secEngineDeal.getServerCertificate();
        System.out.println(this.secEngineDeal.validateCert(cert));
    }

    public void testSignData() throws Base64Exception, HashException, RsaSignException {
        String signData = "";
        System.out.println("\u7b7e\u540d\u539f\u6587\u4e3a\uff1a" + signData);
        System.out.println("\u7b7e\u540d\u503c\u4e3a\uff1a" + this.secEngineDeal.signData(signData));
    }

    public void testVerifySignedData() throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException, RsaSignException {
        String cert = this.secEngineDeal.getServerCertificate();
        String signData = this.properties.getProperty("signData");
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.verifySignedData(cert, signData, this.secEngineDeal.signData(signData)));
    }

    public void testSignFile() throws HashException, RsaSignException, Base64Exception {
        String path = this.properties.getProperty("sign_path");
        System.out.println("\u5f85\u7b7e\u540d\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + path);
        System.out.println("\u6587\u4ef6\u7b7e\u540d\u503c\u4e3a\uff1a" + this.secEngineDeal.signFile(path));
    }

    public void testVerifySignedFile() throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException, RsaSignException {
        String cert = this.secEngineDeal.getServerCertificate();
        String path = this.properties.getProperty("sign_path");
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.verifySignedFile(cert, path, this.secEngineDeal.signFile(path)));
    }

    public void testSecertRecovery() throws Base64Exception, SecretSegmentException {
    }

    public void testEncryptData() throws xjyb.cn.org.bjca.exception.EncryptDataException, IOException, Base64Exception, RandomNumberException {
        String key = this.properties.getProperty("data_symencry_key");
        String data = this.properties.getProperty("data_symencry_data");
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5bc6\u94a5\u4e3a: " + key);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5f85\u52a0\u5bc6\u660e\u6587\u4e3a\uff1a" + data);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5bc6\u6587\u4e3a\uff1a" + this.secEngineDeal.encryptData(key, data));
    }

    public void testDecryptData() throws DecryptDataException, Base64Exception, IOException, xjyb.cn.org.bjca.exception.EncryptDataException {
        String key = this.properties.getProperty("data_symencry_key");
        String data = this.properties.getProperty("data_symencry_data");
        TestSecurityEngineDeal_java.assertEquals((String)"\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u51fa\u9519", (String)this.secEngineDeal.decryptData(key, this.secEngineDeal.encryptData(key, data)), (String)data);
    }

    public void testEncryptFile() throws Base64Exception, xjyb.cn.org.bjca.exception.EncryptDataException {
        String key = this.properties.getProperty("file_symencry_key");
        String inPath = this.properties.getProperty("file_symencry_inPath");
        String outPath = this.properties.getProperty("file_symencry_outPath");
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6587\u4ef6\uff0c\u5bc6\u94a5\u4e3a\uff1a" + key);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6587\u4ef6\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + inPath);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6587\u4ef6\uff0c\u52a0\u5bc6\u540e\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + outPath);
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.encryptFile(key, inPath, outPath));
    }

    public void testDecryptFile() throws Base64Exception, DecryptDataException {
        String key = this.properties.getProperty("file_symencry_key");
        String inPath = this.properties.getProperty("file_symencry_outPath");
        String outPath = this.properties.getProperty("file_sysdecry_outPath");
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6587\u4ef6\uff0c\u5bc6\u94a5\u4e3a\uff1a" + key);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6587\u4ef6\uff0c\u52a0\u5bc6\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + inPath);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6587\u4ef6\uff0c\u89e3\u5bc6\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + outPath);
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.decryptFile(key, inPath, outPath));
    }

    public void testPubKeyEncrypt() throws Base64Exception, GetCertInfoException, RsaEncryptException {
        String cert = this.secEngineDeal.getServerCertificate();
        String data = this.properties.getProperty("cert_encry_data");
        System.out.println("\u4f7f\u7528\u8bc1\u4e66\u5bf9\u6570\u636e\u52a0\u5bc6\uff0c\u8bc1\u4e66\u4e3a\uff1a" + cert);
        System.out.println("\u4f7f\u7528\u8bc1\u4e66\u5bf9\u6570\u636e\u52a0\u5bc6\uff0c\u539f\u6570\u636e\u4e3a\uff1a" + data);
        System.out.println("\u4f7f\u7528\u8bc1\u4e66\u5bf9\u6570\u636e\u52a0\u5bc6\uff0c\u52a0\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.pubKeyEncrypt(cert, data));
    }

    public void testPriKeyDecrypt() throws Base64Exception, GetCertInfoException, RsaEncryptException, RsaDecryptException {
        String cert = this.secEngineDeal.getServerCertificate();
        String data = this.properties.getProperty("cert_encry_data");
        String secret = this.secEngineDeal.pubKeyEncrypt(cert, data);
        System.out.println("\u79c1\u94a5\u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a" + secret);
        System.out.println("\u79c1\u94a5\u89e3\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.priKeyDecrypt(secret));
    }

    public void testAddFile() {
        String file1 = this.properties.getProperty("addFile_1");
        String file2 = this.properties.getProperty("addFile_2");
        String file3 = this.properties.getProperty("addFile_3");
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.addSignFile(file1));
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.addSignFile(file2));
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.addSignFile(file3));
    }

    public void testAddString() {
        String str1 = this.properties.getProperty("addString_1");
        String str2 = this.properties.getProperty("addString_2");
        String str3 = this.properties.getProperty("addString_3");
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.addSignString(str1));
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.addSignString(str2));
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.addSignString(str3));
    }

    public void testClear() {
    }

    public void testGetTotalTsReq() {
    }

    public void testSignDataPkcs7() throws InvalidKeyException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, SecurityException, NoSuchProviderException, SignatureException, Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        String data = this.properties.getProperty("pkcs7_data");
        System.out.println("\u5bf9\u5b57\u7b26\u4e32\u8fdb\u884cpkcs7\u683c\u5f0f\u7684\u6570\u5b57\u7b7e\u540d\uff0c\u539f\u6570\u636e\u4e3a\uff1a" + data);
        System.out.println("\u5bf9\u5b57\u7b26\u4e32\u8fdb\u884cpkcs7\u683c\u5f0f\u7684\u6570\u5b57\u7b7e\u540d\uff0c\u7b7e\u540d\u540e\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.signDataPkcs7(data));
    }

    public void testVerifySignedDataPkcs7() throws InvalidKeyException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, SecurityException, NoSuchProviderException, SignatureException, Pkcs7SignException, Pkcs7EncodeException, Base64Exception, CRLException, Pkcs7VerifySignException {
        String data = this.properties.getProperty("pkcs7_data");
        String secret = this.secEngineDeal.signDataPkcs7(data);
        TestSecurityEngineDeal_java.assertTrue((boolean)this.secEngineDeal.verifySignedDataPkcs7(secret));
    }

    public void testGetP7SignDataInfo() throws Exception {
        String data = this.properties.getProperty("pkcs7_data");
        String secret = this.secEngineDeal.signDataPkcs7(data);
        int type = 1;
        System.out.println("\u89e3\u6790p7\u7b7e\u540d\u5305\u4fe1\u606f\uff0c\u60f3\u83b7\u53d6\u7684\u4fe1\u606f\u7c7b\u578b\u4e3a(1.\u539f\u6587\uff0c2.\u7b7e\u540d\u8005\u8bc1\u4e66): " + type);
        System.out.println("\u89e3\u6790p7\u7b7e\u540d\u5305\u4fe1\u606f\uff0c\u83b7\u53d6\u7684\u4fe1\u606f\u4e3a\uff1a" + this.secEngineDeal.getP7SignDataInfo(secret, type));
    }

    public void testEncodeP7EnvelopedData() throws CertificateException, Base64Exception, Pkcs7EncodeException, Pkcs7EncodeEnvelopeException, EncryptAlgException, xjyb.cn.org.bjca.exception.EncryptDataException, EncryptKeyException, WriteEnvDataException, EncryptDataException {
        String cert = "MIIEdDCCA1ygAwIBAgIKEAAAAAAAABABKDANBgkqhkiG9w0BAQUFADBIMQswCQYDVQQGEwJDTjENMAsGA1UECgwEQkpDQTEUMBIGA1UECwwLQmVpSmluZyBHQ0ExFDASBgNVBAMMC0JlaUppbmcgR0NBMB4XDTA1MDkxMDE2MDAwMFoXDTA2MDkwOTE2MDAwMFowcTELMAkGA1UEBhMCQ04xDTALBgNVBAoMBEJKQ0ExFDASBgNVBAoMC0dDQS1VU0VSVkVSMQwwCgYDVQQKDAPml6AxDzANBgNVBAsMBmJqY2F5eTEeMBwGA1UEAwwV5pyN5Yqh5Zmo6Lqr5Lu96K+B5LmmMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCsTmUHYdD8MhhX0wMoevdf2wQpFuVN4YDWIMQTPx4iSHGZesiC9yYdOP+LrQml1d7lV19FZABXE30nHdRl6/acbcKBFqugo7akiISsjI0Mu/MXTjY8gQ07W6Wwfh7G9lKMRNIsJAHLbbow2aJyj2Dedgp0sD9XU/w02uNapQPCOQIDAQABo4IBuTCCAbUwHwYDVR0jBBgwFoAU4PewVhmGpb1YUwX1YiZjWMQ45j4wDAYDVR0PBAUDAwf4ADArBgNVHRAEJDAigA8yMDA1MDkxMTAwMDAwMFqBDzIwMDYwOTEwMDAwMDAwWjAhBgNVHREEGjAYpBYwFDESMBAGA1UECAwJ5YyX5Lqs5biCMAkGA1UdEwQCMAAwgaQGA1UdHwSBnDCBmTBioGCgXqRcMFoxCzAJBgNVBAYTAkNOMQ0wCwYDVQQKDARCSkNBMRQwEgYDVQQLDAtCZWlKaW5nIEdDQTEUMBIGA1UEAwwLQmVpSmluZyBHQ0ExEDAOBgNVBAMTB2NhMWNybDEwM6AxoC+GLWh0dHA6Ly9sZGFwLmJqY2Eub3JnLmNuL2NybC9iamdjYS9jYTFjcmwxLmNybDARBglghkgBhvhCAQEEBAMCAP8wFAYFKlYLBwkEC0pKMTIzNDU2Nzg5MBcGCGCGSAGG+EQCBAtKSjEyMzQ1Njc4OTBABgNVHSAEOTA3MDUGCSqBHAHFOIEVATAoMCYGCCsGAQUFBwIBFhpodHRwOi8vd3d3LmJqY2Eub3JnLmNuL2NwczANBgkqhkiG9w0BAQUFAAOCAQEAGPBnhe7aRjYliqCkt20TUN48EzelhmhHXFdQRkOpszRGZ1kbqXNFhxyTNh4Fyo91eh2BgiuFpti9Ikp3ZRfzZQfCX2LCD/DxupT4SGE19tkQ3ybFf9/J2F40g8w3HM49J93vazJJ/pfW+jMdghADwWKh0Bnu8rb1LLdaBo+NaLJxM1bpRFIH+lpPWSoNMAmArY8Tu9m4raOLaghGGIJRQO4lWrT9ogcfDQ/M9LAqjgdBwdl/D6kKhbN/y46Z3fj0JZyyaOCAFK8MMgcys+SWEWCpm6hGQv5QKuZFRfvhiilrvwlcggFnMnOCHNsSl5cwtH+6Ofe+wuosiQheFOELVA==";
        String data = this.properties.getProperty("pkcs7_env_data");
        String enP7Data = this.secEngineDeal.encodeP7EnvelopedData(cert, data);
        FileUtil fileU = new FileUtil("");
        fileU.writeFile(this.secEngineDeal.base64Decode(enP7Data), "c:\\111");
        System.out.println("\u5bf9\u6570\u636e\u8fdb\u884cp7\u6570\u5b57\u4fe1\u5c01\u52a0\u5bc6\uff0c\u539f\u6570\u636e\u4e3a\uff1a" + data);
        System.out.println("\u5bf9\u6570\u636e\u8fdb\u884cp7\u6570\u5b57\u4fe1\u5c01\u52a0\u5bc6\uff0c\u52a0\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a" + enP7Data);
    }

    public void testEncodeP7SignAndEnvelopData() throws Exception {
        String cert = this.secEngineDeal.getServerCertificate();
        String data = this.properties.getProperty("pkcs7_env_sign_data");
        System.out.println("pkcs7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u63a5\u53d7\u8005\u8bc1\u4e66\u4e3a\uff1a" + cert);
        System.out.println("pkcs7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u539f\u6587\u4e3a\uff1a" + data);
        System.out.println("pkcs7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u52a0\u5bc6\u540e\u6570\u636e\u4e3a\uff1a" + this.secEngineDeal.encodeP7SignAndEnvelopData(cert, data));
    }

    public void testDecodeP7SignAndEnvelopData() throws Exception {
        String data = this.properties.getProperty("pkcs7_dec_sign_data");
        String secret = this.properties.getProperty("pkcs7_dec_sign_secret");
        TestSecurityEngineDeal_java.assertEquals((String)data, (String)this.secEngineDeal.decodeP7SignAndEnvelopData(secret));
    }
}

