/*
 * Decompiled with CFR 0.152.
 */
package com.zhejiang;

import com.zhejiang.util.CertExtendedKeyUsageEnum;
import com.zhejiang.util.CertInfo;
import com.zhejiang.util.CertKeyUsageEnum;
import com.zhejiang.util.DateUtil;
import com.zhejiang.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.CollectionStore;

public class BillExtractor {
    public static void main(String[] args) throws Exception {
        File file1 = new File("d:/11/33993023-4453024829.pdf");
        byte[] xmlBytes = BillExtractor.pdfToXml(Files.readAllBytes(file1.toPath()));
        System.out.println(new String(xmlBytes));
    }

    public static boolean[] verify(byte[] pdfByte) throws Exception {
        PDDocument doc = PDDocument.load(pdfByte);
        List<PDSignature> signatureDictionaries = doc.getSignatureDictionaries();
        int signatureIndex = signatureDictionaries.size() - 1;
        PDSignature signature = signatureDictionaries.get(signatureIndex);
        byte[] contents = signature.getContents(pdfByte);
        byte[] signatureAsBytes = signature.getContents(pdfByte);
        byte[] signedContentAsBytes = signature.getSignedContent(pdfByte);
        Calendar signDate = signature.getSignDate();
        String reason = signature.getReason();
        boolean[] verify = BillExtractor.verifyWithMyCrypto(signatureAsBytes, signedContentAsBytes);
        return verify;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] pdfToXml(byte[] pdfFile) {
        try (PDDocument document = PDDocument.load(pdfFile);){
            byte[] returnbyte;
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            byte[] byArray = returnbyte = BillExtractor.extractFiles(efTree.getNames());
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ofdToXbrl(byte[] pdfFile) {
        File file = null;
        try {
            ZipEntry ze;
            file = new File(UUID.randomUUID().toString() + ".zip");
            FileOutputStream fout = new FileOutputStream(file);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            bout.write(pdfFile);
            bout.close();
            fout.close();
            StringBuffer b = new StringBuffer();
            ZipFile zf = new ZipFile(file);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            ZipInputStream zin = new ZipInputStream(in);
            while ((ze = zin.getNextEntry()) != null) {
                String line;
                if (ze.isDirectory() || ze.getName().indexOf("Doc_0/Res/zj") == -1) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                while ((line = br.readLine()) != null) {
                    b.append(line);
                }
                br.close();
            }
            zf.close();
            ((InputStream)in).close();
            zin.closeEntry();
            byte[] byArray = b.toString().getBytes();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    private static boolean[] verifyWithMyCrypto(byte[] signedData, byte[] plainData) {
        boolean[] signCertVerify = new boolean[2];
        X509Certificate caCert = null;
        try {
            InputStream inputStream = BillExtractor.class.getClassLoader().getResourceAsStream("ca.cer");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            caCert = (X509Certificate)cf.generateCertificate(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("=========fail to get ca cert=========");
            System.err.println(e.getMessage());
            return signCertVerify;
        }
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider());
        try {
            CMSSignedData cms = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(plainData), signedData);
            CollectionStore store = (CollectionStore)cms.getCertificates();
            Iterator certIt = store.iterator();
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            while (certIt.hasNext()) {
                X509CertificateHolder certificateHolder = (X509CertificateHolder)certIt.next();
                X509Certificate certificate = converter.getCertificate(certificateHolder);
                certList.add(certificate);
            }
            SignerInformationStore signers = cms.getSignerInfos();
            Iterator<SignerInformation> signInfoIt = signers.getSigners().iterator();
            if (!signInfoIt.hasNext()) {
                throw new Exception("no signatureInfo");
            }
            SignerInformation signerInformation = signInfoIt.next();
            Collection certCollection = store.getMatches(signerInformation.getSID());
            if (certCollection.isEmpty()) {
                throw new Exception("no matching certificate");
            }
            X509CertificateHolder certHolder = (X509CertificateHolder)certCollection.iterator().next();
            X509Certificate cert = converter.getCertificate(certHolder);
            String[] keys = cert.getSubjectDN().getName().split(",");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String v : keys) {
                String[] values = v.split("=");
                map.put(values[0], values[1]);
            }
            if (!"12330000470034352M".equals(map.get("O")) || !"\u6d59\u6c5f\u7701\u8d22\u653f\u7968\u636e\u7ba1\u7406\u4e2d\u5fc3".equals(map.get("CN"))) {
                return signCertVerify;
            }
            cert.verify(caCert.getPublicKey());
            signCertVerify[0] = true;
            try {
                signCertVerify[1] = signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return signCertVerify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return signCertVerify;
        }
    }

    private static byte[] extractFiles(Map<String, PDComplexFileSpecification> names) throws IOException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            PDComplexFileSpecification fileSpec = entry.getValue();
            PDEmbeddedFile embeddedFile = BillExtractor.getEmbeddedFile(fileSpec);
            if ("hidexml.zip".equals(entry.getKey())) {
                return ZipUtil.getFileByPath(embeddedFile.toByteArray(), "hidexml.xml");
            }
            if (!"voucher_issuer.xbrl".equals(entry.getKey())) continue;
            return embeddedFile.toByteArray();
        }
        return null;
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    private static CertInfo getCertInfo(X509Certificate certificate) throws CertificateParsingException, IOException, CertificateEncodingException {
        List<String> extendedKeyUsages;
        X500Name subjectDN = new JcaX509CertificateHolder(certificate).getSubject();
        RDN cn = subjectDN.getRDNs(BCStyle.CN)[0];
        String subjectName = IETFUtils.valueToString(cn.getFirst().getValue());
        RDN o = subjectDN.getRDNs(BCStyle.O)[0];
        String subjectCode = IETFUtils.valueToString(o.getFirst().getValue());
        X500Name issuerDN = new JcaX509CertificateHolder(certificate).getIssuer();
        RDN icn = issuerDN.getRDNs(BCStyle.CN)[0];
        String issuerName = IETFUtils.valueToString(icn.getFirst().getValue());
        RDN io = issuerDN.getRDNs(BCStyle.O)[0];
        String issuerCode = IETFUtils.valueToString(io.getFirst().getValue());
        String notBefore = DateUtil.ZoneSimpleFormat(certificate.getNotBefore());
        String notAfter = DateUtil.ZoneSimpleFormat(certificate.getNotAfter());
        boolean[] keyUsage = certificate.getKeyUsage();
        ArrayList<String> keyUsageList = new ArrayList<String>();
        if (keyUsage != null) {
            for (int i = 0; i < keyUsage.length; ++i) {
                CertKeyUsageEnum keyUsg;
                if (!keyUsage[i] || (keyUsg = CertKeyUsageEnum.getByNumber(i)) == null) continue;
                keyUsageList.add(keyUsg.getDescription());
            }
        }
        if ((extendedKeyUsages = certificate.getExtendedKeyUsage()) != null) {
            for (String oid : extendedKeyUsages) {
                CertExtendedKeyUsageEnum extKeyUsg = CertExtendedKeyUsageEnum.getByOid(oid);
                if (extKeyUsg == null) continue;
                keyUsageList.add(extKeyUsg.getDescription());
            }
        }
        return new CertInfo(subjectName, subjectCode, issuerName, issuerCode, notBefore, notAfter, keyUsageList);
    }
}

