/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jcajce.provider.asymmetric.edec;

import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.edec.EdECObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PrivateKeyInfo;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.Ed25519PrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.Ed25519PublicKeyParameters;
import cn.org.bjca.gaia.crypto.util.OpenSSHPrivateKeyUtil;
import cn.org.bjca.gaia.crypto.util.OpenSSHPublicKeyUtil;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import cn.org.bjca.gaia.jcajce.provider.util.AsymmetricKeyInfoConverter;
import cn.org.bjca.gaia.jce.spec.OpenSSHPrivateKeySpec;
import cn.org.bjca.gaia.jce.spec.OpenSSHPublicKeySpec;
import cn.org.bjca.gaia.util.encoders.Hex;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    static final byte[] x448Prefix = Hex.decode("3042300506032b656f033900");
    static final byte[] x25519Prefix = Hex.decode("302a300506032b656e032100");
    static final byte[] Ed448Prefix = Hex.decode("3043300506032b6571033a00");
    static final byte[] Ed25519Prefix = Hex.decode("302a300506032b6570032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    String algorithm;
    private final boolean isXdh;
    private final int specificBase;

    public KeyFactorySpi(String algorithm, boolean isXdh, int specificBase) {
        this.algorithm = algorithm;
        this.isXdh = isXdh;
        this.specificBase = specificBase;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof BCEdDSAPrivateKey) {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(key.getEncoded());
                DEROctetString val2 = (DEROctetString)seq.getObjectAt(2);
                ASN1InputStream in = new ASN1InputStream(val2.getOctets());
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new Ed25519PrivateKeyParameters(((DEROctetString)in.readObject()).getOctets(), 0)));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException(ex.getMessage(), ex.getCause());
            }
        }
        if (spec.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof BCEdDSAPublicKey) {
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new Ed25519PublicKeyParameters(key.getEncoded(), Ed25519Prefix.length)));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException(ex.getMessage(), ex.getCause());
            }
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter parameters = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (parameters instanceof Ed25519PrivateKeyParameters) {
                return new BCEdDSAPrivateKey((Ed25519PrivateKeyParameters)parameters);
            }
            throw new IllegalStateException("openssh private key not Ed25519 private key");
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
            if (this.specificBase == 0 || this.specificBase == enc[8]) {
                switch (enc[8]) {
                    case 111: {
                        return new BCXDHPublicKey(x448Prefix, enc);
                    }
                    case 110: {
                        return new BCXDHPublicKey(x25519Prefix, enc);
                    }
                    case 113: {
                        return new BCEdDSAPublicKey(Ed448Prefix, enc);
                    }
                    case 112: {
                        return new BCEdDSAPublicKey(Ed25519Prefix, enc);
                    }
                }
                return super.engineGeneratePublic(keySpec);
            }
        } else if (keySpec instanceof OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter parameters = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (parameters instanceof Ed25519PublicKeyParameters) {
                return new BCEdDSAPublicKey(new byte[0], ((Ed25519PublicKeyParameters)parameters).getEncoded());
            }
            throw new IllegalStateException("openssh public key not Ed25519 public key");
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                return new BCXDHPrivateKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BCXDHPrivateKey(keyInfo);
            }
        } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new BCEdDSAPrivateKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new BCEdDSAPrivateKey(keyInfo);
            }
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognized");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                return new BCXDHPublicKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BCXDHPublicKey(keyInfo);
            }
        } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                return new BCEdDSAPublicKey(keyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new BCEdDSAPublicKey(keyInfo);
            }
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognized");
    }

    public static class ED25519
    extends KeyFactorySpi {
        public ED25519() {
            super("Ed25519", false, 112);
        }
    }

    public static class ED448
    extends KeyFactorySpi {
        public ED448() {
            super("Ed448", false, 113);
        }
    }

    public static class EDDSA
    extends KeyFactorySpi {
        public EDDSA() {
            super("EdDSA", false, 0);
        }
    }

    public static class X25519
    extends KeyFactorySpi {
        public X25519() {
            super("X25519", true, 110);
        }
    }

    public static class X448
    extends KeyFactorySpi {
        public X448() {
            super("X448", true, 111);
        }
    }

    public static class XDH
    extends KeyFactorySpi {
        public XDH() {
            super("XDH", true, 0);
        }
    }
}

