/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms.bc;

import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.RecipientOperator;
import cn.org.bjca.gaia.cms.bc.BcPasswordRecipient;
import cn.org.bjca.gaia.cms.bc.EnvelopedDataHelper;
import cn.org.bjca.gaia.crypto.BufferedBlockCipher;
import cn.org.bjca.gaia.crypto.StreamCipher;
import cn.org.bjca.gaia.crypto.io.CipherInputStream;
import cn.org.bjca.gaia.crypto.params.KeyParameter;
import cn.org.bjca.gaia.operator.InputDecryptor;
import java.io.InputStream;

public class BcPasswordEnvelopedRecipient
extends BcPasswordRecipient {
    public BcPasswordEnvelopedRecipient(char[] password) {
        super(password);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        KeyParameter secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, derivedKey, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataOut, (StreamCipher)dataCipher);
            }
        });
    }
}

