/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.crmf;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.DEROutputStream;
import cn.org.bjca.gaia.asn1.x509.ExtensionsGenerator;
import cn.org.bjca.gaia.cert.CertIOException;
import cn.org.bjca.gaia.cert.crmf.CRMFRuntimeException;
import java.io.IOException;
import java.io.OutputStream;

class CRMFUtil {
    CRMFUtil() {
    }

    static void derEncodeToStream(ASN1Encodable obj, OutputStream stream) {
        DEROutputStream dOut = new DEROutputStream(stream);
        try {
            dOut.writeObject(obj);
            dOut.close();
        }
        catch (IOException e) {
            throw new CRMFRuntimeException("unable to DER encode object: " + e.getMessage(), e);
        }
    }

    static void addExtension(ExtensionsGenerator extGenerator, ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws CertIOException {
        try {
            extGenerator.addExtension(oid, isCritical, value);
        }
        catch (IOException e) {
            throw new CertIOException("cannot encode extension: " + e.getMessage(), e);
        }
    }
}

