/*
 * Decompiled with CFR 0.152.
 */
package api.loader;

import api.VoucherFileInfo;
import api.tools.FileTool;
import com.pansoft.xbrl.xbrljson.util.CleanPathUtil;
import com.pansoft.xbrl.xbrljson.util.FileUtil;
import com.pansoft.xbrl.xbrljson.util.PropUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OFDLoader {
    private static Logger log = Logger.getLogger(OFDLoader.class.toString());
    private String attPath = "";
    private String rootDir = "";
    private List<String> attachments = null;

    private ZipFile loadOFD(String filePath) throws Exception {
        ZipFile file = new ZipFile(filePath);
        ZipArchiveEntry entry = file.getEntry("OFD.xml");
        if (entry == null) {
            file.close();
            return null;
        }
        Document d = this.entryToDocument(file, entry);
        NodeList list = d.getElementsByTagName("ofd:DocBody");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.parserDocumentBody(node, file);
        }
        return file;
    }

    private void parserDocumentBody(Node nd, ZipFile file) throws Exception {
        String docPath = null;
        NodeList list = nd.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !"ofd:DocRoot".equalsIgnoreCase(node.getNodeName())) continue;
            docPath = node.getTextContent().trim();
            this.rootDir = docPath.startsWith("/") ? docPath.substring(1, docPath.lastIndexOf("/")) : docPath.substring(0, docPath.indexOf("/"));
        }
        if (docPath == null || docPath.length() < 1) {
            return;
        }
        if (docPath.startsWith("/") || docPath.startsWith("\\")) {
            docPath = docPath.substring(1);
        }
        ZipArchiveEntry entry = file.getEntry(docPath);
        Document d = this.entryToDocument(file, entry);
        this.parserDocument(d.getDocumentElement(), file);
    }

    private void parserDocument(Node node, ZipFile file) throws Exception {
        if (node.getNodeType() != 1) {
            return;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node nd = list.item(i);
            if (nd.getNodeType() != 1 || !"ofd:Attachments".equalsIgnoreCase(nd.getNodeName())) continue;
            this.attPath = nd.getTextContent().trim();
            if (this.attPath.startsWith("/") || this.attPath.startsWith("\\")) break;
            this.attPath = this.rootDir + "/" + this.attPath;
            break;
        }
        if (this.attPath.length() > 0) {
            ZipArchiveEntry entry = file.getEntry(this.attPath);
            if (null == entry && this.attPath.startsWith("/")) {
                entry = file.getEntry(this.attPath.substring(this.attPath.indexOf(this.rootDir)));
            }
            Document d = this.entryToDocument(file, entry);
            this.parseAttachment(d.getDocumentElement());
        }
    }

    private Document entryToDocument(ZipFile file, ZipArchiveEntry entry) throws Exception {
        InputStream is = null;
        try {
            is = file.getInputStream(entry);
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setFeature("http://xml.org/sax/features/external-general-entities", false);
            fac.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            fac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document document = builder.parse(is);
            return document;
        }
        catch (Exception e) {
            log.info(e.toString());
            throw e;
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
    }

    private void parseAttachment(Node node) {
        if (node.getNodeType() != 1) {
            return;
        }
        NodeList nlist = node.getChildNodes();
        for (int j = 0; j < nlist.getLength(); ++j) {
            Node nd = nlist.item(j);
            if (nd.getNodeType() != 1) continue;
            String path = nd.getTextContent().trim();
            if (!path.startsWith("/") && !path.startsWith("\\")) {
                path = this.attPath.substring(0, this.attPath.lastIndexOf("/") + 1) + path;
            }
            if (this.attachments == null) {
                this.attachments = new ArrayList<String>();
            }
            if (path.startsWith("/") || path.startsWith("\\")) {
                path = path.substring(1);
            }
            this.attachments.add(path);
        }
    }

    public String extractOriginalXML(String ofdFilePath) throws Exception {
        ZipFile file = null;
        String xmlFullPath = "Doc_0/Attachs/original_invoice.xml";
        String xmlTempPath = System.getProperty("java.io.tmpdir") + File.separator + "original_invoice.xml";
        String xmlValue = "";
        try {
            file = this.loadOFD(ofdFilePath);
            this.extract(file, xmlFullPath, xmlTempPath);
            xmlValue = FileUtil.readFile(xmlTempPath);
        }
        catch (Exception e) {
            log.info(e.toString());
            throw e;
        }
        finally {
            if (null != file) {
                file.close();
            }
        }
        return xmlValue;
    }

    public VoucherFileInfo extractAttach(String ofdFilePath, String outputFile) throws Exception {
        ZipFile file = null;
        VoucherFileInfo voucherFileInfo = new VoucherFileInfo();
        try {
            file = this.loadOFD(ofdFilePath);
            if (this.attachments == null || file == null) {
                VoucherFileInfo voucherFileInfo2 = null;
                return voucherFileInfo2;
            }
            String outFilePath = outputFile;
            String voucherTypeValue = PropUtil.getPropValue("VoucherType", "VoucherType");
            String[] voucherTypeArray = voucherTypeValue.split(",");
            for (int i = 0; i < this.attachments.size(); ++i) {
                String fullPath = this.attachments.get(i);
                String fileName = fullPath.substring(fullPath.lastIndexOf("/") + 1);
                if (outFilePath == null || "".equals(outFilePath)) {
                    outFilePath = System.getProperty("java.io.tmpdir") + File.separator + fileName;
                }
                outFilePath = CleanPathUtil.cleanString(outFilePath);
                for (int j = 0; j < voucherTypeArray.length; ++j) {
                    if (!fileName.startsWith(voucherTypeArray[j])) continue;
                    this.extract(file, fullPath, outFilePath);
                    voucherFileInfo.setVoucherType(voucherTypeArray[j]);
                    voucherFileInfo.setXbrlFilePath(outFilePath);
                    VoucherFileInfo voucherFileInfo3 = voucherFileInfo;
                    return voucherFileInfo3;
                }
                if (this.attachments.size() - 1 != i) continue;
                voucherFileInfo.setXbrlFilePath(outFilePath);
                this.extract(file, fullPath, outFilePath);
            }
            VoucherFileInfo voucherFileInfo4 = voucherFileInfo;
            return voucherFileInfo4;
        }
        catch (Exception e) {
            log.info(e.toString());
            throw e;
        }
        finally {
            if (null != file) {
                file.close();
            }
        }
    }

    private void extract(ZipFile file, String fullPath, String outFilePath) throws IOException {
        ZipArchiveEntry entry = file.getEntry(fullPath);
        InputStream is = null;
        try {
            is = file.getInputStream(entry);
            FileTool.saveTo(is, outFilePath);
        }
        catch (IOException e) {
            log.info(e.toString());
            throw e;
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
    }
}

