/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder.EISValidate;

import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISValidate.MyTBS_Sign;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class MySES_Signature
extends ASN1Object {
    private MyTBS_Sign toSign;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signatureAlgID;
    private ASN1BitString signature;
    private ASN1BitString timeStamp;

    public MySES_Signature() {
    }

    public MySES_Signature(MyTBS_Sign toSign, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgID, ASN1BitString signature, ASN1BitString timeStamp) {
        this.toSign = toSign;
        this.cert = cert;
        this.signatureAlgID = signatureAlgID;
        this.signature = signature;
        this.timeStamp = timeStamp;
    }

    public MySES_Signature(ASN1Sequence seq) {
        Object obj;
        Enumeration e = seq.getObjects();
        this.toSign = MyTBS_Sign.getInstance(e.nextElement());
        this.cert = ASN1OctetString.getInstance(e.nextElement());
        this.signatureAlgID = ASN1ObjectIdentifier.getInstance(e.nextElement());
        this.signature = DERBitString.getInstance(e.nextElement());
        if (e.hasMoreElements() && (obj = e.nextElement()) instanceof ASN1TaggedObject) {
            this.timeStamp = DERBitString.getInstance((Object)((ASN1TaggedObject)obj).getObject());
        }
    }

    public static MySES_Signature getInstance(Object o) {
        if (o instanceof MySES_Signature) {
            return (MySES_Signature)((Object)o);
        }
        if (o instanceof byte[]) {
            ASN1InputStream aIn = new ASN1InputStream((byte[])o);
            try {
                ASN1Primitive obj = aIn.readObject();
                return new MySES_Signature(ASN1Sequence.getInstance((Object)obj));
            }
            catch (IOException var3) {
                throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636ev4 \u65e0\u6cd5\u89e3\u6790", var3);
            }
        }
        return o != null ? new MySES_Signature(ASN1Sequence.getInstance((Object)o)) : null;
    }

    public MyTBS_Sign getToSign() {
        return this.toSign;
    }

    public MySES_Signature setToSign(MyTBS_Sign toSign) {
        this.toSign = toSign;
        return this;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public MySES_Signature setCert(ASN1OctetString cert) {
        this.cert = cert;
        return this;
    }

    public MySES_Signature setCert(Certificate cert) throws CertificateEncodingException {
        this.cert = new DEROctetString(cert.getEncoded());
        return this;
    }

    public ASN1ObjectIdentifier getSignatureAlgID() {
        return this.signatureAlgID;
    }

    public MySES_Signature setSignatureAlgID(ASN1ObjectIdentifier signatureAlgID) {
        this.signatureAlgID = signatureAlgID;
        return this;
    }

    public ASN1BitString getSignature() {
        return this.signature;
    }

    public MySES_Signature setSignature(ASN1BitString signature) {
        this.signature = signature;
        return this;
    }

    public MySES_Signature setSignature(byte[] signature) {
        this.signature = new DERBitString(signature);
        return this;
    }

    public ASN1BitString getTimeStamp() {
        return this.timeStamp;
    }

    public MySES_Signature setTimeStamp(ASN1BitString timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(5);
        v.add((ASN1Encodable)this.toSign);
        v.add((ASN1Encodable)this.cert);
        v.add((ASN1Encodable)this.signatureAlgID);
        v.add((ASN1Encodable)this.signature);
        if (this.timeStamp != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)this.timeStamp));
        }
        return new DERSequence(v);
    }
}

