/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder;

import com.inspur.gs.xbrl.tools.webapi.CommUtils;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.ResourcesUtil;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.security.DigestAlgorithms;
import com.itextpdf.text.pdf.security.EncryptionAlgorithms;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CTPPDFSignatureVerifier {
    public static boolean verifySignature(InputStream is) {
        try {
            ResourcesUtil resourcesUtil = new ResourcesUtil();
            InputStream cetStream = resourcesUtil.getResourceByName("SM2\u6839\u8bc1\u4e66(\u4e13\u7f51).cer");
            String rootCertificateBase64 = "";
            if (cetStream != null) {
                rootCertificateBase64 = CommUtils.convertFileToBase64(cetStream);
            }
            if (is == null) {
                return false;
            }
            PdfReader reader = new PdfReader(is);
            Field digestNamesField = DigestAlgorithms.class.getDeclaredField("digestNames");
            digestNamesField.setAccessible(true);
            HashMap digestNames = (HashMap)digestNamesField.get(null);
            digestNames.put("1.2.156.10197.1.401", "SM3");
            Field algorithmNamesField = EncryptionAlgorithms.class.getDeclaredField("algorithmNames");
            algorithmNamesField.setAccessible(true);
            HashMap algorithmNames = (HashMap)algorithmNamesField.get(null);
            algorithmNames.put("1.2.156.10197.1.501", "SM2");
            AcroFields fields = reader.getAcroFields();
            ArrayList signatureNames = fields.getSignatureNames();
            for (String signatureName : signatureNames) {
                PdfPKCS7 pkcs7 = fields.verifySignature(signatureName);
                if (!pkcs7.verify()) {
                    throw new Exception("\u9a8c\u7b7e\u4e0d\u901a\u8fc7.");
                }
                System.out.println("\u9a8c\u7b7e\u901a\u8fc7.");
                Certificate[] chain = pkcs7.getCertificates();
                try {
                    for (Certificate certificate : chain) {
                        CTPPDFSignatureVerifier.verifyRootCert((X509Certificate)certificate, rootCertificateBase64);
                    }
                }
                catch (Exception e) {
                    throw new Exception("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5408\u6cd5");
                }
            }
            reader.close();
            return true;
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            return false;
        }
    }

    public static void verifyRootCert(X509Certificate signatureCertificate, String rootCertificateBase64) throws Exception {
        byte[] rootCertificate = Base64.getDecoder().decode(rootCertificateBase64);
        X509Certificate rootCert = CTPPDFSignatureVerifier.bytesToX509(rootCertificate);
        try {
            rootCert.checkValidity();
        }
        catch (Exception e) {
            throw new Exception("\u6839\u8bc1\u4e66\u4e0d\u5728\u6709\u6548\u671f\u5185\uff01");
        }
        try {
            signatureCertificate.checkValidity();
        }
        catch (Exception e) {
            throw new Exception("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5728\u6709\u6548\u671f\u5185\uff01");
        }
        try {
            signatureCertificate.verify(rootCert.getPublicKey());
        }
        catch (Exception e) {
            throw new Exception("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5408\u6cd5\uff01");
        }
    }

    public static X509Certificate bytesToX509(byte[] cert) throws Exception {
        X509Certificate x509Cert = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byteArrayInputStream = new ByteArrayInputStream(cert);
            x509Cert = (X509Certificate)cf.generateCertificate(byteArrayInputStream);
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25\uff01");
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return x509Cert;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

