/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.util;

import com.dianju.cz.base.DJCommonResponseException;
import com.dianju.cz.entity.CertInfo;
import com.dianju.cz.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertVerifyUtil {
    private static final Logger log = Logger.getLogger(CertVerifyUtil.class.toString());
    public static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();
    private static final CertificateFactory CF;

    public static void verifyCertificateChain(List<X509Certificate> certificates, X509Certificate waitCheck) {
        for (X509Certificate x509 : certificates) {
            Principal principalSubject = x509.getSubjectDN();
            if (!waitCheck.getIssuerDN().equals(principalSubject)) continue;
            try {
                PublicKey publickey = x509.getPublicKey();
                waitCheck.verify(publickey);
                return;
            }
            catch (Exception e) {
                throw new DJCommonResponseException("\u53ef\u4fe1\u8bc1\u4e66\u94fe\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7!");
            }
        }
        throw new DJCommonResponseException("\u7b7e\u7ae0\u8bc1\u4e66\u9881\u53d1\u8005\u4e0d\u5728\u53ef\u4fe1\u8bc1\u4e66\u94fe\u5217\u8868\u4e2d,\u9881\u53d1\u8005:" + waitCheck.getIssuerDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate parsCert(String cert) {
        X509Certificate x509Certificate = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(Util.decodeBase64(cert));
            x509Certificate = (X509Certificate)CF.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Util.closeStream(inputStream);
                throw throwable;
            }
            Util.closeStream(inputStream);
        }
        Util.closeStream(inputStream);
        return x509Certificate;
    }

    /*
     * Loose catch block
     */
    public static List<X509Certificate> parseUnknownFormatCertFile(File certFile, boolean checkDate) throws IOException {
        List<X509Certificate> list;
        if (!certFile.getName().endsWith(".cer") && !certFile.getName().endsWith(".p7b")) {
            log.info("\u672a\u77e5\u7684\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f:" + certFile.getName());
            return new ArrayList<X509Certificate>();
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(certFile);
            list = CertVerifyUtil.parsCertFile(fis, certFile.getName(), checkDate);
        }
        catch (CertificateException e) {
            byte[] certData = Util.decodeBase64(new String(Util.readFileData(certFile)));
            ByteArrayInputStream bis = null;
            bis = new ByteArrayInputStream(certData);
            List<X509Certificate> list2 = CertVerifyUtil.parsCertFile(bis, certFile.getName(), checkDate);
            Util.closeStream(bis);
            Util.closeStream(fis);
            return list2;
            {
                catch (CertificateException ex) {
                    try {
                        try {
                            throw new RuntimeException(ex);
                        }
                        catch (Throwable throwable) {
                            Util.closeStream(bis);
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        Util.closeStream(fis);
                        throw throwable;
                    }
                }
            }
        }
        Util.closeStream(fis);
        return list;
    }

    public static List<X509Certificate> parsCertFile(InputStream fis, String fileName, boolean checkDate) throws CertificateException {
        Date now = new Date();
        List<X509Certificate> certificates = new ArrayList<X509Certificate>();
        if (fileName.endsWith(".cer")) {
            X509Certificate cert = (X509Certificate)CF.generateCertificate(fis);
            if (checkDate) {
                try {
                    cert.checkValidity(now);
                }
                catch (GeneralSecurityException e) {
                    throw new DJCommonResponseException("\u6839\u8bc1\u4e66\u65e0\u6548:" + cert.getSubjectDN() + ":" + cert.getNotBefore() + "-" + cert.getNotAfter());
                }
            }
            certificates.add(cert);
        } else if (fileName.endsWith(".p7b")) {
            certificates = (List)CF.generateCertificates(fis);
            if (checkDate) {
                for (X509Certificate x509 : certificates) {
                    try {
                        x509.checkValidity(now);
                    }
                    catch (CertificateExpiredException e) {
                        throw new DJCommonResponseException("\u6839\u8bc1\u4e66\u65e0\u6548:" + x509.getSubjectDN() + ":" + x509.getNotBefore() + "-" + x509.getNotAfter());
                    }
                    catch (CertificateNotYetValidException e) {
                        throw new DJCommonResponseException("\u6839\u8bc1\u4e66\u65e0\u6548:" + x509.getSubjectDN() + ":" + x509.getNotBefore() + "-" + x509.getNotAfter());
                    }
                }
            }
        } else {
            log.info("\u672a\u77e5\u7684\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f:" + fileName);
        }
        return certificates;
    }

    public static X509Certificate getX509Certificate(byte[] certBytes) throws CertificateException {
        X509Certificate x509Certificate;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(certBytes);
            x509Certificate = (X509Certificate)CF.generateCertificate(is);
        }
        catch (Throwable throwable) {
            Util.closeStream(is);
            throw throwable;
        }
        Util.closeStream(is);
        return x509Certificate;
    }

    public static CertInfo getCertInfoFromX509Certificate(X509Certificate x509Cert) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CertInfo certInfo = new CertInfo();
        certInfo.setSn(x509Cert.getSerialNumber().toString(16));
        certInfo.setDn(x509Cert.getSubjectDN().toString());
        certInfo.setBeginTime(dateFormat.format(x509Cert.getNotBefore()));
        certInfo.setEndTime(dateFormat.format(x509Cert.getNotAfter()));
        certInfo.setIssuerDn(x509Cert.getIssuerDN().toString());
        certInfo.setAlg(x509Cert.getSigAlgName());
        return certInfo;
    }

    static {
        try {
            CF = CertificateFactory.getInstance("X.509", (Provider)BC_PROVIDER);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

