/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.pl.xbrl.util;

import com.dianju.cz.pl.xbrl.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public class PropUtil {
    public static HashMap<String, Properties> propFileMap = null;
    private static Logger log = Logger.getLogger(PropUtil.class.toString());

    public static Properties getPropObject(String propFileName) {
        if (propFileMap == null || !propFileMap.containsKey(propFileName)) {
            PropUtil.initFileMap(propFileName);
        }
        return propFileMap.get(propFileName);
    }

    public static String getPropValue(String propFilename, String key) {
        return PropUtil.getPropValue(propFilename, key, "");
    }

    public static String getPropValue(String propFilename, String key, String defValue) {
        Properties propObject = PropUtil.getPropObject(propFilename);
        if (propObject == null) {
            return defValue;
        }
        String retValue = propObject.getProperty(key);
        if (!StringUtil.isBlank(retValue)) {
            return retValue;
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initFileMap(String fileName) {
        if (StringUtil.isBlank(fileName)) {
            return;
        }
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = PropUtil.class.getClassLoader().getResourceAsStream(fileName + ".properties");
            properties.load(in);
            if (propFileMap == null) {
                propFileMap = new HashMap();
            }
            propFileMap.put(fileName, properties);
            if (null == in) return;
        }
        catch (IOException e) {
            try {
                log.info(e.toString());
                if (null == in) return;
            }
            catch (Throwable throwable) {
                if (null == in) throw throwable;
                PropUtil.safeCloseInputStream(in);
                throw throwable;
            }
            PropUtil.safeCloseInputStream(in);
            return;
        }
        PropUtil.safeCloseInputStream(in);
        return;
    }

    public static void safeCloseInputStream(InputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        }
    }
}

