/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.api;

import com.alibaba.fastjson.JSONObject;
import com.dianju.cz.api.XbrlUtil;
import com.dianju.cz.base.DJCommonResponseException;
import com.dianju.cz.base.ExceptionEnum;
import com.dianju.cz.base.Response;
import com.dianju.cz.entity.SysVerifyInfo;
import com.dianju.cz.entity.VerifySignInfo;
import com.dianju.cz.entity.VerifyVO;
import com.dianju.cz.entity.VoucherFileInfo;
import com.dianju.cz.pl.xbrl.util.PropUtil;
import com.dianju.cz.pl.xbrl.util.StringUtil;
import com.dianju.cz.util.CertVerifyUtil;
import com.dianju.cz.util.SM2Util;
import com.dianju.cz.util.Util;
import com.dianju.cz.util.XmlUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.CollectionStore;
import org.djdom4j.Element;
import org.djdom4j.io.SAXReader;
import srvSeal.SrvSealUtil;

public class EVoucherFileUtil {
    private static final Logger log = Logger.getLogger(EVoucherFileUtil.class.toString());
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    private static SrvSealUtil srvSealUtil;
    private static final Map<String, String> ISSUER_MAP;
    private static final Pattern VERIFY_RES_REG;

    private EVoucherFileUtil() {
    }

    public static void setSrvSealUtil(String soPath) {
        srvSealUtil = SrvSealUtil.installSrvSealUtil(soPath);
    }

    public static void initCertChainCache(String certChainDir) {
        ISSUER_MAP.clear();
        log.info("\u521d\u59cb\u5316\u8bc1\u4e66\u94fe\u6587\u4ef6\u7f13\u5b58:" + certChainDir);
        File certChainPath = new File(certChainDir);
        File[] certs = certChainPath.listFiles();
        if (null == certs) {
            log.info("\u8bc1\u4e66\u94fe\u76ee\u5f55\u4e0b\u4e0d\u5b58\u5728\u8bc1\u4e66\u6587\u4ef6:path=" + certChainDir);
            return;
        }
        log.info("\u521d\u59cb\u5316\u8bc1\u4e66\u94fe\u6587\u4ef6\u7f13\u5b58:\u8def\u5f84=" + certChainDir + ",\u6570\u91cf=" + certs.length);
        for (File cert : certs) {
            if (!cert.getName().endsWith(".cer") && !cert.getName().endsWith(".p7b")) {
                log.info("\u672a\u77e5\u7684\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f:" + cert.getName());
                continue;
            }
            log.info("\u89e3\u6790\u8bc1\u4e66\u6587\u4ef6:" + cert.getName());
            List<X509Certificate> certificates = null;
            try {
                certificates = CertVerifyUtil.parseUnknownFormatCertFile(cert, false);
            }
            catch (IOException e) {
                throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
            }
            for (X509Certificate x509 : certificates) {
                String dn = x509.getSubjectDN().getName();
                EVoucherFileUtil.verifyCertChainCache(cert, dn);
                ISSUER_MAP.put(dn, cert.getAbsolutePath());
            }
        }
        log.info("\u521d\u59cb\u5316\u8bc1\u4e66\u94fe\u6587\u4ef6\u7f13\u5b58\u5b8c\u6210!");
    }

    public static Response<?> getXbrlFromFile(String oriFilePath) {
        EVoucherFileUtil.checkInit();
        try {
            return EVoucherFileUtil.getXbrlData(oriFilePath);
        }
        catch (DJCommonResponseException e) {
            return Response.of(400, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.of(1000, "\u5904\u7406\u9644\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Response<String> exportXbrlFromFile(String oriFilePath, String targetFilePath) {
        EVoucherFileUtil.checkInit();
        Response<String> xbrlData = EVoucherFileUtil.getXbrlData(oriFilePath);
        if (xbrlData.getCode() != 1) {
            return xbrlData;
        }
        VoucherFileInfo info = (VoucherFileInfo)((Object)xbrlData.getData());
        byte[] xmlData = info.getXbrlData().getBytes("UTF-8");
        FileOutputStream fos = null;
        BufferedOutputStream os = null;
        try {
            fos = new FileOutputStream(targetFilePath);
            os = new BufferedOutputStream(fos);
            os.write(xmlData);
        }
        catch (Exception e) {
            Response<String> response;
            try {
                e.printStackTrace();
                response = Response.of(1011, "\u751f\u6210\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    Util.closeStream(os);
                    Util.closeStream(fos);
                    throw throwable;
                }
                catch (DJCommonResponseException e2) {
                    return Response.of(400, e2.getMessage());
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    return Response.of(1000, "\u5904\u7406\u9644\u4ef6\u53d1\u751f\u5f02\u5e38:" + e3.getMessage());
                }
            }
            Util.closeStream(os);
            Util.closeStream(fos);
            return response;
        }
        Util.closeStream(os);
        Util.closeStream(fos);
        return Response.of(1, info.getVoucherType());
    }

    public static boolean verifyXmlAndSign(String zipFilePath) throws IOException {
        EVoucherFileUtil.checkInit();
        Map<String, String> zipFiles = EVoucherFileUtil.getZipFiles(zipFilePath);
        return EVoucherFileUtil.verifyXmlAndSign(zipFiles);
    }

    public static boolean verifyXmlAndSign(byte[] zipFileBytes) {
        EVoucherFileUtil.checkInit();
        Map<String, String> zipFiles = EVoucherFileUtil.getZipFiles(zipFileBytes);
        return EVoucherFileUtil.verifyXmlAndSign(zipFiles);
    }

    public static VerifySignInfo djVerifyXmlAndSignWithInfo(String zipFileBytes) throws IOException {
        EVoucherFileUtil.checkInit();
        Map<String, String> zipFiles = EVoucherFileUtil.getZipFiles(zipFileBytes);
        return EVoucherFileUtil.djVerifyXmlAndSignWithInfo(zipFiles);
    }

    public static VerifySignInfo djVerifyXmlAndSignWithInfo(byte[] zipFileBytes) {
        EVoucherFileUtil.checkInit();
        Map<String, String> zipFiles = EVoucherFileUtil.getZipFiles(zipFileBytes);
        return EVoucherFileUtil.djVerifyXmlAndSignWithInfo(zipFiles);
    }

    public static boolean verifyXmlAndSign(String signedValue, String xmlData) {
        boolean ret;
        EVoucherFileUtil.checkInit();
        if (signedValue == null || "".equals(signedValue) || xmlData == null || "".equals(xmlData)) {
            log.info("\u53c2\u6570\u9519\u8bef");
            return false;
        }
        try {
            byte[] srcData = xmlData.getBytes();
            ret = SM2Util.verifyP7(srcData, Util.decodeBase64(signedValue));
            log.info("ret:" + ret);
            if (!ret) {
                srcData = xmlData.getBytes("UTF-8");
                ret = SM2Util.verifyP7(srcData, Util.decodeBase64(signedValue));
                log.info("ret2:" + ret);
                if (!ret) {
                    srcData = xmlData.getBytes("GBK");
                    ret = SM2Util.verifyP7(srcData, Util.decodeBase64(signedValue));
                    log.info("ret3:" + ret);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VerifySignInfo djVerifyXmlAndSignWithInfo(String signedValue, String xmlData) {
        EVoucherFileUtil.checkInit();
        if (signedValue == null || "".equals(signedValue) || xmlData == null || "".equals(xmlData)) {
            log.info("\u53c2\u6570\u9519\u8bef");
            throw new DJCommonResponseException("\u53c2\u6570\u9519\u8bef");
        }
        boolean ret = false;
        byte[] srcData = xmlData.getBytes();
        try {
            ret = SM2Util.verifyP7(srcData, Util.decodeBase64(signedValue));
            log.info("ret:" + ret);
            if (!ret) {
                srcData = xmlData.getBytes("UTF-8");
                ret = SM2Util.verifyP7(srcData, Util.decodeBase64(signedValue));
                log.info("ret2:" + ret);
                if (!ret) {
                    srcData = xmlData.getBytes("GBK");
                    ret = SM2Util.verifyP7(srcData, Util.decodeBase64(signedValue));
                    log.info("ret3:" + ret);
                }
            }
            ByteArrayInputStream inStream = null;
            try {
                inStream = new ByteArrayInputStream(Util.decodeBase64(signedValue));
                CMSSignedData cmsSingedData = new CMSSignedData((InputStream)inStream);
                CollectionStore x509s = (CollectionStore)cmsSingedData.getCertificates();
                X509CertificateHolder holder = (X509CertificateHolder)x509s.iterator().next();
                X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(holder);
                VerifySignInfo verifySignInfo = new VerifySignInfo(ret, cert);
                return verifySignInfo;
            }
            catch (Exception e) {
                log.warning("\u9a8c\u8bc1\u8fc7\u7a0b\u5f02\u5e38:\u9a8c\u7b7e\u5931\u8d25:" + e.getMessage());
                return new VerifySignInfo(ret, null);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return new VerifySignInfo(ret, null);
    }

    public static VerifyVO djVerifyFileWithInfo(String filePath) {
        return EVoucherFileUtil.djVerifyFileWithInfo(filePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerifyVO djVerifyFileWithInfo(String filePath, boolean verifyCert) {
        EVoucherFileUtil.checkInit();
        EVoucherFileUtil.filePathCheck(filePath);
        int nObjId = 0;
        try {
            nObjId = EVoucherFileUtil.ocxOpenObj(filePath);
            String verifyRes = EVoucherFileUtil.getVerifyInfo(nObjId);
            if (null == verifyRes || verifyRes.isEmpty()) {
                if (filePath.endsWith(".pdf") || filePath.equals(".PDF")) {
                    boolean pass = EVoucherFileUtil.verifyHn(filePath);
                    VerifyVO verifyVO = new VerifyVO(pass);
                    return verifyVO;
                }
                throw new DJCommonResponseException("\u9a8c\u8bc1\u8fc7\u7a0b\u5f02\u5e38:\u9a8c\u8bc1\u7ed3\u679c\u4e3a\u7a7a");
            }
            List<SysVerifyInfo> infos = EVoucherFileUtil.parseVerifyDataWithInfo(verifyRes);
            EVoucherFileUtil.relateInfo(nObjId, infos);
            EVoucherFileUtil.verifyCertAndSetInfo(nObjId, infos, verifyCert);
            String infosJson = JSONObject.toJSONString(infos);
            List sysVerifyInfos = JSONObject.parseArray((String)infosJson, SysVerifyInfo.class);
            VerifyVO verifyVO = new VerifyVO(sysVerifyInfos, verifyCert);
            return verifyVO;
        }
        finally {
            EVoucherFileUtil.closeFile(nObjId);
        }
    }

    public static Response<String> verifyFile(String filePath) {
        return EVoucherFileUtil.verifyFile(filePath, false);
    }

    public static Response<String> verifyFile(String filePath, boolean verifyCert) {
        EVoucherFileUtil.checkInit();
        try {
            EVoucherFileUtil.filePathCheck(filePath);
            String ret = EVoucherFileUtil.verify(filePath, verifyCert);
            if (ret.equals("\u6587\u6863\u9a8c\u8bc1\u901a\u8fc7")) {
                return new Response<String>(1, ret);
            }
            return new Response<String>(0, ret);
        }
        catch (DJCommonResponseException e) {
            if (e.getMessage().contains("\u7b7e\u7ae0\u8bc1\u4e66\u9881\u53d1\u8005\u4e0d\u5728\u53ef\u4fe1\u8bc1\u4e66\u94fe\u5217\u8868\u4e2d")) {
                return Response.of(1401, e.getMessage());
            }
            log.info("\u9a8c\u8bc1\u6587\u6863:" + filePath + ":" + e.getMessage());
            return Response.of(400, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.of(1000, "\u5904\u7406\u9644\u4ef6\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
        }
    }

    public static JSONObject xbrl2Json(String xbrlXml, String configId) {
        EVoucherFileUtil.checkInit();
        return XbrlUtil.xbrl2Json(xbrlXml, configId);
    }

    private static boolean isXbrl(String xml) {
        return xml.endsWith("</xbrli:xbrl>") || xml.endsWith("</xbrl");
    }

    public static JSONObject xml2Json(String xml) {
        EVoucherFileUtil.checkInit();
        return XbrlUtil.xml2Json(xml);
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        EVoucherFileUtil.checkInit();
        return XbrlUtil.json2Xbrl(jsonValue, configId);
    }

    private static void verifyCertChainCache(File cert, String dn) {
        if (ISSUER_MAP.containsKey(dn)) {
            log.info("\u8bc1\u4e66\u94feDN=" + dn + "\u5bf9\u5e94\u591a\u4e2a\u6587\u4ef6,[" + ISSUER_MAP.get(dn) + "],[" + cert.getAbsolutePath() + "]");
            throw new DJCommonResponseException("\u8bc1\u4e66\u94feDN=" + dn + "\u5bf9\u5e94\u591a\u4e2a\u6587\u4ef6,[" + ISSUER_MAP.get(dn) + "],[" + cert.getName() + "]");
        }
    }

    private static void verifyCertIsTrust(String cert) {
        if (null == cert || "".equals(cert)) {
            log.info("\u7b7e\u7ae0\u8bc1\u4e66\u4e3a\u7a7a");
            return;
        }
        log.info("\u9a8c\u8bc1\u7b7e\u7ae0\u8bc1\u4e66\u6709\u6548\u6027");
        X509Certificate x509 = CertVerifyUtil.parsCert(cert);
        String dn = x509.getIssuerDN().getName();
        if (!ISSUER_MAP.containsKey(dn)) {
            throw new DJCommonResponseException("\u7b7e\u7ae0\u8bc1\u4e66\u9881\u53d1\u8005\u4e0d\u5728\u53ef\u4fe1\u8bc1\u4e66\u94fe\u5217\u8868\u4e2d,\u9881\u53d1\u8005:" + dn);
        }
        String certChainPath = ISSUER_MAP.get(dn);
        log.info("\u7b7e\u7ae0\u8bc1\u4e66\u9881\u53d1\u8005DN:" + dn + ",\u5bf9\u5e94:" + certChainPath);
        List<X509Certificate> certificates = null;
        try {
            certificates = CertVerifyUtil.parseUnknownFormatCertFile(new File(certChainPath), false);
        }
        catch (IOException e) {
            throw new DJCommonResponseException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
        }
        CertVerifyUtil.verifyCertificateChain(certificates, x509);
        log.info("\u9a8c\u8bc1\u7b7e\u7ae0\u8bc1\u4e66\u6709\u6548\u6027\u901a\u8fc7");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Response<?> getXbrlData(String oriFilePath) {
        Iterator iterator;
        Serializable xbrlDataList;
        String voucherType;
        int nObjId;
        block26: {
            EVoucherFileUtil.filePathCheck(oriFilePath);
            nObjId = 0;
            try {
                String xmlZip;
                block25: {
                    nObjId = EVoucherFileUtil.ocxOpenObj(oriFilePath);
                    String xmlAttachList = EVoucherFileUtil.saveAttachmentListToXml(nObjId);
                    voucherType = "";
                    if (oriFilePath.endsWith(".pdf")) {
                        voucherType = "ntrev_gpm_issuer";
                    }
                    if (null != xmlAttachList && !"".equals(xmlAttachList) && !xmlAttachList.startsWith("errorcode")) {
                        try {
                            if (!xmlAttachList.contains("<attachmentinf")) break block25;
                            List attachmentList = new SAXReader().read(new StringReader(xmlAttachList)).getRootElement().elements("attachmentinf");
                            xbrlDataList = new ArrayList();
                            iterator = attachmentList.iterator();
                            break block26;
                        }
                        catch (Exception e) {
                            log.info("get voucherType err :" + e.getLocalizedMessage() + ",xmlAttachList:" + xmlAttachList);
                        }
                    }
                }
                if ((xmlZip = EVoucherFileUtil.getDocProperty(nObjId, "hidexml")) == null || "".equals(xmlZip) || xmlZip.startsWith("errorcode")) {
                    log.info(oriFilePath + " \u83b7\u53d6\u9644\u4ef6\u4e3a\u7a7a");
                    xbrlDataList = Response.of(1002, "\u6587\u4ef6\u4e2d\u6ca1\u6709xbrl\u9644\u4ef6");
                    return xbrlDataList;
                }
                byte[] xmlData = EVoucherFileUtil.unzip(xmlZip);
                String xmlDataStr = new String(xmlData, "UTF-8");
                if (!EVoucherFileUtil.isXbrl(xmlDataStr) && oriFilePath.endsWith("pdf")) {
                    voucherType = "efi";
                }
                Response<VoucherFileInfo> response = new Response<VoucherFileInfo>(1, VoucherFileInfo.buildByData(voucherType, xmlDataStr));
                return response;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            finally {
                EVoucherFileUtil.closeFile(nObjId);
            }
        }
        while (iterator.hasNext()) {
            byte[] xmlData;
            String[] voucherTypeArray;
            Object o = iterator.next();
            Element ele = (Element)o;
            String attachName = ele.attributeValue("name");
            String xmlId = ele.attributeValue("id");
            String voucherTypeValue = PropUtil.getPropValue("VoucherType", "VoucherType");
            for (String type : voucherTypeArray = voucherTypeValue.split(",")) {
                if (!attachName.startsWith(type)) continue;
                voucherType = type;
                break;
            }
            if (StringUtil.isBlank(voucherType)) {
                attachName = ele.attributeValue("file");
                for (String type : voucherTypeArray) {
                    if (!attachName.startsWith(type)) continue;
                    voucherType = type;
                    break;
                }
            }
            if (StringUtil.isBlank(voucherType)) {
                int pos2;
                voucherType = attachName.contains("_") ? ((pos2 = attachName.indexOf("_", attachName.indexOf("_") + 1)) > 0 ? attachName.substring(0, pos2) : attachName) : attachName;
            }
            if (voucherType.contains(".")) {
                voucherType = voucherType.substring(0, voucherType.indexOf("."));
            }
            if (null == (xmlData = EVoucherFileUtil.getAttachData(nObjId, Integer.parseInt(xmlId))) || xmlData.length == 0) {
                log.info(oriFilePath + " \u83b7\u53d6xbrl\u6570\u636e\u4e3a\u7a7a,xmlId=" + xmlId);
                return Response.of(1003, "\u6587\u4ef6\u4e2d\u83b7\u53d6\u5230\u7684xbrl\u6570\u636e\u4e3a\u7a7a");
            }
            String xbrlData = new String(xmlData, "UTF-8");
            if (!xbrlData.startsWith("<")) {
                xmlData = EVoucherFileUtil.unzip(xmlData, "hidexml.xml");
            }
            if (null == xmlData) {
                return Response.of(1003, "\u6587\u4ef6\u4e2d\u83b7\u53d6\u5230\u7684xbrl\u6570\u636e\u4e3a\u7a7a");
            }
            String xmlDataStr = new String(xmlData, "UTF-8");
            if (!EVoucherFileUtil.isXbrl(xmlDataStr) && oriFilePath.endsWith("pdf")) {
                voucherType = "efi";
            }
            xbrlDataList.add((String)xmlDataStr);
        }
        return new Response<VoucherFileInfo>(1, VoucherFileInfo.buildByData(voucherType, xbrlDataList));
    }

    private static boolean verifyXmlAndSign(Map<String, String> zipFileMap) {
        String signedValue = "";
        String xmlData = "";
        for (Map.Entry<String, String> entry : zipFileMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.endsWith(".xml")) {
                xmlData = value;
                continue;
            }
            signedValue = value;
        }
        return EVoucherFileUtil.verifyXmlAndSign(signedValue, xmlData);
    }

    private static VerifySignInfo djVerifyXmlAndSignWithInfo(Map<String, String> zipFileMap) {
        String signedValue = "";
        String xmlData = "";
        for (Map.Entry<String, String> entry : zipFileMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.endsWith(".xml")) {
                xmlData = value;
                continue;
            }
            signedValue = value;
        }
        return EVoucherFileUtil.djVerifyXmlAndSignWithInfo(signedValue, xmlData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String verify(String filePath, boolean verifyCert) {
        int nObjId = 0;
        try {
            nObjId = EVoucherFileUtil.ocxOpenObj(filePath);
            String verifyRes = EVoucherFileUtil.getVerifyInfo(nObjId);
            if (null == verifyRes || verifyRes.isEmpty()) {
                if (filePath.endsWith(".pdf") || filePath.equals(".PDF")) {
                    boolean pass = EVoucherFileUtil.verifyHn(filePath);
                    String string = pass ? "\u6587\u6863\u9a8c\u8bc1\u901a\u8fc7" : "\u6587\u6863\u9a8c\u8bc1\u4e0d\u901a\u8fc7";
                    return string;
                }
                throw new DJCommonResponseException("\u9a8c\u8bc1\u8fc7\u7a0b\u5f02\u5e38:\u9a8c\u8bc1\u7ed3\u679c\u4e3a\u7a7a");
            }
            EVoucherFileUtil.parseVerifyData(verifyRes);
            if (verifyCert) {
                EVoucherFileUtil.verifyCert(nObjId);
            }
            String string = "\u6587\u6863\u9a8c\u8bc1\u901a\u8fc7";
            return string;
        }
        finally {
            EVoucherFileUtil.closeFile(nObjId);
        }
    }

    private static void relateInfo(int nObjId, List<SysVerifyInfo> verifyVOList) {
        if (IS_WINDOWS) {
            HashMap<String, SysVerifyInfo> verifyInfoMap = new HashMap<String, SysVerifyInfo>();
            for (SysVerifyInfo sealInfo : verifyVOList) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                String creTime = dateFormat.format(sealInfo.getCreTm());
                String sealKey = sealInfo.getNodeId() + "|" + creTime + "|" + sealInfo.getNodeName() + "|" + sealInfo.getPos();
                verifyInfoMap.put(sealKey, sealInfo);
            }
            int sealNum = srvSealUtil.getNodeNum(nObjId, 251);
            for (int i = 0; i < sealNum; ++i) {
                String interId = srvSealUtil.getNoteByIndex(nObjId, i, 251);
                if ("".equals(interId) || interId.startsWith("error")) {
                    throw new IllegalArgumentException("\u83b7\u53d6\u6587\u6863\u5185\u7535\u5b50\u5370\u7ae0\u6570\u636e\u5931\u8d25:" + interId);
                }
                String sealId = srvSealUtil.getValueEx(nObjId, interId, 32, "", 0, "");
                String sealDate = srvSealUtil.getValueEx(nObjId, interId, 27, "", 0, "");
                String sealName = srvSealUtil.getValueEx(nObjId, interId, 33, "", 0, "");
                String pos = srvSealUtil.getValueEx(nObjId, interId, 127, "", 0, "");
                String[] posArr = pos.split(",");
                pos = posArr[2] + "," + posArr[3] + "," + posArr[4] + "," + posArr[5] + "," + posArr[6];
                String sealKey = sealId + "|" + sealDate + "|" + sealName + "|" + pos;
                SysVerifyInfo sysVerifyInfo = (SysVerifyInfo)verifyInfoMap.get(sealKey);
                if (sysVerifyInfo == null) {
                    log.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9a8c\u8bc1\u4fe1\u606f:" + sealKey);
                    throw new IllegalArgumentException("\u83b7\u53d6\u6587\u6863\u9a8c\u8bc1\u4fe1\u606f\u5931\u8d25:" + sealName);
                }
                if (null != sysVerifyInfo.getInterId()) continue;
                sysVerifyInfo.setInterId(interId);
            }
        }
    }

    private static void verifyCertAndSetInfo(int nObjId, List<SysVerifyInfo> verifyVOList, boolean verifyCert) {
        for (SysVerifyInfo info : verifyVOList) {
            try {
                String certPublicKey = srvSealUtil.getValueEx(nObjId, info.getInterId(), 39, "", 0, "");
                if ("".equals(certPublicKey) || certPublicKey.startsWith("error")) {
                    throw new IllegalArgumentException("\u83b7\u53d6\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25");
                }
                X509Certificate x509Certificate = CertVerifyUtil.getX509Certificate(Base64.decodeBase64((String)certPublicKey));
                info.setSigner(CertVerifyUtil.getCertInfoFromX509Certificate(x509Certificate));
                Date creTm = info.getCreTm();
                Date begin = x509Certificate.getNotBefore();
                Date end = x509Certificate.getNotAfter();
                if (creTm.before(begin) || creTm.after(end)) {
                    info.setCertStatus("\u8bc1\u4e66\u4e0d\u5728\u6709\u6548\u671f\u5185");
                    continue;
                }
                if (verifyCert) {
                    EVoucherFileUtil.verifyCertIsTrust(certPublicKey);
                }
                info.setCertStatus("true");
            }
            catch (IllegalArgumentException e) {
                info.setCertStatus("\u7b7e\u7ae0\u8bc1\u4e66\u9a8c\u8bc1\u4e0d\u901a\u8fc7:" + e.getMessage());
            }
            catch (DJCommonResponseException e) {
                info.setCertStatus("\u7b7e\u7ae0\u8bc1\u4e66\u9a8c\u8bc1\u4e0d\u901a\u8fc7:" + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("[" + info.getNodeName() + "][" + info.getInterId() + "][" + info.getNodeId() + "]\u89e3\u6790\u7b7e\u7ae0\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25!");
                info.setCertStatus("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25");
            }
        }
    }

    private static void verifyCert(int openObj) {
        int nodeNum = EVoucherFileUtil.getNodeNum(openObj, 251);
        if (nodeNum <= 0) {
            throw new DJCommonResponseException("\u8be5\u6587\u6863\u4e0d\u5b58\u5728\u7535\u5b50\u5370\u7ae0:" + nodeNum);
        }
        for (int i = 0; i < nodeNum; ++i) {
            String m = EVoucherFileUtil.getNoteByIndex(openObj, i, 251);
            String certData = srvSealUtil.getValueEx(openObj, m, 39, "", 0, "");
            if (null == certData || "".equals(certData)) {
                throw new DJCommonResponseException("\u83b7\u53d6\u6587\u6863\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25:" + m);
            }
            if (certData.startsWith("errorcode")) {
                throw new DJCommonResponseException("\u83b7\u53d6\u6587\u6863\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25:" + certData);
            }
            EVoucherFileUtil.verifyCertIsTrust(certData);
        }
    }

    private static String getVerifyInfo(int openObj) {
        if (IS_WINDOWS) {
            return srvSealUtil.verify(openObj);
        }
        StringBuilder s = new StringBuilder();
        String sealVal = "";
        while (!"".equals(sealVal = srvSealUtil.getNextSeal(openObj, sealVal))) {
            String verifyRet = srvSealUtil.verifySeal(openObj, sealVal);
            s.append(verifyRet);
        }
        return s.toString();
    }

    private static void filePathCheck(String filePath) throws DJCommonResponseException {
        if (null == filePath || "".equals(filePath)) {
            throw new DJCommonResponseException("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff0c\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", ExceptionEnum.PATH_ERR.getKey());
        }
        if (!(filePath.endsWith(".ofd") || filePath.endsWith(".OFD") || filePath.endsWith(".pdf") || filePath.endsWith(".PDF"))) {
            throw new DJCommonResponseException("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff0c\u6587\u4ef6\u9700\u8981pdf\u6216ofd\u683c\u5f0f", ExceptionEnum.PATH_ERR.getKey());
        }
    }

    private static Map<String, String> getZipFiles(String zipPath) throws IOException {
        Map<String, String> map;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(zipPath);
            map = EVoucherFileUtil.getZipFiles(fis);
        }
        catch (Throwable throwable) {
            Util.closeStream(fis);
            throw throwable;
        }
        Util.closeStream(fis);
        return map;
    }

    private static Map<String, String> getZipFiles(byte[] zipBytes) {
        Map<String, String> map;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(zipBytes);
            map = EVoucherFileUtil.getZipFiles(bis);
        }
        catch (Throwable throwable) {
            Util.closeStream(bis);
            throw throwable;
        }
        Util.closeStream(bis);
        return map;
    }

    private static Map<String, String> getZipFiles(InputStream inputStream) {
        HashMap<String, String> hashMap;
        ZipInputStream zi = null;
        InputStreamReader reader = null;
        BufferedReader bReader = null;
        try {
            ZipEntry entry;
            zi = new ZipInputStream(inputStream);
            reader = new InputStreamReader((InputStream)zi, "UTF-8");
            bReader = new BufferedReader(reader);
            HashMap<String, String> ret = new HashMap<String, String>();
            while ((entry = zi.getNextEntry()) != null) {
                String line;
                StringBuilder s = new StringBuilder();
                while ((line = bReader.readLine()) != null) {
                    s.append(line);
                }
                ret.put(entry.getName(), s.toString());
            }
            hashMap = ret;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Util.closeStream(bReader);
                Util.closeStream(reader);
                Util.closeStream(zi);
                throw throwable;
            }
        }
        Util.closeStream(bReader);
        Util.closeStream(reader);
        Util.closeStream(zi);
        return hashMap;
    }

    private static byte[] unzip(String str) {
        byte[] byArray;
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bis = null;
        GZIPInputStream gzip = null;
        try {
            int n;
            bos = new ByteArrayOutputStream();
            bis = new ByteArrayInputStream(Util.decodeBase64(str));
            gzip = new GZIPInputStream(bis);
            byte[] buffer = new byte[4096];
            while ((n = gzip.read(buffer)) >= 0) {
                bos.write(buffer, 0, n);
            }
            byArray = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Util.closeStream(gzip);
                Util.closeStream(bis);
                Util.closeStream(bos);
                throw throwable;
            }
        }
        Util.closeStream(gzip);
        Util.closeStream(bis);
        Util.closeStream(bos);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] unzip(byte[] zipFile, String path) {
        ByteArrayOutputStream outputStream;
        ZipInputStream zis;
        ByteArrayInputStream bis;
        block8: {
            byte[] byArray;
            block7: {
                bis = null;
                zis = null;
                outputStream = null;
                try {
                    ZipEntry ze;
                    bis = new ByteArrayInputStream(zipFile);
                    zis = new ZipInputStream(bis);
                    outputStream = new ByteArrayOutputStream();
                    while ((ze = zis.getNextEntry()) != null) {
                        int bytesRead;
                        if (ze.isDirectory() || !path.equals(ze.getName())) continue;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = zis.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        byArray = outputStream.toByteArray();
                        Util.closeStream(outputStream);
                        break block7;
                    }
                    Util.closeStream(outputStream);
                    break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Util.closeStream(zis);
            Util.closeStream(bis);
            return byArray;
        }
        Util.closeStream(zis);
        Util.closeStream(bis);
        return null;
        finally {
            Util.closeStream(outputStream);
            Util.closeStream(zis);
            Util.closeStream(bis);
        }
    }

    private static void parseVerifyData(String verifyData) {
        Matcher matcher = VERIFY_RES_REG.matcher(verifyData);
        ArrayList<String> verifyRes = new ArrayList<String>();
        while (matcher.find()) {
            verifyRes.add(matcher.group(1));
        }
        for (String seal : verifyRes) {
            for (String value : seal.split("/;")) {
                int pos = value.indexOf("=");
                String k = value.substring(0, pos);
                String v = value.substring(pos + 1);
                if (!"RetCode".equals(k) || "0".equals(v)) continue;
                throw new DJCommonResponseException("\u6587\u6863\u9a8c\u8bc1\u4e0d\u901a\u8fc7:" + v);
            }
        }
    }

    private static List<SysVerifyInfo> parseVerifyDataWithInfo(String verifyData) {
        Matcher matcher = VERIFY_RES_REG.matcher(verifyData);
        ArrayList<String> verifyRes = new ArrayList<String>();
        while (matcher.find()) {
            verifyRes.add(matcher.group(1));
        }
        ArrayList<SysVerifyInfo> verifyInfoList = new ArrayList<SysVerifyInfo>();
        for (String seal : verifyRes) {
            HashMap<String, String> sealVerifyInfoMap = new HashMap<String, String>();
            SysVerifyInfo info = new SysVerifyInfo();
            for (String value : seal.split("/;")) {
                int pos = value.indexOf("=");
                String k = value.substring(0, pos);
                String v = value.substring(pos + 1);
                sealVerifyInfoMap.put(k, v);
            }
            info.setNodeName((String)sealVerifyInfoMap.get("NodeName"));
            info.setNodeId((String)sealVerifyInfoMap.get("NodeID"));
            info.setPos((String)sealVerifyInfoMap.get("Pos"));
            info.setRetCode(Integer.parseInt((String)sealVerifyInfoMap.get("RetCode")));
            info.setInterId((String)sealVerifyInfoMap.get("InterID"));
            String creTm = (String)sealVerifyInfoMap.get("CreTm");
            try {
                SimpleDateFormat dateFormat;
                if (IS_WINDOWS) {
                    dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    info.setCreTm(dateFormat.parse(creTm));
                } else {
                    dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    info.setCreTm(dateFormat.parse(creTm));
                    info.setInterId((String)sealVerifyInfoMap.get("InterID"));
                }
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            verifyInfoList.add(info);
        }
        return verifyInfoList;
    }

    private static void checkInit() {
        if (!SrvSealUtil.isInit()) {
            throw new DJCommonResponseException("\u5de5\u5177\u5305\u521d\u59cb\u5316\u5f02\u5e38");
        }
    }

    private static int ocxOpenObj(String openPath) {
        if (openPath == null) {
            throw new DJCommonResponseException("openObj \u63a5\u53e3\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff0c \u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        int openObjResult = IS_WINDOWS ? srvSealUtil.openObj(openPath, 0, 0) : srvSealUtil.openObj(openPath, 0);
        if (openObjResult <= 0) {
            throw new DJCommonResponseException("\u6587\u6863\u6253\u5f00\u5931\u8d25", openObjResult);
        }
        return openObjResult;
    }

    private static int getNodeNum(int nObjId, int nNoteType) {
        if (IS_WINDOWS) {
            return srvSealUtil.getNodeNum(nObjId, nNoteType);
        }
        return srvSealUtil.getNoteNum(nObjId, -1, nNoteType);
    }

    private static String getNoteByIndex(int nObjId, int index, int iNoteType) {
        if (IS_WINDOWS) {
            return srvSealUtil.getNoteByIndex(nObjId, index, iNoteType);
        }
        return srvSealUtil.getNoteByIndex(nObjId, index, -1, iNoteType);
    }

    private static void closeFile(int nObjId) {
        if (nObjId != 0) {
            EVoucherFileUtil.ocxSaveFile(nObjId, "", "", 0);
        }
    }

    private static String getDocProperty(int nObjId, String name) {
        if (IS_WINDOWS) {
            return srvSealUtil.getValue(nObjId, "GET_DOC_PROPERTY:" + name);
        }
        return srvSealUtil.getDocProperty(nObjId, name);
    }

    private static String saveAttachmentListToXml(int nObjId) {
        if (IS_WINDOWS) {
            return srvSealUtil.getValue(nObjId, "SAVE_ATTACHMENTLIST_TO_XML");
        }
        return srvSealUtil.getValueEx(nObjId, "SAVE_ATTACHMENTLIST_TO_XML", 0, "", 0, "");
    }

    private static byte[] getAttachData(int nObjId, int index) {
        if (IS_WINDOWS) {
            String base64 = srvSealUtil.getValue(nObjId, "GET_ATTACHMENT_DATA:" + index);
            if (StringUtil.isBlank(base64) || base64.startsWith("error")) {
                return null;
            }
            return Util.decodeBase64(base64);
        }
        return srvSealUtil.getAttachData(nObjId, index);
    }

    private static void ocxSaveFile(int nObjId, String savePath, String saveType, int keepObj) {
        savePath = savePath == null ? "" : savePath;
        String string = saveType = saveType == null ? "" : saveType;
        int result = IS_WINDOWS ? srvSealUtil.saveFile(nObjId, savePath, saveType, keepObj) : (keepObj == 1 ? srvSealUtil.saveFileEx(nObjId, savePath, 0) : srvSealUtil.saveFile(nObjId, savePath));
        if (result <= 0) {
            throw new DJCommonResponseException("saveFile \u4fdd\u5b58\u6587\u6863\u5931\u8d25", result);
        }
    }

    private static boolean verifyHn(String filePath) {
        Response<?> xbrlData = EVoucherFileUtil.getXbrlData(filePath);
        try {
            if (xbrlData.getCode() == 1) {
                VoucherFileInfo verifyInfo = (VoucherFileInfo)xbrlData.getData();
                String xml = verifyInfo.getXbrlData();
                Element rootElement = XmlUtil.getRootElement(xml);
                String dwSignValue = XmlUtil.parseSignValue(rootElement, 0);
                String czSignValue = XmlUtil.parseSignValue(rootElement, 1);
                if (StringUtil.isBlank(dwSignValue) || StringUtil.isBlank(czSignValue)) {
                    throw new RuntimeException("\u83b7\u53d6\u7b7e\u540d\u503c\u4e3a\u7a7a");
                }
                if (!SM2Util.verifyP7(null, Base64.decodeBase64((String)czSignValue))) {
                    log.warning("CZ\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                    throw new RuntimeException("\u6587\u6863\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01");
                }
                if (!SM2Util.verifyP7(null, Base64.decodeBase64((String)dwSignValue))) {
                    log.warning("DW\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                    throw new RuntimeException("\u6587\u6863\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01");
                }
                return true;
            }
        }
        catch (Exception e) {
            log.warning("\u9a8c\u8bc1\u8fc7\u7a0b\u5f02\u5e38:" + e.getMessage());
        }
        return false;
    }

    static {
        ISSUER_MAP = new HashMap<String, String>();
        VERIFY_RES_REG = Pattern.compile("<\\+(.*?)->");
    }
}

