/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle162.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.params.DHParameters;
import org.bouncycastle162.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle162.crypto.params.DHPublicKeyParameters;
import org.bouncycastle162.crypto.params.ECDomainParameters;
import org.bouncycastle162.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle162.crypto.params.ECPublicKeyParameters;
import org.bouncycastle162.crypto.params.RSAKeyParameters;
import org.bouncycastle162.crypto.tls.AbstractTlsKeyExchange;
import org.bouncycastle162.crypto.tls.Certificate;
import org.bouncycastle162.crypto.tls.CertificateRequest;
import org.bouncycastle162.crypto.tls.DefaultTlsDHVerifier;
import org.bouncycastle162.crypto.tls.TlsCredentials;
import org.bouncycastle162.crypto.tls.TlsDHUtils;
import org.bouncycastle162.crypto.tls.TlsDHVerifier;
import org.bouncycastle162.crypto.tls.TlsECCUtils;
import org.bouncycastle162.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle162.crypto.tls.TlsFatalAlert;
import org.bouncycastle162.crypto.tls.TlsPSKIdentity;
import org.bouncycastle162.crypto.tls.TlsPSKIdentityManager;
import org.bouncycastle162.crypto.tls.TlsRSAUtils;
import org.bouncycastle162.crypto.tls.TlsUtils;
import org.bouncycastle162.crypto.util.PublicKeyFactory;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.io.Streams;

public class TlsPSKKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsPSKIdentity pskIdentity;
    protected TlsPSKIdentityManager pskIdentityManager;
    protected TlsDHVerifier dhVerifier;
    protected DHParameters dhParameters;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected byte[] psk_identity_hint = null;
    protected byte[] psk = null;
    protected DHPrivateKeyParameters dhAgreePrivateKey = null;
    protected DHPublicKeyParameters dhAgreePublicKey = null;
    protected ECPrivateKeyParameters ecAgreePrivateKey = null;
    protected ECPublicKeyParameters ecAgreePublicKey = null;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected RSAKeyParameters rsaServerPublicKey = null;
    protected TlsEncryptionCredentials serverCredentials = null;
    protected byte[] premasterSecret;

    public TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsPSKIdentityManager pskIdentityManager, DHParameters dhParameters, int[] namedCurves, short[] clientECPointFormats, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, pskIdentity, pskIdentityManager, new DefaultTlsDHVerifier(), dhParameters, namedCurves, clientECPointFormats, serverECPointFormats);
    }

    public TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsPSKIdentityManager pskIdentityManager, TlsDHVerifier dhVerifier, DHParameters dhParameters, int[] namedCurves, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms);
        switch (keyExchange) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.pskIdentity = pskIdentity;
        this.pskIdentityManager = pskIdentityManager;
        this.dhVerifier = dhVerifier;
        this.dhParameters = dhParameters;
        this.namedCurves = namedCurves;
        this.clientECPointFormats = clientECPointFormats;
        this.serverECPointFormats = serverECPointFormats;
    }

    public void skipServerCredentials() throws IOException {
        if (this.keyExchange == 15) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsEncryptionCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsEncryptionCredentials)serverCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        this.psk_identity_hint = this.pskIdentityManager.getHint();
        if (this.psk_identity_hint == null && !this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (this.psk_identity_hint == null) {
            TlsUtils.writeOpaque16(TlsUtils.EMPTY_BYTES, buf);
        } else {
            TlsUtils.writeOpaque16(this.psk_identity_hint, buf);
        }
        if (this.keyExchange == 14) {
            if (this.dhParameters == null) {
                throw new TlsFatalAlert(80);
            }
            this.dhAgreePrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, buf);
        } else if (this.keyExchange == 24) {
            this.ecAgreePrivateKey = TlsECCUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.namedCurves, this.clientECPointFormats, buf);
        }
        return buf.toByteArray();
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(10);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        org.bouncycastle162.asn1.x509.Certificate x509Cert = serverCertificate.getCertificateAt(0);
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        if (this.serverPublicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        this.rsaServerPublicKey = this.validateRSAPublicKey((RSAKeyParameters)this.serverPublicKey);
        TlsUtils.validateKeyUsage(x509Cert, 32);
        super.processServerCertificate(serverCertificate);
    }

    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 14: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        this.psk_identity_hint = TlsUtils.readOpaque16(input);
        if (this.keyExchange == 14) {
            this.dhParameters = TlsDHUtils.receiveDHParameters(this.dhVerifier, input);
            this.dhAgreePublicKey = new DHPublicKeyParameters(TlsDHUtils.readDHParameter(input), this.dhParameters);
        } else if (this.keyExchange == 24) {
            ECDomainParameters ecParams = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, input);
            byte[] point = TlsUtils.readOpaque8(input);
            this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, ecParams, point));
        }
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.psk_identity_hint == null) {
            this.pskIdentity.skipIdentityHint();
        } else {
            this.pskIdentity.notifyIdentityHint(this.psk_identity_hint);
        }
        byte[] psk_identity = this.pskIdentity.getPSKIdentity();
        if (psk_identity == null) {
            throw new TlsFatalAlert(80);
        }
        this.psk = this.pskIdentity.getPSK();
        if (this.psk == null) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeOpaque16(psk_identity, output);
        this.context.getSecurityParameters().pskIdentity = Arrays.clone(psk_identity);
        if (this.keyExchange == 14) {
            this.dhAgreePrivateKey = TlsDHUtils.generateEphemeralClientKeyExchange(this.context.getSecureRandom(), this.dhParameters, output);
        } else if (this.keyExchange == 24) {
            this.ecAgreePrivateKey = TlsECCUtils.generateEphemeralClientKeyExchange(this.context.getSecureRandom(), this.serverECPointFormats, this.ecAgreePublicKey.getParameters(), output);
        } else if (this.keyExchange == 15) {
            this.premasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.rsaServerPublicKey, output);
        }
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] psk_identity = TlsUtils.readOpaque16(input);
        this.psk = this.pskIdentityManager.getPSK(psk_identity);
        if (this.psk == null) {
            throw new TlsFatalAlert(115);
        }
        this.context.getSecurityParameters().pskIdentity = psk_identity;
        if (this.keyExchange == 14) {
            this.dhAgreePublicKey = new DHPublicKeyParameters(TlsDHUtils.readDHParameter(input), this.dhParameters);
        } else if (this.keyExchange == 24) {
            byte[] point = TlsUtils.readOpaque8(input);
            ECDomainParameters curve_params = this.ecAgreePrivateKey.getParameters();
            this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.serverECPointFormats, curve_params, point));
        } else if (this.keyExchange == 15) {
            byte[] encryptedPreMasterSecret = TlsUtils.isSSL(this.context) ? Streams.readAll(input) : TlsUtils.readOpaque16(input);
            this.premasterSecret = this.serverCredentials.decryptPreMasterSecret(encryptedPreMasterSecret);
        }
    }

    public byte[] generatePremasterSecret() throws IOException {
        byte[] other_secret = this.generateOtherSecret(this.psk.length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4 + other_secret.length + this.psk.length);
        TlsUtils.writeOpaque16(other_secret, buf);
        TlsUtils.writeOpaque16(this.psk, buf);
        Arrays.fill(this.psk, (byte)0);
        this.psk = null;
        return buf.toByteArray();
    }

    protected byte[] generateOtherSecret(int pskLength) throws IOException {
        if (this.keyExchange == 14) {
            if (this.dhAgreePrivateKey != null) {
                return TlsDHUtils.calculateDHBasicAgreement(this.dhAgreePublicKey, this.dhAgreePrivateKey);
            }
            throw new TlsFatalAlert(80);
        }
        if (this.keyExchange == 24) {
            if (this.ecAgreePrivateKey != null) {
                return TlsECCUtils.calculateECDHBasicAgreement(this.ecAgreePublicKey, this.ecAgreePrivateKey);
            }
            throw new TlsFatalAlert(80);
        }
        if (this.keyExchange == 15) {
            return this.premasterSecret;
        }
        return new byte[pskLength];
    }

    protected RSAKeyParameters validateRSAPublicKey(RSAKeyParameters key) throws IOException {
        if (!key.getExponent().isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        return key;
    }
}

