/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle162.asn1.cmp.PBMParameter;
import org.bouncycastle162.asn1.crmf.PKMACValue;
import org.bouncycastle162.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle162.cert.crmf.CRMFException;
import org.bouncycastle162.cert.crmf.PKMACBuilder;
import org.bouncycastle162.operator.MacCalculator;
import org.bouncycastle162.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.constantTimeAreEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

