/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.io.IOException;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.isismtt.ocsp.RequestedCertificate;
import org.bouncycastle162.asn1.test.ASN1UnitTest;
import org.bouncycastle162.asn1.x509.Certificate;
import org.bouncycastle162.util.encoders.Base64;

public class RequestedCertificateUnitTest
extends ASN1UnitTest {
    byte[] certBytes = Base64.decode("MIIBWzCCAQYCARgwDQYJKoZIhvcNAQEEBQAwODELMAkGA1UEBhMCQVUxDDAKBgNVBAgTA1FMRDEbMBkGA1UEAxMSU1NMZWF5L3JzYSB0ZXN0IENBMB4XDTk1MDYxOTIzMzMxMloXDTk1MDcxNzIzMzMxMlowOjELMAkGA1UEBhMCQVUxDDAKBgNVBAgTA1FMRDEdMBsGA1UEAxMUU1NMZWF5L3JzYSB0ZXN0IGNlcnQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAqtt6qS5GTxVxGZYWa0/4u+IwHf7p2LNZbcPBp9/OfIcYAXBQn8hO/Re1uwLKXdCjIoaGs4DLdG88rkzfyK5dPQIDAQABMAwGCCqGSIb3DQIFBQADQQAEWc7EcF8po2/ZO6kNCwK/ICH6DobgLekA5lSLr5EvuioZniZp5lFzAw4+YzPQ7XKJzl9HYIMxATFyqSiD9jsx");

    public String getName() {
        return "RequestedCertificate";
    }

    public void performTest() throws Exception {
        int type = 1;
        byte[] certOctets = new byte[20];
        Certificate cert = Certificate.getInstance(this.certBytes);
        RequestedCertificate requested = new RequestedCertificate(type, certOctets);
        this.checkConstruction(requested, type, certOctets, null);
        requested = new RequestedCertificate(cert);
        this.checkConstruction(requested, -1, null, cert);
        requested = RequestedCertificate.getInstance(null);
        if (requested != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            RequestedCertificate.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(RequestedCertificate requested, int type, byte[] certOctets, Certificate cert) throws IOException {
        this.checkValues(requested, type, certOctets, cert);
        requested = RequestedCertificate.getInstance(requested);
        this.checkValues(requested, type, certOctets, cert);
        ASN1InputStream aIn = new ASN1InputStream(requested.toASN1Primitive().getEncoded());
        ASN1Primitive obj = aIn.readObject();
        requested = RequestedCertificate.getInstance(obj);
        this.checkValues(requested, type, certOctets, cert);
    }

    private void checkValues(RequestedCertificate requested, int type, byte[] certOctets, Certificate cert) throws IOException {
        this.checkMandatoryField("certType", type, requested.getType());
        if (requested.getType() == -1) {
            this.checkMandatoryField("certificate", cert.getEncoded(), requested.getCertificateBytes());
        } else {
            this.checkMandatoryField("certificateOctets", certOctets, requested.getCertificateBytes());
        }
    }

    public static void main(String[] args) {
        RequestedCertificateUnitTest.runTest(new RequestedCertificateUnitTest());
    }
}

