/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.satellite.client.openapi.util;

import com.ygsoft.abc.eepsp.satellite.client.openapi.exception.AbcIOException;
import com.ygsoft.abc.eepsp.satellite.client.openapi.exception.CheckFailedException;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.vo.FileNameVO;
import com.ygsoft.abc.eepsp.satellite.client.openapi.util.BlockIOUtil;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentDetailVO;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentSummaryVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Blob;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.jdbc.BlobProxy;

public final class AttachUtil {
    public static final int FORMAL_STATUS = 1;

    private AttachUtil() {
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(File file, String fileName, String key) {
        if (null == file) {
            throw CheckFailedException.newInstance("file\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw CheckFailedException.newInstance("fileName\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CheckFailedException.newInstance("\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        }
        FileNameVO fileNameVO = FileNameVO.newInstance(fileName);
        Blob blobData = AttachUtil.genBlobFrom(file);
        return AttachUtil.buildEntity(key, blobData, fileNameVO);
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(byte[] data, String fileName, String key) {
        if (null == data || data.length <= 0) {
            throw CheckFailedException.newInstance("data\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw CheckFailedException.newInstance("fileName\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CheckFailedException.newInstance("\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        }
        FileNameVO fileNameVO = FileNameVO.newInstance(fileName);
        Blob blobData = AttachUtil.genBlobFrom(data);
        return AttachUtil.buildEntity(key, blobData, fileNameVO);
    }

    public static Blob genBlobFrom(byte[] data) {
        return BlobProxy.generateProxy((byte[])data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Blob genBlobFrom(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            byte[] data = BlockIOUtil.toByteArray(input);
            Blob blob = BlobProxy.generateProxy((byte[])data);
            return blob;
        }
        catch (IOException e) {
            throw AbcIOException.newInstance(e);
        }
    }

    private static EntityAttachmentSummaryVO buildEntity(String resId, Blob blobData, FileNameVO fileNameVO) {
        try {
            EntityAttachmentDetailVO attachmentDetail = new EntityAttachmentDetailVO();
            attachmentDetail.setData(blobData);
            attachmentDetail.setId(resId);
            attachmentDetail.setLength(Long.valueOf(blobData.length()));
            EntityAttachmentSummaryVO attachmentSummary = new EntityAttachmentSummaryVO();
            attachmentSummary.setResId(resId);
            attachmentSummary.setYwkey(resId);
            attachmentSummary.setStatus(Integer.valueOf(1));
            attachmentSummary.setTitle(fileNameVO.getDes());
            attachmentSummary.setBsize(Long.valueOf(blobData.length()));
            attachmentSummary.setBtype(fileNameVO.getExt());
            attachmentSummary.setAttachmentDetailVO(attachmentDetail);
            return attachmentSummary;
        }
        catch (Exception e) {
            throw CheckFailedException.newInstance("blobData.length()\u65b9\u6cd5\u5f02\u5e38\u3002");
        }
    }
}

