/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.satellite.client.openapi.tools;

import com.ygsoft.abc.eepsp.satellite.client.openapi.impl.service.VoucherParseService;
import com.ygsoft.abc.eepsp.satellite.client.openapi.impl.service.VoucherVerifyService;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.vo.FileBase64VO;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.vo.FileByteVO;
import com.ygsoft.abc.eepsp.satellite.client.openapi.service.IVoucherParseService;
import com.ygsoft.abc.eepsp.satellite.client.openapi.service.IVoucherVerifyService;
import com.ygsoft.abc.eepsp.service.explain.common.bo.BaseResponseBO;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.File;
import org.apache.http.entity.ContentType;
import org.springframework.web.multipart.MultipartFile;

public final class VoucherTool {
    private static final IEcpLog LOG = EcpLogFactory.getLog(VoucherTool.class);

    private VoucherTool() {
    }

    public static BaseResponseBO verifyFile(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherVerifyService().verify(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO verifyFileForBase64(FileBase64VO fileBase64VO) {
        try {
            return VoucherTool.getVoucherVerifyService().verifyForBase64(fileBase64VO);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO verifyFileForByte(FileByteVO fileByteVO) {
        try {
            return VoucherTool.getVoucherVerifyService().verifyForByte(fileByteVO);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO parseFile(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().parse(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO parseFileForBase64(FileBase64VO fileBase64VO) {
        try {
            return VoucherTool.getVoucherParseService().parseForBase64(fileBase64VO);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO parseFileForByte(FileByteVO fileByteVO) {
        try {
            return VoucherTool.getVoucherParseService().parseForByte(fileByteVO);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static Object parseAllelec(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().parseAllelec(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static Object parseNotGwSpecialVat(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().parseNotGwSpecialVat(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO parseFiscalBills(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().parseFiscalBills(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO parseDigEleVat(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().parseDigEleVat(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO json2Xbrl(File file, String configId) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().json2Xbrl(mfile, configId);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO xbrl2Json(File file, String configId) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().xbrl2Json(mfile, configId);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO parseHnFiscalBills(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().parseHnFiscalBills(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    public static BaseResponseBO parseEntryEVoucher(File file) {
        try {
            MultipartFile mfile = BlockIOUtil.toMultipartFile((File)file, (ContentType)ContentType.MULTIPART_FORM_DATA);
            return VoucherTool.getVoucherParseService().parseEntryEVoucher(mfile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return BaseResponseBO.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    private static IVoucherParseService getVoucherParseService() {
        return new VoucherParseService();
    }

    private static IVoucherVerifyService getVoucherVerifyService() {
        return new VoucherVerifyService();
    }
}

