/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.cache.IRedisService;
import com.ygsoft.ecp.service.tool.RedisUtil;
import java.util.Date;

public final class SnowflakeIdWorker {
    private final long twepoch = 1489111610226L;
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDataCenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static volatile SnowflakeIdWorker idWorker;
    private static final String SNOWFLAKE_KEY = "abc.snowflake.id";
    private static final int SNOWNUMBER = 32;

    private SnowflakeIdWorker(long workerIdVar, long dataCenterIdVar) {
        if (workerIdVar > 31L || workerIdVar < 0L) {
            throw new IllegalArgumentException(String.format("workerId can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterIdVar > 31L || dataCenterIdVar < 0L) {
            throw new IllegalArgumentException(String.format("dataCenterId can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerIdVar;
        this.dataCenterId = dataCenterIdVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SnowflakeIdWorker getInstance() {
        if (null != idWorker) return idWorker;
        Class<SnowflakeIdWorker> clazz = SnowflakeIdWorker.class;
        synchronized (SnowflakeIdWorker.class) {
            if (null != idWorker) return idWorker;
            SnowflakeParam param = SnowflakeIdWorker.buildSnowflakeParam();
            idWorker = new SnowflakeIdWorker(param.getWorkId(), param.getDataCenterId());
            // ** MonitorExit[var0] (shouldn't be in output)
            return idWorker;
        }
    }

    private static SnowflakeParam buildSnowflakeParam() {
        long snowflakeId = SnowflakeIdWorker.incrSnowflakeId();
        long workId = snowflakeId % 32L;
        long dataCenterId = snowflakeId / 32L % 32L;
        return new SnowflakeParam(workId, dataCenterId);
    }

    private static long incrSnowflakeId() {
        IRedisService redis = RedisUtil.getRedisService();
        return redis.incr("abc", SNOWFLAKE_KEY);
    }

    public static synchronized long nextId() {
        if (PropertyConfigUtil.isUnitTest()) {
            return new Date().getTime();
        }
        SnowflakeIdWorker worker = SnowflakeIdWorker.getInstance();
        long timestamp = worker.timeGen();
        if (timestamp < worker.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", worker.lastTimestamp - timestamp));
        }
        if (worker.lastTimestamp == timestamp) {
            worker.sequence = worker.sequence + 1L & worker.sequenceMask;
            if (worker.sequence == 0L) {
                timestamp = worker.tilNextMillis(worker.lastTimestamp);
            }
        } else {
            worker.sequence = 0L;
        }
        worker.lastTimestamp = timestamp;
        long l = timestamp - worker.twepoch;
        worker.getClass();
        long l2 = l << 22;
        long l3 = worker.dataCenterId;
        worker.getClass();
        long l4 = l2 | l3 << 17;
        long l5 = worker.workerId;
        worker.getClass();
        return l4 | l5 << 12 | worker.sequence;
    }

    protected long tilNextMillis(long lastTimestampVar) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestampVar) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
    }

    static class SnowflakeParam {
        private final long workId;
        private final long dataCenterId;

        public SnowflakeParam(long workIdVar, long dataCenterIdVar) {
            this.workId = workIdVar;
            this.dataCenterId = dataCenterIdVar;
        }

        public long getWorkId() {
            return this.workId;
        }

        public long getDataCenterId() {
            return this.dataCenterId;
        }
    }
}

