/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.alibaba.fastjson.JSONObject;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public final class RestUtil {
    private static final int READ_TIMEOUT = 1800000;
    private static final int CONNECT_TIMEOUT = 1800000;
    private static RestTemplate restTemplate;

    private RestUtil() {
    }

    public static RestTemplate getRestTemplate() {
        if (null == restTemplate) {
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setReadTimeout(1800000);
            factory.setConnectTimeout(1800000);
            restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        }
        return restTemplate;
    }

    public static HttpEntity<String> buildHttpEntity(String body) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        return httpEntity;
    }

    public static String getErrorMessage(JSONObject jsonObj) {
        if (jsonObj == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"RestUtil_getErrorMessage_82", (String)"\u53c2\u6570\u9519\u8bef\uff1ajsonObj\u4e3a\u7a7a\u3002"));
        }
        JSONObject errorObj = jsonObj.getJSONObject("error");
        if (null == errorObj) {
            return null;
        }
        return errorObj.getString("message");
    }
}

