/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.InvalidJsonTypeException;
import com.ygsoft.abc.service.exception.MappServiceCallException;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.alibaba.fastjson.JSONArray;
import com.ygsoft.alibaba.fastjson.util.TypeUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.necp.core.service.dcispec.PageModel;
import com.ygsoft.necp.core.service.mapp.MappService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;

public final class MappServiceUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(MappServiceUtil.class);
    private static final String JSON_OBJECT_PATTERN = "^\\{.*\\}$";
    private static final String JSON_ARRAY_PATTERN = "^\\[.*\\]$";
    private static final String HTML_TAG_END = "</html>";
    private static final String FIELD_PAGE = "page";
    private static final String FIELD_PAGE_SIZE = "pageSize";
    private static final String FIELD_CONTENT = "content";
    private static final String FIELD_ERRCODE = "errCode";
    private static final String FIELD_ERRMSG = "errMsg";
    private static final String EMPTY_STRING = "";
    private static final String PREFIX_URI_VALUE = "{";
    private static final String POSTFIX_URI_VALUE = "}";

    private MappServiceUtil() {
    }

    public static <T> PageModel<T> doGetPage(String url, Class<T> responseType, Object ... uriVariables) {
        MappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doGet---url:%s\uff0curiVariables:%s", url, MappServiceUtil.buildUriVariables(uriVariables));
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doGet(url, String.class, uriVariables);
        MappServiceUtil.checkReponseBody(body);
        return MappServiceUtil.castToPageModel(body, responseType);
    }

    private static <T> void checkArgs(String url, Class<T> responseType) {
        if (StringUtil.isNullOrTrimEmptyString((String)url)) {
            String msg = EcpI18nUtil.localizedString((String)"MappServiceUtil_checkArgs_127", (String)"\u53c2\u6570\u9519\u8bef\uff1aurl\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (null == responseType) {
            String msg = EcpI18nUtil.localizedString((String)"MappServiceUtil_checkArgs_131", (String)"\u53c2\u6570\u9519\u8bef\uff1aresponseType\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
    }

    public static <T> T doGet(String url, Class<T> responseType, Object ... uriVariables) {
        String body;
        MappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doGet---url:%s\uff0curiVariables:%s", url, MappServiceUtil.buildUriVariables(uriVariables));
            LOG.info((Object)tipMsg);
        }
        if (Objects.isNull(body = (String)MappService.INSTANCE.doGet(url, String.class, uriVariables))) {
            return null;
        }
        MappServiceUtil.checkReponseBody(body);
        return MappServiceUtil.castToObject(body, responseType);
    }

    private static String buildUriVariables(Object ... uriVariables) {
        if (null == uriVariables) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : uriVariables) {
            sb.append(PREFIX_URI_VALUE).append(obj).append(POSTFIX_URI_VALUE);
        }
        return sb.toString();
    }

    private static <T> T castToObject(String body, Class<T> responseType) {
        if (String.class == responseType) {
            return (T)body;
        }
        if (MappServiceUtil.isJsonObject(body)) {
            if (com.ygsoft.alibaba.fastjson.JSONObject.class == responseType) {
                return (T)com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body);
            }
            if (JSONObject.class == responseType) {
                return (T)JSONObject.parseObject((String)body);
            }
            return (T)JSONUtil.fromJsonString((String)body, responseType);
        }
        if (MappServiceUtil.isJsonArray(body)) {
            String msg = EcpI18nUtil.localizedString((String)"MappServiceUtil_castToObject_199", (String)("json\u5b57\u7b26\u4e32body=" + body + "\uff0c\u4e0d\u662f\u5355\u7eaf\u5bf9\u8c61\u3002"), (Object[])new Object[]{body});
            throw new InvalidJsonTypeException("ABC.0026", msg);
        }
        return (T)TypeUtils.castToJavaBean((Object)body, responseType);
    }

    private static <T> PageModel<T> castToPageModel(String body, Class<T> responseType) {
        if (!MappServiceUtil.isJsonPage(body)) {
            String msg = EcpI18nUtil.localizedString((String)"MappServiceUtil_castToPageModel_215", (String)("json\u5b57\u7b26\u4e32body=" + body + "\uff0c\u4e0d\u662fPageModel\u3002"), (Object[])new Object[]{body});
            throw new InvalidJsonTypeException("ABC.0026", msg);
        }
        PageModel pageModel = (PageModel)com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body, PageModel.class);
        List content = pageModel.getContent();
        if (null != content) {
            String contentJson = com.ygsoft.alibaba.fastjson.JSONObject.toJSONString((Object)content);
            pageModel.setContent(MappServiceUtil.castToList(contentJson, responseType));
        }
        return pageModel;
    }

    private static boolean isJsonPage(String body) {
        if (MappServiceUtil.isJsonObject(body)) {
            com.ygsoft.alibaba.fastjson.JSONObject jsonObject = com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body);
            return jsonObject.containsKey((Object)FIELD_PAGE) && jsonObject.containsKey((Object)FIELD_PAGE_SIZE) && jsonObject.containsKey((Object)FIELD_CONTENT);
        }
        return false;
    }

    private static boolean isJsonObject(String body) {
        return body.matches(JSON_OBJECT_PATTERN);
    }

    private static boolean isJsonArray(String body) {
        return body.matches(JSON_ARRAY_PATTERN);
    }

    public static boolean checkResponse(String body) {
        if (StringUtil.isNullOrTrimEmptyString((String)body)) {
            return true;
        }
        if (MappServiceUtil.isJsonErrorMsg(body)) {
            return false;
        }
        return !MappServiceUtil.isHtmlErrorMsg(body);
    }

    private static void checkReponseBody(String body) {
        MappServiceUtil.checkEmpty(body);
        if (MappServiceUtil.isJsonErrorMsg(body)) {
            MappServiceUtil.logError("\u670d\u52a1\u95f4\u8c03\u7528\u5931\u8d25\u3002body\uff1a" + body, null);
            com.ygsoft.alibaba.fastjson.JSONObject bodyObj = com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body);
            String throwMeg = bodyObj.getString(FIELD_ERRMSG);
            throw new MappServiceCallException("ABC.0025", throwMeg);
        }
        if (MappServiceUtil.isHtmlErrorMsg(body)) {
            MappServiceUtil.logError("\u670d\u52a1\u95f4\u8c03\u7528\u5931\u8d25\u3002body\uff1a" + body, null);
            throw new MappServiceCallException("ABC.0025", body);
        }
        LOG.info((Object)"\u670d\u52a1\u95f4\u8c03\u7528\u6210\u529f\u3002");
    }

    private static void checkEmpty(String body) {
        if (StringUtil.isNullOrTrimEmptyString((String)body)) {
            MappServiceUtil.logError("doGet\u8c03\u7528\u5931\u8d25\uff1a" + body, null);
            throw new MappServiceCallException("ABC.0025", EcpI18nUtil.localizedString((String)"MappServiceUtil_checkEmpty_285", (String)"\u8fd4\u56deResponseBody\u4e3a\u7a7a\u3002"));
        }
    }

    private static boolean isErrorMsg(String body) {
        if (MappServiceUtil.isJsonErrorMsg(body)) {
            return true;
        }
        return MappServiceUtil.isHtmlErrorMsg(body);
    }

    private static boolean isJsonErrorMsg(String body) {
        if (MappServiceUtil.isJsonObject(body)) {
            com.ygsoft.alibaba.fastjson.JSONObject bodyObj = com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body);
            return bodyObj.containsKey((Object)FIELD_ERRCODE) && bodyObj.containsKey((Object)FIELD_ERRMSG) && !bodyObj.get((Object)FIELD_ERRMSG).equals("success");
        }
        return false;
    }

    private static boolean isHtmlErrorMsg(String body) {
        return body.endsWith(HTML_TAG_END);
    }

    public static <T> List<T> doGetReturnList(String url, Class<T> responseType, Object ... uriVariables) {
        MappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doGet---url:%s\uff0curiVariables:%s", url, MappServiceUtil.buildUriVariables(uriVariables));
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doGet(url, String.class, uriVariables);
        MappServiceUtil.checkReponseBody(body);
        return MappServiceUtil.castToList(body, responseType);
    }

    private static <T> List<T> castToList(String body, Class<T> responseType) {
        if (!MappServiceUtil.isJsonArray(body)) {
            String msg = EcpI18nUtil.localizedString((String)"MappServiceUtil_ccastToList_365", (String)("json\u5b57\u7b26\u4e32body=" + body + "\uff0c\u4e0d\u662fJSONArray\u3002"), (Object[])new Object[]{body});
            throw new InvalidJsonTypeException("ABC.0026", msg);
        }
        JSONArray jsonArray = com.ygsoft.alibaba.fastjson.JSONObject.parseArray((String)body);
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                resultList.add(jsonArray.getObject(i, responseType));
            }
        }
        return resultList;
    }

    public static void doPostReturnVoid(String url, Object request, Object ... uriVariables) {
        String body;
        if (StringUtil.isNullOrTrimEmptyString((String)url)) {
            String msg = EcpI18nUtil.localizedString((String)"MappServiceUtil_doPostReturnVoid_388", (String)"\u53c2\u6570\u9519\u8bef\uff1aurl\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        String reqJSON = JSONUtil.toJsonWithoutJcls((Object)request);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPostReturnVoid---url:%s\uff0curiVariables:%s\uff0crequest:%s", url, MappServiceUtil.buildUriVariables(uriVariables), reqJSON);
            LOG.info((Object)tipMsg);
        }
        if (!Objects.isNull(body = (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables))) {
            MappServiceUtil.checkReponseBody(body);
        }
    }

    public static <T> T doPost(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        MappServiceUtil.checkArgs(url, responseType);
        String reqJSON = JSONUtil.toJsonWithoutJcls((Object)request);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPost---url:%s\uff0curiVariables:%s\uff0crequest:%s", url, MappServiceUtil.buildUriVariables(uriVariables), reqJSON);
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables);
        if (!PropertyConfigUtil.isProductEnvironment() && LOG.isInfoEnabled()) {
            String msg = String.format("doPost---url:%s\uff0cresp:%s", url, body);
            LOG.info((Object)msg);
        }
        if (Objects.isNull(body)) {
            return null;
        }
        MappServiceUtil.checkReponseBody(body);
        return MappServiceUtil.castToObject(body, responseType);
    }

    public static String doPost(String url, Object request, Object ... uriVariables) {
        String reqJSON = JSONUtil.toJsonWithoutJcls((Object)request);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPost-CustomDeal--url:%s\uff0curiVariables:%s\uff0crequest:%s", url, MappServiceUtil.buildUriVariables(uriVariables), reqJSON);
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables);
        if (!PropertyConfigUtil.isProductEnvironment() && LOG.isInfoEnabled()) {
            String msg = String.format("doPost-CustomDeal--url:%s\uff0cresp:%s", url, body);
            LOG.info((Object)msg);
        }
        if (Objects.isNull(body)) {
            return null;
        }
        MappServiceUtil.checkReponseBody(body);
        return body;
    }

    public static <T> List<T> doPostReturnList(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        MappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPostReturnList---url:%s\uff0curiVariables:%s\uff0crequest:%s", url, MappServiceUtil.buildUriVariables(uriVariables), JSONUtil.toJsonWithoutJcls((Object)request));
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables);
        MappServiceUtil.checkReponseBody(body);
        return MappServiceUtil.castToList(body, responseType);
    }

    private static void logError(Object obj, Throwable e) {
        if (LOG.isErrorEnabled()) {
            if (null == e) {
                LOG.error((Object)("\n###" + obj));
            } else {
                LOG.error((Object)("\n###" + obj), e);
            }
        }
    }

    public static void main(String[] args) {
        String url = "/abc/mapp/energy/test/{name}/{age}";
        String fullUrl = UriBuilder.fromPath((String)"/abc/mapp/energy/test/{name}/{age}").build(new Object[]{"\u5f20\u4e09", 12}).toString();
        System.out.println("fullUrl=" + fullUrl);
        String url2 = "/abc/mapp/energy/test";
        fullUrl = UriBuilder.fromPath((String)"/abc/mapp/energy/test").build(new Object[0]).toString();
        System.out.println("fullUrl=" + fullUrl);
        fullUrl = UriBuilder.fromPath((String)"/abc/mapp/energy/test/\u6c49\u5b57").build(new Object[0]).toString();
        System.out.println("fullUrl=" + fullUrl);
        fullUrl = UriBuilder.fromPath((String)"/abc/mapp/energy/test?abc=1").build(new Object[0]).toString();
        System.out.println("fullUrl=" + fullUrl);
    }
}

