/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.collect.Maps;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockUrlBuilder {
    private static final String PATH_SPLIT = "?";
    private static final String ARGUMENT_SPLIT = "&";
    private static final String NAME_VALUE_JOIN = "=";
    private static final Pattern URL_ARGUMENT = Pattern.compile("\\{\\S+?\\}");
    private final String path;
    private final Map<String, String> args;

    private BlockUrlBuilder(String path, Map<String, String> args) {
        this.path = path;
        this.args = args;
    }

    @TLog
    public static BlockUrlBuilder on(String path) {
        return new BlockUrlBuilder(path, Maps.newHashMap());
    }

    public BlockUrlBuilder appendArgument(String name, String value) {
        if (StringUtil.isNullOrTrimEmptyString((String)name)) {
            String msg = EcpI18nUtil.localizedString((String)"BlockUrlBuilder_appendArgument_81", (String)"\u53c2\u6570\u9519\u8bef\uff1aname\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (null == value) {
            String msg = EcpI18nUtil.localizedString((String)"BlockUrlBuilder_appendArgument_85", (String)("\u6784\u5efaURL-\u53c2\u6570\uff08" + name + "\uff09\u5bf9\u5e94\u7684value\u4e3anull\u3002"), (Object[])new Object[]{name});
            throw new EmptyValueException("ABC.0001", msg);
        }
        this.args.put(name, value);
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path).append(PATH_SPLIT);
        this.args.forEach((key, val) -> sb.append((String)key).append(NAME_VALUE_JOIN).append((String)val).append(ARGUMENT_SPLIT));
        String url = sb.toString();
        if (url.endsWith(ARGUMENT_SPLIT)) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String replaceArgs(String url, String ... args) {
        if (StringUtil.isNullOrTrimEmptyString((String)url)) {
            String msg = EcpI18nUtil.localizedString((String)"BlockUrlBuilder_replaceArgs_119", (String)"\u53c2\u6570\u9519\u8bef\uff1aurl\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            Matcher regexMatcher = URL_ARGUMENT.matcher(url);
            StringBuilder sb = new StringBuilder();
            int index = 0;
            int argIndex = 0;
            while (regexMatcher.find()) {
                int start = regexMatcher.start();
                int end = regexMatcher.end();
                sb.append(url.substring(index, start));
                sb.append(args[argIndex++]);
                index = end;
            }
            sb.append(url.substring(index));
            return sb.toString();
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockUrlBuilder_replaceArgs_142", (String)"\u66ff\u6362url\u53c2\u6570\u5931\u8d25\u3002");
            throw new AbcServiceException("ABC.0015", msg);
        }
    }

    public static String parsePath(String url) {
        PreconditionUtil.checkNotTrimEmpty(url, "\u53c2\u6570\u9519\u8bef\uff1aurl\u4e3a\u7a7a\u3002");
        int idx = url.lastIndexOf(63);
        if (idx > -1) {
            return url.substring(0, idx);
        }
        return url;
    }

    public static void main(String[] args) {
        String url = BlockUrlBuilder.on("/abc/mapp/energy/ammeter/query/find-ammeter-quantity").appendArgument("ctx_token", "666").appendArgument("ammeterID", "114a-554d-5544").appendArgument("yearMonth", "201901").build();
        System.out.println("url=" + url);
        String url1 = "http://10.121.60.12:9090/assets/blockchain/getTranInfo.json?channelName={name}&txId={txId}";
        System.out.println(BlockUrlBuilder.replaceArgs("http://10.121.60.12:9090/assets/blockchain/getTranInfo.json?channelName={name}&txId={txId}", "aa", "cd"));
    }
}

