/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;

public class BlockLocaleUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BlockLocaleUtil.class);

    static String buildLocaleFieldName(String fieldName, String ecpLocale) {
        String upper = ecpLocale.replaceAll("[_|\\-]", "").toUpperCase();
        return fieldName + upper;
    }

    public static <T> String getValue(T instance, String fieldName, String ecpLocale) {
        if (Objects.isNull(instance)) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"BlockLocaleUtil_getValue_51", (String)"\u53c2\u6570\u9519\u8bef\uff1a%s\u4e3anull\u3002"), instance);
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)fieldName)) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"BlockLocaleUtil_getValue_55", (String)"\u53c2\u6570\u9519\u8bef\uff1a%s\u4e3a\u7a7a\u3002"), fieldName);
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)ecpLocale)) {
            return BlockLocaleUtil.getDefaultFieldValue(instance, fieldName);
        }
        String localeFieldName = BlockLocaleUtil.buildLocaleFieldName(fieldName, ecpLocale);
        try {
            return BeanUtils.getProperty(instance, (String)localeFieldName);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                String msg = String.format("\u83b7\u53d6\u5b57\u6bb5(%s)\u5c5e\u6027\u503c\u5931\u8d25\u3002", localeFieldName);
                LOG.warn((Object)msg, (Throwable)e);
            }
            return BlockLocaleUtil.getDefaultFieldValue(instance, fieldName);
        }
    }

    static <T> String getDefaultFieldValue(T instance, String fieldName) {
        try {
            return BeanUtils.getProperty(instance, (String)fieldName);
        }
        catch (Exception e) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"BlockLocaleUtil_getDefaultFieldValue_89", (String)"\u83b7\u53d6\u5b57\u6bb5(%s)\u5c5e\u6027\u503c\u5931\u8d25\u3002"), fieldName);
            throw new AbcServiceException("ABC.0015", msg, e, new Object[0]);
        }
    }

    public static <T> String getValue(T instance, String fieldName, Locale locale) {
        return BlockLocaleUtil.getValue(instance, fieldName, locale.toString());
    }
}

