/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.domain.bo.DateRangeBO;
import com.ygsoft.abc.service.exception.DateParseException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.InvalidEnumValueException;
import com.ygsoft.abc.service.exception.InvalidNumberRangeException;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.types.BlockTimeUnit;
import com.ygsoft.abc.service.types.DateTimeUnitEnum;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public final class BlockDateUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BlockDateUtil.class);
    public static final int HOUR_23 = 23;
    public static final int MINUTE_59 = 59;
    public static final int SECOND_59 = 59;
    private static final Map<DateTimeUnitEnum, String> UNIT_TO_PATTERN = ImmutableMap.builder().put((Object)DateTimeUnitEnum.YEAR, (Object)"yyyy").put((Object)DateTimeUnitEnum.MONTH, (Object)"yyyyMM").put((Object)DateTimeUnitEnum.WEEK, (Object)"yyyyww").put((Object)DateTimeUnitEnum.DAY, (Object)"yyyyMMdd").put((Object)DateTimeUnitEnum.HOUR, (Object)"yyyyMMddHH").put((Object)DateTimeUnitEnum.MINUTE, (Object)"yyyyMMddHHmm").put((Object)DateTimeUnitEnum.SECOND, (Object)"yyyyMMddHHmmss").build();
    private static final long ONE_SECOND_MILLS = 1000L;
    private static final long ONE_MINUTE_MILLS = 60000L;
    private static final long ONE_HOUR_MILLS = 3600000L;
    private static final long ONE_DAY_MILLS = 86400000L;
    private static final long ONE_WEEK_MILLS = 604800000L;
    public static final String COMPACT_DAY_PATTERN = "yyyyMMdd";
    public static final String SIMPLE_DAY_PATTERN = "yyyy-MM-dd";
    public static final String SIMPLE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String SIMPLE_PATTERN_1 = "yyyyMMdd HH:mm:ss";
    public static final String FULL_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String COMPOSER_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'+800'";
    public static final String COMPOSER_PATTERN_POE = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String YEARMONTH_PATTERN = "yyyy-MM";
    public static final int COMPARE_GREATER_THAN = 1;
    public static final int COMPARE_EQUALS = 0;
    public static final int COMPARE_LESS_THAN = -1;
    private static final int FIRST_DAY_OF_MONTH = 1;
    public static final int MONTHS_OF_YEAR = 12;

    private BlockDateUtil() {
    }

    @TLog(checkArguments=true)
    public static boolean isFirstMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        BlockDateUtil.logInfo("\u5f53\u524d\u6708\u4efd\uff08\u4ece0\u5f00\u59cb\uff09:" + month);
        return 0 == month;
    }

    @TLog(checkArguments=true)
    public static boolean isLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        BlockDateUtil.logInfo("\u5f53\u524d\u6708\u4efd\uff08\u4ece0\u5f00\u59cb\uff09:" + month);
        return 11 == month;
    }

    @TLog(checkArguments=true)
    public static boolean isFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        return 1 == dayOfMonth;
    }

    @TLog(checkArguments=true)
    public static boolean isLastDayOfMonth(Date date) {
        Date nextDay = BlockDateUtil.nextDay(date);
        return BlockDateUtil.isFirstDayOfMonth(nextDay);
    }

    public static int compareDay(Date date1, Date date2) {
        int distance = BlockDateUtil.getDayDistance(date1, date2);
        if (distance > 0) {
            return 1;
        }
        if (distance < 0) {
            return -1;
        }
        return 0;
    }

    public static int getDayDistance(Date beginDate, Date endDate) {
        Date dateZero1 = BlockDateUtil.setZeroTime(beginDate);
        Date dateZero2 = BlockDateUtil.setZeroTime(endDate);
        Calendar beginTime = Calendar.getInstance();
        beginTime.setTime(dateZero1);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(dateZero2);
        long betweenMills = endTime.getTimeInMillis() - beginTime.getTimeInMillis();
        return (int)(betweenMills / 86400000L);
    }

    public static int getTimeDistance(Date beginDate, Date endDate, DateUnit dateUnit) {
        Calendar beginTime = Calendar.getInstance();
        beginTime.setTime(beginDate);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(endDate);
        long betweenMills = endTime.getTimeInMillis() - beginTime.getTimeInMillis();
        if (DateUnit.YEAR == dateUnit) {
            return endTime.get(1) - beginTime.get(1);
        }
        if (DateUnit.MONTH == dateUnit) {
            int years = endTime.get(1) - beginTime.get(1);
            int months = endTime.get(2) - beginTime.get(2);
            int distance = years * 12 + months;
            return distance;
        }
        if (DateUnit.WEEK == dateUnit) {
            return (int)(betweenMills / 604800000L);
        }
        if (DateUnit.DAY == dateUnit) {
            return BlockDateUtil.getDayDistance(beginDate, endDate);
        }
        if (DateUnit.HOUR == dateUnit) {
            return (int)(betweenMills / 3600000L);
        }
        if (DateUnit.MINUTE == dateUnit) {
            return (int)(betweenMills / 60000L);
        }
        if (DateUnit.SECOND == dateUnit) {
            return (int)(betweenMills / 1000L);
        }
        return 0;
    }

    public static Date setZeroTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setLastTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getUnreachableTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date nextDate(Date date, int amount, BlockTimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                return BlockDateUtil.nextSecond(date, amount);
            }
            case MINUTES: {
                return BlockDateUtil.nextMinute(date, amount);
            }
            case HOURS: {
                return BlockDateUtil.nextHour(date, amount);
            }
            case DAYS: {
                return BlockDateUtil.nextDay(date, amount);
            }
            case WEEKS: {
                return BlockDateUtil.nextWeek(date, amount);
            }
            case MONTHS: {
                return BlockDateUtil.nextMonth(date, amount);
            }
            case YEARS: {
                return BlockDateUtil.nextYear(date, amount);
            }
        }
        String localMsg = "\u679a\u4e3etimeUnit={0}\uff0c\u4e0d\u652f\u6301";
        String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_nextDate_358", (String)"\u679a\u4e3etimeUnit={0}\uff0c\u4e0d\u652f\u6301", (Object[])new Object[]{timeUnit});
        throw new InvalidEnumValueException("ABC.0006", msg);
    }

    public static Date nextSecond(Date date) {
        return BlockDateUtil.nextSecond(date, 1);
    }

    public static Date nextSecond(Date date, int amount) {
        long time = date.getTime();
        return new Date(time += (long)amount * 1000L);
    }

    public static Date nextMinute(Date date) {
        return BlockDateUtil.nextMinute(date, 1);
    }

    public static Date nextMinute(Date date, int amount) {
        long time = date.getTime();
        return new Date(time += (long)amount * 60000L);
    }

    public static Date nextHour(Date date) {
        return BlockDateUtil.nextHour(date, 1);
    }

    public static Date nextHour(Date date, int amount) {
        long time = date.getTime();
        return new Date(time += (long)amount * 3600000L);
    }

    public static Date nextDay(Date date) {
        return BlockDateUtil.nextDay(date, 1);
    }

    public static Date nextDay(Date date, int amount) {
        long time = date.getTime();
        return new Date(time += (long)amount * 86400000L);
    }

    public static Date nextWeek(Date date) {
        return BlockDateUtil.nextWeek(date, 1);
    }

    public static Date nextWeek(Date date, int amount) {
        long time = date.getTime();
        return new Date(time += (long)amount * 604800000L);
    }

    public static Date nextMonth(Date date) {
        return BlockDateUtil.nextMonth(date, 1);
    }

    public static Date nextMonth(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, amount);
        return calendar.getTime();
    }

    public static Date nextYear(Date date) {
        return BlockDateUtil.nextYear(date, 1);
    }

    public static Date nextYear(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, amount);
        return calendar.getTime();
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_formatDate_545", (String)"date is null");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)pattern)) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_formatDate_549", (String)"pattern is null");
            throw new EmptyValueException("ABC.0001", msg);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    public static String formatDayCompact(Date date) {
        return BlockDateUtil.formatDate(date, COMPACT_DAY_PATTERN);
    }

    public static Date parseDate(String dateStr, String pattern) {
        if (StringUtil.isNullOrTrimEmptyString((String)dateStr)) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_parseDate_575", (String)"dateStr is null");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)pattern)) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_parseDate_579", (String)"pattern is null");
            throw new EmptyValueException("ABC.0001", msg);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_parseDate_590", (String)"\u89e3\u6790\u65e5\u671f\u9519\u8bef\uff1a") + dateStr;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\n>>>" + msg), (Throwable)e);
            }
            throw new DateParseException("ABC.0018", msg, e, new Object[0]);
        }
    }

    public static String formatSimple(Date date) {
        PreconditionUtil.checkNotNull(date, "\u53c2\u6570\u9519\u8bef\uff1adate\u4e3a\u7a7a\u3002");
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_PATTERN);
        return dateFormat.format(date);
    }

    public static String formatSimpleDay(Date date) {
        PreconditionUtil.checkNotNull(date, "\u53c2\u6570\u9519\u8bef\uff1adate\u4e3a\u7a7a\u3002");
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DAY_PATTERN);
        return dateFormat.format(date);
    }

    public static Date parseSimple(String dateStr) {
        PreconditionUtil.checkNotTrimEmpty(dateStr, "\u53c2\u6570\u9519\u8bef\uff1adateStr\u4e3a\u7a7a\u3002");
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_PATTERN);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_parseSimple_635", (String)"\u89e3\u6790\u65e5\u671f\u9519\u8bef\uff1a") + dateStr;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\n>>>" + msg), (Throwable)e);
            }
            throw new DateParseException("ABC.0018", msg, e, new Object[0]);
        }
    }

    public static Date parseSimpleDay(String dateStr) {
        PreconditionUtil.checkNotTrimEmpty(dateStr, "\u53c2\u6570\u9519\u8bef\uff1adateStr\u4e3a\u7a7a\u3002");
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DAY_PATTERN);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_parseSimpleDay_655", (String)"\u89e3\u6790\u65e5\u671f\u9519\u8bef\uff1a") + dateStr;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\n>>>" + msg), (Throwable)e);
            }
            throw new DateParseException("ABC.0018", msg, e, new Object[0]);
        }
    }

    public static String formatFull(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FULL_PATTERN);
        return dateFormat.format(date);
    }

    @TLog(checkArguments=true)
    public static Date parseFull(String dateStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FULL_PATTERN);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_parseFull_687", (String)"\u89e3\u6790\u65e5\u671f\u9519\u8bef\uff1a") + dateStr;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\n>>>" + msg), (Throwable)e);
            }
            throw new DateParseException("ABC.0018", msg, e, new Object[0]);
        }
    }

    public static String formatNodeStyle(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(COMPOSER_PATTERN);
        return dateFormat.format(date);
    }

    public static String formatNodeStylePoe(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(COMPOSER_PATTERN_POE);
        return dateFormat.format(date);
    }

    public static Date parseNodeStyle(String dateStr) {
        if (StringUtil.isNullOrTrimEmptyString((String)dateStr)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(COMPOSER_PATTERN);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            String msg = "\u89e3\u6790\u65e5\u671f\u9519\u8bef\uff1a" + e.getMessage();
            throw new DateParseException(msg, e);
        }
    }

    public static boolean equalsByTime(Date date1, Date date2) {
        if (null == date1 || null == date2) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_equalsByTime_743", (String)"\u53c2\u6570\u9519\u8bef\uff1adate1 or date2\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        return date1.getTime() == date2.getTime();
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static DateRangeBO buildMonthRange(Date date) {
        if (null == date) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_buildMonthRange_770", (String)"\u53c2\u6570\u9519\u8bef\uff1adate\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        Date beginDate = BlockDateUtil.setFirstDayOfMonth(date);
        Date endDate = BlockDateUtil.setFirstDayOfMonth(BlockDateUtil.nextMonth(date, 1));
        return new DateRangeBO(beginDate, endDate);
    }

    public static DateRangeBO buildDateSection(Date date, DateUnit dateUnit, int amount) {
        if (null == date) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_buildDateSection_790", (String)"\u53c2\u6570\u9519\u8bef\uff1adate\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (null == dateUnit) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_buildDateSection_794", (String)"\u53c2\u6570\u9519\u8bef\uff1adateUnit\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (0 == amount) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_buildDateSection_798", (String)"\u53c2\u6570\u9519\u8bef\uff1aamount\u4e0d\u80fd\u4e3a\u96f6\u3002");
            throw new InvalidNumberRangeException("ABC.0007", msg);
        }
        int section = Math.abs(amount);
        if (DateUnit.YEAR == dateUnit) {
            return new DateRangeBO(BlockDateUtil.nextYear(date, -section), BlockDateUtil.nextYear(date, section));
        }
        if (DateUnit.MONTH == dateUnit) {
            return new DateRangeBO(BlockDateUtil.nextMonth(date, -section), BlockDateUtil.nextMonth(date, section));
        }
        if (DateUnit.WEEK == dateUnit) {
            return new DateRangeBO(BlockDateUtil.nextWeek(date, -section), BlockDateUtil.nextWeek(date, section));
        }
        if (DateUnit.DAY == dateUnit) {
            return new DateRangeBO(BlockDateUtil.nextDay(date, -section), BlockDateUtil.nextDay(date, section));
        }
        if (DateUnit.HOUR == dateUnit) {
            return new DateRangeBO(BlockDateUtil.nextHour(date, -section), BlockDateUtil.nextHour(date, section));
        }
        if (DateUnit.MINUTE == dateUnit) {
            return new DateRangeBO(BlockDateUtil.nextMinute(date, -section), BlockDateUtil.nextMinute(date, section));
        }
        if (DateUnit.SECOND == dateUnit) {
            return new DateRangeBO(BlockDateUtil.nextSecond(date, -section), BlockDateUtil.nextMinute(date, section));
        }
        return null;
    }

    public static Date setFirstDayOfMonth(Date date) {
        if (null == date) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_setFirstDayOfMonth_843", (String)"\u53c2\u6570\u9519\u8bef\uff1adate\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Integer getMonth(Date date) {
        if (null == date) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_getMonth_865", (String)"\u53c2\u6570\u9519\u8bef\uff1adate\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static Integer getMonth(String dateStr) {
        String[] t = dateStr.split("-");
        if (t.length < 2) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_getMonth_881", (String)"\u6708\u4efd\u4e3a\u7a7a");
            throw EmptyValueException.newInstance(msg);
        }
        Integer month = Integer.valueOf(t[1]);
        return month;
    }

    public static Integer getYear(String dateStr) {
        String[] t = dateStr.split("-");
        if (t.length < 1) {
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_getYear_896", (String)"\u5e74\u4efd\u4e3a\u7a7a");
            throw EmptyValueException.newInstance(msg);
        }
        Integer year = Integer.valueOf(t[0]);
        return year;
    }

    public static Date getFirstDate(String dateStr) {
        String[] t = dateStr.split("-");
        int year = Integer.valueOf(t[0]);
        if (t.length == 2) {
            int month = Integer.valueOf(t[1]);
            YearMonth yearMonth = YearMonth.of(year, month);
            LocalDate localDate = yearMonth.atDay(1);
            LocalDateTime startOfDay = localDate.atStartOfDay();
            ZonedDateTime zonedDateTime = startOfDay.atZone(ZoneId.of("Asia/Shanghai"));
            return Date.from(zonedDateTime.toInstant());
        }
        if (t.length == 1) {
            YearMonth yearMonth = YearMonth.of(year, 1);
            LocalDate localDate = yearMonth.atDay(1);
            LocalDateTime startOfDay = localDate.atStartOfDay();
            ZonedDateTime zonedDateTime = startOfDay.atZone(ZoneId.of("Asia/Shanghai"));
            return Date.from(zonedDateTime.toInstant());
        }
        return null;
    }

    public static Date getEndDate(String dateStr) {
        String[] t = dateStr.split("-");
        int year = Integer.valueOf(t[0]);
        if (t.length == 2) {
            int month = Integer.valueOf(t[1]);
            YearMonth yearMonth = YearMonth.of(year, month);
            LocalDate endOfMonth = yearMonth.atEndOfMonth();
            LocalDateTime localDateTime = endOfMonth.atTime(23, 59, 59, 999);
            ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.of("Asia/Shanghai"));
            return Date.from(zonedDateTime.toInstant());
        }
        if (t.length == 1) {
            YearMonth yearMonth = YearMonth.of(year, 12);
            LocalDate endOfMonth = yearMonth.atEndOfMonth();
            LocalDateTime localDateTime = endOfMonth.atTime(23, 59, 59, 999);
            ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.of("Asia/Shanghai"));
            return Date.from(zonedDateTime.toInstant());
        }
        return null;
    }

    public static boolean isHourZero(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int minute = calendar.get(12);
        BlockDateUtil.logInfo("\u5f53\u524d\u5206\u949f=" + minute);
        return minute == 0;
    }

    public static boolean isDayZero(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        BlockDateUtil.logInfo("\u5f53\u524d\u5c0f\u65f6=" + hour + ",\u5f53\u524d\u5206\u949f=" + minute);
        return hour == 0 && minute == 0;
    }

    public static boolean isWeekZero(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        BlockDateUtil.logInfo("\u672c\u5468\u7b2c\u51e0\u5929=" + dayOfWeek + ",\u5f53\u524d\u5c0f\u65f6=" + hour + ",\u5f53\u524d\u5206\u949f=" + minute);
        return dayOfWeek == 1 && hour == 0 && minute == 0;
    }

    public static boolean isMonthZero(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        BlockDateUtil.logInfo("\u672c\u6708\u7b2c\u51e0\u5929=" + dayOfMonth + ",\u5f53\u524d\u5c0f\u65f6=" + hour + ",\u5f53\u524d\u5206\u949f=" + minute);
        return dayOfMonth == 1 && hour == 0 && minute == 0;
    }

    public static int compareDatetime(Date date1, Date date2) {
        if (null == date1 || null == date2) {
            String localMsg = "\u53c2\u6570\u9519\u8bef\uff1adate1 or date2\u4e3a\u7a7a\u3002";
            String msg = EcpI18nUtil.localizedString((String)"BlockDateUtil_compareDatetime_1031", (String)"\u53c2\u6570\u9519\u8bef\uff1adate1 or date2\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (date1.getTime() > date2.getTime()) {
            return 1;
        }
        if (date1.getTime() < date2.getTime()) {
            return -1;
        }
        return 0;
    }

    public static Date convertGMTToLocal(String gmtDateStr) {
        Date gmtDate = BlockDateUtil.parseNodeStyle(gmtDateStr);
        return BlockDateUtil.convertGMTToLocal(gmtDate);
    }

    public static Date convertGMTToLocal(Date gmtDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(gmtDate);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, zoneOffset + dstOffset);
        return calendar.getTime();
    }

    public static Date convertGMTTo(Date gmtDate, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(gmtDate);
        calendar.setTimeZone(timeZone);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, dstOffset + zoneOffset);
        return calendar.getTime();
    }

    public static Date convertLocalToGMT(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(dstOffset + zoneOffset));
        return calendar.getTime();
    }

    public static String getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return String.valueOf(calendar.get(1));
    }

    private static void logInfo(Object obj) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>" + obj));
        }
    }

    static void logError(Object obj, Throwable e) {
        if (LOG.isErrorEnabled()) {
            if (null == e) {
                LOG.error((Object)("\n###" + obj));
            } else {
                LOG.error((Object)("\n###" + obj), e);
            }
        }
    }

    public static boolean beforeNowByDateTimeUnit(Date date, DateTimeUnitEnum dateTimeUnit, boolean containsEqual) {
        String nowStr;
        Date now = new Date();
        String pattern = UNIT_TO_PATTERN.get((Object)dateTimeUnit);
        String dateStr = BlockDateUtil.formatDate(date, pattern);
        int compare = dateStr.compareTo(nowStr = BlockDateUtil.formatDate(now, pattern));
        if (compare < 0) {
            return true;
        }
        return containsEqual && compare == 0;
    }

    public static boolean afterNowByDateTimeUnit(Date date, DateTimeUnitEnum dateTimeUnit, boolean containsEqual) {
        String nowStr;
        Date now = new Date();
        String pattern = UNIT_TO_PATTERN.get((Object)dateTimeUnit);
        String dateStr = BlockDateUtil.formatDate(date, pattern);
        int compare = dateStr.compareTo(nowStr = BlockDateUtil.formatDate(now, pattern));
        if (compare > 0) {
            return true;
        }
        return containsEqual && compare == 0;
    }

    public static String transferDateFormat(String dateStr, String originPattern, String targetPattern) {
        Date date = BlockDateUtil.parseDate(dateStr, originPattern);
        return BlockDateUtil.formatDate(date, targetPattern);
    }

    public static enum DateUnit {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

