/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.exception.AbcDecodeException;
import com.ygsoft.abc.service.exception.AbcEncodeException;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.security.Base64Coder;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public final class BlockCodingUtil {
    public static final String CHARSET_UTF_8 = "UTF-8";
    private static final Pattern HTML_ENCODE_PATTERN = Pattern.compile("[<>]");
    private static final Pattern HTML_DECODE_PATTERN = Pattern.compile("(&lt;)|(&gt;)");
    private static final Map<String, String> HTML_ENCODE_MAP = ImmutableMap.of((Object)"<", (Object)"&lt;", (Object)">", (Object)"&gt;");
    private static final Map<String, String> HTML_DECODE_MAP = ImmutableMap.of((Object)"&lt;", (Object)"<", (Object)"&gt;", (Object)">");
    private static final String ALPHABET = "aAbBCdDeEfFgGhHiIjJKLmMnNOPqQrRStTuUVWXyYZ";
    private static final String[] CHARS = "aAbBCdDeEfFgGhHiIjJKLmMnNOPqQrRStTuUVWXyYZ".split("");
    private static final char[] HEX_DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String HEX_CODE_STRING = "0123456789ABCDEF";

    private BlockCodingUtil() {
    }

    public static String randomNumber(int length) {
        return CastUtil.getString(CommonUtil.randomNumber(length));
    }

    public static String randomLetters(int length) {
        PreconditionUtil.checkArgument(length > 0, "\u53c2\u6570\u9519\u8bef\uff1alength\u5fc5\u987b\u5927\u4e8e0\u3002");
        StringBuilder padding = new StringBuilder();
        ThreadLocalRandom gen = ThreadLocalRandom.current();
        IntStream.rangeClosed(1, length).forEach(i -> {
            int idx = gen.nextInt(CHARS.length);
            padding.append(CHARS[idx]);
        });
        return padding.toString();
    }

    private static boolean isDigitString(String str) {
        return str.matches("^\\d+$");
    }

    public static String digitToLetter(String digit) {
        PreconditionUtil.checkArgument(BlockCodingUtil.isDigitString(digit), "\u53c2\u6570digit\u683c\u5f0f\u4e0d\u5339\u914d\u3002");
        StringBuilder sb = new StringBuilder();
        String[] codes = digit.split("");
        int i = 0;
        while (i < codes.length) {
            String pair;
            int idx;
            String current = codes[i];
            if (i + 1 < codes.length && (idx = CastUtil.getInteger(pair = current + codes[i + 1]).intValue()) < CHARS.length) {
                sb.append(CHARS[idx]);
                i += 2;
                continue;
            }
            int idx2 = CastUtil.getInteger(current);
            sb.append(CHARS[idx2]);
            ++i;
        }
        return sb.toString();
    }

    public static String digitToLetterWithPadding(String digit) {
        String letters = BlockCodingUtil.digitToLetter(digit);
        if (letters.length() < digit.length()) {
            int count = digit.length() - letters.length();
            return letters + BlockCodingUtil.randomLetters(count);
        }
        return letters;
    }

    public static String digitToLetterFixedLength(String digit, int length) {
        PreconditionUtil.checkArgument(length > 0, "\u53c2\u6570\u9519\u8bef\uff1alength\u5fc5\u987b\u5927\u4e8e0\u3002");
        String letters = BlockCodingUtil.digitToLetter(digit);
        if (letters.length() < length) {
            int count = length - letters.length();
            return letters + BlockCodingUtil.randomLetters(count);
        }
        if (letters.length() == length) {
            return letters;
        }
        return letters.substring(0, length);
    }

    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, CHARSET_UTF_8);
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockCodingUtil_encodeUrl_74", (String)"\u7f16\u7801\u5931\u8d25\u3002");
            throw new AbcEncodeException("ABC.0027", msg);
        }
    }

    public static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, CHARSET_UTF_8);
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockCodingUtil_decodeUrl_89", (String)"\u89e3\u7801\u5931\u8d25\u3002");
            throw new AbcDecodeException("ABC.0028", msg);
        }
    }

    public static String encodeHtml(String html) {
        try {
            Matcher regexMatcher = HTML_ENCODE_PATTERN.matcher(html);
            StringBuilder sb = new StringBuilder();
            int index = 0;
            while (regexMatcher.find()) {
                String text = regexMatcher.group();
                int start = regexMatcher.start();
                int end = regexMatcher.end();
                sb.append(html.substring(index, start));
                sb.append(HTML_ENCODE_MAP.get(text));
                index = end;
            }
            sb.append(html.substring(index));
            return sb.toString();
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockCodingUtil_encodeHtml_119", (String)"\u7f16\u7801\u5931\u8d25\u3002");
            throw new AbcEncodeException("ABC.0027", msg);
        }
    }

    public static String decodeHtml(String html) {
        try {
            Matcher regexMatcher = HTML_DECODE_PATTERN.matcher(html);
            StringBuilder sb = new StringBuilder();
            int index = 0;
            while (regexMatcher.find()) {
                String text = regexMatcher.group();
                int start = regexMatcher.start();
                int end = regexMatcher.end();
                sb.append(html.substring(index, start));
                sb.append(HTML_DECODE_MAP.get(text));
                index = end;
            }
            sb.append(html.substring(index));
            return sb.toString();
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"BlockCodingUtil_decodeHtml_149", (String)"\u89e3\u7801\u5931\u8d25\u3002");
            throw new AbcDecodeException("ABC.0028", msg);
        }
    }

    public static String decodeUrlParam(String val) {
        if (StringUtil.isNullOrTrimEmptyString((String)val)) {
            return null;
        }
        try {
            return URLDecoder.decode(Base64Coder.base64decode(val), CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AbcServiceException("ABC.0015", e);
        }
    }

    public static String decodeHexUrlParam(String val) {
        if (StringUtil.isNullOrTrimEmptyString((String)val)) {
            return null;
        }
        return BlockCodingUtil.fromHexString(val);
    }

    public static String toHexString(String str) {
        StringBuilder sb = new StringBuilder();
        byte[] bs = str.getBytes();
        for (int i = 0; i < bs.length; ++i) {
            int bit = (bs[i] & 0xF0) >> 4;
            sb.append(HEX_DIGITS_UPPER[bit]);
            bit = bs[i] & 0xF;
            sb.append(HEX_DIGITS_UPPER[bit]);
        }
        return sb.toString().trim();
    }

    public static String fromHexString(String hexStr) {
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = HEX_CODE_STRING.indexOf(hexs[2 * i]) * 16;
            bytes[i] = (byte)((n += HEX_CODE_STRING.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return new String(bytes);
    }

    public static String byte2HexStr(byte[] b) {
        String stmp = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            sb.append(stmp.length() == 1 ? "0" + stmp : stmp);
        }
        return sb.toString().toUpperCase().trim();
    }

    public static byte[] hexStr2Bytes(String src) {
        int m = 0;
        int n = 0;
        int l = src.length() / 2;
        System.out.println(l);
        byte[] ret = new byte[l];
        for (int i = 0; i < l; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            ret[i] = Byte.decode("0x" + src.substring(i * 2, m) + src.substring(m, n));
        }
        return ret;
    }

    public static String strToUnicode(String strText) throws Exception {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < strText.length(); ++i) {
            char c;
            char intAsc = c = strText.charAt(i);
            String strHex = Integer.toHexString(intAsc);
            if (intAsc > '\u0080') {
                str.append("\\u" + strHex);
                continue;
            }
            str.append("\\u00" + strHex);
        }
        return str.toString();
    }

    public static String unicodeToString(String hex) {
        int t = hex.length() / 6;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < t; ++i) {
            String s = hex.substring(i * 6, (i + 1) * 6);
            String s1 = s.substring(2, 4) + "00";
            String s2 = s.substring(4);
            int n = Integer.valueOf(s1, 16) + Integer.valueOf(s2, 16);
            char[] chars = Character.toChars(n);
            str.append(new String(chars));
        }
        return str.toString();
    }

    public static char[] encodeHex(byte[] data) {
        return BlockCodingUtil.encodeHex(data, true);
    }

    private static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return BlockCodingUtil.encodeHex(data, toLowerCase ? HEX_DIGITS_LOWER : HEX_DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexStr(byte[] data) {
        return BlockCodingUtil.encodeHexStr(data, true);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return BlockCodingUtil.encodeHexStr(data, toLowerCase ? HEX_DIGITS_LOWER : HEX_DIGITS_UPPER);
    }

    protected static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(BlockCodingUtil.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = BlockCodingUtil.toDigit(data[j], j) << 4;
            f |= BlockCodingUtil.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String encodeParamsByBase64(String text) {
        try {
            byte[] textByte = text.getBytes(CHARSET_UTF_8);
            Base64.Encoder encoder = Base64.getEncoder();
            String encodedText = encoder.encodeToString(textByte);
            return URLEncoder.encode(encodedText, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AbcDecodeException("ABC.0028", "\u7f16\u7801\u9519\u8bef");
        }
    }

    public static String decodeParamsByBase64(String encodedText) {
        try {
            String decodeStr = URLDecoder.decode(encodedText, CHARSET_UTF_8);
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] bytes = decoder.decode(decodeStr);
            String text = new String(bytes, CHARSET_UTF_8);
            return text;
        }
        catch (UnsupportedEncodingException e) {
            throw new AbcDecodeException("ABC.0028", "\u7f16\u7801\u9519\u8bef");
        }
    }

    public static void main(String[] args) {
        System.out.println(BlockCodingUtil.encodeHtml("(<\u884c<\u4e1a\u5e73\u5747\u5229\u7387\uff1a3.5% - 3.5%\uff0c\u6570\u636e\u6765\u6e90\u4e8e\u6743\u5a01\u7f51\u7ad9\uff0c\u66f4\u65b0\u4e8e2019\u5e7411\u670827\u65e5)"));
        System.out.println(BlockCodingUtil.decodeHtml("(&lt;\u884c&lt;\u4e1a\u5e73\u5747\u5229\u7387\uff1a3.5% - 3.5%\uff0c\u6570\u636e\u6765\u6e90\u4e8e\u6743\u5a01\u7f51\u7ad9\uff0c\u66f4\u65b0\u4e8e2019\u5e7411\u670827\u65e5)"));
        String s = BlockCodingUtil.encodeParamsByBase64("\u7ea2\u7ea2\u706b\u706b\u604d\u604d\u60da\u60daabcd");
        System.out.println(s);
        System.out.println(BlockCodingUtil.decodeParamsByBase64(s));
    }
}

