/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.seqno;

import com.ygsoft.abc.service.exception.DateParseException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.MonitorUtil;
import com.ygsoft.abc.service.tool.RedisLockUtil;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.RedisUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCodeBuilder {
    private static final IEcpLog LOG = EcpLogFactory.getLog(AbstractCodeBuilder.class);
    public static final String SEQ_PREFIX = "abc:seqno:";
    public static final String PADDING_FOUR = "0000";
    public static final String PADDING_FIVE = "00000";
    public static final String PADDING_SIX = "000000";
    public static final String PADDING_SEVEN = "0000000";
    public static final String PADDING_EIGHT = "00000000";
    public static final String PADDING_NINE = "000000000";
    public static final int EXPIRE_NONE = -1;
    public static final int EXPIRE_ONE_DAY = 86400;
    public static final long INIT_ACQUIRETIMEOUT = 30000L;
    public static final long LOCKED_TIMEOUT = 60000L;
    private static final List<String> DATE_CODE_PATTERN = new ArrayList<String>();
    protected String table;
    protected String field;
    protected String prefix;
    protected String padding;
    protected int expireTime;

    protected AbstractCodeBuilder(String newTable, String newField, String newPrefix, String newPadding, int newExpireTime) {
        if (StringUtil.isNullOrTrimEmptyString((String)newPadding)) {
            String msg = EcpI18nUtil.localizedString((String)"AbstractCodeBuilder_AbstractCodeBuilder_125", (String)"\u53c2\u6570\u9519\u8bef\uff1apadding\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)newTable)) {
            String msg = EcpI18nUtil.localizedString((String)"AbstractCodeBuilder_AbstractCodeBuilder_128", (String)"\u53c2\u6570\u9519\u8bef\uff1atable\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)newField)) {
            String msg = EcpI18nUtil.localizedString((String)"AbstractCodeBuilder_AbstractCodeBuilder_131", (String)"\u53c2\u6570\u9519\u8bef\uff1afield\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">>>\u53c2\u6570:prefix=" + newPrefix + ",padding=" + newPadding + ",table=" + newTable + ",field=" + newField + ",expireTime=" + newExpireTime));
        }
        this.table = newTable;
        this.field = newField;
        this.prefix = newPrefix;
        this.padding = newPadding;
        this.expireTime = newExpireTime;
    }

    protected boolean isDateCode() {
        return false;
    }

    protected String getCodePrefix() {
        if (this.isDateCode()) {
            Date now = new Date();
            for (String p : DATE_CODE_PATTERN) {
                Pattern regex = Pattern.compile("(" + p + ")");
                Matcher regexMatcher = regex.matcher(this.prefix);
                StringBuilder sb = new StringBuilder();
                if (!regexMatcher.find()) continue;
                String datePattern = regexMatcher.group();
                String dateStr = BlockDateUtil.formatDate(now, datePattern);
                sb.append(this.prefix.substring(0, regexMatcher.start()));
                sb.append(dateStr);
                sb.append(this.prefix.substring(regexMatcher.end()));
                return sb.toString();
            }
            String msg = EcpI18nUtil.localizedString((String)"AbstractCodeBuilder_getCodePrefix_174", (String)"\u7f16\u7801\u7684\u65e5\u671f\u683c\u5f0f\u672a\u914d\u7f6e\u3002");
            throw new DateParseException("ABC.0018", msg);
        }
        return this.prefix;
    }

    protected String getNext() {
        MonitorUtil monitorUtil = MonitorUtil.getInstance(LOG);
        long start = monitorUtil.getStartTime();
        String codePrefix = this.getCodePrefix();
        String codeKey = this.table + "#" + this.field + "#" + codePrefix;
        String key = SEQ_PREFIX + codeKey;
        String nextCode = null;
        if (!RedisUtil.getRedisService().exists("abc", key).booleanValue()) {
            this.initSeqno(key, codePrefix);
        }
        nextCode = this.buildBySeqno(codePrefix, RedisUtil.getRedisService().incr("abc", key));
        monitorUtil.monitor("\u83b7\u53d6\u7f16\u7801\u8017\u65f6", start);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">>>\u7f16\u7801:code=" + nextCode));
        }
        return nextCode;
    }

    protected void initSeqno(String key, String codePrefix) {
        RedisLockUtil.executeTryLock(key, 30000L, 60000L, () -> {
            if (!RedisUtil.getRedisService().exists("abc", key).booleanValue()) {
                Long maxSeqno = this.findMaxSeqno(codePrefix);
                RedisUtil.getRedisService().setnx("abc", key, CastUtil.getString(maxSeqno));
            }
        });
    }

    protected long findMaxSeqno(String codePrefix) {
        List list;
        ISQLTemplate sqlTemplate = (ISQLTemplate)OSGiUtil.getSpringBean(ISQLTemplate.class);
        String sql = "SELECT MAX(" + this.field + ") CODE FROM " + this.table + " WHERE " + this.field + " LIKE '" + codePrefix + "%'";
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>\u83b7\u53d6\u6700\u5927\u7f16\u7801Sql=" + sql));
        }
        if (BlockCollectionUtil.isEmpty(list = sqlTemplate.findBySQLWithoutRowNumLimit(sql, Map.class))) {
            return 0L;
        }
        Map entity = (Map)list.get(0);
        if (null == entity) {
            return 0L;
        }
        String code = CastUtil.getString(entity.get("code"));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u6700\u5927\u7f16\u7801code=" + code));
        }
        long seqno = CastUtil.getLong(code.substring(codePrefix.length()));
        return seqno;
    }

    protected String buildBySeqno(String codePrefix, Long seqno) {
        String str = CastUtil.getString(seqno);
        int length = str.length();
        String code = codePrefix + this.padding.substring(length) + str;
        return code;
    }

    static {
        DATE_CODE_PATTERN.add("yyyyMMdd");
        DATE_CODE_PATTERN.add("yyyyMM");
        DATE_CODE_PATTERN.add("yyyy");
    }
}

