/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.sensitive.util;

import cn.hutool.core.util.ReflectUtil;
import com.ygsoft.abc.service.sensitive.annotation.SensitiveInfo;
import com.ygsoft.abc.service.sensitive.strategy.IStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SensitiveAddressStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SensitiveBankCardStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SensitiveChineseNameStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SensitiveEmailStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SensitiveFixedPhoneStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SensitiveIdCardStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SensitiveMobileStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class SensitiveInfoCover {
    private static Map<Class<?>, IStrategy> STRATEGY_MAP = new HashMap();

    private SensitiveInfoCover() {
    }

    public static <T> T coverSensitive(T t) {
        Field[] fields;
        if (t == null) {
            return null;
        }
        for (Field field : fields = ReflectUtil.getFields(t.getClass())) {
            Annotation[] annotains;
            Object value = ReflectUtil.getFieldValue(t, (Field)field);
            if (value == null) continue;
            for (Annotation anno : annotains = field.getAnnotations()) {
                if (!(anno instanceof SensitiveInfo)) continue;
                SensitiveInfo sensitiveInfo = (SensitiveInfo)anno;
                IStrategy strategy = STRATEGY_MAP.get(sensitiveInfo.strategy());
                String fieldValue = (String)value;
                String newValue = strategy.desensitization(fieldValue, 0, 0);
                ReflectUtil.setFieldValue(t, (Field)field, (Object)newValue);
            }
        }
        return t;
    }

    static {
        STRATEGY_MAP.put(SensitiveAddressStrategy.class, new SensitiveAddressStrategy());
        STRATEGY_MAP.put(SensitiveBankCardStrategy.class, new SensitiveBankCardStrategy());
        STRATEGY_MAP.put(SensitiveChineseNameStrategy.class, new SensitiveChineseNameStrategy());
        STRATEGY_MAP.put(SensitiveEmailStrategy.class, new SensitiveEmailStrategy());
        STRATEGY_MAP.put(SensitiveFixedPhoneStrategy.class, new SensitiveFixedPhoneStrategy());
        STRATEGY_MAP.put(SensitiveIdCardStrategy.class, new SensitiveIdCardStrategy());
        STRATEGY_MAP.put(SensitiveMobileStrategy.class, new SensitiveMobileStrategy());
    }
}

