/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.ECKeyUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class SM2Encryptor {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SM2Encryptor.class);
    private static final String PRIVATE_KEY = "6b502b257f5cff6fb31da57a5ec6b7b5998e54f06e671a09a91186f07fb28ca0";
    private static final String PUBLIC_KEY = "042371ae9ec9aaeeaf5e845c87756da2fafb4c48f3151ff57e5efbb4a8cf03ef7760fe7e1441892100770642821c74c505aa150876e3fd00f28a6b63696de30a6a";

    private static void createSM2Key() {
        SM2 sm2 = SmUtil.sm2();
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String tempPrivateKey = HexUtil.encodeHexStr((byte[])BCUtil.encodeECPrivateKey((PrivateKey)sm2.getPrivateKey()));
        String tempPublicKey = HexUtil.encodeHexStr((byte[])((BCECPublicKey)sm2.getPublicKey()).getQ().getEncoded(false));
        LOG.info((Object)String.format("\u79c1\u94a5\uff1a%s", tempPrivateKey));
        LOG.info((Object)String.format("\u516c\u94a5\uff1a%s", tempPublicKey));
    }

    public static String encrypt(String data) {
        String publicKeyTmp = PUBLIC_KEY;
        if (PUBLIC_KEY.length() == 130) {
            publicKeyTmp = PUBLIC_KEY.substring(2);
        }
        String xhex = publicKeyTmp.substring(0, 64);
        String yhex = publicKeyTmp.substring(64, 128);
        ECPublicKeyParameters ecPublicKeyParameters = BCUtil.toSm2Params((String)xhex, (String)yhex);
        SM2 sm2 = new SM2(null, ecPublicKeyParameters);
        sm2.usePlainEncoding();
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String hex = sm2.encryptHex(data, KeyType.PublicKey);
        return hex;
    }

    public static String decrypt(String data) {
        SM2 sm2 = new SM2(ECKeyUtil.toSm2PrivateParams((String)PRIVATE_KEY), null);
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        sm2.setEncoding((DSAEncoding)new PlainDSAEncoding());
        String encryptStr = sm2.decryptStr(data, KeyType.PrivateKey);
        return encryptStr;
    }

    public static void main(String[] args) throws IOException {
        SM2Encryptor.createSM2Key();
        String data = SM2Encryptor.encrypt("test");
        LOG.info((Object)String.format("\u52a0\u5bc6\u540e\u6570\u636e\uff1a%s", data));
        String result = SM2Encryptor.decrypt(data);
        LOG.info((Object)String.format("\u89e3\u5bc6\u540e\u6570\u636e\uff1a%s", result));
    }
}

