/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.google.common.collect.ImmutableSet;
import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.exception.InvalidValueException;
import com.ygsoft.abc.service.security.key.kit.SecretKeyKit;
import com.ygsoft.abc.service.security.kit.Base64Kit;
import com.ygsoft.abc.service.security.kit.HexKit;
import com.ygsoft.abc.service.tool.MonitorUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DigestKit {
    static final IEcpLog LOG = EcpLogFactory.getLog(DigestKit.class);

    public static IDigest md() {
        return new MDDigest();
    }

    public static IDigest md(String algorithm) {
        return new MDDigest(algorithm);
    }

    public static IDigest sha() {
        return new SHADigest();
    }

    public static IDigest sha(String algorithm) {
        return new SHADigest(algorithm);
    }

    public static IDigest sm3() {
        return new SMDigest();
    }

    public static IMACDigest hmacmd() {
        return new HmacDigest("HmacMD5");
    }

    public static IMACDigest hmacsha() {
        return new HmacDigest("HmacSHA1");
    }

    public static IMACDigest hmac(String algorithm) {
        return new HmacDigest(algorithm);
    }

    public static void main(String[] args) {
        String data = "\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002";
        byte[] digest = DigestKit.md().hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes());
        System.out.println("MD5\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        digest = DigestKit.md("MD4").hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes());
        System.out.println("MD4\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        digest = DigestKit.sha().hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes());
        System.out.println("SHA-1\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        digest = DigestKit.sha("SHA-256").hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes());
        System.out.println("SHA-256\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        byte[] key = SecretKeyKit.getInstance("HmacMD5").generate().getEncoded();
        digest = DigestKit.hmac("HmacMD5").hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes(), key);
        System.out.println("HmacMD5\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        key = SecretKeyKit.getInstance("HmacSHA1").generate().getEncoded();
        digest = DigestKit.hmac("HmacSHA1").hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes(), key);
        System.out.println("HmacSHA1\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        key = SecretKeyKit.getInstance("HmacSHA224").generate().getEncoded();
        digest = DigestKit.hmac("HmacSHA224").hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes(), key);
        System.out.println("HmacSHA224\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        digest = DigestKit.sm3().hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes());
        System.out.println("SM3-1\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        digest = DigestKit.hash("\u6545\u4eba\u897f\u8f9e\u9ec4\u9e64\u697c\uff0c\u70df\u82b1\u4e09\u6708\u4e0b\u626c\u5dde\u3002".getBytes());
        System.out.println("SM3-2\u6458\u8981\uff1a" + Base64Kit.standardMode().encode(digest));
        System.out.println("SM3-3\u6458\u8981\uff1a" + HexKit.getInstance().encode(digest));
    }

    private static byte[] hash(byte[] data) {
        com.ygsoft.ecp.security.cipher.sm.SM3Digest digest = new com.ygsoft.ecp.security.cipher.sm.SM3Digest();
        digest.update(data, 0, data.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    static class SMDigest
    implements IDigest {
        SMDigest() {
        }

        @Override
        public byte[] hash(byte[] data) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SM3Digest digest = new SM3Digest();
            digest.update(data, 0, data.length);
            byte[] hash = new byte[digest.getDigestSize()];
            digest.doFinal(hash, 0);
            return hash;
        }
    }

    static class HmacDigest
    implements IMACDigest {
        private static final Set<String> ACCEPT_ALGORITHMS = ImmutableSet.of((Object)"HmacMD2", (Object)"HmacMD4", (Object)"HmacMD5", (Object)"HmacSHA1", (Object)"HmacSHA224", (Object)"HmacSHA256", (Object[])new String[]{"HmacSHA384", "HmacSHA512"});
        private final String algorithm;

        private HmacDigest(String algorithm) {
            if (!ACCEPT_ALGORITHMS.contains(algorithm)) {
                throw InvalidValueException.newInstance("\u4e0d\u63a5\u53d7\u7684\u6458\u8981\u7b97\u6cd5\uff08" + algorithm + "\uff09\u3002");
            }
            this.algorithm = algorithm;
        }

        @Override
        public byte[] hash(byte[] data, byte[] key) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                SecretKeySpec secretKey = new SecretKeySpec(key, this.algorithm);
                Mac mac = Mac.getInstance(secretKey.getAlgorithm());
                mac.init(secretKey);
                return mac.doFinal(data);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u751f\u6210\u6458\u8981\u5931\u8d25\u3002", e);
            }
        }
    }

    static class SHADigest
    implements IDigest {
        private static final String DIGEST_ALGORITHM = "SHA-1";
        private static final Set<String> ACCEPT_ALGORITHMS = ImmutableSet.of((Object)"SHA-1", (Object)"SHA-224", (Object)"SHA-256", (Object)"SHA-384", (Object)"SHA-512");
        private final String algorithm;

        public SHADigest() {
            this.algorithm = DIGEST_ALGORITHM;
        }

        public SHADigest(String algorithm) {
            if (!ACCEPT_ALGORITHMS.contains(algorithm)) {
                throw InvalidValueException.newInstance("\u4e0d\u63a5\u53d7\u7684\u6458\u8981\u7b97\u6cd5\uff08" + algorithm + "\uff09\u3002");
            }
            this.algorithm = algorithm;
        }

        @Override
        public byte[] hash(byte[] data) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                MonitorUtil util = MonitorUtil.getInstance(LOG);
                MessageDigest md = MessageDigest.getInstance(this.algorithm);
                byte[] hash = md.digest(data);
                util.monitor(this.algorithm + "\u6458\u8981\u8017\u65f6");
                return hash;
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u751f\u6210\u6458\u8981\u5931\u8d25\u3002", e);
            }
        }
    }

    static class MDDigest
    implements IDigest {
        private static final String DIGEST_ALGORITHM = "MD5";
        private static final Set<String> ACCEPT_ALGORITHMS = ImmutableSet.of((Object)"MD2", (Object)"MD4", (Object)"MD5");
        private final String algorithm;

        public MDDigest() {
            this.algorithm = DIGEST_ALGORITHM;
        }

        public MDDigest(String algorithm) {
            if (!ACCEPT_ALGORITHMS.contains(algorithm)) {
                throw InvalidValueException.newInstance("\u4e0d\u63a5\u53d7\u7684\u6458\u8981\u7b97\u6cd5\uff08" + algorithm + "\uff09\u3002");
            }
            this.algorithm = algorithm;
        }

        @Override
        public byte[] hash(byte[] data) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                MonitorUtil util = MonitorUtil.getInstance(LOG);
                MessageDigest md = MessageDigest.getInstance(this.algorithm);
                byte[] hash = md.digest(data);
                util.monitor(this.algorithm + "\u6458\u8981\u8017\u65f6");
                return hash;
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u751f\u6210\u6458\u8981\u5931\u8d25\u3002", e);
            }
        }
    }

    public static interface IMACDigest {
        public byte[] hash(byte[] var1, byte[] var2);
    }

    public static interface IDigest {
        public byte[] hash(byte[] var1);
    }
}

