/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.login.domain.vo;

import com.google.common.collect.Maps;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.login.domain.vo.ProductFieldExtendVO;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.types.ApproveStateEnum;
import com.ygsoft.abc.service.types.AuthStateEnum;
import com.ygsoft.abc.service.types.OwnerScopeEnum;
import com.ygsoft.abc.service.types.UserSourceEnum;
import com.ygsoft.ecp.core.framework.internal.context.LoginContext;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExtendLoginContext
extends LoginContext {
    private static final long serialVersionUID = -1292821390794261910L;
    private String gid;
    private String userGid;
    private String userCode;
    private String loginOrgGid;
    private String loginOrgCode;
    private String deptId;
    private String deptName;
    private String tenantName;
    private String movetel;
    private String email;
    private String openId;
    private Integer compType;
    private String coreGid;
    private String coreId;
    private String leaderGid;
    private String leaderId;
    private Integer leaderCompType;
    private UserSourceEnum userSource;
    private OwnerScopeEnum ownerScope;
    private AuthStateEnum authState;
    private int orgRole;
    private List<Integer> orgRoleList;
    private String businessNo;
    private ApproveStateEnum orgApproveState;
    private ApproveStateEnum userApproveState;
    private Integer supplierType;
    private String userPosition;
    private Integer entryMode;
    private String abbName;
    private Map<String, ProductFieldExtendVO> productFieldExtendMap;
    private String orgParent;
    private List<String> orgChildren;

    public boolean isTenantAdmin() {
        if (null == this.userSource) {
            return false;
        }
        return this.userSource.isTenantAdmin();
    }

    public Map<String, String> toExtendMap() {
        HashMap map = Maps.newHashMap();
        map.put("tenantId", CastUtil.getSafeString(this.getTenantId()));
        map.put("userId", CastUtil.getSafeString(this.getUserId()));
        map.put("userType", CastUtil.getSafeString(this.getUserType()));
        map.put("userName", CastUtil.getSafeString(this.getUserName()));
        map.put("userDisplayName", CastUtil.getSafeString(this.getUserDisplayName()));
        map.put("loginOrgId", CastUtil.getSafeString(this.getLoginOrgId()));
        map.put("loginOrgName", CastUtil.getSafeString(this.getLoginOrgName()));
        map.put("ownerAppId", CastUtil.getSafeString(this.getOwnerAppId()));
        map.put("loginDate", CastUtil.getSafeString(CastUtil.ecpDateToString(this.getLoginDate())));
        map.put("ip", CastUtil.getSafeString(this.getIp()));
        map.put("locale", CastUtil.getSafeString(CastUtil.localeToString(this.getLocale())));
        map.put("uniqueKey", CastUtil.getSafeString(this.getUniqueKey()));
        map.put("timeZone", CastUtil.getSafeString(CastUtil.timeZoneToString(this.getTimeZone())));
        map.put("gid", CastUtil.getSafeString(this.gid));
        map.put("userGid", CastUtil.getSafeString(this.userGid));
        map.put("userCode", CastUtil.getSafeString(this.userCode));
        map.put("userSource", ExtendLoginContext.formatUserSource(this.getUserSource()));
        map.put("ownerScope", ExtendLoginContext.formatOwnerScope(this.getOwnerScope()));
        map.put("loginOrgGid", CastUtil.getSafeString(this.loginOrgGid));
        map.put("loginOrgCode", CastUtil.getSafeString(this.loginOrgCode));
        map.put("deptId", CastUtil.getSafeString(this.deptId));
        map.put("deptName", CastUtil.getSafeString(this.deptName));
        map.put("tenantName", CastUtil.getSafeString(this.tenantName));
        map.put("movetel", CastUtil.getSafeString(this.movetel));
        map.put("email", CastUtil.getSafeString(this.email));
        map.put("authState", ExtendLoginContext.formatAuthSource(this.authState));
        map.put("openId", CastUtil.getSafeString(this.openId));
        if (!Objects.isNull(this.compType)) {
            map.put("compType", CastUtil.getString(this.compType));
        }
        map.put("coreGid", CastUtil.getSafeString(this.coreGid));
        map.put("coreId", CastUtil.getSafeString(this.coreId));
        map.put("leaderGid", CastUtil.getSafeString(this.leaderGid));
        map.put("leaderId", CastUtil.getSafeString(this.leaderId));
        if (!Objects.isNull(this.leaderCompType)) {
            map.put("leaderCompType", CastUtil.getString(this.leaderCompType));
        }
        map.put("orgRole", CastUtil.getSafeString(this.orgRole));
        map.put("orgRoleList", CastUtil.getSafeString(JSONUtil.toJsonString(this.orgRoleList)));
        map.put("businessNo", CastUtil.getSafeString(this.businessNo));
        map.put("orgApproveState", ExtendLoginContext.formatOrgApproveState(this.orgApproveState));
        map.put("userApproveState", ExtendLoginContext.formatUserApproveState(this.userApproveState));
        if (!Objects.isNull(this.supplierType)) {
            map.put("supplierType", CastUtil.getSafeString(this.supplierType));
        }
        if (!Objects.isNull(this.userPosition)) {
            map.put("userPosition", CastUtil.getSafeString(this.userPosition));
        }
        if (!Objects.isNull(this.entryMode)) {
            map.put("entryMode", CastUtil.getSafeString(this.entryMode));
        }
        if (!Objects.isNull(this.abbName)) {
            map.put("abbName", CastUtil.getSafeString(this.abbName));
        }
        if (!BlockCollectionUtil.isEmpty(this.productFieldExtendMap)) {
            map.put("productFieldExtendMap", CastUtil.getSafeString(JSONUtil.toJsonString(this.productFieldExtendMap)));
        }
        if (!Objects.isNull(this.orgParent)) {
            map.put("orgParent", CastUtil.getSafeString(this.orgParent));
        }
        if (BlockCollectionUtil.isNotEmptyAndWithoutNull(this.orgChildren)) {
            map.put("orgChildren", CastUtil.getSafeString(JSONUtil.toJsonString(this.orgChildren)));
        }
        return map;
    }

    public static ExtendLoginContext fromMap(Map<String, String> map) {
        ExtendLoginContext extend = new ExtendLoginContext();
        extend.setTenantId(map.get("tenantId"));
        extend.setUserId(map.get("userId"));
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("userType"))) {
            extend.setUserType(CastUtil.getInteger(map.get("userType")));
        }
        extend.setUserName(map.get("userName"));
        extend.setUserDisplayName(map.get("userDisplayName"));
        extend.setLoginOrgId(map.get("loginOrgId"));
        extend.setLoginOrgName(map.get("loginOrgName"));
        extend.setOwnerAppId(map.get("ownerAppId"));
        extend.setLoginDate(CastUtil.strToEcpDate(map.get("loginDate")));
        extend.setIp(map.get("ip"));
        extend.setTokenId(map.get("tokenId"));
        extend.setLocale(CastUtil.strToLocale(map.get("locale")));
        extend.setUniqueKey(map.get("uniqueKey"));
        extend.setTimeZone(CastUtil.strToTimeZone(map.get("timeZone")));
        extend.setGid(map.get("gid"));
        extend.setUserGid(map.get("userGid"));
        extend.setUserCode(map.get("userCode"));
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("userSource"))) {
            extend.setUserSource(ExtendLoginContext.parseUserSource(map.get("userSource")));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("ownerScope"))) {
            extend.setOwnerScope(ExtendLoginContext.parseOwnerScope(map.get("ownerScope")));
        }
        extend.setLoginOrgGid(map.get("loginOrgGid"));
        extend.setLoginOrgCode(map.get("loginOrgCode"));
        extend.setDeptId(map.get("deptId"));
        extend.setDeptName(map.get("deptName"));
        extend.setTenantName(map.get("tenantName"));
        extend.setMovetel(map.get("movetel"));
        extend.setEmail(map.get("email"));
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("authState"))) {
            extend.setAuthState(ExtendLoginContext.parseAuthSource(map.get("authState")));
        }
        extend.setOpenId(map.get("openId"));
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("compType"))) {
            extend.setCompType(CastUtil.getInteger(map.get("compType")));
        }
        extend.setCoreGid(map.get("coreGid"));
        extend.setCoreId(map.get("coreId"));
        extend.setLeaderGid(map.get("leaderGid"));
        extend.setLeaderId(map.get("leaderId"));
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("leaderCompType"))) {
            extend.setLeaderCompType(CastUtil.getInteger(map.get("leaderCompType")));
        }
        if (!ExtendLoginContext.isRedisEmptyValue(map.get("orgRole"))) {
            extend.setOrgRole(CastUtil.getInteger(map.get("orgRole")));
        }
        if (!ExtendLoginContext.isRedisEmptyValue(map.get("orgRoleList"))) {
            extend.setOrgRoleList((List)JSONUtil.fromJsonString((String)map.get("orgRoleList"), List.class));
        }
        extend.setBusinessNo(map.get("businessNo"));
        extend.setOrgApproveState(ExtendLoginContext.parseOrgApproveState(map.get("orgApproveState")));
        extend.setUserApproveState(ExtendLoginContext.parseUserApproveState(map.get("userApproveState")));
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("supplierType"))) {
            extend.setSupplierType(CastUtil.getInteger(map.get("supplierType")));
        }
        extend.setUserPosition(map.get("userPosition"));
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("entryMode"))) {
            extend.setEntryMode(CastUtil.getInteger(map.get("entryMode")));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("abbName"))) {
            extend.setAbbName(map.get("abbName"));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("productFieldExtendMap"))) {
            extend.setProductFieldExtendMap((Map)JSONUtil.fromJsonString((String)map.get("productFieldExtendMap"), Map.class));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("orgParent"))) {
            extend.setOrgParent(map.get("orgParent"));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)map.get("orgChildren"))) {
            extend.setOrgChildren((List)JSONUtil.fromJsonString((String)map.get("orgChildren"), List.class));
        }
        return extend;
    }

    private static boolean isRedisEmptyValue(String str) {
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return true;
        }
        return "null".equals(str);
    }

    private static String formatUserSource(UserSourceEnum userSource) {
        if (Objects.isNull((Object)userSource)) {
            return "";
        }
        return CastUtil.getSafeString(userSource.ordinal());
    }

    private static UserSourceEnum parseUserSource(String userSource) {
        if (StringUtil.isNullOrTrimEmptyString((String)userSource)) {
            return null;
        }
        int idx = CastUtil.getInteger(userSource);
        return UserSourceEnum.values()[idx];
    }

    private static String formatOwnerScope(OwnerScopeEnum ownerScope) {
        if (Objects.isNull((Object)ownerScope)) {
            return "";
        }
        return CastUtil.getSafeString(ownerScope.ordinal());
    }

    private static OwnerScopeEnum parseOwnerScope(String ownerScope) {
        if (StringUtil.isNullOrTrimEmptyString((String)ownerScope)) {
            return null;
        }
        int idx = CastUtil.getInteger(ownerScope);
        return OwnerScopeEnum.values()[idx];
    }

    private static String formatAuthSource(AuthStateEnum authSource) {
        if (Objects.isNull((Object)authSource)) {
            return "";
        }
        return CastUtil.getSafeString(authSource.ordinal());
    }

    private static AuthStateEnum parseAuthSource(String authSource) {
        if (StringUtil.isNullOrTrimEmptyString((String)authSource)) {
            return null;
        }
        int idx = CastUtil.getInteger(authSource);
        return AuthStateEnum.values()[idx];
    }

    private static String formatOrgApproveState(ApproveStateEnum orgApproveState) {
        if (Objects.isNull((Object)orgApproveState)) {
            return "";
        }
        return CastUtil.getSafeString(orgApproveState.ordinal());
    }

    private static ApproveStateEnum parseOrgApproveState(String orgApproveState) {
        if (StringUtil.isNullOrTrimEmptyString((String)orgApproveState)) {
            return null;
        }
        int idx = CastUtil.getInteger(orgApproveState);
        return ApproveStateEnum.values()[idx];
    }

    private static String formatUserApproveState(ApproveStateEnum userApproveState) {
        if (Objects.isNull((Object)userApproveState)) {
            return "";
        }
        return CastUtil.getSafeString(userApproveState.ordinal());
    }

    private static ApproveStateEnum parseUserApproveState(String userApproveState) {
        if (StringUtil.isNullOrTrimEmptyString((String)userApproveState)) {
            return null;
        }
        int idx = CastUtil.getInteger(userApproveState);
        return ApproveStateEnum.values()[idx];
    }

    public static ExtendLoginContext newInstance(LoginContext loginContext) {
        if (Objects.isNull(loginContext)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"ExtendLoginContext_newInstance_258", (String)"\u53c2\u6570\u9519\u8bef\uff1aloginContext\u4e3a\u7a7a\u3002"));
        }
        ExtendLoginContext entity = new ExtendLoginContext();
        entity.setTenantId(loginContext.getTenantId());
        entity.setUserId(loginContext.getUserId());
        entity.setUserName(loginContext.getUserName());
        entity.setUserDisplayName(loginContext.getUserDisplayName());
        entity.setLoginOrgId(loginContext.getLoginOrgId());
        entity.setLoginOrgName(loginContext.getLoginOrgName());
        entity.setOwnerAppId(loginContext.getOwnerAppId());
        entity.setLoginDate(loginContext.getLoginDate());
        entity.setIp(loginContext.getIp());
        entity.setTokenId(loginContext.getTokenId());
        entity.setLocale(loginContext.getLocale());
        entity.setUniqueKey(loginContext.getUniqueKey());
        entity.setTimeZone(loginContext.getTimeZone());
        entity.setProductFieldExtendMap(new HashMap<String, ProductFieldExtendVO>());
        return entity;
    }

    public boolean platform() {
        String tenantGid = this.getTenantId();
        return "-1".equals(tenantGid);
    }

    public boolean tenant() {
        return this.getUserType() == 3;
    }

    public String getGid() {
        return this.gid;
    }

    public void setGid(String gid) {
        this.gid = gid;
    }

    public String getUserGid() {
        return this.userGid;
    }

    public void setUserGid(String userGid) {
        this.userGid = userGid;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getLoginOrgGid() {
        return this.loginOrgGid;
    }

    public void setLoginOrgGid(String loginOrgGid) {
        this.loginOrgGid = loginOrgGid;
    }

    public String getLoginOrgCode() {
        return this.loginOrgCode;
    }

    public void setLoginOrgCode(String loginOrgCode) {
        this.loginOrgCode = loginOrgCode;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String newDeptId) {
        this.deptId = newDeptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String newDeptName) {
        this.deptName = newDeptName;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getMovetel() {
        return this.movetel;
    }

    public void setMovetel(String movetel) {
        this.movetel = movetel;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String newEmail) {
        this.email = newEmail;
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getCompType() {
        return this.compType;
    }

    public void setCompType(Integer compType) {
        this.compType = compType;
    }

    public String getCoreGid() {
        return this.coreGid;
    }

    public void setCoreGid(String coreGid) {
        this.coreGid = coreGid;
    }

    public String getCoreId() {
        return this.coreId;
    }

    public void setCoreId(String coreId) {
        this.coreId = coreId;
    }

    public String getLeaderGid() {
        return this.leaderGid;
    }

    public void setLeaderGid(String leaderGid) {
        this.leaderGid = leaderGid;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public void setLeaderId(String leaderId) {
        this.leaderId = leaderId;
    }

    public Integer getLeaderCompType() {
        return this.leaderCompType;
    }

    public void setLeaderCompType(Integer leaderCompType) {
        this.leaderCompType = leaderCompType;
    }

    public UserSourceEnum getUserSource() {
        return this.userSource;
    }

    public void setUserSource(UserSourceEnum userSource) {
        this.userSource = userSource;
    }

    public OwnerScopeEnum getOwnerScope() {
        return this.ownerScope;
    }

    public void setOwnerScope(OwnerScopeEnum ownerScope) {
        this.ownerScope = ownerScope;
    }

    public int getOrgRole() {
        return this.orgRole;
    }

    public void setOrgRole(int orgRole) {
        this.orgRole = orgRole;
    }

    public List<Integer> getOrgRoleList() {
        return this.orgRoleList;
    }

    public void setOrgRoleList(List<Integer> orgRoleList) {
        this.orgRoleList = orgRoleList;
    }

    public AuthStateEnum getAuthState() {
        return this.authState;
    }

    public void setAuthState(AuthStateEnum authState) {
        this.authState = authState;
    }

    public String getBusinessNo() {
        return this.businessNo;
    }

    public void setBusinessNo(String businessNo) {
        this.businessNo = businessNo;
    }

    public ApproveStateEnum getOrgApproveState() {
        return this.orgApproveState;
    }

    public void setOrgApproveState(ApproveStateEnum orgApproveState) {
        this.orgApproveState = orgApproveState;
    }

    public ApproveStateEnum getUserApproveState() {
        return this.userApproveState;
    }

    public void setUserApproveState(ApproveStateEnum userApproveState) {
        this.userApproveState = userApproveState;
    }

    public Integer getSupplierType() {
        return this.supplierType;
    }

    public void setSupplierType(Integer supplierType) {
        this.supplierType = supplierType;
    }

    public String getUserPosition() {
        return this.userPosition;
    }

    public void setUserPosition(String userPosition) {
        this.userPosition = userPosition;
    }

    public Integer getEntryMode() {
        return this.entryMode;
    }

    public void setEntryMode(Integer newEntryMode) {
        this.entryMode = newEntryMode;
    }

    public String getAbbName() {
        return this.abbName;
    }

    public void setAbbName(String newAbbName) {
        this.abbName = newAbbName;
    }

    public Map<String, ProductFieldExtendVO> getProductFieldExtendMap() {
        return this.productFieldExtendMap;
    }

    public void setProductFieldExtendMap(Map<String, ProductFieldExtendVO> newProductFieldExtendMap) {
        this.productFieldExtendMap = newProductFieldExtendMap;
    }

    public String getOrgParent() {
        return this.orgParent;
    }

    public void setOrgParent(String newOrgParent) {
        this.orgParent = newOrgParent;
    }

    public List<String> getOrgChildren() {
        return this.orgChildren;
    }

    public void setOrgChildren(List<String> newOrgChildren) {
        this.orgChildren = newOrgChildren;
    }
}

