/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ygsoft.abc.service.document.function.GroupTemplateFunction;
import com.ygsoft.abc.service.document.function.impl.ClasspathGroupTemplateFunction;
import com.ygsoft.abc.service.document.function.impl.FileGroupTemplateFunction;
import com.ygsoft.abc.service.document.function.impl.StringGroupTemplateFunction;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;

public final class BeetlUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BeetlUtil.class);

    private BeetlUtil() {
    }

    public static <T> String renderFromStr(String templateContent, T param) {
        return BeetlUtil.renderTemplate(StringGroupTemplateFunction.INSTANCE, templateContent, param);
    }

    public static <T> String renderFromFile(String fileName, T param) {
        return BeetlUtil.renderTemplate(FileGroupTemplateFunction.INSTANCE, fileName, param);
    }

    public static <T> String renderFromClasspath(String fileName, T param) {
        return BeetlUtil.renderTemplate(ClasspathGroupTemplateFunction.INSTANCE, fileName, param);
    }

    public static <T> String renderHtmlFromStr(String templateContent, T param) {
        String regex = "\\s*<html>([\\s\\S]*)</html>\\s*";
        if (!Pattern.matches("\\s*<html>([\\s\\S]*)</html>\\s*", templateContent)) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "\u6a21\u677f\u53ea\u80fd\u662fHTML\u3002");
        }
        return BeetlUtil.renderTemplate(StringGroupTemplateFunction.INSTANCE, templateContent, param);
    }

    public static <T> String renderHtmlFromFile(String fileName, T param) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "\u6a21\u677f\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!fileName.endsWith(".html")) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "\u6a21\u677f\u53ea\u80fd\u662fHTML\u3002");
        }
        return BeetlUtil.renderTemplate(FileGroupTemplateFunction.INSTANCE, fileName, param);
    }

    public static <T> String renderHtmlFromClasspath(String fileName, T param) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "\u6a21\u677f\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!fileName.endsWith(".html")) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "\u6a21\u677f\u53ea\u80fd\u662fHTML\u3002");
        }
        return BeetlUtil.renderTemplate(ClasspathGroupTemplateFunction.INSTANCE, fileName, param);
    }

    protected static <T> String renderTemplate(GroupTemplateFunction func, String tp, T param) {
        GroupTemplate gt;
        Template template;
        if (null == func) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "func, GroupTemplate\u51fd\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)tp)) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "tp, \u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("GroupTemplate = " + func.getClass().getName()));
        }
        if (null == (template = (gt = func.get()).getTemplate(tp))) {
            throw new EcpCheckException("ERR.BEETL.UTIL.002", "\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\u3002");
        }
        BeetlUtil.bindParam(template, param);
        return template.render();
    }

    private static <T> void bindParam(Template template, T param) {
        if (null == template) {
            throw new EcpCheckException("ERR.BEETL.UTIL.001", "\u5165\u53c2template\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == param) {
            return;
        }
        String jsonstr = JSON.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        JSONObject jsonObj = JSON.parseObject((String)jsonstr);
        jsonObj.forEach((key, value) -> {
            if (null == value) {
                template.binding(key, (Object)"");
            } else {
                template.binding(key, value);
            }
        });
    }
}

